/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.LineGlyph;
import uk.ac.starlink.ttools.plot2.layer.LineXYShape;
import uk.ac.starlink.ttools.plot2.layer.PixelDrawing;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.layer.StrokeKit;
import uk.ac.starlink.ttools.plot2.layer.XYShape;

public class FatLineXYShape
extends XYShape {
    private final PixerFactory kernel_;
    private final StrokeKit strokeKit_;
    private static XYShape[] instances_ = new XYShape[5];

    protected FatLineXYShape(int nthick) {
        this("Line" + nthick, LineGlyph.createThickKernel(nthick), LineGlyph.createThickStrokeKit(nthick));
    }

    private FatLineXYShape(String name, PixerFactory kernel, StrokeKit strokeKit) {
        super(name, 16, FatLineXYShape.createPointGlyph(kernel, strokeKit));
        this.kernel_ = kernel;
        this.strokeKit_ = strokeKit;
    }

    @Override
    protected Glyph createGlyph(final short sx, final short sy) {
        return new LineGlyph(){

            @Override
            public Rectangle getPixelBounds() {
                short x = sx >= 0 ? (short)0 : sx;
                int w = sx >= 0 ? sx + 1 : 1 - sx;
                short y = sy >= 0 ? (short)0 : sy;
                int h = sy >= 0 ? sy + 1 : 1 - sy;
                return new Rectangle(x, y, w, h);
            }

            @Override
            public void drawShape(PixelDrawing drawing) {
                drawing.drawLine(0, 0, sx, sy);
            }

            @Override
            public void paintGlyph(Graphics g, StrokeKit strokeKit) {
                Graphics2D g2 = (Graphics2D)g;
                Stroke stroke0 = g2.getStroke();
                g2.setStroke(strokeKit.getRound());
                g2.drawLine(0, 0, sx, sy);
                g2.setStroke(stroke0);
            }
        }.toThicker(this.kernel_, this.strokeKit_);
    }

    public static XYShape getInstance(int nthick) {
        if (nthick < instances_.length) {
            XYShape instance = instances_[nthick];
            if (instance == null) {
                FatLineXYShape.instances_[nthick] = instance = new FatLineXYShape(nthick);
            }
            return instance;
        }
        return new FatLineXYShape(nthick);
    }

    static Glyph createPointGlyph(final PixerFactory kernel, StrokeKit strokeKit) {
        final Stroke stroke = strokeKit.getRound();
        return new Glyph(){

            @Override
            public Pixer createPixer(Rectangle clip) {
                return Pixers.createClippedPixer(kernel, clip);
            }

            @Override
            public void paintGlyph(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                Stroke stroke0 = g2.getStroke();
                g2.setStroke(stroke);
                g2.drawLine(0, 0, 0, 0);
                g2.setStroke(stroke0);
            }
        };
    }

    static {
        FatLineXYShape.instances_[0] = LineXYShape.INSTANCE;
    }
}

