/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.function.Function;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurface;
import uk.ac.starlink.ttools.plot2.layer.Binner;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.XYArrayData;
import uk.ac.starlink.util.SplitCollector;

public class FillPlan {
    private final Binner binner_;
    private final Gridder gridder_;
    private final int[] xlos_;
    private final int[] xhis_;
    private final int[] ylos_;
    private final int[] yhis_;
    private final Point cpXlo_;
    private final Point cpXhi_;
    private final Point cpYlo_;
    private final Point cpYhi_;
    private final DataGeom geom_;
    private final DataSpec dataSpec_;
    private final Surface surface_;

    private FillPlan(DataSpec dataSpec, FillCollector fcollector, FillData fdata) {
        this.dataSpec_ = dataSpec;
        this.binner_ = fdata.binner_;
        this.gridder_ = fcollector.gridder_;
        this.xlos_ = fdata.xlos_;
        this.xhis_ = fdata.xhis_;
        this.ylos_ = fdata.ylos_;
        this.yhis_ = fdata.yhis_;
        this.cpXlo_ = fdata.cpXlo_;
        this.cpXhi_ = fdata.cpXhi_;
        this.cpYlo_ = fdata.cpYlo_;
        this.cpYhi_ = fdata.cpYhi_;
        this.geom_ = fcollector.geom_;
        this.surface_ = fcollector.surface_;
    }

    public Binner getBinner() {
        return this.binner_;
    }

    public Gridder getGridder() {
        return this.gridder_;
    }

    public int[] getXlos() {
        return this.xlos_;
    }

    public int[] getXhis() {
        return this.xhis_;
    }

    public int[] getYlos() {
        return this.ylos_;
    }

    public int[] getYhis() {
        return this.yhis_;
    }

    public Point getCpXlo() {
        return this.cpXlo_;
    }

    public Point getCpXhi() {
        return this.cpXhi_;
    }

    public Point getCpYlo() {
        return this.cpYlo_;
    }

    public Point getCpYhi() {
        return this.cpYhi_;
    }

    public boolean matches(DataGeom geom, DataSpec dataSpec, Surface surface) {
        return PlotUtil.equals(this.geom_, geom) && this.dataSpec_.equals(dataSpec) && this.surface_.equals(surface);
    }

    public static FillPlan createPlan(Surface surface, DataSpec dataSpec, DataGeom geom, int icPos, DataStore dataStore) {
        PointsFillCollector fcollector = new PointsFillCollector(surface, geom, icPos);
        FillData fdata = PlotUtil.tupleCollect(fcollector, dataSpec, dataStore);
        return new FillPlan(dataSpec, fcollector, fdata);
    }

    public static FillPlan createPlanArrays(Surface surface, DataSpec dataSpec, DataGeom geom, Function<Tuple, XYArrayData> xyReader, DataStore dataStore) {
        ArraysFillCollector fcollector = new ArraysFillCollector(surface, geom, xyReader);
        FillData fdata = PlotUtil.tupleCollect(fcollector, dataSpec, dataStore);
        return new FillPlan(dataSpec, fcollector, fdata);
    }

    private static GraphicsConverter createGraphicsConverter(Surface surf) {
        if (surf instanceof PlaneSurface) {
            double yMinusInf;
            PlaneSurface psurf = (PlaneSurface)surf;
            boolean xflip = psurf.getFlipFlags()[0];
            boolean yflip = psurf.getFlipFlags()[1];
            Scale xscale = psurf.getScales()[0];
            Scale yscale = psurf.getScales()[1];
            Axis xAxis = psurf.getAxes()[0];
            Axis yAxis = psurf.getAxes()[1];
            double big = 1.073741823E9;
            double xMinusInf = xflip ? big : -big;
            double d = yMinusInf = yflip ? -big : big;
            if (xscale.isPositiveDefinite() || yscale.isPositiveDefinite()) {
                return (dpos, gpos) -> {
                    double dx = dpos[0];
                    double dy = dpos[1];
                    gpos.x = xscale.isPositiveDefinite() && dx <= 0.0 ? xMinusInf : xAxis.dataToGraphics(dx);
                    gpos.y = yscale.isPositiveDefinite() && dy <= 0.0 ? yMinusInf : yAxis.dataToGraphics(dy);
                    return PlotUtil.isPointReal(gpos);
                };
            }
            return (dpos, gpos) -> surf.dataToGraphics(dpos, false, gpos) && PlotUtil.isPointReal(gpos);
        }
        return (dpos, gpos) -> surf.dataToGraphics(dpos, false, gpos) && PlotUtil.isPointReal(gpos);
    }

    private static class ArraysFillCollector
    extends FillCollector {
        final Function<Tuple, XYArrayData> xyReader_;

        ArraysFillCollector(Surface surface, DataGeom geom, Function<Tuple, XYArrayData> xyReader) {
            super(surface, geom);
            this.xyReader_ = xyReader;
        }

        public void accumulate(TupleSequence tseq, FillData fdata) {
            double[] dpos = new double[2];
            Point2D.Double gp = new Point2D.Double();
            Binner binner = fdata.binner_;
            int[] xlos = fdata.xlos_;
            int[] xhis = fdata.xhis_;
            int[] ylos = fdata.ylos_;
            int[] yhis = fdata.yhis_;
            Point cpXlo = fdata.cpXlo_;
            Point cpXhi = fdata.cpXhi_;
            Point cpYlo = fdata.cpYlo_;
            Point cpYhi = fdata.cpYhi_;
            while (tseq.next()) {
                XYArrayData xyData = this.xyReader_.apply(tseq);
                if (xyData == null) continue;
                int np = xyData.getLength();
                for (int ip = 0; ip < np; ++ip) {
                    boolean inY;
                    dpos[0] = xyData.getX(ip);
                    dpos[1] = xyData.getY(ip);
                    if (!this.gconv_.dataToGraphics(dpos, gp)) continue;
                    int x = (int)(gp.x - (double)this.x0_);
                    int y = (int)(gp.y - (double)this.y0_);
                    boolean inX = x >= 0 && x < this.nx_;
                    boolean bl = inY = y >= 0 && y < this.ny_;
                    if (inX && inY) {
                        binner.increment(this.gridder_.getIndex(x, y));
                        continue;
                    }
                    if (inX) {
                        if (y < 0) {
                            int n = x;
                            xlos[n] = xlos[n] + 1;
                            if (cpYlo != null && y <= cpYlo.y) continue;
                            cpYlo = new Point(x, y);
                            continue;
                        }
                        int n = x;
                        xhis[n] = xhis[n] + 1;
                        if (cpYhi != null && y >= cpYhi.y) continue;
                        cpYhi = new Point(x, y);
                        continue;
                    }
                    if (!inY) continue;
                    if (x < 0) {
                        int n = y;
                        ylos[n] = ylos[n] + 1;
                        if (cpXlo != null && x <= cpXlo.x) continue;
                        cpXlo = new Point(x, y);
                        continue;
                    }
                    int n = y;
                    yhis[n] = yhis[n] + 1;
                    if (cpXhi != null && x >= cpXhi.x) continue;
                    cpXhi = new Point(x, y);
                }
                fdata.cpXlo_ = cpXlo;
                fdata.cpXhi_ = cpXhi;
                fdata.cpYlo_ = cpYlo;
                fdata.cpYhi_ = cpYhi;
            }
        }
    }

    private static class PointsFillCollector
    extends FillCollector {
        final int icPos_;

        PointsFillCollector(Surface surface, DataGeom geom, int icPos) {
            super(surface, geom);
            this.icPos_ = icPos;
        }

        public void accumulate(TupleSequence tseq, FillData fdata) {
            double[] dpos = new double[this.surface_.getDataDimCount()];
            Point2D.Double gp = new Point2D.Double();
            Binner binner = fdata.binner_;
            int[] xlos = fdata.xlos_;
            int[] xhis = fdata.xhis_;
            int[] ylos = fdata.ylos_;
            int[] yhis = fdata.yhis_;
            Point cpXlo = fdata.cpXlo_;
            Point cpXhi = fdata.cpXhi_;
            Point cpYlo = fdata.cpYlo_;
            Point cpYhi = fdata.cpYhi_;
            while (tseq.next()) {
                boolean inY;
                if (!this.geom_.readDataPos(tseq, this.icPos_, dpos) || !this.gconv_.dataToGraphics(dpos, gp)) continue;
                int x = (int)(gp.x - (double)this.x0_);
                int y = (int)(gp.y - (double)this.y0_);
                boolean inX = x >= 0 && x < this.nx_;
                boolean bl = inY = y >= 0 && y < this.ny_;
                if (inX && inY) {
                    binner.increment(this.gridder_.getIndex(x, y));
                    continue;
                }
                if (inX) {
                    if (y < 0) {
                        int n = x;
                        xlos[n] = xlos[n] + 1;
                        if (cpYlo != null && y <= cpYlo.y) continue;
                        cpYlo = new Point(x, y);
                        continue;
                    }
                    int n = x;
                    xhis[n] = xhis[n] + 1;
                    if (cpYhi != null && y >= cpYhi.y) continue;
                    cpYhi = new Point(x, y);
                    continue;
                }
                if (!inY) continue;
                if (x < 0) {
                    int n = y;
                    ylos[n] = ylos[n] + 1;
                    if (cpXlo != null && x <= cpXlo.x) continue;
                    cpXlo = new Point(x, y);
                    continue;
                }
                int n = y;
                yhis[n] = yhis[n] + 1;
                if (cpXhi != null && x >= cpXhi.x) continue;
                cpXhi = new Point(x, y);
            }
            fdata.cpXlo_ = cpXlo;
            fdata.cpXhi_ = cpXhi;
            fdata.cpYlo_ = cpYlo;
            fdata.cpYhi_ = cpYhi;
        }
    }

    private static abstract class FillCollector
    implements SplitCollector<TupleSequence, FillData> {
        final Surface surface_;
        final DataGeom geom_;
        final int x0_;
        final int y0_;
        final int nx_;
        final int ny_;
        final Gridder gridder_;
        final GraphicsConverter gconv_;

        FillCollector(Surface surface, DataGeom geom) {
            this.surface_ = surface;
            this.geom_ = geom;
            Rectangle bounds = surface.getPlotBounds();
            this.x0_ = bounds.x;
            this.y0_ = bounds.y;
            this.nx_ = bounds.width;
            this.ny_ = bounds.height;
            this.gridder_ = new Gridder(this.nx_, this.ny_);
            this.gconv_ = FillPlan.createGraphicsConverter(surface);
        }

        public FillData createAccumulator() {
            return new FillData(this.nx_, this.ny_);
        }

        public FillData combine(FillData fdata1, FillData fdata2) {
            fdata1.binner_.add(fdata2.binner_);
            for (int ix = 0; ix < this.nx_; ++ix) {
                fdata1.xlos_[ix] = FillCollector.addInt(fdata1.xlos_[ix], fdata2.xlos_[ix]);
                fdata1.xhis_[ix] = FillCollector.addInt(fdata1.xhis_[ix], fdata2.xhis_[ix]);
            }
            for (int iy = 0; iy < this.ny_; ++iy) {
                fdata1.ylos_[iy] = FillCollector.addInt(fdata1.ylos_[iy], fdata2.ylos_[iy]);
                fdata1.yhis_[iy] = FillCollector.addInt(fdata1.yhis_[iy], fdata2.yhis_[iy]);
            }
            if (fdata1.cpXlo_ == null) {
                fdata1.cpXlo_ = fdata2.cpXlo_;
            }
            if (fdata1.cpXhi_ == null) {
                fdata1.cpXhi_ = fdata2.cpXhi_;
            }
            if (fdata1.cpYlo_ == null) {
                fdata1.cpYlo_ = fdata2.cpYlo_;
            }
            if (fdata1.cpYhi_ == null) {
                fdata1.cpYhi_ = fdata2.cpYhi_;
            }
            return fdata1;
        }

        private static int addInt(int i1, int i2) {
            long sum = i1 + i2;
            int isum = (int)sum;
            return (long)isum == sum ? isum : Integer.MAX_VALUE;
        }
    }

    @FunctionalInterface
    private static interface GraphicsConverter {
        public boolean dataToGraphics(double[] var1, Point2D.Double var2);
    }

    private static class FillData {
        final Binner binner_;
        final int[] xlos_;
        final int[] xhis_;
        final int[] ylos_;
        final int[] yhis_;
        Point cpXlo_;
        Point cpXhi_;
        Point cpYlo_;
        Point cpYhi_;

        FillData(int nx, int ny) {
            this.binner_ = new Binner(nx * ny);
            this.xlos_ = new int[nx];
            this.xhis_ = new int[nx];
            this.ylos_ = new int[ny];
            this.yhis_ = new int[ny];
        }
    }
}

