/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.PerUnitConfigKey;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.layer.AbstractKernelDensityPlotter;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Kernel1d;
import uk.ac.starlink.ttools.plot2.layer.Kernel1dShape;
import uk.ac.starlink.ttools.plot2.layer.Pixel1dPlotter;
import uk.ac.starlink.ttools.plot2.layer.Unit;

public class FixedKernelDensityPlotter
extends AbstractKernelDensityPlotter {
    public FixedKernelDensityPlotter(FloatingCoord xCoord, boolean hasWeight, PerUnitConfigKey<Unit> unitKey) {
        super(xCoord, hasWeight, unitKey, "KDE", ResourceIcon.FORM_KDE);
    }

    @Override
    protected ConfigKey<?>[] getKernelConfigKeys() {
        return new ConfigKey[]{SMOOTHSIZER_KEY, this.getCombinerKey()};
    }

    @Override
    protected AbstractKernelDensityPlotter.KernelFigure createKernelFigure(ConfigMap config) {
        BinSizer sizer = (BinSizer)config.get(SMOOTHSIZER_KEY);
        Combiner combiner = config.get(this.getCombinerKey());
        boolean isLikeMean = !combiner.getType().isExtensive();
        return new FixedKernelFigure(sizer, isLikeMean);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a Discrete Kernel Density Estimate", "giving a smoothed frequency of data values along the", "horizontal axis, using a fixed-width smoothing kernel.", "This is a generalisation of a histogram in which", "the bins are always 1 pixel wide,", "and a smoothing kernel is applied to each bin.", "The width and shape of the kernel may be varied.", "</p>", "<p>This is suitable for cases where", "the division into discrete bins", "done by a normal histogram is unnecessary or troublesome.", "</p>", "<p>Note this is not a true Kernel Density Estimate,", "since, for performance reasons,", "the smoothing is applied to the (pixel-width) bins", "rather than to each data sample.", "The deviation from a true KDE caused by this quantisation", "will be at the pixel level,", "hence in most cases not visually apparent.", "</p>", this.getWeightingDescription()});
    }

    private static class FixedKernelFigure
    implements AbstractKernelDensityPlotter.KernelFigure {
        private final BinSizer binSizer_;
        private final boolean isMean_;

        FixedKernelFigure(BinSizer binSizer, boolean isMean) {
            this.binSizer_ = binSizer;
            this.isMean_ = isMean;
        }

        @Override
        public Kernel1d createKernel(Kernel1dShape shape, Axis xAxis) {
            return Pixel1dPlotter.createKernel(shape, this.binSizer_, xAxis, this.isMean_);
        }

        @Override
        public ReportMap getReportMap(Axis xAxis) {
            ReportMap report = new ReportMap();
            double[] dLimits = xAxis.getDataLimits();
            Scale scale = xAxis.getScale();
            double w = this.binSizer_.getScaleWidth(scale, dLimits[0], dLimits[1], false);
            report.put(Pixel1dPlotter.SMOOTHWIDTH_KEY, w);
            return report;
        }

        public int hashCode() {
            int code = 23452304;
            code = 23 * code + this.binSizer_.hashCode();
            code = 23 * code + (this.isMean_ ? 29 : 37);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof FixedKernelFigure) {
                FixedKernelFigure other = (FixedKernelFigure)o;
                return this.binSizer_.equals(other.binSizer_) && this.isMean_ == other.isMean_;
            }
            return false;
        }
    }
}

