/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import gnu.jel.CompilationException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.jel.Constant;
import uk.ac.starlink.ttools.jel.JELFunction;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.StringConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.LineStyle;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;
import uk.ac.starlink.ttools.plot2.layer.UnplannedDrawing;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class FunctionPlotter
extends AbstractPlotter<FunctionStyle> {
    private final FuncAxis[] axes_;
    private Map<String, ? extends Constant<?>> constMap_;
    private static final Pattern TOKEN_REGEXP = Pattern.compile("[A-Za-z_][A-Za-z0-9_]*");
    private static final double PIXEL_SPACING = 0.25;
    public static final FunctionPlotter PLANE = new FunctionPlotter(PlaneAxis.values());
    public static final ConfigKey<String> XNAME_KEY = new StringConfigKey(new ConfigMeta("xname", "Independent Variable Name").setStringUsage("<name>").setShortDescription("Independent variable name").setXmlDescription(new String[]{"<p>Name of the independent variable for use in the", "function expression.", "This is typically", "<code>x</code> for a horizontal independent variable and", "<code>y</code> for a vertical independent variable,", "but any string that is a legal expression language identifier", "(starts with a letter, continues with letters, numbers,", "underscores) can be used.", "</p>"}), "x");
    public static final ConfigKey<String> FEXPR_KEY = new StringConfigKey(new ConfigMeta("fexpr", "Function Expression").setStringUsage("<expr>").setShortDescription("Expression for function").setXmlDescription(new String[]{"<p>An expression using TOPCAT's", "<ref id='jel'>expression language</ref>", "in terms of the independent variable", "to define the function.", "This expression must be standalone -", "it cannot reference any tables.", "</p>"}), null);
    private final ConfigKey<FuncAxis> axisKey_;

    public FunctionPlotter(FuncAxis[] axes) {
        super("Function", ResourceIcon.PLOT_FUNCTION);
        this.axes_ = axes;
        this.axisKey_ = new OptionConfigKey<FuncAxis>(new ConfigMeta("axis", "Independent Axis").setShortDescription("Axis of independent variable").setXmlDescription(new String[]{"<p>Which axis the independent variable varies along.", "Options are currently", "<code>" + PlaneAxis.X.getAxisName() + "</code> and", "<code>" + PlaneAxis.Y.getAxisName() + "</code>.", "</p>"}), FuncAxis.class, this.axes_, this.axes_[0]){

            @Override
            public String valueToString(FuncAxis axis) {
                return axis == null ? null : axis.getAxisName();
            }

            @Override
            public String getXmlDescription(FuncAxis axis) {
                return null;
            }
        }.setOptionUsage();
    }

    public void setConstantMap(Map<String, ? extends Constant<?>> constMap) {
        this.constMap_ = constMap;
    }

    public Map<String, ? extends Constant<?>> getConstantMap() {
        return this.constMap_;
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots an analytic function.", "This layer is currently only available for the Plane plots", "(including histogram).", "</p>"});
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFunctionStyleKeys()));
        list.add(StyleKeys.COLOR);
        list.addAll(Arrays.asList(StyleKeys.getStrokeKeys()));
        list.add(StyleKeys.ANTIALIAS);
        return list.toArray(new ConfigKey[0]);
    }

    public ConfigKey<?>[] getFunctionStyleKeys() {
        return new ConfigKey[]{this.axisKey_, XNAME_KEY, FEXPR_KEY};
    }

    @Override
    public FunctionStyle createStyle(ConfigMap config) throws ConfigException {
        JELFunction jelfunc;
        String xname = config.get(XNAME_KEY);
        String fexpr = config.get(FEXPR_KEY);
        if (xname == null || xname.trim().length() == 0 || fexpr == null || fexpr.trim().length() == 0) {
            return null;
        }
        if (!TOKEN_REGEXP.matcher(xname).matches()) {
            throw new ConfigException(XNAME_KEY, "Bad variable name \"" + xname + "\"");
        }
        try {
            jelfunc = new JELFunction(xname, fexpr, this.constMap_);
        }
        catch (CompilationException e) {
            throw new ConfigException(FEXPR_KEY, "Bad expression \"" + fexpr + "\": " + e.getMessage(), e);
        }
        FuncAxis axis = config.get(this.axisKey_);
        Color color = config.get(StyleKeys.COLOR);
        Stroke stroke = StyleKeys.createStroke(config, 1, 1);
        boolean antialias = config.get(StyleKeys.ANTIALIAS);
        return new FunctionStyle(color, stroke, antialias, jelfunc, axis);
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, final FunctionStyle style) {
        if (style == null) {
            return null;
        }
        LayerOpt opt = new LayerOpt(style.getColor(), true);
        return new AbstractPlotLayer(this, null, null, style, opt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, PaperType paperType) {
                return new FunctionDrawing(style, surface, paperType);
            }
        };
    }

    private static enum PlaneAxis implements FuncAxis
    {
        X("Horizontal"){

            @Override
            public double[] getXValues(Surface surface) {
                Rectangle plotBounds = surface.getPlotBounds();
                int gxlo = plotBounds.x - 1;
                int gxhi = plotBounds.x + plotBounds.width + 1;
                int np = (int)((double)(gxhi - gxlo) / 0.25);
                double[] xs = new double[np];
                Point2D.Double gpos = new Point2D.Double(gxlo, plotBounds.y);
                for (int ip = 0; ip < np; ++ip) {
                    xs[ip] = surface.graphicsToData(gpos, null)[0];
                    gpos.x += 0.25;
                }
                return xs;
            }

            @Override
            public boolean xfToData(Surface surface, double x, double f, double[] dpos) {
                dpos[0] = x;
                dpos[1] = f;
                return true;
            }
        }
        ,
        Y("Vertical"){

            @Override
            public double[] getXValues(Surface surface) {
                Rectangle plotBounds = surface.getPlotBounds();
                int gylo = plotBounds.y - 1;
                int gyhi = plotBounds.y + plotBounds.height + 1;
                int np = (int)((double)(gyhi - gylo) / 0.25);
                double[] ys = new double[np];
                Point2D.Double gpos = new Point2D.Double(plotBounds.x, gylo);
                for (int ip = 0; ip < np; ++ip) {
                    ys[ip] = surface.graphicsToData(gpos, null)[1];
                    gpos.y += 0.25;
                }
                return ys;
            }

            @Override
            public boolean xfToData(Surface surface, double x, double f, double[] dpos) {
                dpos[1] = x;
                dpos[0] = f;
                return true;
            }
        };

        private final String name_;

        private PlaneAxis(String name) {
            this.name_ = name;
        }

        @Override
        public String getAxisName() {
            return this.name_;
        }
    }

    private static class FunctionDrawing
    extends UnplannedDrawing {
        private final FunctionStyle style_;
        private final Surface surface_;
        private final PaperType paperType_;

        FunctionDrawing(FunctionStyle style, Surface surface, PaperType paperType) {
            this.style_ = style;
            this.surface_ = surface;
            this.paperType_ = paperType;
        }

        @Override
        protected void paintData(Paper paper, DataStore dataStore) {
            this.paperType_.placeDecal(paper, new Decal(){

                @Override
                public void paintDecal(Graphics g) {
                    this.paintFunction((Graphics2D)g);
                }

                @Override
                public boolean isOpaque() {
                    return !style_.getAntialias();
                }
            });
        }

        private void paintFunction(Graphics2D g2) {
            JELFunction function = this.style_.function_;
            FuncAxis axis = this.style_.axis_;
            double[] xs = axis.getXValues(this.surface_);
            int np = xs.length;
            LineTracer tracer = this.style_.createLineTracer(g2, this.surface_.getPlotBounds(), np, this.paperType_.isBitmap());
            Color color = this.style_.getColor();
            Point2D.Double gpos = new Point2D.Double();
            double[] dpos = new double[this.surface_.getDataDimCount()];
            for (int ip = 0; ip < np; ++ip) {
                double x = xs[ip];
                double f = function.evaluate(x);
                if (Double.isNaN(f)) {
                    tracer.flush();
                    continue;
                }
                if (!axis.xfToData(this.surface_, x, f, dpos) || !this.surface_.dataToGraphics(dpos, false, gpos) || !PlotUtil.isPointReal(gpos)) continue;
                tracer.addVertex(gpos.x, gpos.y, color);
            }
            tracer.flush();
        }
    }

    public static interface FuncAxis {
        public String getAxisName();

        public double[] getXValues(Surface var1);

        public boolean xfToData(Surface var1, double var2, double var4, double[] var6);
    }

    public static class FunctionStyle
    extends LineStyle {
        private final JELFunction function_;
        private final Object functionId_;
        private final FuncAxis axis_;

        public FunctionStyle(Color color, Stroke stroke, boolean antialias, JELFunction function, FuncAxis axis) {
            super(color, stroke, antialias);
            this.function_ = function;
            this.functionId_ = Arrays.asList(this.function_.getXVarName(), this.function_.getExpression(), Arrays.stream(this.function_.getReferencedConstants()).map(Constant::getValue).map(String::valueOf).collect(Collectors.joining(",")));
            this.axis_ = axis;
        }

        public String toString() {
            return this.function_.getExpression();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof FunctionStyle) {
                FunctionStyle other = (FunctionStyle)o;
                return super.equals(o) && this.functionId_.equals(other.functionId_) && this.axis_.equals(other.axis_);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code = 23 * code + this.functionId_.hashCode();
            code = 23 * code + this.axis_.hashCode();
            return code;
        }
    }
}

