/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.HealpixTableInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.func.Tilings;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ComboBoxSpecifier;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.SkySysConfigKey;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.HealpixDataGeom;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;
import uk.ac.starlink.ttools.plot2.geom.SkySurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SkySys;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.BinListCollector;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.SkyDensityPlotter;
import uk.ac.starlink.ttools.plot2.layer.SkyTileRenderer;
import uk.ac.starlink.ttools.plot2.layer.SolidAngleUnit;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class HealpixPlotter
extends AbstractPlotter<HealpixStyle> {
    private final boolean transparent_;
    private final boolean reportAuxKeys_;
    private final int icHealpix_;
    private final int icValue_;
    public static final boolean IS_NEST = true;
    public static final int MAX_LEVEL = 29;
    public static final FloatingCoord VALUE_COORD = FloatingCoord.createCoord(new InputMeta("value", "Value").setShortDescription("Tile value").setXmlDescription(new String[]{"<p>Value of HEALPix tile, determining the colour", "which will be plotted.", "</p>"}), true);
    public static final ConfigKey<Integer> DATALEVEL_KEY = HealpixPlotter.createDataLevelKey();
    public static final ConfigKey<SkySys> DATASYS_KEY = new SkySysConfigKey(new ConfigMeta("datasys", "Data Sky System").setShortDescription("Sky system of HEALPix grid").setXmlDescription(new String[]{"<p>The sky coordinate system to which the HEALPix grid", "used by the input pixel file refers.", "</p>"}), false, true);
    public static final ConfigKey<SolidAngleUnit> ANGLE_KEY = SkyDensityPlotter.ANGLE_KEY;
    public static final ConfigKey<Integer> DEGRADE_KEY;
    public static final ConfigKey<Combiner> COMBINER_KEY;
    private static final ConfigKey<Double> TRANSPARENCY_KEY;
    private static final AuxScale SCALE;
    private static final RampKeySet RAMP_KEYS;
    private static final Logger logger_;

    public HealpixPlotter(boolean transparent) {
        super("Healpix", ResourceIcon.PLOT_HEALPIX, CoordGroup.createCoordGroup(1, new Coord[]{VALUE_COORD}), false);
        this.icHealpix_ = 0;
        this.icValue_ = 1;
        this.transparent_ = transparent;
        this.reportAuxKeys_ = false;
    }

    @Override
    public String getPlotterDescription() {
        StringBuffer sbuf = new StringBuffer().append("<p>Plots a table representing HEALPix pixels ").append("on the sky.\n").append("Each row represents a single HEALPix tile,\n").append("and a value from that row is used to colour\n").append("the corresponding region of the sky plot.\n").append("</p>\n");
        sbuf.append("<p>");
        if (this.reportAuxKeys_) {
            sbuf.append("There are additional options to adjust\n").append("the way data values are mapped to colours.\n");
        } else {
            sbuf.append("The way that data values are mapped\n").append("to colours is usually controlled by options\n").append("at the level of the plot itself,\n").append("rather than by per-layer configuration.\n");
        }
        sbuf.append("</p>\n");
        return sbuf.toString();
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList keyList = new ArrayList();
        keyList.add(DATALEVEL_KEY);
        keyList.add(DATASYS_KEY);
        keyList.add(DEGRADE_KEY);
        keyList.add(COMBINER_KEY);
        keyList.add(ANGLE_KEY);
        if (this.transparent_) {
            keyList.add(TRANSPARENCY_KEY);
        }
        if (this.reportAuxKeys_) {
            keyList.addAll(Arrays.asList(RAMP_KEYS.getKeys()));
        }
        return keyList.toArray(new ConfigKey[0]);
    }

    @Override
    public HealpixStyle createStyle(ConfigMap config) {
        SkySys viewSys = config.get(SkySurfaceFactory.VIEWSYS_KEY);
        RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
        int dataLevel = config.get(DATALEVEL_KEY);
        SkySys dataSys = config.get(DATASYS_KEY);
        int degrade = config.get(DEGRADE_KEY);
        Combiner combiner = config.get(COMBINER_KEY);
        SolidAngleUnit angle = config.get(ANGLE_KEY);
        Rotation rotation = Rotation.createRotation(dataSys, viewSys);
        Scaling scaling = ramp.getScaling();
        Subrange dataclip = ramp.getDataClip();
        float scaleAlpha = 1.0f - config.get(TRANSPARENCY_KEY).floatValue();
        Shader shader = Shaders.fade(ramp.getShader(), scaleAlpha);
        return new HealpixStyle(dataLevel, degrade, rotation, scaling, dataclip, shader, combiner, angle);
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, HealpixStyle style) {
        if (!(geom instanceof HealpixDataGeom)) {
            throw new IllegalArgumentException("DataGeom not Healpix: " + geom);
        }
        StarTable table = dataSpec.getSourceTable();
        List tparams = table.getParameters();
        HealpixTableInfo hpxInfo = HealpixTableInfo.isHealpix((List)tparams) ? HealpixTableInfo.fromParams((List)tparams) : null;
        int dataLevel = -1;
        if (dataLevel < 0 && style.dataLevel_ >= 0) {
            dataLevel = style.dataLevel_;
        }
        if (dataLevel < 0 && hpxInfo != null) {
            dataLevel = hpxInfo.getLevel();
        }
        if (dataLevel < 0) {
            dataLevel = HealpixPlotter.guessDataLevel(table.getRowCount());
        }
        if (dataLevel >= 0) {
            int nside = 1 << dataLevel;
            IndexReader rdr = dataSpec.isCoordBlank(this.icHealpix_) ? new IndexReader(){

                @Override
                public long getHealpixIndex(Tuple tuple) {
                    return tuple.getRowIndex();
                }
            } : new IndexReader(){

                @Override
                public long getHealpixIndex(Tuple tuple) {
                    return HealpixDataGeom.HEALPIX_COORD.readLongCoord(tuple, HealpixPlotter.this.icHealpix_);
                }
            };
            return new BinsHealpixLayer(geom, dataSpec, style, dataLevel, rdr);
        }
        return null;
    }

    private static int guessDataLevel(long nrow) {
        if (nrow > 0L) {
            for (int il = 0; il <= 29; ++il) {
                long hprow = 12L * (1L << 2 * il);
                if (nrow != hprow && nrow != hprow + 1L && (nrow > hprow || !((double)nrow >= 0.95 * (double)hprow))) continue;
                return il;
            }
        }
        return -1;
    }

    private static ConfigKey<Integer> createDataLevelKey() {
        ConfigMeta meta = new ConfigMeta("datalevel", "HEALPix Data Level");
        meta.setShortDescription("HEALPix level of tile index");
        meta.setXmlDescription(new String[]{"<p>HEALPix level of the (implicit or explicit) tile indices.", "Legal values are between 0 (12 pixels) and", Integer.toString(29), "(" + Long.toString(12L * (long)Math.pow(4.0, 29.0)) + " pixels).", "If a negative value is supplied (the default),", "then an attempt is made to determine the correct level", "from the data.", "</p>"});
        final ArrayList<Integer> levelOptions = new ArrayList<Integer>();
        levelOptions.add(-1);
        for (int i = 0; i <= 29; ++i) {
            levelOptions.add(i);
        }
        IntegerConfigKey key = new IntegerConfigKey(meta, -1){

            @Override
            public Specifier<Integer> createSpecifier() {
                return new ComboBoxSpecifier<Integer>(Integer.class, levelOptions);
            }
        };
        return key;
    }

    private static Icon createHealpixIcon(final Shader shader, final int width, final int height, final int xpad, final int ypad) {
        final double xd = (double)(width - 2 * xpad) * 0.25;
        final double yd = (double)(width - 2 * ypad) * 0.25;
        return new Icon(){

            @Override
            public int getIconWidth() {
                return width;
            }

            @Override
            public int getIconHeight() {
                return height;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int xoff = x + xpad;
                int yoff = y + ypad;
                g.translate(xoff, yoff);
                Color color0 = g.getColor();
                this.paintDiamond(g, 0.125, 2, 0);
                this.paintDiamond(g, 0.625, 1, 1);
                this.paintDiamond(g, 0.875, 3, 1);
                this.paintDiamond(g, 0.375, 2, 2);
                g.setColor(color0);
                g.translate(-xoff, -yoff);
            }

            private void paintDiamond(Graphics g, double shade, int ix, int iy) {
                float[] rgba = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
                shader.adjustRgba(rgba, (float)shade);
                g.setColor(new Color(rgba[0], rgba[1], rgba[2], rgba[3]));
                int[] xs = new int[]{(int)xd * ix, (int)xd * (ix - 1), (int)xd * ix, (int)xd * (ix + 1)};
                int[] ys = new int[]{(int)yd * iy, (int)yd * (iy + 1), (int)yd * (iy + 2), (int)yd * (iy + 1)};
                g.fillPolygon(xs, ys, 4);
            }
        };
    }

    static {
        TRANSPARENCY_KEY = StyleKeys.TRANSPARENCY;
        SCALE = AuxScale.COLOR;
        ConfigMeta degradeMeta = new ConfigMeta("degrade", "Degrade");
        ConfigMeta combineMeta = new ConfigMeta("combine", "Combine");
        degradeMeta.setShortDescription("HEALPix level degradation");
        degradeMeta.setXmlDescription(new String[]{"<p>Allows the HEALPix grid to be drawn at a less detailed", "level than the level at which the input data are supplied.", "A value of zero (the default) means that the HEALPix tiles", "are painted with the same resolution as the input data,", "but a higher value will degrade resolution of the plot tiles;", "each plotted tile will correspond to", "4^<code>" + degradeMeta.getShortName() + "</code> input tiles.", "The way that values are combined within each painted tile", "is controlled by the", "<code>" + combineMeta.getShortName() + "</code> value.", "</p>"});
        combineMeta.setShortDescription("Tile degrade combination mode");
        combineMeta.setXmlDescription(new String[]{"<p>Defines how values degraded to a lower HEALPix level", "are combined together to produce the value assigned to the", "larger tile, and hence its colour.", "This is mostly useful in the case that", "<code>" + degradeMeta.getShortName() + "</code>&gt;0.", "</p>", "<p>For density-like values", "(<code>" + Combiner.DENSITY + "</code>,", "<code>" + Combiner.WEIGHTED_DENSITY + "</code>)", "the scaling is additionally influenced by the", "<code>" + ANGLE_KEY.getMeta().getShortName() + "</code>", "parameter.", "</p>"});
        DEGRADE_KEY = IntegerConfigKey.createSpinnerKey(degradeMeta, 0, 0, 29);
        COMBINER_KEY = new OptionConfigKey<Combiner>(combineMeta, Combiner.class, Combiner.getKnownCombiners(), Combiner.MEAN){

            @Override
            public String getXmlDescription(Combiner combiner) {
                return combiner.getDescription();
            }
        }.setOptionUsage().addOptionsXml();
        RAMP_KEYS = StyleKeys.AUX_RAMP;
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.layer");
    }

    private static interface IndexReader {
        public long getHealpixIndex(Tuple var1);
    }

    private static class TilePlan {
        final int dataLevel_;
        final int viewLevel_;
        final Combiner combiner_;
        final DataSpec dataSpec_;
        final BinList.Result binResult_;

        TilePlan(int dataLevel, int viewLevel, Combiner combiner, DataSpec dataSpec, BinList.Result binResult) {
            this.dataLevel_ = dataLevel;
            this.viewLevel_ = viewLevel;
            this.combiner_ = combiner;
            this.dataSpec_ = dataSpec;
            this.binResult_ = binResult;
        }

        public boolean matches(int dataLevel, int viewLevel, Combiner combiner, DataSpec dataSpec) {
            return this.dataLevel_ == dataLevel && this.viewLevel_ == viewLevel && this.combiner_ == combiner && this.dataSpec_.equals(dataSpec);
        }
    }

    private class BinsHealpixLayer
    extends AbstractPlotLayer {
        private final HealpixStyle hstyle_;
        private final int dataLevel_;
        private final int viewLevel_;
        private final IndexReader indexReader_;

        BinsHealpixLayer(DataGeom geom, DataSpec dataSpec, HealpixStyle hstyle, int dataLevel, IndexReader indexReader) {
            super(HealpixPlotter.this, geom, dataSpec, hstyle, hstyle.isOpaque() ? LayerOpt.OPAQUE : LayerOpt.NO_SPECIAL);
            this.hstyle_ = hstyle;
            this.dataLevel_ = dataLevel;
            this.indexReader_ = indexReader;
            this.viewLevel_ = Math.max(0, this.dataLevel_ - this.hstyle_.degrade_);
            assert (hstyle.degrade_ >= 0);
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers() {
            HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
            map.put(SCALE, new AuxReader(){

                @Override
                public int getCoordIndex() {
                    return HealpixPlotter.this.icValue_;
                }

                @Override
                public ValueInfo getAxisInfo(DataSpec dataSpec) {
                    return BinsHealpixLayer.this.getCombinedInfo(dataSpec);
                }

                @Override
                public Scaling getScaling() {
                    return BinsHealpixLayer.this.hstyle_.scaling_;
                }

                @Override
                public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] knownPlans, Ranger ranger) {
                    TilePlan tplan = BinsHealpixLayer.this.getTilePlan(knownPlans);
                    BinList.Result binResult = tplan == null ? BinsHealpixLayer.this.readBins(dataSpec, dataStore) : tplan.binResult_;
                    BinsHealpixLayer.this.createTileRenderer(surface).extendAuxRange(ranger, binResult);
                }
            });
            return map;
        }

        @Override
        public Drawing createDrawing(Surface surf, Map<AuxScale, Span> auxSpans, final PaperType paperType) {
            final DataSpec dataSpec = this.getDataSpec();
            final Combiner combiner = this.hstyle_.combiner_;
            final Shader shader = this.hstyle_.shader_;
            final Scaler scaler = auxSpans.get(SCALE).createScaler(this.hstyle_.scaling_, this.hstyle_.dataclip_);
            final SkyTileRenderer renderer = this.createTileRenderer(surf);
            return new Drawing(){

                @Override
                public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                    TilePlan knownPlan = BinsHealpixLayer.this.getTilePlan(knownPlans);
                    if (knownPlan != null) {
                        return knownPlan;
                    }
                    BinList.Result binResult = BinsHealpixLayer.this.readBins(dataSpec, dataStore).compact();
                    return new TilePlan(BinsHealpixLayer.this.dataLevel_, BinsHealpixLayer.this.viewLevel_, combiner, dataSpec, binResult);
                }

                @Override
                public void paintData(Object plan, Paper paper, DataStore dataStore) {
                    final BinList.Result binResult = ((TilePlan)plan).binResult_;
                    paperType.placeDecal(paper, new Decal(){

                        @Override
                        public void paintDecal(Graphics g) {
                            renderer.renderBins(g, binResult, shader, scaler);
                        }

                        @Override
                        public boolean isOpaque() {
                            return BinsHealpixLayer.this.hstyle_.isOpaque();
                        }
                    });
                }

                @Override
                public ReportMap getReport(Object plan) {
                    return null;
                }
            };
        }

        private SkyTileRenderer createTileRenderer(Surface surf) {
            double binExtent = Tilings.healpixSqdeg(this.viewLevel_) / this.hstyle_.angle_.getExtentInSquareDegrees();
            Combiner.Type ctype = this.hstyle_.combiner_.getType();
            double binFactor = ctype.getBinFactor(binExtent);
            return SkyTileRenderer.createRenderer((SkySurface)surf, this.hstyle_.rotation_, this.viewLevel_, binFactor);
        }

        private TilePlan getTilePlan(Object[] knownPlans) {
            DataSpec dataSpec = this.getDataSpec();
            for (Object plan : knownPlans) {
                TilePlan tplan;
                if (!(plan instanceof TilePlan) || !(tplan = (TilePlan)plan).matches(this.dataLevel_, this.viewLevel_, this.hstyle_.combiner_, dataSpec)) continue;
                return tplan;
            }
            return null;
        }

        private BinList.Result readBins(DataSpec dataSpec, DataStore dataStore) {
            int degrade = this.dataLevel_ - this.viewLevel_;
            assert (degrade >= 0);
            final int shift = degrade * 2;
            final long dataNpix = 12L * (1L << 2 * this.dataLevel_);
            long viewNbin = 12L * (1L << 2 * this.viewLevel_);
            Combiner combiner = this.hstyle_.combiner_;
            BinListCollector collector = new BinListCollector(combiner, viewNbin){

                public void accumulate(TupleSequence tseq, BinList binList) {
                    while (tseq.next()) {
                        long hpx;
                        double value = tseq.getDoubleValue(HealpixPlotter.this.icValue_);
                        if (Double.isNaN(value) || (hpx = BinsHealpixLayer.this.indexReader_.getHealpixIndex(tseq)) < 0L || hpx >= dataNpix) continue;
                        long ibin = hpx >> shift;
                        binList.submitToBin(ibin, value);
                    }
                }
            };
            boolean forceSequential = this.viewLevel_ > 9 || combiner.hasBigBin();
            return (forceSequential ? TupleRunner.SEQUENTIAL : dataStore.getTupleRunner()).collect(collector, () -> dataStore.getTupleSequence(dataSpec)).getResult();
        }

        private ValueInfo getCombinedInfo(DataSpec dataSpec) {
            ValueInfo[] winfos;
            Object weightInfo = HealpixPlotter.this.icValue_ < 0 || dataSpec.isCoordBlank(HealpixPlotter.this.icValue_) ? new DefaultValueInfo("1", Double.class, "Weight unspecified, taken as unity") : ((winfos = dataSpec.getUserCoordInfos(HealpixPlotter.this.icValue_)) != null && winfos.length == 1 ? winfos[0] : new DefaultValueInfo("Weight", Double.class));
            return this.hstyle_.combiner_.createCombinedInfo((ValueInfo)weightInfo, this.hstyle_.angle_);
        }
    }

    public static class HealpixStyle
    implements Style {
        private final int dataLevel_;
        private final int degrade_;
        private final Rotation rotation_;
        private final Scaling scaling_;
        private final Subrange dataclip_;
        private final Shader shader_;
        private final Combiner combiner_;
        private final SolidAngleUnit angle_;

        public HealpixStyle(int dataLevel, int degrade, Rotation rotation, Scaling scaling, Subrange dataclip, Shader shader, Combiner combiner, SolidAngleUnit angle) {
            this.dataLevel_ = dataLevel;
            this.degrade_ = degrade;
            this.rotation_ = rotation;
            this.scaling_ = scaling;
            this.dataclip_ = dataclip;
            this.shader_ = shader;
            this.combiner_ = combiner;
            this.angle_ = angle;
        }

        boolean isOpaque() {
            return !Shaders.isTransparent(this.shader_);
        }

        @Override
        public Icon getLegendIcon() {
            return HealpixPlotter.createHealpixIcon(this.shader_, 18, 16, 1, 1);
        }

        public int hashCode() {
            int code = 553227;
            code = 23 * code + this.dataLevel_;
            code = 23 * code + this.degrade_;
            code = 23 * code + this.rotation_.hashCode();
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + this.dataclip_.hashCode();
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.combiner_.hashCode();
            code = 23 * code + this.angle_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof HealpixStyle) {
                HealpixStyle other = (HealpixStyle)o;
                return this.dataLevel_ == other.dataLevel_ && this.degrade_ == other.degrade_ && this.rotation_.equals(other.rotation_) && this.scaling_.equals(other.scaling_) && this.dataclip_.equals(other.dataclip_) && this.shader_.equals(other.shader_) && this.combiner_.equals(other.combiner_) && this.angle_.equals(other.angle_);
            }
            return false;
        }
    }
}

