/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.PerUnitConfigKey;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.layer.AbstractKernelDensityPlotter;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Kernel1d;
import uk.ac.starlink.ttools.plot2.layer.Kernel1dShape;
import uk.ac.starlink.ttools.plot2.layer.Pixel1dPlotter;
import uk.ac.starlink.ttools.plot2.layer.Unit;

public class KnnKernelDensityPlotter
extends AbstractKernelDensityPlotter {
    public static final ReportKey<Double> MINWIDTH_RKEY = ReportKey.createDoubleKey(new ReportMeta("minwidth", "Minimum smoothing width"), false);
    public static final ReportKey<Double> MAXWIDTH_RKEY = ReportKey.createDoubleKey(new ReportMeta("maxwidth", "Maximum smoothing width"), false);
    public static final ConfigKey<Double> KNN_CKEY = new DoubleConfigKey(new ConfigMeta("knn", "Knn K").setShortDescription("Number of nearest neighbours").setXmlDescription(new String[]{"<p>Sets the number of nearest neighbours to count", "away from a sample point to determine the width", "of the smoothing kernel at that point.", "For the symmetric case this is the number of nearest", "neighbours summed over both directions,", "and for the asymmetric case it is the number in a single", "direction.", "</p>", "<p>The threshold is actually the weighted total of samples;", "for unweighted (<code>weight=1</code>) bins", "that is equivalent to the number of samples.", "</p>"}), 100.0){

        @Override
        public Specifier<Double> createSpecifier() {
            return new SliderSpecifier(1.0, 10000.0, true, 100.0, false, SliderSpecifier.TextOption.ENTER_ECHO);
        }
    };
    public static final ConfigKey<Boolean> SYMMETRIC_CKEY = new BooleanConfigKey(new ConfigMeta("symmetric", "Symmetric").setShortDescription("KNN search in both directions?").setXmlDescription(new String[]{"<p>If true, the nearest neigbour search is carried out", "in both directions, and the kernel is symmetric.", "If false, the nearest neigbour search is carried out", "separately in the positive and negative directions,", "and the kernel width is accordingly different in the", "positive and negative directions.", "</p>"}), true);
    public static final ConfigKey<BinSizer> MINSIZER_CKEY = KnnKernelDensityPlotter.createLimitSizerKey(false);
    public static final ConfigKey<BinSizer> MAXSIZER_CKEY = KnnKernelDensityPlotter.createLimitSizerKey(true);

    public KnnKernelDensityPlotter(FloatingCoord xCoord, boolean hasWeight, PerUnitConfigKey<Unit> unitKey) {
        super(xCoord, hasWeight, unitKey, "Knn", ResourceIcon.FORM_KNN);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a Discrete Kernel Density Estimate", "giving a smoothed frequency of data values along the", "horizontal axis, using an adaptive (K-Nearest-Neighbours)", "smoothing kernel.", "This is a generalisation of a histogram in which", "the bins are always 1 pixel wide,", "and a smoothing kernel is applied to each bin.", "The width and shape of the kernel may be varied.", "</p>", "<p>The K-Nearest-Neighbour figure gives the number of", "points in each direction to determine the width of the", "smoothing kernel for smoothing each bin.", "Upper and lower limits for the kernel width are also supplied;", "if the upper and lower limits are equal, this is equivalent", "to a fixed-width kernel.", "</p>", "<p>Note this is not a true Kernel Density Estimate,", "since, for performance reasons,", "the smoothing is applied to the (pixel-width) bins", "rather than to each data sample.", "The deviation from a true KDE caused by this quantisation", "will be at the pixel level,", "hence in most cases not visually apparent.", "</p>"});
    }

    @Override
    protected ConfigKey<?>[] getKernelConfigKeys() {
        return new ConfigKey[]{KNN_CKEY, SYMMETRIC_CKEY, MINSIZER_CKEY, MAXSIZER_CKEY};
    }

    @Override
    protected AbstractKernelDensityPlotter.KernelFigure createKernelFigure(ConfigMap config) throws ConfigException {
        double k = config.get(KNN_CKEY);
        boolean isSymmetric = config.get(SYMMETRIC_CKEY);
        BinSizer minSizer = config.get(MINSIZER_CKEY);
        BinSizer maxSizer = config.get(MAXSIZER_CKEY);
        if (minSizer.getScaleWidth(Scale.LINEAR, 0.0, 1.0, false) > maxSizer.getScaleWidth(Scale.LINEAR, 0.0, 1.0, false)) {
            throw new ConfigException(MINSIZER_CKEY, "Smoothing min/max are the wrong way round");
        }
        assert (config.get(this.getCombinerKey()).getType().isExtensive());
        return new KnnKernelFigure(k, isSymmetric, minSizer, maxSizer);
    }

    private static ConfigKey<BinSizer> createLimitSizerKey(boolean isMax) {
        ConfigMeta meta = new ConfigMeta((isMax ? "max" : "min") + "smooth", (isMax ? "Max" : "Min") + " Smoothing");
        meta.setStringUsage("+<width>|-<count>");
        meta.setShortDescription((isMax ? "Upper" : "Lower") + " size limit of smoothing kernel");
        meta.setXmlDescription(new String[]{"<p>Fixes the", isMax ? "maximum" : "minimum", "size of the smoothing kernel.", "This functions as", isMax ? "an upper" : "a lower", "limit on the distance that is otherwise determined by", "searching for the K nearest neighbours at each sample point.", "</p>", BinSizer.getConfigKeyDescription()});
        ReportKey<Double> reportKey = isMax ? MAXWIDTH_RKEY : MINWIDTH_RKEY;
        int dfltNbin = isMax ? 100 : 0;
        boolean allowZero = true;
        return BinSizer.createSizerConfigKey(meta, reportKey, dfltNbin, allowZero);
    }

    private static class KnnKernelFigure
    implements AbstractKernelDensityPlotter.KernelFigure {
        private final double knn_;
        private final boolean isSymmetric_;
        private final BinSizer minSizer_;
        private final BinSizer maxSizer_;

        KnnKernelFigure(double knn, boolean isSymmetric, BinSizer minSizer, BinSizer maxSizer) {
            this.knn_ = knn;
            this.isSymmetric_ = isSymmetric;
            this.minSizer_ = minSizer;
            this.maxSizer_ = maxSizer;
        }

        @Override
        public Kernel1d createKernel(Kernel1dShape shape, Axis xAxis) {
            int minWidth = (int)Pixel1dPlotter.getPixelWidth(this.minSizer_, xAxis);
            int maxWidth = (int)Pixel1dPlotter.getPixelWidth(this.maxSizer_, xAxis);
            return shape.createKnnKernel(this.knn_, this.isSymmetric_, minWidth, maxWidth);
        }

        @Override
        public ReportMap getReportMap(Axis xAxis) {
            Scale scale = xAxis.getScale();
            double[] dLimits = xAxis.getDataLimits();
            double dlo = dLimits[0];
            double dhi = dLimits[1];
            double minWidth = this.minSizer_.getScaleWidth(scale, dlo, dhi, false);
            double maxWidth = this.maxSizer_.getScaleWidth(scale, dlo, dhi, false);
            ReportMap report = new ReportMap();
            report.put(MINWIDTH_RKEY, minWidth);
            report.put(MAXWIDTH_RKEY, maxWidth);
            return report;
        }

        public int hashCode() {
            int code = 2134233;
            code = 23 * code + Float.floatToIntBits((float)this.knn_);
            code = 23 * code + (this.isSymmetric_ ? 11 : 13);
            code = 23 * code + this.minSizer_.hashCode();
            code = 23 * code + this.maxSizer_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof KnnKernelFigure) {
                KnnKernelFigure other = (KnnKernelFigure)o;
                return this.knn_ == other.knn_ && this.isSymmetric_ == other.isSymmetric_ && this.minSizer_.equals(other.minSizer_) && this.maxSizer_.equals(other.maxSizer_);
            }
            return false;
        }
    }
}

