/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.layer.NumberArray;

@Equality
public abstract class LevelMode {
    private final String name_;
    private final String description_;
    private static final int NCLIP = 16;
    public static LevelMode LINEAR = new LevelMode("linear", "levels are equally spaced"){

        @Override
        public double[] calculateLevels(NumberArray array, int nLevel, double offset, boolean isCounts) {
            return LevelMode.calculateLinearLevels(array, nLevel, offset, isCounts);
        }
    };
    public static LevelMode LOG = new LevelMode("log", "level logarithms are equally spaced"){

        @Override
        public double[] calculateLevels(NumberArray array, int nLevel, double offset, boolean isCounts) {
            return LevelMode.calculateLogLevels(array, nLevel, offset, isCounts);
        }
    };
    public static LevelMode EQU = new LevelMode("equal", "levels are spaced to provide equal-area inter-contour regions"){

        @Override
        public double[] calculateLevels(NumberArray array, int nLevel, double offset, boolean isCounts) {
            return LevelMode.calculateEquivLevels(array, nLevel, offset, isCounts);
        }
    };
    public static final LevelMode[] MODES = new LevelMode[]{LINEAR, LOG, EQU};

    protected LevelMode(String name, String description) {
        this.name_ = name;
        this.description_ = description;
    }

    public abstract double[] calculateLevels(NumberArray var1, int var2, double var3, boolean var5);

    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.name_;
    }

    private static double[] calculateLinearLevels(NumberArray array, int nLevel, double offset, boolean isCounts) {
        double[] limits = LevelMode.getCutLimits(array, 16, false);
        double min = limits[0];
        double max = limits[1];
        if (isCounts) {
            min = Math.max(1.0, min);
            max = Math.max(1.0, max);
        }
        if (!(max > min)) {
            return new double[0];
        }
        double step = (max - min) / (double)nLevel;
        if (isCounts) {
            step = Math.max(1.0, step);
        }
        double[] levels = new double[nLevel];
        for (int il = 0; il < nLevel; ++il) {
            levels[il] = min + step * ((double)il + offset);
        }
        return levels;
    }

    private static double[] calculateLogLevels(NumberArray array, int nLevel, double offset, boolean isCounts) {
        double max;
        double[] limits = LevelMode.getCutLimits(array, 16, true);
        double min = isCounts ? Math.max(1.0, limits[0]) : limits[0];
        double d = max = isCounts ? Math.max(1.0, limits[1]) : limits[1];
        if (!(max > min)) {
            return new double[0];
        }
        double step = (Math.log(max) - Math.log(min)) / (double)nLevel;
        double[] levels = new double[nLevel];
        for (int il = 0; il < nLevel; ++il) {
            levels[il] = min * Math.exp(step * ((double)il + offset));
        }
        return levels;
    }

    private static double[] calculateEquivLevels(NumberArray array, int nLevel, double offset, boolean isCounts) {
        int npix = array.getLength();
        float[] values = new float[npix];
        int ngood = 0;
        for (int ip = 0; ip < npix; ++ip) {
            double v = array.getValue(ip);
            if (Double.isNaN(v) || isCounts && !(v > 0.0)) continue;
            values[ngood++] = (float)v;
        }
        if (ngood == 0) {
            return new double[0];
        }
        Arrays.sort(values, 0, ngood);
        double[] levels = new double[nLevel];
        int lastIndex = 0;
        double lastLevel = 0.0;
        for (int il = 0; il < nLevel; ++il) {
            int index = (int)((double)lastIndex + (double)(ngood - lastIndex) * 1.0 / ((double)nLevel + offset - (double)il));
            index = Math.min(index, ngood - 1);
            double level = values[index];
            if (isCounts && level - lastLevel < 1.0 && (index = Arrays.binarySearch(values, 0, ngood, (float)(level = lastLevel + 1.0))) < 0) {
                index = -(index + 1);
            }
            levels[il] = level;
            lastIndex = index;
            lastLevel = level;
        }
        return levels;
    }

    private static double[] getCutLimits(NumberArray array, int nExclude, boolean isLog) {
        double[] tops = new double[nExclude + 1];
        double[] bots = new double[nExclude + 1];
        Arrays.fill(tops, Double.NEGATIVE_INFINITY);
        Arrays.fill(bots, Double.POSITIVE_INFINITY);
        int np = array.getLength();
        for (int ip = 0; ip < np; ++ip) {
            double c = array.getValue(ip);
            if (Double.isNaN(c) || isLog && !(c > 0.0)) continue;
            if (c > tops[0]) {
                tops[0] = c;
                Arrays.sort(tops);
            }
            if (!(c < bots[nExclude - 1])) continue;
            bots[nExclude - 1] = c;
            Arrays.sort(bots);
        }
        return new double[]{bots[nExclude - 1], tops[0]};
    }
}

