/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.layer.CombineArrayPlotter;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.LineStyle;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class LineCombineArrayPlotter
extends CombineArrayPlotter<LineCombineArrayStyle> {
    public static final LineCombineArrayPlotter INSTANCE = new LineCombineArrayPlotter();
    public static ConfigKey<Integer> THICK_KEY = StyleKeys.createThicknessKey(3);

    private LineCombineArrayPlotter() {
        super("StatLine", ResourceIcon.PLOT_STATLINE);
    }

    @Override
    public String getPlotterDescription() {
        return String.join((CharSequence)"\n", "<p>Plots a single line based on a combination", "(typically the mean) of input array-valued coordinates.", "The input X and Y coordinates must be fixed-length arrays", "of length N;", "a line with N points is plotted, each point representing", "the mean (or median, minimum, maximum, ...)", "of all the input array elements at the corresponding position.", "</p>", LineCombineArrayPlotter.getXYCombineComment(), "");
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList<ConfigKey<Serializable>> list = new ArrayList<ConfigKey<Serializable>>();
        list.add(XCOMBINER_KEY);
        list.add(YCOMBINER_KEY);
        list.add(StyleKeys.COLOR);
        list.add(THICK_KEY);
        list.add(StyleKeys.ANTIALIAS);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public LineCombineArrayStyle createStyle(ConfigMap config) {
        Combiner xCombiner = (Combiner)config.get(XCOMBINER_KEY);
        Combiner yCombiner = (Combiner)config.get(YCOMBINER_KEY);
        int thick = config.get(THICK_KEY);
        Color color = config.get(StyleKeys.COLOR);
        BasicStroke stroke = new BasicStroke(thick, 1, 1);
        boolean antialias = config.get(StyleKeys.ANTIALIAS);
        return new LineCombineArrayStyle(xCombiner, yCombiner, color, stroke, antialias);
    }

    public static class LineCombineArrayStyle
    extends CombineArrayPlotter.CombineArrayStyle {
        private final Color color_;
        private final Stroke stroke_;
        private final boolean isAntialias_;
        private final Icon icon_;

        public LineCombineArrayStyle(Combiner xCombiner, Combiner yCombiner, Color color, Stroke stroke, boolean isAntialias) {
            super(xCombiner, yCombiner, new LayerOpt(color, !isAntialias));
            this.color_ = color;
            this.stroke_ = stroke;
            this.isAntialias_ = isAntialias;
            this.icon_ = new LineStyle(color, stroke, isAntialias).getLegendIcon();
        }

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public void paintPoints(final PlanarSurface surface, final PaperType paperType, Paper paper, final Point2D.Double[] gpoints) {
            paperType.placeDecal(paper, new Decal(){

                @Override
                public void paintDecal(Graphics g) {
                    LineTracer tracer = new LineTracer(g, surface.getPlotBounds(), stroke_, isAntialias_, gpoints.length + 1, paperType.isBitmap());
                    for (Point2D.Double gp : gpoints) {
                        tracer.addVertex(gp.getX(), gp.getY(), color_);
                    }
                    tracer.flush();
                }

                @Override
                public boolean isOpaque() {
                    return !isAntialias_;
                }
            });
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code = 23 * code + this.color_.hashCode();
            code = 23 * code + this.stroke_.hashCode();
            code = 23 * code + (this.isAntialias_ ? 99 : 101);
            return code;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof LineCombineArrayStyle) {
                LineCombineArrayStyle other = (LineCombineArrayStyle)o;
                return super.equals(other) && this.color_.equals(other.color_) && this.stroke_.equals(other.stroke_) && this.isAntialias_ == other.isAntialias_;
            }
            return false;
        }
    }
}

