/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.layer.DrawingGlyph;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.PixelDrawing;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.layer.StrokeKit;

public abstract class LineGlyph
extends DrawingGlyph {
    public abstract Rectangle getPixelBounds();

    public abstract void drawShape(PixelDrawing var1);

    public abstract void paintGlyph(Graphics var1, StrokeKit var2);

    @Override
    public PixelDrawing createPixerFactory(Rectangle clip) {
        Rectangle bounds = this.getPixelBounds();
        int xlo = Math.max(clip.x, bounds.x);
        int xhi = Math.min(clip.x + clip.width, bounds.x + bounds.width);
        int dw = xhi - xlo;
        if (dw > 0) {
            int ylo = Math.max(clip.y, bounds.y);
            int yhi = Math.min(clip.y + clip.height, bounds.y + bounds.height);
            int dh = yhi - ylo;
            if (dh > 0) {
                PixelDrawing drawing = new PixelDrawing(xlo, ylo, dw, dh);
                this.drawShape(drawing);
                return drawing;
            }
        }
        return null;
    }

    @Override
    public void paintGlyph(Graphics g) {
        this.paintGlyph(g, StrokeKit.DEFAULT);
    }

    public DrawingGlyph toThicker(PixerFactory kernel, StrokeKit strokeKit) {
        return new ThickerGlyph(this, kernel, strokeKit);
    }

    public static PixerFactory createThickKernel(int nthick) {
        return LineGlyph.createKernel(nthick == 1 ? MarkerShape.CROSS : MarkerShape.FILLED_CIRCLE, nthick);
    }

    public static PixerFactory createKernel(MarkerShape shape, int nthick) {
        return shape.getStyle(Color.BLACK, nthick).getPixerFactory();
    }

    public static StrokeKit createThickStrokeKit(int nthick) {
        return new StrokeKit(1.0f + (float)(2 * nthick));
    }

    private static class ThickerGlyph
    extends DrawingGlyph {
        private final LineGlyph base_;
        private final PixerFactory kernel_;
        private final StrokeKit strokeKit_;

        public ThickerGlyph(LineGlyph base, PixerFactory kernel, StrokeKit strokeKit) {
            this.base_ = base;
            this.kernel_ = kernel;
            this.strokeKit_ = strokeKit;
        }

        @Override
        public void paintGlyph(Graphics g) {
            this.base_.paintGlyph(g, this.strokeKit_);
        }

        @Override
        public PixelDrawing createPixerFactory(Rectangle clip) {
            Rectangle baseBounds = this.base_.getPixelBounds();
            int xlo = Math.max(baseBounds.x + this.kernel_.getMinX(), clip.x);
            int xhi = Math.min(baseBounds.x + baseBounds.width + this.kernel_.getMaxX(), clip.x + clip.width);
            int dw = xhi - xlo;
            if (dw > 0) {
                int ylo = Math.max(baseBounds.y + this.kernel_.getMinY(), clip.y);
                int yhi = Math.min(baseBounds.y + baseBounds.height + this.kernel_.getMaxY(), clip.y + clip.height);
                int dh = yhi - ylo;
                if (dh > 0) {
                    PixelDrawing drawing = new PixelDrawing(xlo, ylo, dw, dh);
                    this.base_.drawShape(drawing);
                    return Pixers.convolve(drawing, this.kernel_, clip);
                }
            }
            return null;
        }
    }
}

