/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.LineStyle;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.util.SplitCollector;

public class LinearFitPlotter
extends AbstractPlotter<LineStyle> {
    public static final ReportKey<double[]> COEFFS_KEY = new ReportKey<double[]>(new ReportMeta("coeffs", "Coefficients"), double[].class, false){

        @Override
        public String toText(double[] value) {
            return Arrays.toString(value);
        }
    };
    public static final ReportKey<String> EQUATION_KEY = ReportKey.createStringKey(new ReportMeta("equation", "Equation"), true);
    public static final ReportKey<Double> CORRELATION_KEY = ReportKey.createDoubleKey(new ReportMeta("correlation", "Correlation"), true);
    public static final ReportKey<Double> RMSD_KEY = ReportKey.createDoubleKey(new ReportMeta("RMSD", "RMS Deviation"), true);
    private static final ReportKey<Double> C0_KEY = ReportKey.createDoubleKey(new ReportMeta("c", "c"), true);
    private static final ReportKey<Double> C1_KEY = ReportKey.createDoubleKey(new ReportMeta("m", "m"), true);
    private static final FloatingCoord WEIGHT_COORD = FloatingCoord.createCoord(new InputMeta("weight", "Weight").setShortDescription("Weight for line fitting").setXmlDescription(new String[]{"<p>The weight associated with each data point", "for fitting purposes.", "This is used for calculating the coefficients of", "the line of best fit, and the correlation coefficient.", "If no coordinate is supplied, all points are assumed to", "have equal weight (1).", "Otherwise, any point with a null weight value", "is assigned a weight of zero, i.e. ignored.", "</p>", "<p>Given certain assumptions about independence of samples,", "a suitable value for the weight may be", "<code>1/(err*err)</code>, if <code>err</code> is the", "measurement error for each Y value.", "</p>"}), false);

    public LinearFitPlotter(boolean hasWeights) {
        Coord[] coordArray;
        if (hasWeights) {
            Coord[] coordArray2 = new Coord[1];
            coordArray = coordArray2;
            coordArray2[0] = WEIGHT_COORD;
        } else {
            coordArray = new Coord[]{};
        }
        super("LinearFit", ResourceIcon.FORM_LINEARFIT, CoordGroup.createCoordGroup(1, coordArray), true);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a line of best fit for the data points.", "</p>"});
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList list = new ArrayList();
        list.add(StyleKeys.COLOR);
        list.addAll(Arrays.asList(StyleKeys.getStrokeKeys()));
        list.add(StyleKeys.ANTIALIAS);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public LineStyle createStyle(ConfigMap config) {
        Color color = config.get(StyleKeys.COLOR);
        Stroke stroke = StyleKeys.createStroke(config, 1, 1);
        boolean antialias = config.get(StyleKeys.ANTIALIAS);
        return new LineStyle(color, stroke, antialias);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final LineStyle style) {
        LayerOpt layerOpt = new LayerOpt(style.getColor(), true);
        final CoordGroup cgrp = this.getCoordGroup();
        return new AbstractPlotLayer(this, geom, dataSpec, style, layerOpt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, PaperType paperType) {
                return new LinearFitDrawing((PlanarSurface)surface, geom, dataSpec, cgrp, style, paperType);
            }
        };
    }

    private static double log(double val) {
        return Math.log10(val);
    }

    private static double unlog(double val) {
        return Math.pow(10.0, val);
    }

    private static class WXYStats {
        private double sw_;
        private double swX_;
        private double swY_;
        private double swXX_;
        private double swYY_;
        private double swXY_;

        private WXYStats() {
        }

        public void addPoint(double x, double y, double w) {
            if (w > 0.0 && !Double.isInfinite(w)) {
                this.sw_ += w;
                this.swX_ += w * x;
                this.swY_ += w * y;
                this.swXX_ += w * x * x;
                this.swYY_ += w * y * y;
                this.swXY_ += w * x * y;
            }
        }

        public void addPoint(double x, double y) {
            this.sw_ += 1.0;
            this.swX_ += x;
            this.swY_ += y;
            this.swXX_ += x * x;
            this.swYY_ += y * y;
            this.swXY_ += x * y;
        }

        public void add(WXYStats other) {
            this.sw_ += other.sw_;
            this.swX_ += other.swX_;
            this.swY_ += other.swY_;
            this.swXX_ += other.swXX_;
            this.swYY_ += other.swYY_;
            this.swXY_ += other.swXY_;
        }

        public double[] getLinearCoefficients() {
            double sw2x = this.sw_ * this.swXX_ - this.swX_ * this.swX_;
            double c = (this.swXX_ * this.swY_ - this.swX_ * this.swXY_) / sw2x;
            double m = (this.sw_ * this.swXY_ - this.swX_ * this.swY_) / sw2x;
            return new double[]{c, m};
        }

        public double getCorrelation() {
            double sw2x = this.sw_ * this.swXX_ - this.swX_ * this.swX_;
            double sw2y = this.sw_ * this.swYY_ - this.swY_ * this.swY_;
            return (this.sw_ * this.swXY_ - this.swX_ * this.swY_) / Math.sqrt(sw2x * sw2y);
        }

        public double getRmsDeviation() {
            double[] cm = this.getLinearCoefficients();
            double c = cm[0];
            double m = cm[1];
            double nK2 = m * m * this.swXX_ + this.swYY_ - 2.0 * m * this.swXY_ + 2.0 * m * c * this.swX_ - 2.0 * c * this.swY_ + c * c * this.sw_;
            return Math.sqrt(nK2 / this.sw_);
        }
    }

    private static class LinearFitPlan {
        final WXYStats stats_;
        final DataSpec dataSpec_;
        final Scale[] scales_;

        LinearFitPlan(WXYStats stats, DataSpec dataSpec, Scale[] scales) {
            this.stats_ = stats;
            this.dataSpec_ = dataSpec;
            this.scales_ = scales;
        }

        boolean matches(DataSpec dataSpec, Scale[] scales) {
            return dataSpec.equals(this.dataSpec_) && Arrays.equals(scales, this.scales_);
        }

        void paintLine(Graphics g, PlanarSurface surface, LineStyle style) {
            Rectangle bounds = surface.getPlotBounds();
            int gy0 = bounds.y;
            int gx1 = bounds.x - 10;
            int gx2 = bounds.x + bounds.width + 10;
            double dx1 = surface.graphicsToData(new Point(gx1, gy0), null)[0];
            double dx2 = surface.graphicsToData(new Point(gx2, gy0), null)[0];
            double dy1 = this.yFunction(dx1);
            double dy2 = this.yFunction(dx2);
            Point2D.Double gp1 = new Point2D.Double();
            Point2D.Double gp2 = new Point2D.Double();
            if (surface.dataToGraphics(new double[]{dx1, dy1}, false, gp1) && PlotUtil.isPointFinite(gp1) && surface.dataToGraphics(new double[]{dx2, dy2}, false, gp2) && PlotUtil.isPointFinite(gp2)) {
                LineTracer tracer = style.createLineTracer(g, bounds, 2, false);
                Color color = style.getColor();
                tracer.addVertex(gp1.x, gp1.y, color);
                tracer.addVertex(gp2.x, gp2.y, color);
                tracer.flush();
            }
        }

        private double yFunction(double x) {
            double[] coeffs = this.stats_.getLinearCoefficients();
            double sy = coeffs[0] + coeffs[1] * this.scales_[0].dataToScale(x);
            return this.scales_[1].scaleToData(sy);
        }

        public ReportMap getReport() {
            double[] coeffs = this.stats_.getLinearCoefficients();
            String equation = new StringBuffer().append(this.scales_[1].dataToScaleExpression("y")).append(" = ").append(C1_KEY.getMeta().getShortName()).append(" * ").append(this.scales_[0].dataToScaleExpression("x")).append(" + ").append(C0_KEY.getMeta().getShortName()).toString();
            ReportMap report = new ReportMap();
            report.put(EQUATION_KEY, equation);
            report.put(C0_KEY, coeffs[0]);
            report.put(C1_KEY, coeffs[1]);
            report.put(CORRELATION_KEY, this.stats_.getCorrelation());
            report.put(RMSD_KEY, this.stats_.getRmsDeviation());
            report.put(COEFFS_KEY, coeffs);
            return report;
        }
    }

    private static class LinearFitDrawing
    implements Drawing {
        private final PlanarSurface surface_;
        private final DataGeom geom_;
        private final DataSpec dataSpec_;
        private final CoordGroup cgrp_;
        private final LineStyle style_;
        private final PaperType paperType_;

        LinearFitDrawing(PlanarSurface surface, DataGeom geom, DataSpec dataSpec, CoordGroup cgrp, LineStyle style, PaperType paperType) {
            this.surface_ = surface;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.cgrp_ = cgrp;
            this.style_ = style;
            this.paperType_ = paperType;
        }

        @Override
        public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
            boolean hasWeight;
            int icWeight;
            Scale[] scales = this.surface_.getScales();
            for (Object knownPlan : knownPlans) {
                if (!(knownPlan instanceof LinearFitPlan) || !((LinearFitPlan)knownPlan).matches(this.dataSpec_, scales)) continue;
                return knownPlan;
            }
            boolean visibleOnly = false;
            final Scale xscale = scales[0];
            final Scale yscale = scales[1];
            final int icPos = this.cgrp_.getPosCoordIndex(0, this.geom_);
            if (this.cgrp_.getExtraCoords().length > 0) {
                icWeight = this.cgrp_.getExtraCoordIndex(0, this.geom_);
                hasWeight = !this.dataSpec_.isCoordBlank(icWeight);
            } else {
                icWeight = -1;
                hasWeight = false;
            }
            SplitCollector<TupleSequence, WXYStats> collector = new SplitCollector<TupleSequence, WXYStats>(){

                public WXYStats createAccumulator() {
                    return new WXYStats();
                }

                public void accumulate(TupleSequence tseq, WXYStats stats) {
                    Point2D.Double gp = new Point2D.Double();
                    double[] dpos = new double[geom_.getDataDimCount()];
                    while (tseq.next()) {
                        if (!geom_.readDataPos(tseq, icPos, dpos) || !surface_.dataToGraphics(dpos, false, gp) || !PlotUtil.isPointFinite(gp)) continue;
                        double x = xscale.dataToScale(dpos[0]);
                        double y = yscale.dataToScale(dpos[1]);
                        if (hasWeight) {
                            double w = tseq.getDoubleValue(icWeight);
                            stats.addPoint(x, y, w);
                            continue;
                        }
                        stats.addPoint(x, y);
                    }
                }

                public WXYStats combine(WXYStats stats1, WXYStats stats2) {
                    stats1.add(stats2);
                    return stats1;
                }
            };
            WXYStats stats = PlotUtil.tupleCollect(collector, this.dataSpec_, dataStore);
            return new LinearFitPlan(stats, this.dataSpec_, scales);
        }

        @Override
        public void paintData(final Object plan, Paper paper, DataStore dataStore) {
            this.paperType_.placeDecal(paper, new Decal(){

                @Override
                public void paintDecal(Graphics g) {
                    ((LinearFitPlan)plan).paintLine(g, surface_, style_);
                }

                @Override
                public boolean isOpaque() {
                    return !style_.getAntialias();
                }
            });
        }

        @Override
        public ReportMap getReport(Object plan) {
            return ((LinearFitPlan)plan).getReport();
        }
    }
}

