/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.PointCloud;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.GPoint3D;
import uk.ac.starlink.ttools.plot2.layer.BinPlan;
import uk.ac.starlink.ttools.plot2.layer.Binner;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.MarkerStyle;
import uk.ac.starlink.ttools.plot2.layer.MultiPosIcon;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public abstract class MarkForm
implements ShapeForm {
    private final int npos_;
    private final String name_;
    private final Icon icon_;
    public static final int MIN_LEGEND_SIZE = 2;
    public static final MarkForm SINGLE = MarkForm.createMarkForm(1);
    public static final MarkForm PAIR = MarkForm.createMarkForm(2);
    public static final MarkForm QUAD = MarkForm.createMarkForm(4);
    private static final Color DUMMY_COLOR = Color.GRAY;

    protected MarkForm(int npos, String name, Icon icon) {
        this.npos_ = npos;
        this.name_ = name;
        this.icon_ = icon;
    }

    @Override
    public int getBasicPositionCount() {
        return this.npos_;
    }

    @Override
    public String getFormName() {
        return this.name_;
    }

    @Override
    public Icon getFormIcon() {
        return this.icon_;
    }

    @Override
    public String getFormDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a marker of fixed size and shape", "at each position.", "</p>"});
    }

    @Override
    public Coord[] getExtraCoords() {
        return new Coord[0];
    }

    @Override
    public int getExtraPositionCount() {
        return 0;
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        return geom;
    }

    public int hashCode() {
        return this.npos_;
    }

    public boolean equals(Object o) {
        if (o instanceof MarkForm) {
            MarkForm other = (MarkForm)o;
            return this.npos_ == other.npos_;
        }
        return false;
    }

    public static MarkForm createMarkForm(final int npos) {
        if (npos == 1) {
            return new MarkForm(1, "Mark", ResourceIcon.FORM_MARK){

                @Override
                public ConfigKey<?>[] getConfigKeys() {
                    return new ConfigKey[]{StyleKeys.MARKER_SHAPE, StyleKeys.SIZE};
                }

                @Override
                public Outliner createOutliner(ConfigMap config) {
                    MarkerShape shape = config.get(StyleKeys.MARKER_SHAPE);
                    int size = config.get(StyleKeys.SIZE);
                    return 1.createMarkOutliner(shape, size);
                }
            };
        }
        Icon icon = npos == 2 ? ResourceIcon.FORM_MARKS2 : (npos == 3 ? ResourceIcon.FORM_MARKS3 : ResourceIcon.FORM_MARKS4);
        return new MarkForm(npos, "Mark" + npos, icon){

            @Override
            public String getFormDescription() {
                return PlotUtil.concatLines(new String[]{"<p>Plots " + npos + " similar markers", "of fixed size and shape", "representing " + npos + " separate positions", "from the same input table row.", "This is a convenience option that can be used with", "other plot layers based on " + npos + " positions.", "</p>"});
            }

            @Override
            public ConfigKey<?>[] getConfigKeys() {
                return new ConfigKey[]{StyleKeys.MARKER_SHAPE, StyleKeys.SIZE};
            }

            @Override
            public Outliner createOutliner(ConfigMap config) {
                MarkerShape shape = config.get(StyleKeys.MARKER_SHAPE);
                int size = config.get(StyleKeys.SIZE);
                return 2.createMultiMarkOutliner(shape, size, npos);
            }
        };
    }

    public static Outliner createMarkOutliner(MarkerShape shape, int size) {
        return new SingleMarkOutliner(shape, size);
    }

    public static Outliner createMultiMarkOutliner(MarkerShape shape, int size, int npos) {
        return new MultiMarkOutliner(shape, size, npos);
    }

    public static MarkerStyle createMarkStyle(MarkerShape shape, int size) {
        return size == 0 ? MarkerShape.POINT.getStyle(DUMMY_COLOR, 0) : shape.getStyle(DUMMY_COLOR, size);
    }

    private static MarkerStyle createLegendMarkStyle(MarkerShape shape, int size) {
        if (size == 0) {
            return MarkerShape.FILLED_SQUARE.getStyle(DUMMY_COLOR, 2);
        }
        return shape.getStyle(DUMMY_COLOR, Math.max(size, 2));
    }

    public static Glyph createMarkGlyph(MarkerShape shape, int size, boolean isMultipix) {
        final MarkerStyle style = MarkForm.createMarkStyle(shape, size);
        final PixerFactory pfact = isMultipix ? Pixers.createPixerCopier(style.getPixerFactory().createPixer()) : style.getPixerFactory();
        return new Glyph(){

            @Override
            public void paintGlyph(Graphics g) {
                style.drawShape(g);
            }

            @Override
            public Pixer createPixer(Rectangle clip) {
                return Pixers.createClippedPixer(pfact, clip);
            }
        };
    }

    public static Icon createLegendIcon(MarkerShape shape, int size) {
        final MarkerStyle style = MarkForm.createLegendMarkStyle(shape, size);
        Icon baseIcon = style.getLegendIcon();
        final int width = baseIcon.getIconWidth();
        final int height = baseIcon.getIconHeight();
        return new Icon(){

            @Override
            public int getIconWidth() {
                return width;
            }

            @Override
            public int getIconHeight() {
                return height;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int xoff = x + width / 2;
                int yoff = y + height / 2;
                g.translate(xoff, yoff);
                style.drawLegendShape(g);
                g.translate(-xoff, -yoff);
            }
        };
    }

    private static Icon createMultiLegendIcon(MarkerShape shape, int size, final int npos) {
        final MarkerStyle style = MarkForm.createLegendMarkStyle(shape, size);
        return new MultiPosIcon(npos){

            @Override
            protected void paintPositions(Graphics g, Point[] positions) {
                for (int ip = 0; ip < npos; ++ip) {
                    Point pos = positions[ip];
                    g.translate(pos.x, pos.y);
                    style.drawLegendShape(g);
                    g.translate(-pos.x, -pos.y);
                }
            }
        };
    }

    private static class MultiMarkOutliner
    extends MarkOutliner {
        private final int npos_;

        public MultiMarkOutliner(MarkerShape shape, int size, int npos) {
            super(shape, size, MarkForm.createMultiLegendIcon(shape, size, npos));
            this.npos_ = npos;
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType2D paperType) {
            final double[] dpos = new double[surface.getDataDimCount()];
            final Point2D.Double gp = new Point2D.Double();
            final int npc = geom.getPosCoords().length;
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    for (int ip = 0; ip < npos_; ++ip) {
                        if (!geom.readDataPos(tuple, ip * npc, dpos) || !surface.dataToGraphics(dpos, true, gp)) continue;
                        paperType.placeGlyph(paper, gp.x, gp.y, glyph_, color);
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(final CubeSurface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType3D paperType) {
            final double[] dpos = new double[surface.getDataDimCount()];
            final GPoint3D gp = new GPoint3D();
            final int npc = geom.getPosCoords().length;
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    for (int ip = 0; ip < npos_; ++ip) {
                        if (!geom.readDataPos(tuple, ip * npc, dpos) || !surface.dataToGraphicZ(dpos, true, gp)) continue;
                        paperType.placeGlyph(paper, gp.x, gp.y, gp.z, glyph_, color);
                    }
                }
            };
        }

        @Override
        protected PointCloud createPointCloud(DataGeom geom, DataSpec spec) {
            return new PointCloud(SubCloud.createSubClouds(geom, spec, this.npos_, false));
        }

        public boolean equals(Object o) {
            if (o instanceof MultiMarkOutliner) {
                MultiMarkOutliner other = (MultiMarkOutliner)o;
                return this.npos_ == other.npos_ && this.style_.equals(other.style_);
            }
            return false;
        }

        public int hashCode() {
            int code = 332;
            code = 23 * code + this.npos_;
            code = 23 * code + this.style_.hashCode();
            return code;
        }
    }

    private static class SingleMarkOutliner
    extends MarkOutliner {
        public SingleMarkOutliner(MarkerShape shape, int size) {
            super(shape, size, MarkForm.createLegendIcon(shape, size));
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType2D paperType) {
            final double[] dpos = new double[surface.getDataDimCount()];
            final Point2D.Double gp = new Point2D.Double();
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos) && surface.dataToGraphics(dpos, true, gp)) {
                        paperType.placeGlyph(paper, gp.x, gp.y, glyph_, color);
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(final CubeSurface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType3D paperType) {
            final double[] dpos = new double[surface.getDataDimCount()];
            final GPoint3D gp = new GPoint3D();
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos) && surface.dataToGraphicZ(dpos, true, gp)) {
                        paperType.placeGlyph(paper, gp.x, gp.y, gp.z, glyph_, color);
                    }
                }
            };
        }

        @Override
        protected PointCloud createPointCloud(DataGeom geom, DataSpec spec) {
            return new PointCloud(new SubCloud(geom, spec, 0));
        }

        public boolean equals(Object o) {
            if (o instanceof SingleMarkOutliner) {
                SingleMarkOutliner other = (SingleMarkOutliner)o;
                return this.style_.equals(other.style_);
            }
            return false;
        }

        public int hashCode() {
            return this.style_.hashCode();
        }
    }

    private static abstract class MarkOutliner
    implements Outliner {
        final MarkerStyle style_;
        final Glyph glyph_;
        final Icon icon_;

        protected MarkOutliner(MarkerShape shape, int size, Icon icon) {
            this.style_ = MarkForm.createMarkStyle(shape, size);
            this.glyph_ = MarkForm.createMarkGlyph(shape, size, true);
            this.icon_ = icon;
        }

        protected abstract PointCloud createPointCloud(DataGeom var1, DataSpec var2);

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public boolean canPaint(DataSpec dataSpec) {
            return true;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            return new HashMap<AuxScale, AuxReader>();
        }

        @Override
        public Object calculateBinPlan(Surface surface, DataGeom geom, Map<AuxScale, Span> auxSpans, DataStore dataStore, DataSpec dataSpec, Object[] knownPlans) {
            return BinPlan.calculatePointCloudPlan(this.createPointCloud(geom, dataSpec), surface, dataStore, knownPlans);
        }

        @Override
        public int[] getBinCounts(Object plan) {
            BinPlan binPlan = (BinPlan)plan;
            Rectangle bigRect = new Rectangle(-536870912, -536870912, 0x3FFFFFFF, 0x3FFFFFFF);
            return MarkOutliner.convolve(binPlan.getBinner(), binPlan.getGridder(), this.glyph_.createPixer(bigRect));
        }

        @Override
        public long getPointCount(Object plan) {
            return ((BinPlan)plan).getBinner().getTotal();
        }

        @Override
        public ReportMap getReport(Object plan) {
            return null;
        }

        private static int[] convolve(Binner binner, Gridder gridder, Pixer pixer) {
            int nx = gridder.getWidth();
            int ny = gridder.getHeight();
            int[] buf = new int[gridder.getLength()];
            while (pixer.next()) {
                int px = pixer.getX();
                int py = pixer.getY();
                int ix0 = Math.max(0, px);
                int ix1 = Math.min(nx, nx + px);
                int iy0 = Math.max(0, py);
                int iy1 = Math.min(ny, ny + py);
                for (int iy = iy0; iy < iy1; ++iy) {
                    int jy = iy - py;
                    for (int ix = ix0; ix < ix1; ++ix) {
                        int jx = ix - px;
                        int n = gridder.getIndex(ix, iy);
                        buf[n] = buf[n] + binner.getCount(gridder.getIndex(jx, jy));
                    }
                }
            }
            return buf;
        }
    }
}

