/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.MarkerStyle;
import uk.ac.starlink.ttools.plot2.layer.Pixers;

public abstract class MarkerShape {
    private final String name_;
    public static RenderingHints.Key OUTLINE_CIRCLE_HINT = new RenderingHints.Key(1){

        @Override
        public boolean isCompatibleValue(Object obj) {
            return obj instanceof Boolean;
        }
    };
    private static final List<Supplier<Pixer>> OPEN_CIRCLE_PIXERS = MarkerShape.calculateOpenCirclePixers();
    private static final List<Supplier<Pixer>> FILLED_CIRCLE_PIXERS = MarkerShape.calculateFilledCirclePixers();
    public static final MarkerShape POINT = new MarkerShape("point"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            return new MarkerStyle((MarkerShape)this, color, 0, 1, g -> g.fillRect(0, 0, 1, 1));
        }
    };
    public static final MarkerShape OPEN_CIRCLE = new MarkerShape("open circle"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            int off = -size;
            int d = size * 2;
            Consumer<Graphics> drawShape = g -> g.drawOval(off, off, d, d);
            Supplier pixerFact = size < OPEN_CIRCLE_PIXERS.size() ? (Supplier)OPEN_CIRCLE_PIXERS.get(size) : null;
            return pixerFact == null ? new MarkerStyle((MarkerShape)this, color, size, size + 1, drawShape) : new MarkerStyle((MarkerShape)this, color, size, drawShape, (Pixer)pixerFact.get());
        }
    };
    public static final MarkerShape FILLED_CIRCLE = new MarkerShape("filled circle"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            int off = -size;
            int d = size * 2;
            Consumer<Graphics> drawShape = g -> {
                g.fillOval(off, off, d, d);
                if (((Graphics2D)g).getRenderingHint(OUTLINE_CIRCLE_HINT) != Boolean.FALSE) {
                    g.drawOval(off, off, d, d);
                }
            };
            Supplier pixerFact = size < FILLED_CIRCLE_PIXERS.size() ? (Supplier)FILLED_CIRCLE_PIXERS.get(size) : null;
            return pixerFact == null ? new MarkerStyle((MarkerShape)this, color, size, size + 1, drawShape) : new MarkerStyle((MarkerShape)this, color, size, drawShape, (Pixer)pixerFact.get());
        }
    };
    public static final MarkerShape OPEN_SQUARE = new MarkerShape("open square"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            int off = -size;
            int h = size * 2;
            return new MarkerStyle((MarkerShape)this, color, size, size + 1, g -> g.drawRect(off, off, h, h));
        }
    };
    public static final MarkerShape FILLED_SQUARE = new MarkerShape("filled square"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            int off = -size;
            int h = size * 2 + 1;
            return new MarkerStyle((MarkerShape)this, color, size, size + 1, g -> g.fillRect(off, off, h, h));
        }
    };
    public static final MarkerShape CROSS = new MarkerShape("cross"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            int off = size;
            return new MarkerStyle((MarkerShape)this, color, size, size + 1, g -> {
                g.drawLine(-off, 0, off, 0);
                g.drawLine(0, -off, 0, off);
            });
        }
    };
    public static final MarkerShape CROXX = new MarkerShape("x"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            int off = size;
            return new MarkerStyle((MarkerShape)this, color, size, size + 1, g -> {
                g.drawLine(-off, -off, off, off);
                g.drawLine(off, -off, -off, off);
            });
        }
    };
    public static final MarkerShape OPEN_DIAMOND = new MarkerShape("open diamond"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            return MarkerShape.shapeStyle((MarkerShape)this, color, size, MarkerShape.diamond(size), true, false);
        }
    };
    public static final MarkerShape FILLED_DIAMOND = new MarkerShape("filled diamond"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            return MarkerShape.shapeStyle((MarkerShape)this, color, size, MarkerShape.diamond(size), true, true);
        }
    };
    public static final MarkerShape OPEN_TRIANGLE_UP = new MarkerShape("open triangle up"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            return MarkerShape.shapeStyle((MarkerShape)this, color, size, MarkerShape.triangle(size, true), true, false);
        }
    };
    public static final MarkerShape OPEN_TRIANGLE_DOWN = new MarkerShape("open triangle down"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            return MarkerShape.shapeStyle((MarkerShape)this, color, size, MarkerShape.triangle(size, false), true, false);
        }
    };
    public static final MarkerShape FILLED_TRIANGLE_UP = new MarkerShape("filled triangle up"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            return MarkerShape.shapeStyle((MarkerShape)this, color, size, MarkerShape.triangle(size, true), false, true);
        }
    };
    public static final MarkerShape FILLED_TRIANGLE_DOWN = new MarkerShape("filled triangle down"){

        @Override
        public MarkerStyle getStyle(Color color, int size) {
            return MarkerShape.shapeStyle((MarkerShape)this, color, size, MarkerShape.triangle(size, false), false, true);
        }
    };

    protected MarkerShape(String name) {
        this.name_ = name;
    }

    public abstract MarkerStyle getStyle(Color var1, int var2);

    public String toString() {
        return this.name_;
    }

    private static MarkerStyle shapeStyle(MarkerShape shapeId, Color color, int size, Shape shape, boolean draw, boolean fill) {
        Consumer<Graphics> drawShape = draw && fill ? g -> {
            Graphics2D g2 = (Graphics2D)g;
            g2.fill(shape);
            g2.draw(shape);
        } : (draw ? g -> ((Graphics2D)g).draw(shape) : (fill ? g -> ((Graphics2D)g).fill(shape) : g -> {}));
        return new MarkerStyle(shapeId, color, size, MarkerShape.getMaxRadius(shape), drawShape);
    }

    private static int getMaxRadius(Shape shape) {
        Rectangle rect = shape.getBounds();
        int[] bounds = new int[]{rect.x, rect.x + rect.width, rect.y, rect.y + rect.height};
        int maxr = 1;
        for (int i = 0; i < bounds.length; ++i) {
            maxr = Math.max(maxr, Math.abs(bounds[i]));
        }
        return maxr;
    }

    private static Shape diamond(int size) {
        return new Polygon(new int[]{-size, 0, size, 0}, new int[]{0, -size, 0, size}, 4);
    }

    private static Shape triangle(int size, boolean up) {
        double scale = (double)size * 1.5;
        int c = (int)Math.round(scale * Math.sqrt(3.0) / 2.0);
        int s = (int)Math.round(scale * 0.5);
        int r = (int)Math.round(scale);
        return up ? new Polygon(new int[]{-c, 0, c}, new int[]{-s, r, -s}, 3) : new Polygon(new int[]{-c, 0, c}, new int[]{s, -r, s}, 3);
    }

    private static List<Supplier<Pixer>> calculateOpenCirclePixers() {
        return MarkerShape.rotatePixelLists(new int[][]{{0, 0}, {0, 1, 1, 1}, {0, 2, 1, 2}, {0, 3, 1, 3, 2, 2}, {0, 4, 1, 4, 2, 4, 3, 3}, {0, 5, 1, 5, 2, 5, 3, 4}});
    }

    private static List<Supplier<Pixer>> calculateFilledCirclePixers() {
        return MarkerShape.rotatePixelLists(new int[][]{{0, 0}, {0, 0, 0, 1, 1, 1}, {0, 0, 0, 1, 0, 2, 1, 1, 1, 2}, {0, 0, 0, 1, 0, 2, 0, 3, 1, 1, 1, 2, 1, 3, 2, 2}, {0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 1, 1, 1, 2, 1, 3, 1, 4, 2, 2, 2, 3, 2, 4, 3, 3}, {0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 2, 2, 2, 3, 2, 4, 2, 5, 3, 3, 3, 4}});
    }

    private static List<Supplier<Pixer>> rotatePixelLists(int[][] seeds) {
        ArrayList<Supplier<Pixer>> results = new ArrayList<Supplier<Pixer>>(seeds.length);
        for (int size = 0; size < seeds.length; ++size) {
            int[] seed = seeds[size];
            HashSet<Point> pointSet = new HashSet<Point>();
            for (int ip = 0; ip < seed.length / 2; ++ip) {
                int a = seed[ip * 2 + 0];
                int b = seed[ip * 2 + 1];
                pointSet.add(new Point(a, b));
                pointSet.add(new Point(-b, a));
                pointSet.add(new Point(-a, -b));
                pointSet.add(new Point(b, -a));
                pointSet.add(new Point(b, a));
                pointSet.add(new Point(-a, b));
                pointSet.add(new Point(-b, -a));
                pointSet.add(new Point(a, -b));
            }
            Point[] points = pointSet.toArray(new Point[0]);
            results.add(() -> Pixers.createPointsPixer(points));
        }
        return results;
    }
}

