/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Rectangle;
import java.util.Map;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.layer.GlyphPaper;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.util.SplitCollector;

public abstract class PixOutliner
implements Outliner {
    @Override
    public Object calculateBinPlan(Surface surface, DataGeom geom, Map<AuxScale, Span> auxRanges, DataStore dataStore, DataSpec dataSpec, Object[] knownPlans) {
        for (int ip = 0; ip < knownPlans.length; ++ip) {
            PixBinPlan plan;
            if (!(knownPlans[ip] instanceof PixBinPlan) || !(plan = (PixBinPlan)knownPlans[ip]).matches(geom, dataSpec, surface, this)) continue;
            return plan;
        }
        BinPaper paper = dataStore.getTupleRunner().collectPool(new BinCollector(surface, geom, dataSpec, auxRanges), () -> dataStore.getTupleSequence(dataSpec));
        return new PixBinPlan(paper.counts_, paper.pointCount_, geom, dataSpec, surface, this);
    }

    @Override
    public int[] getBinCounts(Object binPlan) {
        return ((PixBinPlan)binPlan).counts_;
    }

    @Override
    public long getPointCount(Object binPlan) {
        return ((PixBinPlan)binPlan).pointCount_;
    }

    @Override
    public ReportMap getReport(Object binPlan) {
        return null;
    }

    private static class PixBinPlan {
        final int[] counts_;
        final long pointCount_;
        final DataGeom geom_;
        final DataSpec dataSpec_;
        final Surface surface_;
        final PixOutliner outliner_;

        PixBinPlan(int[] counts, long pointCount, DataGeom geom, DataSpec dataSpec, Surface surface, PixOutliner outliner) {
            this.counts_ = counts;
            this.pointCount_ = pointCount;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.surface_ = surface;
            this.outliner_ = outliner;
        }

        boolean matches(DataGeom geom, DataSpec dataSpec, Surface surface, PixOutliner outliner) {
            return PlotUtil.equals(this.geom_, geom) && this.dataSpec_.equals(dataSpec) && this.surface_.equals(surface) && this.outliner_.equals(outliner);
        }
    }

    private static class BinPaper
    extends GlyphPaper {
        final Rectangle bounds_;
        final Gridder gridder_;
        final int xoff_;
        final int yoff_;
        final int[] counts_;
        long pointCount_;

        BinPaper(Rectangle bounds) {
            super(bounds);
            this.bounds_ = new Rectangle(bounds);
            this.gridder_ = new Gridder(bounds.width, bounds.height);
            this.xoff_ = this.bounds_.x;
            this.yoff_ = this.bounds_.y;
            this.counts_ = new int[this.gridder_.getLength()];
        }

        @Override
        public void glyphPixels(Pixer pixer) {
            while (pixer.next()) {
                int px = pixer.getX();
                int py = pixer.getY();
                assert (this.bounds_.contains(px, py));
                int n = this.gridder_.getIndex(px - this.xoff_, py - this.yoff_);
                this.counts_[n] = this.counts_[n] + 1;
            }
            ++this.pointCount_;
        }

        void add(BinPaper other) {
            this.pointCount_ += other.pointCount_;
            int n = Math.min(this.counts_.length, other.counts_.length);
            int[] otherCounts = other.counts_;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.counts_[n2] = this.counts_[n2] + otherCounts[i];
            }
        }
    }

    private class BinCollector
    implements SplitCollector<TupleSequence, BinPaper> {
        private final Surface surface_;
        private final DataGeom geom_;
        private final DataSpec dataSpec_;
        private final Map<AuxScale, Span> auxRanges_;

        BinCollector(Surface surface, DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxRanges) {
            this.surface_ = surface;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.auxRanges_ = auxRanges;
        }

        public BinPaper createAccumulator() {
            return new BinPaper(this.surface_.getPlotBounds());
        }

        public void accumulate(TupleSequence tseq, BinPaper paper) {
            ShapePainter painter;
            GlyphPaper.GlyphPaperType ptype = paper.getPaperType();
            ShapePainter shapePainter = painter = this.surface_ instanceof CubeSurface ? PixOutliner.this.create3DPainter((CubeSurface)this.surface_, this.geom_, this.dataSpec_, this.auxRanges_, ptype) : PixOutliner.this.create2DPainter(this.surface_, this.geom_, this.dataSpec_, this.auxRanges_, ptype);
            while (tseq.next()) {
                painter.paintPoint(tseq, null, paper);
            }
        }

        public BinPaper combine(BinPaper paper1, BinPaper paper2) {
            paper1.add(paper2);
            return paper1;
        }
    }
}

