/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.layer.CartesianMultiPointCoordSet;
import uk.ac.starlink.ttools.plot2.layer.CartesianMultiPointForm;
import uk.ac.starlink.ttools.plot2.layer.MultiPointForm;

public class PlaneCorrelationCoordSet
implements CartesianMultiPointCoordSet {
    private static final int NP = 4;
    private static final FloatingCoord XERR_COORD = FloatingCoord.createCoord(new InputMeta("xerr", "X Error").setShortDescription("Error in X coordinate").setXmlDescription(new String[]{"<p>Error in the X coordinate.", "</p>"}), true);
    private static final FloatingCoord YERR_COORD = FloatingCoord.createCoord(new InputMeta("yerr", "Y Error").setShortDescription("Error in Y coordinate").setXmlDescription(new String[]{"<p>Error in the Y coordinate.", "</p>"}), true);
    private static final FloatingCoord XYCORR_COORD = FloatingCoord.createCoord(new InputMeta("xycorr", "XY Correlation").setShortDescription("Correlation between X and Y errors").setXmlDescription(new String[]{"<p>Correlation beteween the errors in the X and Y directions.", "This is a dimensionless quantity in the range -1..+1,", "and is equivalent to the covariance divided by", "the product of the X and Y error values themselves.", "It corresponds to the <code>*_corr</code> values", "supplied in the Gaia source catalogue.", "</p>"}), true);

    @Override
    public Coord[] getCoords() {
        return new Coord[]{XERR_COORD, YERR_COORD, XYCORR_COORD};
    }

    @Override
    public int getPointCount() {
        return 4;
    }

    @Override
    public boolean readPoints(Tuple tuple, int icol, double[] xy0, double[][] xyExtras) {
        double xerr = XERR_COORD.readDoubleCoord(tuple, icol + 0);
        double yerr = YERR_COORD.readDoubleCoord(tuple, icol + 1);
        if (Double.isNaN(xerr) || Double.isNaN(yerr) || xerr == 0.0 && yerr == 0.0) {
            return false;
        }
        double xycorr = XYCORR_COORD.readDoubleCoord(tuple, icol + 2);
        if (Double.isNaN(xycorr)) {
            return false;
        }
        double[] ra = new double[2];
        double[] rb = new double[2];
        PlaneCorrelationCoordSet.calculateErrorVectors(xerr, yerr, xycorr, ra, rb);
        double rax = ra[0];
        double ray = ra[1];
        double rbx = rb[0];
        double rby = rb[1];
        double x0 = xy0[0];
        double y0 = xy0[1];
        double[] xy1 = xyExtras[0];
        double[] xy2 = xyExtras[1];
        double[] xy3 = xyExtras[2];
        double[] xy4 = xyExtras[3];
        xy1[0] = x0 + rax;
        xy1[1] = y0 + ray;
        xy2[0] = x0 - rax;
        xy2[1] = y0 - ray;
        xy3[0] = x0 + rbx;
        xy3[1] = y0 + rby;
        xy4[0] = x0 - rbx;
        xy4[1] = y0 - rby;
        return true;
    }

    public static void calculateErrorVectors(double xerr, double yerr, double xycorr, double[] ra, double[] rb) {
        double ryb;
        double rxb;
        double rya;
        double rxa;
        double xycov = xycorr * xerr * yerr;
        if (xycov != 0.0) {
            double xerr2 = xerr * xerr;
            double yerr2 = yerr * yerr;
            double tr = xerr2 + yerr2;
            double det = xerr2 * yerr2 - xycov * xycov;
            double disc = Math.sqrt(0.25 * tr * tr - det);
            double la = 0.5 * tr + disc;
            double lb = 0.5 * tr - disc;
            double exa = la - yerr2;
            double eya = xycov;
            double exb = lb - yerr2;
            double eyb = xycov;
            double ma = Math.sqrt(la / (exa * exa + eya * eya));
            double mb = Math.sqrt(lb / (exb * exb + eyb * eyb));
            rxa = ma * exa;
            rya = ma * eya;
            rxb = mb * exb;
            ryb = mb * eyb;
        } else {
            rxa = xerr;
            rya = 0.0;
            rxb = 0.0;
            ryb = yerr;
        }
        ra[0] = rxa;
        ra[1] = rya;
        rb[0] = rxb;
        rb[1] = ryb;
    }

    public static MultiPointForm createForm() {
        boolean canScale = true;
        String descrip = PlotUtil.concatLines(new String[]{"<p>Plots an error ellipse", "(or rectangle or other similar figure)", "defined by errors in the X and Y directions,", "and a correlation between the two errors.", "</p>", "<p>The supplied correlation is a dimensionless value", "in the range -1..+1", "and is equal to the covariance divided by the product of the", "X and Y errors.", "The covariance matrix is thus:", "<verbatim>", "    [  xerr*xerr         xerr*yerr*xycorr  ]", "    [  xerr*yerr*xycorr  yerr*yerr         ]", "</verbatim>", "</p>", canScale ? MultiPointForm.getDefaultScalingDescription("ellipse") : "", "<p>This plot type is suitable for use with the", "<code>&lt;x&gt;_error</code> and", "<code>&lt;x&gt;_&lt;y&gt;_corr</code> columns", "in the <em>Gaia</em> source catalogue.", "</p>"});
        return new CartesianMultiPointForm("XYCorr", ResourceIcon.FORM_ELLIPSE_CORR, descrip, new PlaneCorrelationCoordSet(), StyleKeys.ELLIPSE_SHAPE, canScale);
    }
}

