/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapeModePlotter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.layer.Stamper;

public class ShapePlotter
extends AbstractPlotter<ShapeStyle>
implements ShapeModePlotter {
    private final ShapeForm form_;
    private final ShapeMode mode_;

    public ShapePlotter(String name, ShapeForm form, ShapeMode mode) {
        this(name, form, mode, CoordGroup.createCoordGroup(form.getBasicPositionCount(), PlotUtil.arrayConcat(form.getExtraCoords(), mode.getExtraCoords()), form.getExtraPositionCount()));
    }

    protected ShapePlotter(String name, ShapeForm form, ShapeMode mode, CoordGroup cgrp) {
        super(name, form.getFormIcon(), cgrp, mode.hasReports());
        this.form_ = form;
        this.mode_ = mode;
    }

    @Override
    public ShapeForm getForm() {
        return this.form_;
    }

    @Override
    public ShapeMode getMode() {
        return this.mode_;
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p><dl>", "<dt>Shape</dt>", "<dd>", this.form_.getFormDescription(), "</dd>", "<dt>Shading</dt>", "<dd>", this.mode_.getModeDescription(), "</dd>", "</dl></p>"});
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        return PlotUtil.arrayConcat(this.form_.getConfigKeys(), this.mode_.getConfigKeys());
    }

    @Override
    public ShapeStyle createStyle(ConfigMap config) {
        ShapeStyle style = new ShapeStyle(this.form_.createOutliner(config), this.mode_.createStamper(config));
        assert (style.equals(new ShapeStyle(this.form_.createOutliner(config), this.mode_.createStamper(config))));
        return style;
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        Outliner outliner = style.getOutliner();
        Stamper stamper = style.getStamper();
        geom = this.form_.adjustGeom(geom, dataSpec, style);
        return outliner.canPaint(dataSpec) ? this.mode_.createLayer(this, this.form_, geom, dataSpec, outliner, stamper) : null;
    }

    public int getModeCoordsIndex(DataGeom geom) {
        return (geom == null ? 0 : geom.getPosCoords().length) * this.form_.getBasicPositionCount() + this.form_.getExtraCoords().length;
    }

    public static ShapePlotter[] createShapePlotters(ShapeForm[] forms, ShapeMode[] modes) {
        int nf = forms.length;
        int nm = modes.length;
        ShapePlotter[] plotters = new ShapePlotter[nf * nm];
        int ip = 0;
        for (int im = 0; im < nm; ++im) {
            ShapeMode mode = modes[im];
            for (int jf = 0; jf < nf; ++jf) {
                ShapeForm form = forms[jf];
                String name = form.getFormName() + "-" + mode.getModeName();
                plotters[ip++] = new ShapePlotter(name, form, mode);
            }
        }
        assert (ip == plotters.length);
        return plotters;
    }

    public static ShapePlotter createFlat2dPlotter(ShapeForm form) {
        return new ShapePlotter(form.getFormName(), form, ShapeMode.FLAT2D);
    }
}

