/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import cds.healpix.Healpix;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.sphgeom.Cone;
import cds.healpix.common.sphgeom.CooXYZ;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import uk.ac.starlink.ttools.cone.CdsHealpixUtil;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;

public class SkySurfaceTiler {
    private final SkySurface surf_;
    private final VerticesAndPathComputer vpc_;
    private final long nside_;
    private final Rotation rotation_;
    private final Set<Long> visiblePixels_;

    public SkySurfaceTiler(SkySurface surf, Rotation rotation, int hpxOrder) {
        this.surf_ = surf;
        this.nside_ = 1L << hpxOrder;
        this.rotation_ = rotation;
        this.vpc_ = Healpix.getNested((int)hpxOrder).newVerticesAndPathComputer();
        Set<Long> visPixels = SkySurfaceTiler.calculateVisiblePixels(surf, rotation, hpxOrder, PolygonTiler.CDS_POLY);
        this.visiblePixels_ = Collections.unmodifiableSet(visPixels);
    }

    public Set<Long> visiblePixels() {
        return this.visiblePixels_;
    }

    public boolean isVisible(long hpxIndex) {
        return this.visiblePixels_.contains(hpxIndex);
    }

    public Polygon getTileShape(long hpxIndex) {
        double[] dpos0 = CdsHealpixUtil.lonlatToVector(this.vpc_.center(hpxIndex));
        this.rotation_.rotate(dpos0);
        Point2D.Double gpos0 = new Point2D.Double();
        if (this.surf_.dataToGraphics(dpos0, false, gpos0)) {
            double[][] lonlatVertices = CdsHealpixUtil.lonlatVertices(this.vpc_, hpxIndex, 5);
            int nv = lonlatVertices.length;
            int[] gxs = new int[nv];
            int[] gys = new int[nv];
            double[] dpos1 = new double[3];
            Point2D.Double gpos1 = new Point2D.Double();
            int np = 0;
            int nInvisible = 0;
            for (int i = 0; i < nv; ++i) {
                CdsHealpixUtil.lonlatToVector(lonlatVertices[i], dpos1);
                this.rotation_.rotate(dpos1);
                if (this.surf_.dataToGraphicsOffset(dpos0, gpos0, dpos1, false, gpos1)) {
                    assert (!Double.isNaN(gpos1.x));
                    assert (!Double.isNaN(gpos1.y));
                    gxs[np] = PlotUtil.ifloor(gpos1.x);
                    gys[np] = PlotUtil.ifloor(gpos1.y);
                    ++np;
                    continue;
                }
                if (++nInvisible <= 1) continue;
                return null;
            }
            assert (np >= 1);
            return new Polygon(gxs, gys, np);
        }
        return null;
    }

    private static Set<Long> calculateVisiblePixels(SkySurface surf, Rotation rotation, int order, PolygonTiler ptiler) {
        List<double[]> vertexList = SkySurfaceTiler.createSurfacePolygon(surf, rotation);
        Set<Long> indexSet = vertexList == null ? null : ptiler.queryPolygon(order, vertexList);
        return indexSet != null ? indexSet : SkySurfaceTiler.createIntegerSet(12L << 2 * order);
    }

    private static List<double[]> createSurfacePolygon(SkySurface surf, Rotation rotation) {
        Rectangle bounds = surf.getPlotBounds();
        Rotation unrot = rotation.invert();
        int nq = 16;
        double nq1 = 1.0 / (double)nq;
        ArrayList<double[]> vertexList = new ArrayList<double[]>(4 * nq + 1);
        for (int is = 0; is < 4; ++is) {
            for (int iq = 0; iq < nq; ++iq) {
                Point2D.Double gpos = SkySurfaceTiler.traceEdge(bounds, is, (double)iq * nq1);
                double[] dpos = surf.graphicsToData(gpos, null);
                if (dpos == null) {
                    return null;
                }
                unrot.rotate(dpos);
                vertexList.add(dpos);
            }
        }
        return vertexList;
    }

    private static Point2D.Double traceEdge(Rectangle bounds, int iside, double fraction) {
        double gy;
        double gx;
        if (iside == 0) {
            gx = (double)bounds.x + (double)bounds.width * fraction;
            gy = bounds.y;
        } else if (iside == 1) {
            gx = bounds.x + bounds.width;
            gy = (double)bounds.y + (double)bounds.height * fraction;
        } else if (iside == 2) {
            gx = (double)bounds.x + (double)bounds.width * (1.0 - fraction);
            gy = bounds.y + bounds.height;
        } else if (iside == 3) {
            gx = bounds.x;
            gy = (double)bounds.y + (double)bounds.height * (1.0 - fraction);
        } else {
            throw new IllegalArgumentException();
        }
        return new Point2D.Double(gx, gy);
    }

    private static Set<Long> createIntegerSet(final long leng) {
        return new AbstractSet<Long>(){

            @Override
            public int size() {
                return (int)leng;
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Number) {
                    long l = ((Number)o).longValue();
                    return l >= 0L && l < leng;
                }
                return false;
            }

            @Override
            public Iterator<Long> iterator() {
                return new Iterator<Long>(){
                    private long lx_;

                    @Override
                    public boolean hasNext() {
                        return this.lx_ < leng;
                    }

                    @Override
                    public Long next() {
                        if (this.hasNext()) {
                            return this.lx_++;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static abstract class PolygonTiler {
        public static PolygonTiler CDS_POLY = new PolygonTiler(){

            @Override
            Set<Long> queryPolygon(int order, List<double[]> xyzs) {
                int nv = xyzs.size();
                double[][] lonlatVertices = new double[nv][2];
                for (int iv = 0; iv < nv; ++iv) {
                    CdsHealpixUtil.vectorToLonlat(xyzs.get(iv), lonlatVertices[iv]);
                }
                HealpixNestedBMOC bmoc = Healpix.getNested((int)order).newPolygonComputer().overlappingCells(lonlatVertices);
                return CdsHealpixUtil.bmocSet(bmoc);
            }
        };
        public static PolygonTiler CDS_CONE = new PolygonTiler(){

            @Override
            Set<Long> queryPolygon(int order, List<double[]> xyzs) {
                int nc = xyzs.size();
                CooXYZ[] coos = new CooXYZ[nc];
                for (int ic = 0; ic < nc; ++ic) {
                    double[] xyz = xyzs.get(ic);
                    coos[ic] = new CooXYZ(xyz[0], xyz[1], xyz[2]);
                }
                Cone cone = Cone.mec((CooXYZ[])coos);
                if (cone != null) {
                    HealpixNestedBMOC bmoc = Healpix.getNested((int)order).newConeComputerApprox(cone.radiusRad()).overlappingCells(cone.lon(), cone.lat());
                    return CdsHealpixUtil.bmocSet(bmoc);
                }
                return null;
            }
        };

        private PolygonTiler() {
        }

        abstract Set<Long> queryPolygon(int var1, List<double[]> var2);
    }
}

