/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.layer.AngleUnit;
import uk.ac.starlink.ttools.plot2.layer.Unit;

public class SolidAngleUnit
extends Unit {
    public static final SolidAngleUnit STERADIAN = new SolidAngleUnit("steradian", "steradian", "sr", AngleUnit.RADIAN, "(180/Pi)^2 deg^2");
    public static final SolidAngleUnit DEGREE2 = new SolidAngleUnit("degree2", "square degree", "deg**2", AngleUnit.DEGREE, "square degrees");
    public static final SolidAngleUnit ARCMIN2 = new SolidAngleUnit("arcmin2", "square arcminute", "arcmin**2", AngleUnit.MINUTE, "square arcminute, (1/60)^2 deg^2");
    public static final SolidAngleUnit ARCSEC2 = new SolidAngleUnit("arcsec2", "square arcsecond", "arcsec**2", AngleUnit.ARCSEC, "square arcsecond, (1/3600)^2 deg^2");
    public static final SolidAngleUnit MAS2 = new SolidAngleUnit("mas2", "square milliarcsec", "mas**2", AngleUnit.MAS, "square milliarcsecond, (.001/3600)^2 deg^2");
    public static final SolidAngleUnit UAS2 = new SolidAngleUnit("uas2", "square microarcsec", "uas**2", AngleUnit.UAS, "square microarcsecond, (1e-6/3600)^2 deg^2");
    private static final SolidAngleUnit[] VALUES = new SolidAngleUnit[]{STERADIAN, DEGREE2, ARCMIN2, ARCSEC2, MAS2, UAS2};

    public SolidAngleUnit(String label, String textName, String symbol, AngleUnit linearAngleUnit, String description) {
        super(label, textName, symbol, Math.pow(linearAngleUnit.getValueInDegrees(), 2.0), description);
    }

    public double getExtentInSquareDegrees() {
        return this.getExtent();
    }

    public static SolidAngleUnit[] getKnownUnits() {
        return (SolidAngleUnit[])VALUES.clone();
    }
}

