/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.GreyImage;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.layer.XYShape;

public class StrokeXYShape
extends XYShape {
    private final Stroke stroke_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.layer");

    public StrokeXYShape(Stroke stroke) {
        super("Stroke", 16, XYShape.POINT);
        this.stroke_ = stroke;
    }

    public Stroke getStroke() {
        return this.stroke_;
    }

    @Override
    protected Glyph createGlyph(short sx, short sy) {
        return this.isCached(sx, sy) ? new CachedStrokeGlyph(this.stroke_, sx, sy) : new UncachedStrokeGlyph(this.stroke_, sx, sy);
    }

    private static int getFatness(Stroke stroke) {
        Rectangle bounds = stroke.createStrokedShape(new Line2D.Double(0.0, 0.0, 0.0, 0.0)).getBounds();
        return Math.max(Math.max(-bounds.x, bounds.width + bounds.x), Math.max(-bounds.y, bounds.height + bounds.y));
    }

    private static Pixer createStrokePixer(Stroke stroke, short x, short y) {
        int fat = StrokeXYShape.getFatness(stroke);
        int xmin = Math.min(x - fat, -fat);
        int xmax = Math.max(x + fat, fat);
        int ymin = Math.min(y - fat, -fat);
        int ymax = Math.max(y + fat, fat);
        int x0 = fat - Math.min(0, x);
        int y0 = fat - Math.min(0, y);
        GreyImage bitmap = GreyImage.createGreyImage(xmax - xmin, ymax - ymin);
        Graphics2D g = bitmap.getImage().createGraphics();
        g.setStroke(stroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.drawLine(x0, y0, x0 + x, y0 + y);
        return Pixers.translate(bitmap.createPixer(), -x0, -y0);
    }

    private static class UncachedStrokeGlyph
    extends StrokeGlyph {
        UncachedStrokeGlyph(Stroke stroke, short x, short y) {
            super(stroke, x, y);
        }

        @Override
        public Pixer createPixer(Rectangle clip) {
            int fat = StrokeXYShape.getFatness(this.stroke_);
            int gxmin = clip.x;
            int gxmax = clip.x + clip.width;
            int gymin = clip.y;
            int gymax = clip.y + clip.height;
            if (this.x_ - fat >= gxmin && this.x_ + fat <= gxmax && this.y_ - fat >= gymin && this.y_ + fat <= gymax) {
                return StrokeXYShape.createStrokePixer(this.stroke_, this.x_, this.y_);
            }
            logger_.warning("Long line creation may be inefficient");
            return StrokeXYShape.createStrokePixer(this.stroke_, this.x_, this.y_);
        }
    }

    private static class CachedStrokeGlyph
    extends StrokeGlyph {
        final PixerFactory pixerFact_;

        CachedStrokeGlyph(Stroke stroke, short x, short y) {
            super(stroke, x, y);
            this.pixerFact_ = Pixers.createPixerCopier(StrokeXYShape.createStrokePixer(stroke, x, y));
        }

        @Override
        public Pixer createPixer(Rectangle clip) {
            return Pixers.clip(this.pixerFact_.createPixer(), clip);
        }
    }

    private static abstract class StrokeGlyph
    implements Glyph {
        final Stroke stroke_;
        final short x_;
        final short y_;

        StrokeGlyph(Stroke stroke, short x, short y) {
            this.stroke_ = stroke;
            this.x_ = x;
            this.y_ = y;
        }

        @Override
        public void paintGlyph(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke0 = g2.getStroke();
            g2.setStroke(this.stroke_);
            g2.drawLine(0, 0, this.x_, this.y_);
            g2.setStroke(stroke0);
        }
    }
}

