/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.layer.XYArrayData;

@Equality
public abstract class XYArrayPlacement {
    private final String name_;
    private final String description_;
    private final boolean usesFraction_;
    public static final XYArrayPlacement INDEX = XYArrayPlacement.createIndexFractionPlacement("Index");
    public static final XYArrayPlacement XMAX = XYArrayPlacement.createExtremumPlacement("XMax", false, true);
    public static final XYArrayPlacement XMIN = XYArrayPlacement.createExtremumPlacement("XMin", false, false);
    public static final XYArrayPlacement YMAX = XYArrayPlacement.createExtremumPlacement("YMax", true, true);
    public static final XYArrayPlacement YMIN = XYArrayPlacement.createExtremumPlacement("YMin", true, false);
    public static final XYArrayPlacement XYMEAN = XYArrayPlacement.createMeanPlacement("XYMean");
    static final String FRACTION_NAME = "fraction";

    protected XYArrayPlacement(String name, String description, boolean usesFraction) {
        this.name_ = name;
        String ignoreTxt = " (<code>fraction</code> is ignored)";
        this.description_ = description + (usesFraction ? "" : ignoreTxt);
        this.usesFraction_ = usesFraction;
    }

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean usesFraction() {
        return this.usesFraction_;
    }

    public abstract boolean readPosition(XYArrayData var1, double var2, double[] var4);

    public String toString() {
        return this.name_;
    }

    private static XYArrayPlacement createIndexFractionPlacement(String name) {
        String descrip = new StringBuffer().append("(X,Y) point at a certain fraction of the way ").append("through the arrays, as given by the ").append("<code>fraction</code> value; ").append("<code>fraction=0.0</code> ").append("is the first element, ").append("<code>fraction=1.0</code> ").append("is the last.").toString();
        return new XYArrayPlacement(name, descrip, true){

            @Override
            public boolean readPosition(XYArrayData xyData, double fraction, double[] dpos) {
                int leng = xyData.getLength();
                if (leng > 0 && fraction >= 0.0 && fraction <= 1.0) {
                    int index = (int)Math.round(fraction * (double)(leng - 1));
                    double x = xyData.getX(index);
                    double y = xyData.getY(index);
                    if (!Double.isNaN(x) && !Double.isNaN(y)) {
                        dpos[0] = x;
                        dpos[1] = y;
                        return true;
                    }
                    return false;
                }
                return false;
            }
        };
    }

    private static XYArrayPlacement createExtremumPlacement(String name, final boolean isY, final boolean isMax) {
        String descrip = new StringBuffer().append("(X,Y) position at which the ").append(isMax ? "maximum " : "minimum ").append(isY ? "Y " : "X ").append("value is located").toString();
        return new XYArrayPlacement(name, descrip, false){

            @Override
            public boolean readPosition(XYArrayData xyData, double fraction, double[] dpos) {
                int n = xyData.getLength();
                double pos0 = Double.NaN;
                double pos1 = isMax ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                for (int i = 0; i < n; ++i) {
                    double v0;
                    double v1;
                    double d = v1 = isY ? xyData.getY(i) : xyData.getX(i);
                    if (!(isMax ? v1 > pos1 : v1 < pos1)) continue;
                    pos0 = v0 = isY ? xyData.getX(i) : xyData.getY(i);
                    pos1 = v1;
                }
                if (!Double.isNaN(pos0)) {
                    dpos[isY ? 0 : 1] = pos0;
                    dpos[isY ? 1 : 0] = pos1;
                    return true;
                }
                return false;
            }
        };
    }

    private static XYArrayPlacement createMeanPlacement(String name) {
        String descrip = "center of gravity of all the (X,Y) points";
        return new XYArrayPlacement(name, descrip, false){

            @Override
            public boolean readPosition(XYArrayData xyData, double fraction, double[] dpos) {
                int n = xyData.getLength();
                int s0 = 0;
                double sx = 0.0;
                double sy = 0.0;
                for (int i = 0; i < n; ++i) {
                    double x = xyData.getX(i);
                    double y = xyData.getY(i);
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    ++s0;
                    sx += x;
                    sy += y;
                }
                if (s0 > 0) {
                    double s1 = 1.0 / (double)s0;
                    dpos[0] = sx * s1;
                    dpos[1] = sy * s1;
                    return true;
                }
                return false;
            }
        };
    }
}

