/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.ShortPair;

public abstract class XYShape {
    private final String name_;
    private final int maxCacheRadius_;
    private final Glyph pointGlyph_;
    public static Glyph POINT = new PointGlyph(0, 0);
    private final Map<ShortPair, Glyph> cache_ = new ConcurrentHashMap<ShortPair, Glyph>();

    protected XYShape(String name, int maxCacheRadius, Glyph pointGlyph) {
        this.name_ = name;
        this.maxCacheRadius_ = maxCacheRadius;
        this.pointGlyph_ = pointGlyph;
    }

    protected XYShape(String name) {
        this(name, 16, POINT);
    }

    public String getName() {
        return this.name_;
    }

    public boolean isCached(short sx, short sy) {
        return sx >= -this.maxCacheRadius_ && sx <= this.maxCacheRadius_ && sy >= -this.maxCacheRadius_ && sy <= this.maxCacheRadius_;
    }

    public Glyph getGlyph(short sx, short sy) {
        if (sx == 0 && sy == 0 && this.pointGlyph_ != null) {
            return this.pointGlyph_;
        }
        if (this.isCached(sx, sy)) {
            ShortPair xy = new ShortPair(sx, sy);
            Glyph glyph = this.cache_.get(xy);
            if (glyph == null) {
                glyph = this.createGlyph(sx, sy);
                this.cache_.put(xy, glyph);
            }
            return glyph;
        }
        return this.createGlyph(sx, sy);
    }

    protected abstract Glyph createGlyph(short var1, short var2);

    public String toString() {
        return this.name_;
    }

    public static Icon createIcon(XYShape shape, int width, int height, final boolean useComponentColor) {
        final short sx = (short)(width / 2);
        final short sy = (short)(height / 2);
        final Glyph glyph = shape.getGlyph(sx, sy);
        return new Icon(){

            @Override
            public int getIconWidth() {
                return sx * 2;
            }

            @Override
            public int getIconHeight() {
                return sy * 2;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int xoff = x + sx;
                int yoff = y + sy;
                g.translate(xoff, yoff);
                Color color0 = g.getColor();
                if (useComponentColor) {
                    g.setColor(c.getForeground());
                }
                glyph.paintGlyph(g);
                g.setColor(color0);
                g.translate(-xoff, -yoff);
            }
        };
    }

    private static class PointGlyph
    implements Glyph {
        private final int px_;
        private final int py_;

        PointGlyph(int px, int py) {
            this.px_ = px;
            this.py_ = py;
        }

        @Override
        public void paintGlyph(Graphics g) {
            g.fillRect(this.px_, this.py_, 1, 1);
        }

        @Override
        public Pixer createPixer(Rectangle clip) {
            if (clip.x <= this.px_ && clip.x + clip.width >= this.px_ + 1 && clip.y <= this.px_ && clip.y + clip.height >= this.py_ + 1) {
                return new Pixer(){
                    boolean done_;

                    @Override
                    public boolean next() {
                        if (this.done_) {
                            return false;
                        }
                        this.done_ = true;
                        return true;
                    }

                    @Override
                    public int getX() {
                        return px_;
                    }

                    @Override
                    public int getY() {
                        return py_;
                    }
                };
            }
            return null;
        }
    }
}

