/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.BitSet;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.RgbPaperType2D;

public class OverPaperType2D
extends RgbPaperType2D {
    public OverPaperType2D() {
        super("PixelOverlay", true);
    }

    @Override
    protected RgbPaperType2D.RgbPaper2D createPaper2D(Rectangle bounds) {
        return new OverPaper(this, bounds);
    }

    private static class OverPaper
    extends RgbPaperType2D.RgbPaper2D {
        private Color lastColor_;
        private int lastRgb_;
        private final int[] rgbs_ = this.getRgbImage().getBuffer();
        private final BitSet mask_ = new BitSet(this.rgbs_.length);

        public OverPaper(PaperType paperType, Rectangle bounds) {
            super(paperType, bounds);
        }

        @Override
        public boolean canMerge() {
            return true;
        }

        @Override
        public Paper createSheet() {
            return new OverPaper(this.getPaperType(), this.getBounds());
        }

        @Override
        public void mergeSheet(Paper other) {
            OverPaper paper1 = (OverPaper)other;
            int[] rgbs1 = paper1.rgbs_;
            BitSet mask1 = paper1.mask_;
            int n = this.rgbs_.length;
            for (int i = 0; i < n; ++i) {
                if (!mask1.get(i)) continue;
                this.rgbs_[i] = rgbs1[i];
                this.mask_.set(i);
            }
        }

        @Override
        protected void placePixels(int xoff, int yoff, Pixer pixer, Color color) {
            if (color != this.lastColor_) {
                this.lastColor_ = color;
                this.lastRgb_ = color.getRGB();
            }
            int rgb = this.lastRgb_;
            while (pixer.next()) {
                int index = this.getPixelIndex(xoff, yoff, pixer);
                this.rgbs_[index] = rgb;
                this.mask_.set(index);
            }
        }

        @Override
        public void flush() {
        }
    }
}

