/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;

public class RgbImage {
    private final BufferedImage image_;
    private final int[] buffer_;
    private final boolean hasAlpha_;

    private RgbImage(BufferedImage image, int[] buffer, boolean hasAlpha) {
        this.image_ = image;
        this.buffer_ = buffer;
        this.hasAlpha_ = hasAlpha;
    }

    public BufferedImage getImage() {
        return this.image_;
    }

    public int[] getBuffer() {
        return this.buffer_;
    }

    public static RgbImage createRgbImage(int width, int height, boolean hasAlpha) {
        return RgbImage.createRgbImage(width, height, hasAlpha, hasAlpha ? 0 : -1);
    }

    public static RgbImage createRgbImage(int width, int height, boolean hasAlpha, int bg) {
        BufferedImage image = new BufferedImage(width, height, hasAlpha ? 2 : 1);
        int[] buf = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        Arrays.fill(buf, bg);
        return new RgbImage(image, buf, hasAlpha);
    }
}

