/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.ttools.plot2.data.ByteStoreColumnFactory;
import uk.ac.starlink.ttools.plot2.data.CachedDataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.MemoryColumnFactory;
import uk.ac.starlink.ttools.plot2.data.PersistentDataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.SimpleDataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.SmartColumnFactory;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;

public class DataStoreParameter
extends ChoiceParameter<DataStoreFactory> {
    private static final TupleRunner TUPLE_RUNNER = TupleRunner.DEFAULT;
    public static final DataStoreFactory SIMPLE = new SimpleDataStoreFactory(TUPLE_RUNNER);
    public static final DataStoreFactory BASIC_CACHE = new CachedDataStoreFactory(new MemoryColumnFactory(), TUPLE_RUNNER);
    public static final DataStoreFactory MEMORY_CACHE = new CachedDataStoreFactory(new SmartColumnFactory(new MemoryColumnFactory()), TUPLE_RUNNER);
    public static final DataStoreFactory PARALLEL_MEMORY_CACHE = new CachedDataStoreFactory(new SmartColumnFactory(new MemoryColumnFactory()), TUPLE_RUNNER, RowRunner.DEFAULT){};
    public static final DataStoreFactory DISK_CACHE = new CachedDataStoreFactory(new SmartColumnFactory(new ByteStoreColumnFactory(StoragePolicy.PREFER_DISK)), TUPLE_RUNNER);
    public static final DataStoreFactory POLICY_CACHE = new CachedDataStoreFactory(new SmartColumnFactory(new ByteStoreColumnFactory(StoragePolicy.getDefaultPolicy())), TUPLE_RUNNER);
    public static final DataStoreFactory PERSISTENT_CACHE = new PersistentDataStoreFactory(null, TUPLE_RUNNER);
    private static final DataStoreFactory MEMORY1_CACHE = new CachedDataStoreFactory(new SmartColumnFactory(new MemoryColumnFactory()), TUPLE_RUNNER);

    public DataStoreParameter(String name) {
        super(name, DataStoreFactory.class);
        this.addOption(SIMPLE, "simple");
        this.addOption(MEMORY_CACHE, "memory");
        this.addOption(DISK_CACHE, "disk");
        this.addOption(POLICY_CACHE, "policy");
        this.addOption(MEMORY1_CACHE, "cache");
        this.addOption(BASIC_CACHE, "basic-cache");
        this.addOption(PERSISTENT_CACHE, "persistent");
        this.addOption(PARALLEL_MEMORY_CACHE, "parallel");
        this.setDefaultOption(SIMPLE);
        this.setPrompt("Data storage policy");
        this.setDescription(new String[]{"<p>Determines the way that data is accessed when constructing", "the plot.", "There are two main options, cached or not.", "If no caching is used", "then rows are read sequentially from the specified input table(s)", "every time they are required.", "This generally requires a small resource footprint", "(though that can depend on how the table is specified)", "and makes sense if the data only needs to be scanned once", "or perhaps if the table is very large.", "If caching is used", "then the required data is read once", "from the specified input table(s), then prepared and cached", "before any plotting is performed,", "and plots are done using this cached data.", "This may use a significant amount of storage for large tables", "but it's usually more sensible (faster)", "if the data will need to be scanned multiple times.", "There are various options for cache storage.", "</p>", "<p>The options are:", "<ul>", "<li><code>simple</code>: ", "no caching, data read directly from input table", "</li>", "<li><code>memory</code>: ", "cached to memory; OutOfMemoryError possible", "for very large plots", "</li>", "<li><code>disk</code>: ", "cached to disk", "</li>", "<li><code>policy</code>: ", "cached using application-wide default storage policy,", "which is usually <em>adaptive</em> (memory/disk hybrid)", "</li>", "<li><code>persistent</code>: ", "cached to persistent files on disk,", "in the system temporary directory", "(defined by system property <code>java.io.tmpdir</code>).", "If this is used, plot data will be stored on disk in a way", "that means they can be re-used between STILTS invocations,", "so data preparation can be avoided on subsequent runs.", "Note however it can leave potentially large files", "in your temporary directory.", "</li>", "<li><code>cache</code>: ", "synonym for <code>memory</code> (backward compatibility)", "</li>", "<li><code>basic-cache</code>: ", "dumber version of <code>memory</code>", "(no optimisation for constant-valued columns)", "</li>", "<li><code>parallel</code>: ", "experimental version of memory-based cache that reads", "into the cache in parallel for large files.", "This will make the plot faster to prepare,", "but interaction is a bit slower and sequence-dependent", "attributes of the plot may not come out right.", "This experimental option may be withdrawn or modified", "in future releases.", "</li>", "</ul>", "</p>"});
    }

    public void setDefaultCaching(boolean caching) {
        this.setDefaultOption(this.getDefaultForCaching(caching));
    }

    public DataStoreFactory getDefaultForCaching(boolean isCachingSensible) {
        return isCachingSensible ? MEMORY_CACHE : SIMPLE;
    }
}

