/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.Domain;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.StarTableJELRowReader;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.data.AbstractDataSpec;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;
import uk.ac.starlink.ttools.plot2.task.CoordValue;

public class JELDataSpec
extends AbstractDataSpec {
    private final StarTable table_;
    private final String maskExpr_;
    private final CoordValue[] coordValues_;
    private final ValueInfo[][] userCoordInfos_;
    private final JELKey maskId_;
    private final JELKey[] coordIds_;
    private static final JELKey ALL_MASK = new JELKey(new String[]{new String("true")}, new DomainMapper[1]);

    public JELDataSpec(StarTable table, String maskExpr, CoordValue[] coordValues) throws TaskException {
        int ic;
        this.table_ = table;
        this.maskExpr_ = maskExpr;
        int nCoord = coordValues.length;
        this.maskId_ = maskExpr == null || "true".equals(maskExpr.trim()) ? ALL_MASK : new JELKey(new String[]{maskExpr}, new DomainMapper[1]);
        this.coordValues_ = new CoordValue[nCoord];
        RowDataEvaluator preEvaluator = new RowDataEvaluator(table);
        Library preLib = JELUtils.getLibrary(preEvaluator);
        for (int ic2 = 0; ic2 < nCoord; ++ic2) {
            CoordValue cval0 = coordValues[ic2];
            Input[] inputs = cval0.getCoord().getInputs();
            String[] exprs = cval0.getExpressions();
            int nu = exprs.length;
            DomainMapper[] dms0 = cval0.getDomainMappers();
            DomainMapper[] dms = new DomainMapper[nu];
            for (int iu = 0; iu < nu; ++iu) {
                Input input = inputs[iu];
                Domain<?> domain = input.getDomain();
                String expr = exprs[iu];
                DomainMapper dm = dms0[iu];
                if (dm == null) {
                    ValueReader vrdr = JELDataSpec.createValueReader(expr, table, preEvaluator, preLib, null, Object.class);
                    ValueInfo info = vrdr.getValueInfo();
                    dm = domain.getProbableMapper(info);
                    if (dm == null) {
                        dm = domain.getPossibleMapper(info);
                    }
                    if (dm == null && domain.getMappers().length > 0) {
                        dm = domain.getMappers()[0];
                    }
                }
                if (dm == null) {
                    String msg = new StringBuffer().append("Expression \"").append(expr).append("\" not usable as type ").append(domain.getDomainName()).append(" for ").append(input.getMeta().getShortName()).toString();
                    throw new TaskException(msg);
                }
                dms[iu] = dm;
            }
            this.coordValues_[ic2] = new CoordValue(cval0.getCoord(), cval0.getExpressions(), dms);
        }
        JELUserDataReader dataRdr = this.createJELUserDataReader();
        this.userCoordInfos_ = new ValueInfo[nCoord][];
        for (ic = 0; ic < nCoord; ++ic) {
            int nu = coordValues[ic].getExpressions().length;
            this.userCoordInfos_[ic] = new ValueInfo[nu];
            for (int iu = 0; iu < nu; ++iu) {
                this.userCoordInfos_[ic][iu] = dataRdr.userCoordReaders_[ic][iu].getValueInfo();
            }
        }
        this.coordIds_ = new JELKey[nCoord];
        for (ic = 0; ic < nCoord; ++ic) {
            CoordValue cv = coordValues[ic];
            this.coordIds_[ic] = new JELKey(cv.getExpressions(), cv.getDomainMappers());
        }
    }

    @Override
    public StarTable getSourceTable() {
        return this.table_;
    }

    @Override
    public int getCoordCount() {
        return this.coordValues_.length;
    }

    @Override
    public String getCoordId(int ic) {
        return this.coordIds_[ic].toText();
    }

    @Override
    public Coord getCoord(int ic) {
        return this.coordValues_[ic].getCoord();
    }

    @Override
    public String getMaskId() {
        return this.maskId_.toText();
    }

    @Override
    public ValueInfo[] getUserCoordInfos(int ic) {
        return this.userCoordInfos_[ic];
    }

    @Override
    public DomainMapper[] getUserCoordMappers(int ic) {
        return this.coordValues_[ic].getDomainMappers();
    }

    @Override
    public UserDataReader createUserDataReader() {
        try {
            return this.createJELUserDataReader();
        }
        catch (TaskException e) {
            throw new AssertionError((Object)"Well it worked last time.");
        }
    }

    @Override
    public boolean isMaskTrue() {
        return ALL_MASK.equals(this.maskId_);
    }

    @Override
    public boolean isCoordBlank(int icoord) {
        for (String expr : this.coordValues_[icoord].getExpressions()) {
            if (expr == null || expr.trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public String[] getCoordExpressions(int ic) {
        return (String[])this.coordIds_[ic].exprs_.clone();
    }

    private JELUserDataReader createJELUserDataReader() throws TaskException {
        return new JELUserDataReader(this.table_, this.maskExpr_, this.coordValues_);
    }

    private static ValueReader createValueReader(String expr, StarTable table, RowDataEvaluator evaluator, Library lib, Object fallback, Class<?> reqClazz) throws TaskException {
        CompiledExpression compex;
        if (expr == null || expr.trim().length() == 0) {
            return new FixedValueReader(fallback);
        }
        int ncol = table.getColumnCount();
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo info = table.getColumnInfo(icol);
            if (!expr.trim().equalsIgnoreCase(info.getName().trim())) continue;
            return new ColumnValueReader(table, icol);
        }
        try {
            compex = JELUtils.compile(lib, table, expr);
        }
        catch (CompilationException e) {
            throw new TaskException("Bad Expression \"" + expr + "\"", (Throwable)e);
        }
        Class<?> exprClazz = compex.getTypeC();
        if (!reqClazz.isAssignableFrom(exprClazz)) {
            String msg = new StringBuffer().append("Expression wrong type: ").append('\"').append(expr).append('\"').append(" is ").append(exprClazz.getName()).append(" not ").append(reqClazz.getName()).toString();
            throw new TaskException(msg);
        }
        return new JelValueReader(evaluator, compex, expr);
    }

    @Equality
    private static class JELKey {
        private final String[] exprs_;
        private final String text_;

        JELKey(String[] exprs, DomainMapper[] dms) {
            this.exprs_ = exprs;
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < exprs.length; ++i) {
                String expr = exprs[i];
                sbuf.append(expr == null ? "null" : expr);
                DomainMapper dm = dms[i];
                if (dm != null) {
                    sbuf.append("|" + dm);
                }
                sbuf.append(";");
            }
            this.text_ = sbuf.toString();
        }

        public String toText() {
            return this.text_;
        }

        public boolean equals(Object other) {
            return other instanceof JELKey && this.text_.equals(((JELKey)other).text_);
        }

        public int hashCode() {
            return this.text_.hashCode();
        }

        public String toString() {
            return this.text_;
        }
    }

    private static class RowDataEvaluator
    extends StarTableJELRowReader {
        private RowData rdata_;
        private long irow_;

        RowDataEvaluator(StarTable table) {
            super(table);
        }

        @Override
        public long getCurrentRow() {
            return this.irow_;
        }

        @Override
        protected Object getCell(int icol) throws IOException {
            return this.rdata_.getCell(icol);
        }

        public Object evaluateObject(CompiledExpression compex, RowData rdata, long irow) throws IOException {
            this.rdata_ = rdata;
            this.irow_ = irow;
            try {
                return this.evaluate(compex);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                return null;
            }
        }
    }

    private static class JelValueReader
    implements ValueReader {
        private final RowDataEvaluator evaluator_;
        private final CompiledExpression compex_;
        private final ValueInfo info_;
        private long irow_;

        JelValueReader(RowDataEvaluator evaluator, CompiledExpression compex, String expr) {
            this.evaluator_ = evaluator;
            this.compex_ = compex;
            this.info_ = new DefaultValueInfo(expr, compex.getTypeC(), null);
        }

        @Override
        public Object readValue(RowData rdata, long irow) throws IOException {
            return this.evaluator_.evaluateObject(this.compex_, rdata, irow);
        }

        @Override
        public ValueInfo getValueInfo() {
            return this.info_;
        }
    }

    private static class ColumnValueReader
    implements ValueReader {
        private final int icol_;
        private final ValueInfo info_;

        ColumnValueReader(StarTable table, int icol) {
            this.icol_ = icol;
            this.info_ = table.getColumnInfo(icol);
        }

        @Override
        public Object readValue(RowData rdata, long irow) throws IOException {
            return rdata.getCell(this.icol_);
        }

        @Override
        public ValueInfo getValueInfo() {
            return this.info_;
        }
    }

    private static class FixedValueReader
    implements ValueReader {
        private final Object value_;
        private final ValueInfo info_;

        private FixedValueReader(Object value) {
            this.value_ = value;
            this.info_ = new DefaultValueInfo("fixed-" + value, value == null ? Void.class : value.getClass(), "Fixed value");
        }

        @Override
        public Object readValue(RowData rdata, long irow) {
            return this.value_;
        }

        @Override
        public ValueInfo getValueInfo() {
            return this.info_;
        }
    }

    private static interface ValueReader {
        public Object readValue(RowData var1, long var2) throws IOException;

        public ValueInfo getValueInfo();
    }

    private static class JELUserDataReader
    implements UserDataReader {
        private final ValueReader maskReader_;
        private final ValueReader[][] userCoordReaders_;
        private final Object[][] userCoordRows_;

        JELUserDataReader(StarTable table, String maskExpr, CoordValue[] coordValues) throws TaskException {
            RowDataEvaluator evaluator = new RowDataEvaluator(table);
            Library lib = JELUtils.getLibrary(evaluator);
            this.maskReader_ = JELDataSpec.createValueReader(maskExpr, table, evaluator, lib, Boolean.TRUE, Boolean.TYPE);
            int nCoord = coordValues.length;
            this.userCoordRows_ = new Object[nCoord][];
            this.userCoordReaders_ = new ValueReader[nCoord][];
            for (int ic = 0; ic < nCoord; ++ic) {
                CoordValue coordVal = coordValues[ic];
                Input[] inputs = coordVal.getCoord().getInputs();
                String[] ucexprs = coordVal.getExpressions();
                DomainMapper[] dms = coordVal.getDomainMappers();
                int nu = ucexprs.length;
                this.userCoordRows_[ic] = new Object[nu];
                ValueReader[] vrdrs = new ValueReader[nu];
                for (int iu = 0; iu < nu; ++iu) {
                    vrdrs[iu] = JELDataSpec.createValueReader(ucexprs[iu], table, evaluator, lib, null, dms[iu].getSourceClass());
                }
                this.userCoordReaders_[ic] = vrdrs;
            }
        }

        @Override
        public boolean getMaskFlag(RowData rdata, long irow) throws IOException {
            return Boolean.TRUE.equals(this.maskReader_.readValue(rdata, irow));
        }

        @Override
        public Object[] getUserCoordValues(RowData rdata, long irow, int icoord) throws IOException {
            ValueReader[] vrdrs = this.userCoordReaders_[icoord];
            int nu = vrdrs.length;
            Object[] userRow = this.userCoordRows_[icoord];
            for (int iu = 0; iu < nu; ++iu) {
                userRow[iu] = vrdrs[iu].readValue(rdata, irow);
            }
            return userRow;
        }
    }
}

