/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.IndicatedRow;
import uk.ac.starlink.ttools.plot2.NavigationListener;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotCaching;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotScene;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.PointCloud;
import uk.ac.starlink.ttools.plot2.ShadeAxisKit;
import uk.ac.starlink.ttools.plot2.SingleGangerFactory;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Trimming;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;
import uk.ac.starlink.ttools.plot2.task.PointSelectionEvent;
import uk.ac.starlink.ttools.plot2.task.PointSelectionListener;

public class PlotDisplay<P, A>
extends JComponent {
    private final PlotScene<P, A> scene_;
    private final DataStore dataStore_;
    private final List<PointSelectionListener> pslList_;
    private final Executor clickExecutor_;
    private Decoration navDecoration_;
    public static final String ASPECTS_PROPERTY = "Plot2Aspects";
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.task");

    public PlotDisplay(final PlotScene<P, A> scene, final Navigator<A> navigator, DataStore dataStore) {
        this.scene_ = scene;
        this.dataStore_ = dataStore;
        this.pslList_ = new ArrayList<PointSelectionListener>();
        if (navigator != null) {
            new NavigationListener<A>(){

                @Override
                public int getSurfaceIndex(Point pos) {
                    return scene.getGang().getNavigationZoneIndex(pos);
                }

                @Override
                public Surface getSurface(int isurf) {
                    return isurf >= 0 ? scene.getSurfaces()[isurf] : null;
                }

                @Override
                public Navigator<A> getNavigator(int isurf) {
                    return navigator;
                }

                @Override
                public Supplier<CoordSequence> createDataPosSupplier(Point pos) {
                    int iz = scene.getZoneIndex(pos);
                    if (iz >= 0) {
                        PlotLayer[] layers = scene.getLayers(iz);
                        return new PointCloud(SubCloud.createSubClouds(layers, true)).createDataPosSupplier(PlotDisplay.this.dataStore_);
                    }
                    return null;
                }

                @Override
                protected void setAspect(int isurf, A aspect) {
                    A[] oldAspects = scene.getAspects();
                    Object[] aspects = (Object[])oldAspects.clone();
                    aspects[isurf] = aspect;
                    if (scene.setAspects(scene.getGanger().adjustAspects(aspects, isurf))) {
                        PlotDisplay.this.repaint();
                        PlotDisplay.this.firePropertyChange(PlotDisplay.ASPECTS_PROPERTY, oldAspects, aspects);
                    }
                }

                @Override
                protected void setDecoration(Decoration dec) {
                    PlotDisplay.this.setNavDecoration(dec);
                }
            }.addListeners(this);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mEvt) {
                Point p = mEvt.getPoint();
                int iz = scene.getZoneIndex(p);
                if (iz >= 0 && PlotDisplay.this.pslList_.size() > 0) {
                    Surface surface = scene.getSurfaces()[iz];
                    PlotLayer[] layers = scene.getLayers(iz);
                    if (surface != null && layers.length > 0 && surface.getPlotBounds().contains(p)) {
                        PlotDisplay.this.clickExecutor_.execute(() -> {
                            IndicatedRow[] closestRows = scene.findClosestRows(surface, layers, p, PlotDisplay.this.dataStore_);
                            if (closestRows != null) {
                                int nc = closestRows.length;
                                long[] lrows = new long[nc];
                                for (int ic = 0; ic < nc; ++ic) {
                                    lrows[ic] = closestRows[ic].getIndex();
                                }
                                PointSelectionEvent pEvt = new PointSelectionEvent(PlotDisplay.this, p, iz, lrows);
                                SwingUtilities.invokeLater(() -> {
                                    for (PointSelectionListener psl : PlotDisplay.this.pslList_) {
                                        psl.pointSelected(pEvt);
                                    }
                                });
                            }
                        });
                    }
                }
            }
        });
        this.clickExecutor_ = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, "Point Identifier");
                th.setDaemon(true);
                return th;
            }
        });
    }

    public PlotScene<P, A> getScene() {
        return this.scene_;
    }

    public void addPointSelectionListener(PointSelectionListener psl) {
        this.pslList_.add(psl);
    }

    public void removePointSelectionListener(PointSelectionListener psl) {
        this.pslList_.remove(psl);
    }

    @Override
    public void invalidate() {
        this.scene_.clearPlot();
        super.invalidate();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle extBox = PlotUtil.subtractInsets(new Rectangle(this.getSize()), this.getInsets());
        this.scene_.paintScene(g, extBox, this.dataStore_);
        if (this.navDecoration_ != null) {
            this.navDecoration_.paintDecoration(g);
        }
    }

    private void setNavDecoration(Decoration dec) {
        if (!PlotUtil.equals(this.navDecoration_, dec)) {
            this.navDecoration_ = dec;
            this.repaint();
        }
    }

    @Slow
    public static <P, A> PlotDisplay<P, A> createPlotDisplay(PlotLayer[] layers, SurfaceFactory<P, A> surfFact, ConfigMap config, Trimming trimming, ShadeAxisKit shadeKit, PaperTypeSelector ptSel, Compositor compositor, Padding padding, DataStore dataStore, boolean navigable, PlotCaching caching) {
        P profile = surfFact.createProfile(config);
        long t0 = System.currentTimeMillis();
        Range[] ranges = surfFact.useRanges(profile, config) ? surfFact.readRanges(profile, layers, dataStore) : null;
        PlotUtil.logTimeFromStart(logger_, "Range", t0);
        A aspect = surfFact.createAspect(profile, config, ranges);
        Navigator<A> navigator = navigable ? surfFact.createNavigator(config) : null;
        Ganger ganger = SingleGangerFactory.createGanger(padding);
        ZoneContent<P, A>[] contents = PlotUtil.singletonArray(new ZoneContent<P, A>(profile, aspect, layers));
        Trimming[] trimmings = new Trimming[]{trimming};
        ShadeAxisKit[] shadeKits = new ShadeAxisKit[]{shadeKit};
        PlotScene scene = new PlotScene(ganger, surfFact, contents, trimmings, shadeKits, ptSel, compositor, caching);
        return new PlotDisplay(scene, navigator, dataStore);
    }
}

