/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.task.AbstractPlot2Task;
import uk.ac.starlink.ttools.plot2.task.ConfigParameter;
import uk.ac.starlink.ttools.plot2.task.ParameterFinder;
import uk.ac.starlink.ttools.plot2.task.PlotContext;

public class TypedPlot2Task<P, A>
extends AbstractPlot2Task {
    private final PlotType<P, A> plotType_;
    private final PlotContext<P, A> context_;
    private final Map<ConfigKey<String>, Input> axlabelMap_;
    private final Parameter<?>[] params_;

    public TypedPlot2Task(PlotType<P, A> plotType, Map<ConfigKey<String>, Input> axlabelMap, PlotContext<P, A> context) {
        super(true, plotType.getGangerFactory().hasIndependentZones());
        Parameter<?> geomParam;
        this.plotType_ = plotType;
        this.context_ = context;
        this.axlabelMap_ = axlabelMap == null ? new HashMap() : axlabelMap;
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.addAll(Arrays.asList(this.getBasicParameters()));
        for (ConfigKey<?> gangKey : plotType.getGangerFactory().getGangerKeys()) {
            paramList.add(ConfigParameter.createConfigParameter(gangKey));
        }
        SurfaceFactory<P, A> surfFact = plotType.getSurfaceFactory();
        paramList.addAll(this.getZoneKeyParams(surfFact.getProfileKeys()));
        paramList.addAll(this.getZoneKeyParams(surfFact.getAspectKeys()));
        for (ConfigKey<?> configKey : surfFact.getNavigatorKeys()) {
            paramList.add(ConfigParameter.createConfigParameter(configKey));
        }
        paramList.add(TypedPlot2Task.createLabelParameter("N"));
        paramList.add(TypedPlot2Task.createLayerTypeParameter("N", context));
        if (this.hasZoneSuffixes()) {
            paramList.add(TypedPlot2Task.createZoneParameter("N"));
        }
        if ((geomParam = context.getGeomParameter("N")) != null) {
            paramList.add(geomParam);
        }
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    public TypedPlot2Task(PlotType<P, A> plotType, Map<ConfigKey<String>, Input> axlabelMap) {
        this(plotType, axlabelMap, TypedPlot2Task.createDefaultPlotContext(plotType));
    }

    public PlotType<P, A> getPlotType() {
        return this.plotType_;
    }

    public String getPurpose() {
        return "Draws a " + this.plotType_.toString() + " plot";
    }

    public Parameter<?>[] getParameters() {
        return this.params_;
    }

    public PlotContext<P, A> getPlotContext(Environment env) {
        return this.context_;
    }

    public PlotContext<P, A> getPlotContext() {
        return this.context_;
    }

    @Override
    protected <T> String getConfigParamDefault(Environment env, ConfigKey<T> key, String[] suffixes) throws TaskException {
        String dataName;
        Input dataInput = this.axlabelMap_.get(key);
        if (dataInput != null && (dataName = TypedPlot2Task.getAxisDataName(env, dataInput, suffixes)) != null) {
            return dataName;
        }
        return null;
    }

    private static String getAxisDataName(Environment env, final Input input, String[] suffixes) throws TaskException {
        for (String suffix : suffixes) {
            Object dataParam = new ParameterFinder<Parameter<String>>(){

                @Override
                public Parameter<String> createParameter(String sfix) {
                    return AbstractPlot2Task.createDataParameter(input, sfix, false);
                }
            }.findParameter(env, suffix);
            if (dataParam == null) continue;
            return dataParam.stringValue(env);
        }
        return null;
    }

    public static <P, A> PlotContext<P, A> createDefaultPlotContext(PlotType<P, A> plotType) {
        DataGeom[] geoms = plotType.getPointDataGeoms();
        return geoms.length == 1 ? PlotContext.createFixedContext(plotType, geoms[0]) : PlotContext.createStandardContext(plotType);
    }
}

