/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plottask.StyleParameter;

public class FontParameter
extends StyleParameter<String> {
    private final IntegerParameter sizeParam_;
    private final ChoiceParameter<Integer> styleParam_;

    public FontParameter(String name) {
        super(name, GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        String dflt = "dialog";
        if (Arrays.asList(this.getOptionNames()).contains(dflt)) {
            this.setStringDefault(dflt);
        } else {
            assert (false) : Arrays.asList(this.getOptionNames());
            this.setStringDefault(this.getOptionNames()[0]);
        }
        this.setPrompt("Font family name");
        this.setUsage("dialog|serif|...");
        List<String> alwaysList = Arrays.asList("serif", "sansserif", "monospaced", "dialog", "dialoginput");
        List<String> otherList = new ArrayList<String>(Arrays.asList(this.getOptionNames()));
        otherList.removeAll(alwaysList);
        if (otherList.size() > 24) {
            otherList = otherList.subList(0, Math.min(otherList.size(), 24));
            otherList.add("...");
        }
        this.setDescription(new String[]{"<p>Determines the font that will be used for textual annotation", "of the plot, including axes etc.", "At least the following fonts will be available:", FontParameter.xmlList(alwaysList), "as well as a range of system-dependent fonts,", "possibly including", FontParameter.xmlList(otherList), "</p>"});
        this.sizeParam_ = new IntegerParameter(name + "size");
        this.sizeParam_.setPrompt("Font size");
        this.sizeParam_.setDescription(new String[]{"<p>Sets the font size used for plot annotations.", "</p>"});
        this.sizeParam_.setIntDefault(12);
        this.sizeParam_.setMinimum(1);
        this.styleParam_ = new ChoiceParameter(name + "style", Integer.class);
        this.styleParam_.addOption((Object)0, "plain");
        this.styleParam_.addOption((Object)1, "bold");
        this.styleParam_.addOption((Object)2, "italic");
        this.styleParam_.addOption((Object)3, "bold-italic");
        this.styleParam_.setPrompt("Font modifier");
        this.styleParam_.setDescription(new String[]{"<p>Gives a style in which the font is to be applied for", "plot annotations.", "Options are", "<code>plain</code>,", "<code>bold</code>,", "<code>italic</code> and", "<code>bold-italic</code>.", "</p>"});
        this.styleParam_.setStringDefault("plain");
    }

    public Parameter<?>[] getAssociatedParameters() {
        return new Parameter[]{this.sizeParam_, this.styleParam_};
    }

    public Font fontValue(Environment env) throws TaskException {
        int size = this.sizeParam_.intValue(env);
        int style = (Integer)this.styleParam_.objectValue(env);
        String family = (String)this.objectValue(env);
        return new Font(family, style, size);
    }

    private static String xmlList(List<String> sList) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<ul>\n");
        for (String str : sList) {
            sbuf.append("<li>").append("<code>").append("<![CDATA[").append(str).append("]]>").append("</code>").append("</li>").append("\n");
        }
        sbuf.append("</ul>");
        return sbuf.toString();
    }
}

