/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.scheme;

import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedFast;
import cds.healpix.VerticesAndPathComputer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.LongFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToDoubleFunction;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.HealpixTableInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.cone.CdsHealpixUtil;

public class SkySimData {
    private final int nrow_;
    private final HealpixTableInfo hpxInfo_;
    private final double[] cprobs_;
    private final Xyz xyz_;
    private final Qstat[] qstats_;
    private final boolean useGaussianPosition_;

    private SkySimData(int nrow, HealpixTableInfo hpxInfo, double[] cprobs, Xyz xyz, Qstat[] qstats) {
        this.nrow_ = nrow;
        this.hpxInfo_ = hpxInfo;
        this.cprobs_ = cprobs;
        this.xyz_ = xyz;
        this.qstats_ = qstats;
        this.useGaussianPosition_ = true;
    }

    public int getRowCount() {
        return this.nrow_;
    }

    public HealpixTableInfo getHealpixInfo() {
        return this.hpxInfo_;
    }

    public int getRandomRowIndex(long seed) {
        int ix;
        double rndval = new Random(seed).nextDouble();
        int ipos = Arrays.binarySearch(this.cprobs_, rndval);
        if (ipos >= 0) {
            return ipos;
        }
        for (ix = -2 - ipos; ix < this.cprobs_.length - 1 && this.cprobs_[ix + 1] == this.cprobs_[ix]; ++ix) {
        }
        return ix;
    }

    public Col createCoordColumn(final boolean isLat) {
        String description;
        String ucd;
        String name;
        int level = this.hpxInfo_.getLevel();
        switch (this.hpxInfo_.getCoordSys()) {
            case GALACTIC: {
                name = isLat ? "b" : "l";
                ucd = "pos.galactic." + (isLat ? "lat" : "lon");
                description = "Galactic " + (isLat ? "latitude" : "longitude");
                break;
            }
            case ECLIPTIC: {
                name = isLat ? "ecl_lat" : "ecl_lon";
                ucd = "pos.ecliptic." + (isLat ? "lat" : "lon");
                description = "Ecliptic " + (isLat ? "latitude" : "longitude");
                break;
            }
            default: {
                name = isLat ? "dec" : "ra";
                ucd = "pos.eq." + (isLat ? "dec" : "ra");
                description = (isLat ? "Right Ascension" : "Declination") + " J2000";
            }
        }
        ColumnInfo info = new ColumnInfo(name, Double.class, description);
        info.setUnitString("deg");
        info.setUCD(ucd);
        final double levelFact = 1.0 / (double)(1 << 2 * level);
        final ToDoubleFunction<Random> rndAdjust = this.useGaussianPosition_ ? rnd -> 18.0 * rnd.nextGaussian() : rnd -> 60.0 * (rnd.nextDouble() - 0.5);
        final double[] xs = this.xyz_.xs_;
        final double[] ys = this.xyz_.ys_;
        final double[] zs = this.xyz_.zs_;
        return new Col(info){

            @Override
            public double getValue(int irow, long seed) {
                double x = xs[irow];
                double y = ys[irow];
                double z = zs[irow];
                Random rnd = new Random(seed);
                double r1 = 1.0 / Math.sqrt((x += rndAdjust.applyAsDouble(rnd) * levelFact) * x + (y += rndAdjust.applyAsDouble(rnd) * levelFact) * y + (z += rndAdjust.applyAsDouble(rnd) * levelFact) * z);
                x *= r1;
                y *= r1;
                z *= r1;
                if (isLat) {
                    double theta = Math.acos(z);
                    return Math.toDegrees(1.5707963267948966 - theta);
                }
                return Math.toDegrees(Math.atan2(y, x));
            }
        };
    }

    public Col[] createQuantityColumns() {
        int nq = this.qstats_.length;
        Col[] qcols = new Col[nq];
        for (int iq = 0; iq < nq; ++iq) {
            qcols[iq] = this.createQuantityColumn(this.qstats_[iq]);
        }
        return qcols;
    }

    private Col createQuantityColumn(final Qstat qstat) {
        ColumnInfo info = new ColumnInfo((ValueInfo)qstat.meanInfo_);
        info.setContentClass(Double.class);
        info.setDescription(null);
        return new Col(info){

            @Override
            public double getValue(int irow, long seed) {
                float mean = qstat.means_[irow];
                float stdev = qstat.stdevs_[irow];
                return !Float.isNaN(mean) && stdev >= 0.0f ? (double)mean + new Random(seed).nextGaussian() * (double)stdev : Double.NaN;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkySimData readData(StarTable table, HealpixTableInfo hpxInfo, String cnameWeight, String stdevSuffix) throws IOException {
        LongUnaryOperator irowToHpx;
        int nrow = Tables.checkedLongToInt((long)table.getRowCount());
        int level = hpxInfo.getLevel();
        int ncol = table.getColumnCount();
        String[] colNames = new String[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            colNames[icol] = table.getColumnInfo(icol).getName();
        }
        int icWeight = Arrays.asList(colNames).indexOf(cnameWeight);
        double[] weights = new double[nrow];
        Qloc[] qlocs = SkySimData.findQlocs(colNames, stdevSuffix);
        int nq = qlocs.length;
        Qstat[] qstats = new Qstat[nq];
        for (int iq = 0; iq < nq; ++iq) {
            qstats[iq] = new Qstat(table.getColumnInfo(qlocs[iq].icMean_), nrow);
        }
        Xyz xyz = new Xyz(nrow);
        HealpixNestedFast hnf = Healpix.getNestedFast((int)level);
        HealpixNested hn = Healpix.getNested((int)level);
        LongFunction<double[]> toLonLat = hpxInfo.isNest() ? arg_0 -> SkySimData.lambda$readData$2((VerticesAndPathComputer)hnf, arg_0) : arg_0 -> SkySimData.lambda$readData$3((VerticesAndPathComputer)hnf, hn, arg_0);
        int icHpx = Arrays.asList(colNames).indexOf(hpxInfo.getPixelColumnName());
        if (icHpx < 0) {
            irowToHpx = irow -> irow;
        } else {
            RowAccess racc = table.getRowAccess();
            irowToHpx = irow -> {
                try {
                    racc.setRowIndex(irow);
                    Object hpxObj = racc.getCell(icHpx);
                    return hpxObj instanceof Number ? ((Number)hpxObj).longValue() : -1L;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        RowSequence rseq = table.getRowSequence();
        double[] v3 = new double[3];
        double wsum = 0.0;
        try {
            int irow2 = 0;
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                Object weightObj = row[icWeight];
                double weight = weightObj instanceof Number ? ((Number)weightObj).doubleValue() : 0.0;
                weights[irow2] = wsum;
                if (weight > 0.0) {
                    wsum += weight;
                }
                long hpx = irowToHpx.applyAsLong(irow2);
                double[] lonlat = toLonLat.apply(hpx);
                CdsHealpixUtil.lonlatToVector(lonlat, v3);
                xyz.xs_[irow2] = v3[0];
                xyz.ys_[irow2] = v3[1];
                xyz.zs_[irow2] = v3[2];
                for (int iq = 0; iq < nq; ++iq) {
                    Qloc qloc = qlocs[iq];
                    Qstat qstat = qstats[iq];
                    qstat.means_[irow2] = ((Number)row[qloc.icMean_]).floatValue();
                    qstat.stdevs_[irow2] = ((Number)row[qloc.icStdev_]).floatValue();
                }
                ++irow2;
            }
        }
        finally {
            rseq.close();
        }
        double scale = 1.0 / wsum;
        int i = 1;
        while (i < nrow) {
            int n = i++;
            weights[n] = weights[n] * scale;
        }
        assert (weights[0] == 0.0);
        return new SkySimData(nrow, hpxInfo, weights, xyz, qstats);
    }

    private static Qloc[] findQlocs(String[] colnames, String stdevSuffix) {
        ArrayList<Qloc> qlocs = new ArrayList<Qloc>();
        for (int icol = 0; icol < colnames.length; ++icol) {
            String cname = colnames[icol];
            if (!cname.endsWith(stdevSuffix)) continue;
            String baseName = cname.substring(0, cname.length() - stdevSuffix.length());
            int jcol = Arrays.asList(colnames).indexOf(baseName);
            if (jcol < 0) continue;
            qlocs.add(new Qloc(jcol, icol));
        }
        return qlocs.toArray(new Qloc[0]);
    }

    private static /* synthetic */ double[] lambda$readData$3(VerticesAndPathComputer hnf, HealpixNested hn, long hpx) {
        return hnf.center(hn.toRing(hpx));
    }

    private static /* synthetic */ double[] lambda$readData$2(VerticesAndPathComputer hnf, long hpx) {
        return hnf.center(hpx);
    }

    private static class Qstat {
        final ColumnInfo meanInfo_;
        final float[] means_;
        final float[] stdevs_;

        Qstat(ColumnInfo meanInfo, int nrow) {
            this.meanInfo_ = meanInfo;
            this.means_ = new float[nrow];
            this.stdevs_ = new float[nrow];
        }
    }

    private static class Qloc {
        final int icMean_;
        final int icStdev_;

        Qloc(int icMean, int icStdev) {
            this.icMean_ = icMean;
            this.icStdev_ = icStdev;
        }
    }

    private static class Xyz {
        final double[] xs_;
        final double[] ys_;
        final double[] zs_;

        Xyz(int nrow) {
            this.xs_ = new double[nrow];
            this.ys_ = new double[nrow];
            this.zs_ = new double[nrow];
        }
    }

    public static abstract class Col {
        private final ColumnInfo info_;

        protected Col(ColumnInfo info) {
            this.info_ = info;
        }

        public ColumnInfo getInfo() {
            return this.info_;
        }

        public abstract double getValue(int var1, long var2);
    }
}

