/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.task.DataStoreParameter;
import uk.ac.starlink.ttools.plot2.task.PlotConfiguration;
import uk.ac.starlink.ttools.plottask.PaintModeParameter;
import uk.ac.starlink.ttools.server.ServerPainter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.util.Pair;

public class PlotServletEnvironment
implements TableEnvironment {
    private final Map<String, List<String>> paramMap_;
    private final StarTableFactory tableFactory_;
    private final StarTableOutput tableOutput_;
    private final JDBCAuthenticator jdbcAuth_;
    private final DataStoreFactory dataStoreFactory_;
    private final PrintStream outStream_;
    private final ServerPainter painter_;
    private boolean strictVot_;
    private boolean debug_;
    private GraphicExporter exporter_;

    public PlotServletEnvironment(HttpServletResponse response, List<Pair<String>> nvPairs, StarTableFactory tableFactory, StarTableOutput tableOutput, JDBCAuthenticator jdbcAuth, DataStoreFactory dataStoreFactory) throws IOException {
        this.outStream_ = new PrintStream((OutputStream)response.getOutputStream());
        this.tableFactory_ = tableFactory;
        this.tableOutput_ = tableOutput;
        this.jdbcAuth_ = jdbcAuth;
        this.dataStoreFactory_ = dataStoreFactory;
        this.painter_ = new ServerPainter();
        this.paramMap_ = new LinkedHashMap<String, List<String>>();
        for (Pair<String> pair : nvPairs) {
            String key = LineTableEnvironment.normaliseName((String)pair.getItem1());
            String value = (String)pair.getItem2();
            this.paramMap_.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
    }

    public String[] getNames() {
        return this.paramMap_.keySet().toArray(new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void acquireValue(Parameter<?> param) throws TaskException {
        if (param instanceof PaintModeParameter) {
            PaintModeParameter pmParam = (PaintModeParameter)param;
            ChoiceParameter<GraphicExporter> formatParam = pmParam.getFormatParameter();
            formatParam.setStringDefault("jpeg");
            this.exporter_ = (GraphicExporter)formatParam.objectValue((Environment)this);
            pmParam.setValueFromPainter(this, this.painter_);
            return;
        } else if (param instanceof DataStoreParameter) {
            DataStoreParameter storageParam = (DataStoreParameter)param;
            storageParam.setValueFromObject(this, this.dataStoreFactory_);
            return;
        } else {
            String stringVal;
            int nval;
            String pname = LineTableEnvironment.normaliseName(param.getName());
            List<String> valList = this.paramMap_.get(pname);
            int n = nval = valList == null ? 0 : valList.size();
            if (nval == 0) {
                stringVal = param.getStringDefault();
            } else if (param instanceof MultiParameter) {
                char sep = ((MultiParameter)param).getValueSeparator();
                StringBuffer sbuf = new StringBuffer();
                for (int iv = 0; iv < nval; ++iv) {
                    if (iv > 0) {
                        sbuf.append(sep);
                    }
                    sbuf.append(valList.get(iv));
                }
                stringVal = sbuf.toString();
            } else if (nval > 1) {
                int nv = 0;
                String val = null;
                for (String value : valList) {
                    if (value == null || value.length() <= 0) continue;
                    ++nv;
                    val = value;
                }
                if (nv == 0) {
                    stringVal = null;
                } else {
                    if (nv != true) throw new ParameterValueException(param, "Multiple values supplied for single-valued  parameter");
                    stringVal = val;
                }
            } else {
                stringVal = valList.get(0);
            }
            if (stringVal == null || stringVal.length() == 0) {
                if (!param.isNullPermitted()) throw new ParameterValueException(param, "null value not allowed");
                param.setValueFromString((Environment)this, null);
                return;
            } else {
                param.setValueFromString((Environment)this, stringVal);
            }
        }
    }

    public PlotConfiguration<?, ?> getPlotConfiguration() {
        return this.painter_.getPlotConfiguration();
    }

    public GraphicExporter getGraphicExporter() {
        return this.exporter_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearValue(Parameter<?> param) {
        Map<String, List<String>> map = this.paramMap_;
        synchronized (map) {
            this.paramMap_.remove(LineTableEnvironment.normaliseName(param.getName()));
        }
    }

    public PrintStream getOutputStream() {
        return this.outStream_;
    }

    public PrintStream getErrorStream() {
        return this.outStream_;
    }

    @Override
    public StarTableFactory getTableFactory() {
        return this.tableFactory_;
    }

    @Override
    public StarTableOutput getTableOutput() {
        return this.tableOutput_;
    }

    @Override
    public JDBCAuthenticator getJdbcAuthenticator() {
        return this.jdbcAuth_;
    }

    @Override
    public boolean isDebug() {
        return this.debug_;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug_ = debug;
    }

    @Override
    public boolean isStrictVotable() {
        return this.strictVot_;
    }

    @Override
    public void setStrictVotable(boolean strictVot) {
        this.strictVot_ = strictVot;
    }
}

