/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.util.logging.Logger;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.ReportType;

public class AdhocCode
implements ReportCode {
    private final ReportType type_;
    private final String label_;
    public static final int LABEL_LENGTH = 4;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.taplint");

    public AdhocCode(ReportType type, String label) {
        this.type_ = type;
        if (label.length() != 4) {
            assert (false);
            label = AdhocCode.createLabelChars(label, 4);
            logger_.warning("Wrong length label: changed to " + label);
        }
        this.label_ = label;
    }

    @Override
    public ReportType getType() {
        return this.type_;
    }

    @Override
    public String getLabel() {
        return this.label_;
    }

    public int hashCode() {
        return this.type_.hashCode() * 23 + this.label_.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ReportCode) {
            ReportCode other = (ReportCode)o;
            return this.getType() == other.getType() && this.getLabel().equals(other.getLabel());
        }
        return false;
    }

    public static AdhocCode createCodeFromText(ReportType type, String text) {
        return new AdhocCode(type, AdhocCode.createLabelChars(text, 4));
    }

    public static String createLabelChars(Object id, int nchar) {
        int hash = id.hashCode();
        char[] chrs = new char[nchar];
        for (int i = 0; i < nchar; ++i) {
            chrs[i] = (char)(65 + (hash & 0x1F) % 25);
            hash >>= 5;
        }
        return new String(chrs);
    }
}

