/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.ttools.taplint.AdhocCode;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TableMetadataStage;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapService;

public class CompareMetadataStage
implements Stage {
    private final String srcDesc1_;
    private final String srcDesc2_;
    private final MetadataHolder metaHolder1_;
    private final MetadataHolder metaHolder2_;
    private static Pattern ADQLTYPE_REGEX = Pattern.compile("^(adql:)?([^(]*)(\\(.*\\))?$");

    public CompareMetadataStage(String srcDesc1, String srcDesc2, MetadataHolder metaHolder1, MetadataHolder metaHolder2) {
        this.srcDesc1_ = srcDesc1;
        this.srcDesc2_ = srcDesc2;
        this.metaHolder1_ = metaHolder1;
        this.metaHolder2_ = metaHolder2;
    }

    @Override
    public String getDescription() {
        return "Compare table metadata from " + this.srcDesc1_ + " and " + this.srcDesc2_;
    }

    @Override
    public void run(Reporter reporter, TapService tapService) {
        SchemaMeta[] smetas1 = this.metaHolder1_.getTableMetadata();
        SchemaMeta[] smetas2 = this.metaHolder2_.getTableMetadata();
        if (smetas1 == null || smetas2 == null) {
            reporter.report(FixedCode.F_NOTM, "Don't have two metadata sets to compare (earlier stages failed/skipped?)");
            return;
        }
        this.compareSchemas(reporter, smetas1, smetas2);
    }

    private void compareSchemas(Reporter reporter, SchemaMeta[] smetas1, SchemaMeta[] smetas2) {
        boolean hasDetails;
        boolean bl = hasDetails = this.metaHolder1_.hasDetail() && this.metaHolder2_.hasDetail();
        if (!hasDetails) {
            reporter.report(FixedCode.F_NODT, "No column/fkey metadata comparison (one/both metadatas lack detail)");
        }
        Map<String, SchemaMeta> smMap1 = CompareMetadataStage.createNameMap(smetas1);
        Map<String, SchemaMeta> smMap2 = CompareMetadataStage.createNameMap(smetas2);
        Collection<String> sNames = this.getIntersection(reporter, 'S', "Schema", null, smetas1, smetas2);
        for (String sname : sNames) {
            SchemaMeta sm1 = smMap1.get(sname);
            SchemaMeta sm2 = smMap2.get(sname);
            assert (sm1 != null && sm2 != null) : sm1 + " " + sm2;
            this.compareTables(reporter, sname, sm1.getTables(), sm2.getTables(), hasDetails);
        }
    }

    private void compareTables(Reporter reporter, String schemaName, TableMeta[] tmetas1, TableMeta[] tmetas2, boolean cmpDetail) {
        Map<String, TableMeta> tmMap1 = CompareMetadataStage.createNameMap(tmetas1);
        Map<String, TableMeta> tmMap2 = CompareMetadataStage.createNameMap(tmetas2);
        Collection<String> tNames = this.getIntersection(reporter, 'T', "Table", "schema " + schemaName, tmetas1, tmetas2);
        if (cmpDetail) {
            for (String tname : tNames) {
                TableMeta tm1 = tmMap1.get(tname);
                TableMeta tm2 = tmMap2.get(tname);
                assert (tm1 != null && tm2 != null) : tm1 + " " + tm2;
                this.compareColumns(reporter, tname, tm1.getColumns(), tm2.getColumns());
                this.compareForeignKeys(reporter, tname, tm1.getForeignKeys(), tm2.getForeignKeys());
            }
        }
    }

    private void compareColumns(Reporter reporter, String tableName, ColumnMeta[] cmetas1, ColumnMeta[] cmetas2) {
        Map<String, ColumnMeta> cmMap1 = CompareMetadataStage.createNameMap(cmetas1);
        Map<String, ColumnMeta> cmMap2 = CompareMetadataStage.createNameMap(cmetas2);
        Collection<String> cNames = this.getIntersection(reporter, 'C', "Column", "table " + tableName, cmetas1, cmetas2);
        for (String cname : cNames) {
            ColumnMeta cm1 = cmMap1.get(cname);
            ColumnMeta cm2 = cmMap2.get(cname);
            Checker checker = new Checker(reporter, "Column", tableName + ":" + cname);
            checker.checkDataTypes(FixedCode.W_CTYP, cm1.getDataType(), cm2.getDataType());
            checker.check("UCD", FixedCode.W_CUCD, cm1.getUcd(), cm2.getUcd());
            checker.check("Utype", FixedCode.W_CUTP, cm1.getUtype(), cm2.getUtype());
            checker.check("Unit", FixedCode.W_CUNI, cm1.getUnit(), cm2.getUnit());
            checker.check("IsIndexed", FixedCode.W_CIDX, cm1.isIndexed(), cm2.isIndexed());
        }
    }

    private void compareForeignKeys(Reporter reporter, String tableName, ForeignMeta[] fmetas1, ForeignMeta[] fmetas2) {
        this.getIntersection(reporter, 'F', "Foreign key", "table " + tableName, fmetas1, fmetas2);
    }

    private Collection<String> getIntersection(Reporter reporter, char lchr, String ltype, String context, Object[] items1, Object[] items2) {
        String msg;
        ArrayList<String> names1 = new ArrayList<String>();
        for (int i1 = 0; i1 < items1.length; ++i1) {
            names1.add(items1[i1].toString());
        }
        ArrayList<String> names2 = new ArrayList<String>();
        for (int i2 = 0; i2 < items2.length; ++i2) {
            names2.add(items2[i2].toString());
        }
        ArrayList extras1 = new ArrayList(names1);
        ArrayList extras2 = new ArrayList(names2);
        extras1.removeAll(names2);
        extras2.removeAll(names1);
        String contextString = context == null ? "" : " from " + context;
        for (String ex1 : extras1) {
            msg = new StringBuffer().append(ltype).append(" ").append(ex1).append(contextString).append(" exists in ").append(this.srcDesc1_).append(" but not in ").append(this.srcDesc2_).toString();
            reporter.report(new AdhocCode(ReportType.ERROR, "" + lchr + "M12"), msg);
        }
        for (String ex2 : extras2) {
            msg = new StringBuffer().append(ltype).append(" ").append(ex2).append(contextString).append(" exists in ").append(this.srcDesc2_).append(" but not ").append(this.srcDesc1_).toString();
            reporter.report(new AdhocCode(ReportType.ERROR, "" + lchr + "M21"), msg);
        }
        ArrayList<String> intersect = new ArrayList<String>(names1);
        intersect.retainAll(names2);
        return intersect;
    }

    public static boolean compatibleDataTypes(String dt1, String dt2) {
        return CompareMetadataStage.compatibleDataTypesOneWay(dt1, dt2) || CompareMetadataStage.compatibleDataTypesOneWay(dt2, dt1);
    }

    private static boolean compatibleDataTypesOneWay(String dt1, String dt2) {
        boolean isBlank2;
        boolean isBlank1 = dt1 == null || dt1.trim().length() == 0;
        boolean bl = isBlank2 = dt2 == null || dt2.trim().length() == 0;
        if (isBlank1 && isBlank2) {
            return true;
        }
        if (isBlank1 || isBlank2) {
            return false;
        }
        if ((dt1 = CompareMetadataStage.stripAdqlType(dt1)).equalsIgnoreCase(dt2)) {
            return true;
        }
        if (dt1.equals("SMALLINT") && dt2.equals("short") || dt1.equals("INTEGER") && dt2.equals("int") || dt1.equals("BIGINT") && dt2.equals("long") || dt1.equals("REAL") && dt2.equals("float") || dt1.equals("DOUBLE") && dt2.equals("double") || dt1.equals("VARBINARY") && (dt2.equals("short") || dt2.equals("int") || dt2.equals("long") || dt2.equals("float") || dt2.equals("double") || dt2.equals("unsignedByte")) || dt1.equals("BLOB") && dt2.equals("unsignedByte") || (dt1.equals("CHAR") || dt1.equals("VARCHAR") || dt1.equals("CLOB") || dt1.equals("TIMESTAMP") || dt1.equals("POINT") || dt1.equals("REGION")) && (dt2.equals("char") || dt2.equals("unicodeChar")) || (dt1.equals("SMALLINT") || dt1.equals("INTEGER")) && dt2.equals("boolean")) {
            return true;
        }
        return dt1.equals("BOOLEAN") && dt2.equals("boolean");
    }

    private static <T> Map<String, T> createNameMap(T[] items) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        for (int i = 0; i < items.length; ++i) {
            T item = items[i];
            map.put(item.toString(), item);
        }
        return map;
    }

    public static String stripAdqlType(String dtype) {
        if (dtype == null) {
            return null;
        }
        Matcher atm = ADQLTYPE_REGEX.matcher(dtype);
        return atm.matches() ? atm.group(2) : dtype;
    }

    public static CompareMetadataStage createStage(TableMetadataStage stage1, TableMetadataStage stage2) {
        return new CompareMetadataStage(stage1.getSourceDescription(), stage2.getSourceDescription(), stage1, stage2);
    }

    private static class Checker {
        private final Reporter reporter_;
        private final String objectType_;
        private final String objectName_;

        Checker(Reporter reporter, String objectType, String objectName) {
            this.reporter_ = reporter;
            this.objectType_ = objectType;
            this.objectName_ = objectName;
        }

        void check(String itemName, ReportCode code, Object item1, Object item2) {
            if (!(item1 == null && item2 == null || item1 != null && item1.equals(item2))) {
                String q1 = item1 instanceof String ? "\"" : "";
                String q2 = item2 instanceof String ? "\"" : "";
                String msg = new StringBuffer().append(itemName).append(" mismatch for ").append(this.objectType_).append(" ").append(this.objectName_).append("; ").append(q1).append(item1).append(q1).append(" != ").append(q2).append(item2).append(q2).toString();
                this.reporter_.report(code, msg);
            }
        }

        void checkDataTypes(ReportCode code, String dt1, String dt2) {
            if (!CompareMetadataStage.compatibleDataTypes(dt1, dt2)) {
                String msg = new StringBuffer().append("Possibly incompatible datatypes for ").append(this.objectType_).append(" ").append(this.objectName_).append("; ").append(dt1).append(" vs. ").append(dt2).toString();
                this.reporter_.report(code, msg);
            }
        }
    }
}

