/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.ObsLocStage;
import uk.ac.starlink.ttools.taplint.ObsTapStage;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TableData;
import uk.ac.starlink.ttools.taplint.TapRunner;
import uk.ac.starlink.ttools.votlint.VocabChecker;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.UcdStatus;
import uk.ac.starlink.vo.VocabTerm;

public class EpnTapStage
implements Stage {
    private final TapRunner tapRunner_;
    private final MetadataHolder metaHolder_;
    public static final String EPNCORE_TNAME = "epn_core";
    public static final Ivoid EPNCORE_UTYPE = new Ivoid("ivo://ivoa.net/std/epntap#table-2.0");
    public static final Ivoid EPNCORE_UTYPE2 = new Ivoid("ivo://vopdc.obspm/std/epncore#schema-2.0");
    private static final int JD_PLAUSIBLE_LO = 2086000;
    private static final int JD_PLAUSIBLE_HI = 2817000;
    static Pattern DALI_TIMESTAMP_REGEX = Pattern.compile("[0-9]{4}-[01][0-9]-[0-3][0-9](?:T[0-2][0-9]:[0-5][0-9]:[0-5][0-9](?:[.][0-9]*)?Z?)?");
    private static final VocabChecker MESSENGER_VOCAB = VocabChecker.MESSENGER;

    public EpnTapStage(TapRunner tapRunner, MetadataHolder metaHolder) {
        this.tapRunner_ = tapRunner;
        this.metaHolder_ = metaHolder;
    }

    @Override
    public String getDescription() {
        return "Test implementation of EPN-TAP tables";
    }

    @Override
    public void run(Reporter reporter, TapService tapService) {
        ArrayList<TableMeta> epnMetas = new ArrayList<TableMeta>();
        for (SchemaMeta smeta : this.metaHolder_.getTableMetadata()) {
            for (TableMeta tmeta : smeta.getTables()) {
                String msg;
                String tname = tmeta.getName();
                Ivoid utype = new Ivoid(tmeta.getUtype());
                String subname = tname.replaceAll("^.*[.]", "");
                boolean isEpnName = EPNCORE_TNAME.equalsIgnoreCase(subname);
                boolean isEpnUtype = EPNCORE_UTYPE.equalsIvoid(utype);
                boolean isEpnUtype2 = EPNCORE_UTYPE2.equalsIvoid(utype);
                if (isEpnName && !isEpnUtype) {
                    FixedCode code;
                    if (isEpnUtype2) {
                        msg = new StringBuffer().append("Table ").append(tname).append(" has transitional utype ").append(utype).append(" not EPN-TAP v2 utype ").append(EPNCORE_UTYPE).toString();
                        code = FixedCode.W_PNUB;
                    } else {
                        msg = new StringBuffer().append("Table ").append(tname).append(" has EPN-TAP name, but not utype (").append(utype).append(" != ").append(EPNCORE_UTYPE).append(")").toString();
                        code = FixedCode.E_PNUT;
                    }
                    reporter.report(code, msg);
                }
                if (isEpnUtype && !isEpnName) {
                    msg = new StringBuffer().append("Table ").append(tname).append(" has EPN-TAP utype, but not name").append(" (not of form <schema-name>.").append(EPNCORE_TNAME).append(")").toString();
                    reporter.report(FixedCode.E_PNTN, msg);
                }
                if (!isEpnName && !isEpnUtype) continue;
                epnMetas.add(tmeta);
            }
        }
        int nEpn = epnMetas.size();
        for (int i = 0; i < nEpn; ++i) {
            TableMeta tmeta = (TableMeta)epnMetas.get(i);
            String msg = new StringBuffer().append("Checking EPN-TAP table #").append(i + 1).append("/").append(nEpn).append(": ").append(tmeta.getName()).toString();
            reporter.report(FixedCode.I_PNIX, msg);
            new EpncoreRunner(reporter, tapService, tmeta, this.tapRunner_).run();
        }
        if (epnMetas.size() == 0) {
            reporter.report(FixedCode.F_NOPN, "No epn_core tables");
        } else {
            String msg = new StringBuffer().append("Found ").append(nEpn).append(" ").append(EPNCORE_TNAME).append(" tables").toString();
            reporter.report(FixedCode.S_PNCN, msg);
        }
    }

    static SingleCol[] toSingleCols(EpnCol[] cols) {
        ArrayList<SingleCol> list = new ArrayList<SingleCol>();
        for (EpnCol col : cols) {
            if (col instanceof SingleCol) {
                list.add((SingleCol)col);
                continue;
            }
            if (col instanceof MinMaxCol) {
                MinMaxCol mcol = (MinMaxCol)col;
                list.add(mcol.minCol());
                list.add(mcol.maxCol());
                continue;
            }
            throw new AssertionError();
        }
        return list.toArray(new SingleCol[0]);
    }

    static EpnCol[] getAllColumns() {
        ArrayList<EpnCol> list = new ArrayList<EpnCol>();
        list.addAll(Arrays.asList(EpnTapStage.createMandatoryColumns()));
        list.addAll(Arrays.asList(EpnTapStage.createOptionalColumns()));
        list.addAll(Arrays.asList(EpnTapStage.createExtensionColumns()));
        return list.toArray(new EpnCol[0]);
    }

    private static EpnCol[] getNonMandatoryColumns() {
        ArrayList<EpnCol> list = new ArrayList<EpnCol>();
        list.addAll(Arrays.asList(EpnTapStage.createOptionalColumns()));
        list.addAll(Arrays.asList(EpnTapStage.createExtensionColumns()));
        return list.toArray(new EpnCol[0]);
    }

    private static Map<String, EpnCol> toEpnColMap(EpnCol[] cols) {
        LinkedHashMap<String, EpnCol> map = new LinkedHashMap<String, EpnCol>();
        for (EpnCol col : cols) {
            map.put(col.id_, col);
        }
        return map;
    }

    private static EpnCol[] createMandatoryColumns() {
        ContentChecker timestampChecker;
        ContentChecker notNull;
        Map<String, EpnCol> colMap = EpnTapStage.toEpnColMap(new EpnCol[]{EpnTapStage.textCol("granule_uid", "meta.id"), EpnTapStage.textCol("granule_gid", "meta.id"), EpnTapStage.textCol("obs_id", "meta.id;obs"), EpnTapStage.textCol("dataproduct_type", "meta.code.class"), EpnTapStage.textCol("target_name", "meta.id;src"), EpnTapStage.textCol("target_class", "src.class"), new MinMaxCol("time_", Type.DOUBLE, "d", new String2("time.start;obs", "time.end;obs")), new MinMaxCol("time_sampling_step_", Type.DOUBLE, "s", EpnTapStage.minMaxStats("time.resolution")), new MinMaxCol("time_exp_", Type.DOUBLE, "s", EpnTapStage.minMaxStats("time.duration;obs.exposure")), new MinMaxCol("spectral_range_", Type.DOUBLE, "Hz", EpnTapStage.minMaxStats("em.freq")), new MinMaxCol("spectral_sampling_step_", Type.DOUBLE, "Hz", EpnTapStage.minMaxStats("em.freq;spect.binSize")), new MinMaxCol("spectral_resolution_", Type.DOUBLE, "", EpnTapStage.minMaxStats("spect.resolution")), new MinMaxCol("c1", Type.DOUBLE, null, null), new MinMaxCol("c2", Type.DOUBLE, null, null), new MinMaxCol("c3", Type.DOUBLE, null, null), EpnTapStage.textCol("s_region", "pos.outline;obs.field"), new MinMaxCol("c1_resol_", Type.DOUBLE, null, null), new MinMaxCol("c2_resol_", Type.DOUBLE, null, null), new MinMaxCol("c3_resol_", Type.DOUBLE, null, null), EpnTapStage.textCol("spatial_frame_type", "meta.code.class;pos.frame"), new MinMaxCol("incidence_", Type.DOUBLE, "deg", EpnTapStage.minMaxStats("pos.incidenceAng")), new MinMaxCol("emergence_", Type.DOUBLE, "deg", EpnTapStage.minMaxStats("pos.emergenceAng")), new MinMaxCol("phase_", Type.DOUBLE, "deg", EpnTapStage.minMaxStats("pos.phaseAng")), EpnTapStage.textCol("instrument_host_name", "meta.id;instr.obsty"), EpnTapStage.textCol("instrument_name", "meta.id;instr"), EpnTapStage.textCol("measurement_type", "meta.ucd"), new SingleCol("processing_level", Type.INTEGER, null, "meta.calibLevel"), new SingleCol("creation_date", Type.TIMESTAMP, null, "time.creation"), new SingleCol("modification_date", Type.TIMESTAMP, null, "time.processing"), new SingleCol("release_date", Type.TIMESTAMP, null, "time.release"), EpnTapStage.textCol("service_title", "meta.title")});
        colMap.get((Object)"granule_uid").checker_ = notNull = EpnTapStage.notNullChecker();
        colMap.get((Object)"granule_gid").checker_ = notNull;
        colMap.get((Object)"obs_id").checker_ = notNull;
        colMap.get((Object)"dataproduct_type").checker_ = notNull;
        colMap.get((Object)"creation_date").checker_ = notNull;
        colMap.get((Object)"modification_date").checker_ = notNull;
        colMap.get((Object)"release_date").checker_ = notNull;
        colMap.get((Object)"service_title").checker_ = notNull;
        for (String cname : new String[]{"c1", "c2", "c3"}) {
            ((MinMaxCol)colMap.get((Object)cname)).couldBeLongitude_ = true;
        }
        colMap.get((Object)"time_").checker_ = EpnTapStage.jdChecker();
        colMap.get((Object)"spatial_frame_type").checker_ = EpnTapStage.optionsChecker(false, FixedCode.E_PNFT, new String[]{"celestial", "body", "cartesian", "spherical", "cylindrical", "none", "healpix"});
        colMap.get((Object)"s_region").checker_ = EpnTapStage.sregionChecker();
        colMap.get((Object)"dataproduct_type").checker_ = EpnTapStage.hashlistOptionsChecker(false, FixedCode.E_PNDP, new String[]{"im", "ma", "sp", "ds", "sc", "pr", "pf", "vo", "mo", "cu", "ts", "ca", "ci", "sv", "ev"});
        colMap.get((Object)"processing_level").checker_ = EpnTapStage.rangeChecker(true, FixedCode.E_PNPL, "1", "6");
        colMap.get((Object)"target_class").checker_ = EpnTapStage.hashlistOptionsChecker(false, FixedCode.E_PNTG, new String[]{"asteroid", "dwarf_planet", "planet", "satellite", "comet", "exoplanet", "interplanetary_medium", "sample", "sky", "spacecraft", "spacejunk", "star", "calibration"});
        colMap.get((Object)"service_title").checker_ = EpnTapStage.serviceTitleChecker();
        colMap.get((Object)"measurement_type").checker_ = EpnTapStage.ucdChecker();
        colMap.get((Object)"creation_date").checker_ = timestampChecker = EpnTapStage.timestampChecker(false);
        colMap.get((Object)"modification_date").checker_ = timestampChecker;
        colMap.get((Object)"release_date").checker_ = timestampChecker;
        return colMap.values().toArray(new EpnCol[0]);
    }

    private static EpnCol[] createOptionalColumns() {
        Map<String, EpnCol> colMap = EpnTapStage.toEpnColMap(new EpnCol[]{EpnTapStage.textCol("access_url", "meta.ref.url;meta.file"), EpnTapStage.textCol("access_format", "meta.code.mime"), new SingleCol("access_estsize", Type.INTEGER, "kbyte", "phys.size;meta.file"), EpnTapStage.textCol("access_md5", "meta.checksum;meta.file"), EpnTapStage.textCol("thumbnail_url", "meta.ref.url;meta.preview"), EpnTapStage.textCol("file_name", "meta.id;meta.file"), EpnTapStage.textCol("datalink_url", "meta.ref.url"), EpnTapStage.textCol("species", "meta.id;phys.atmol"), EpnTapStage.textCol("messenger", "instr.bandpass"), EpnTapStage.textCol("alt_target_name", "meta.id;src"), EpnTapStage.textCol("target_region", "meta.id;src;obs.field"), EpnTapStage.textCol("feature_name", "meta.id;src;obs.field"), EpnTapStage.textCol("publisher", "meta.curation"), EpnTapStage.textCol("processing_level_desc", "meta.note"), EpnTapStage.textCol("bib_reference", "meta.bib"), EpnTapStage.textCol("internal_reference", "meta.id.cross"), EpnTapStage.textCol("external_link", "meta.ref.url"), new SingleCol("coverage", Type.TEXT_MOC, null, "pos.outline;obs.field"), EpnTapStage.textCol("spatial_coordinate_description", "meta.code.class;pos.frame"), EpnTapStage.textCol("spatial_origin", "meta.ref;pos.frame"), EpnTapStage.textCol("time_refposition", "meta.ref;time.scale"), EpnTapStage.textCol("time_scale", "time.scale"), new MinMaxCol("subsolar_longitude_", Type.DOUBLE, "deg", EpnTapStage.minMaxStats("pos.bodyrc.lon")), new MinMaxCol("subsolar_latitude_", Type.DOUBLE, "deg", EpnTapStage.minMaxStats("pos.bodyrc.lat")), new MinMaxCol("subobserver_longitude_", Type.DOUBLE, "deg", EpnTapStage.minMaxStats("pos.bodyrc.lon")), new MinMaxCol("subobserver_latitude_", Type.DOUBLE, "deg", EpnTapStage.minMaxStats("pos.bodyrc.lat")), new SingleCol("ra", Type.DOUBLE, "deg", "pos.eq.ra;meta.main"), new SingleCol("dec", Type.DOUBLE, "deg", "pos.eq.dec;meta.main"), new MinMaxCol("radial_distance_", Type.DOUBLE, "km", EpnTapStage.minMaxStats("pos.distance;pos.bodyrc")), new MinMaxCol("altitude_fromshape_", Type.DOUBLE, "km", EpnTapStage.minMaxStats("pos.bodyrc.alt")), new MinMaxCol("solar_longitude_", Type.DOUBLE, "deg", EpnTapStage.minMaxStats("pos.ecliptic.lon;pos.heliocentric")), new MinMaxCol("local_time_", Type.DOUBLE, "h", EpnTapStage.minMaxStats("time.phase;time.period.rotation")), new MinMaxCol("target_distance_", Type.DOUBLE, "km", EpnTapStage.minMaxStats("pos.distance")), new MinMaxCol("target_time_", Type.TIMESTAMP, null, new String2("time.start;src", "time.end;src")), new MinMaxCol("earth_distance_", Type.DOUBLE, "AU", EpnTapStage.minMaxStats("pos.distance")), new MinMaxCol("sun_distance_", Type.DOUBLE, "AU", EpnTapStage.minMaxStats("pos.distance"))});
        for (String cname : new String[]{"subsolar_longitude_", "subobserver_longitude_", "solar_longitude_"}) {
            ((MinMaxCol)colMap.get((Object)cname)).couldBeLongitude_ = true;
        }
        colMap.get((Object)"local_time_").checker_ = EpnTapStage.rangeChecker(true, FixedCode.E_PNLT, "0", "24");
        colMap.get((Object)"target_time_").checker_ = EpnTapStage.timestampChecker(true);
        colMap.get((Object)"messenger").checker_ = EpnTapStage.vocabChecker(true, MESSENGER_VOCAB, FixedCode.E_PNMG, FixedCode.W_VCPD);
        colMap.get((Object)"time_scale").checker_ = EpnTapStage.vocabChecker(true, VocabChecker.TIMESCALE, FixedCode.W_PNTS, FixedCode.W_VCPD);
        return colMap.values().toArray(new EpnCol[0]);
    }

    private static EpnCol[] createExtensionColumns() {
        Map<String, EpnCol> colMap = EpnTapStage.toEpnColMap(new EpnCol[]{EpnTapStage.textCol("obs_mode", "meta.code;instr.setup"), EpnTapStage.textCol("detector_name", "meta.id;instr.det"), EpnTapStage.textCol("opt_elem", "meta.id;instr.param"), EpnTapStage.textCol("filter", "meta.id;instr.filter"), EpnTapStage.textCol("instrument_type", "meta.id;instr"), EpnTapStage.textCol("acquisition_id", "meta.id"), EpnTapStage.textCol("proposal_id", "meta.id;obs.proposal"), EpnTapStage.textCol("proposal_pi", "meta.id.PI;obs.proposal"), EpnTapStage.textCol("proposal_title", "meta.title;obs.proposal"), EpnTapStage.textCol("campaign", "meta.id;obs.proposal"), EpnTapStage.textCol("target_description", "meta.note;src"), EpnTapStage.textCol("proposal_target_name", "meta.note;obs.proposal"), new SingleCol("target_apparent_radius", Type.DOUBLE, "arcsec", "phys.angSize;src"), new SingleCol("north_pole_position", Type.DOUBLE, "deg", "pos.posAng"), EpnTapStage.textCol("target_primary_hemisphere", "meta.id;obs.field"), EpnTapStage.textCol("target_secondary_hemisphere", "meta.id;obs.field"), new SingleCol("platesc", Type.DOUBLE, "arcsec/pix", "instr.scale"), new SingleCol("orientation", Type.DOUBLE, "deg", "pos.posAng"), EpnTapStage.textCol("measurement_unit", "meta.unit"), EpnTapStage.textCol("observer_name", "meta.id.PI;obs.observer"), EpnTapStage.textCol("observer_institute", "meta.note"), new SingleCol("observer_id", Type.INTEGER, null, "meta.id.PI"), EpnTapStage.textCol("observer_code", "meta.id.PI"), EpnTapStage.textCol("observer_country", "meta.note;obs.observer"), EpnTapStage.textCol("observer_location", "pos;obs.observer"), new SingleCol("observer_lon", Type.DOUBLE, "deg", "obs.observer;pos.earth.lon"), new SingleCol("observer_lat", Type.DOUBLE, "deg", "obs.observer;pos.earth.lat"), new SingleCol("mass", Type.DOUBLE, "kg", "phys.mass"), new SingleCol("sidereal_rotation_period", Type.DOUBLE, "h", "time.period.rotation"), new SingleCol("mean_radius", Type.DOUBLE, "km", "phys.size.radius"), new SingleCol("equatorial_radius", Type.DOUBLE, "km", "phys.size.radius"), new SingleCol("polar_radius", Type.DOUBLE, "km", "phys.size.radius"), new SingleCol("diameter", Type.DOUBLE, "km", "phys.size.diameter"), new SingleCol("semi_major_axis", Type.DOUBLE, "AU", "phys.size.smajAxis"), new SingleCol("inclination", Type.DOUBLE, "deg", "src.orbital.inclination"), new SingleCol("eccentricity", Type.DOUBLE, null, "src.orbital.eccentricity"), new SingleCol("long_asc", Type.DOUBLE, "deg", "src.orbital.node"), new SingleCol("arg_perihel", Type.DOUBLE, "deg", "src.orbital.periastron"), new SingleCol("mean_anomaly", Type.DOUBLE, "deg", "src.orbital.meanAnomaly"), new SingleCol("epoch", Type.DOUBLE, "d", "time.epoch"), EpnTapStage.textCol("dynamical_class", "meta.code.class;src"), EpnTapStage.textCol("dynamical_type", "meta.code.class;src"), EpnTapStage.textCol("taxonomy_code", "src.class.color"), new SingleCol("magnitude", Type.DOUBLE, "mag", "phys.magAbs"), new SingleCol("flux", Type.DOUBLE, "mJy", "phot.flux.density"), new SingleCol("albedo", Type.DOUBLE, null, "phys.albedo"), EpnTapStage.textCol("map_projection", "pos.projection"), new SingleCol("map_height", Type.DOUBLE, "pix", "phys.size"), new SingleCol("map_width", Type.DOUBLE, "pix", "phys.size"), EpnTapStage.textCol("map_scale", "pos.wcs.scale"), new MinMaxCol("pixelscale_", Type.DOUBLE, "km/pix", EpnTapStage.minMaxStats("instr.scale")), EpnTapStage.textCol("particle_spectral_type", "meta.id;phys.particle"), new MinMaxCol("particle_spectral_range_", Type.DOUBLE, null, null), new MinMaxCol("particle_spectral_sampling_step_", Type.DOUBLE, null, EpnTapStage.minMaxStats("spect.resolution;phys.particle")), new MinMaxCol("particle_spectral_resolution_", Type.DOUBLE, null, EpnTapStage.minMaxStats("spect.resolution;phys.particle")), EpnTapStage.textCol("original_publisher", "meta.note"), EpnTapStage.textCol("producer_name", "meta.note"), EpnTapStage.textCol("producer_institute", "meta.note"), EpnTapStage.textCol("sample_id", "meta.id;src"), EpnTapStage.textCol("sample_classification", "meta.note;phys.composition"), EpnTapStage.textCol("sample_desc", "meta.note"), EpnTapStage.textCol("species_inchikey", "meta.id;phys.atmol"), EpnTapStage.textCol("data_calibration_desc", "meta.note"), EpnTapStage.textCol("setup_desc", "meta.note"), EpnTapStage.textCol("geometry_type", "meta.note;instr.setup"), EpnTapStage.textCol("spectrum_type", "meta.note;instr.setup"), new MinMaxCol("grain_size_", Type.DOUBLE, "um", EpnTapStage.minMaxStats("phys.size")), new MinMaxCol("azimuth_", Type.DOUBLE, "deg", EpnTapStage.minMaxStats("pos.azimuth")), new SingleCol("pressure", Type.DOUBLE, "bar", "phys.pressure"), EpnTapStage.textCol("measurement_atmosphere", "meta.note;phys.pressure"), new SingleCol("temperature", Type.DOUBLE, "K", "phys.temperature"), EpnTapStage.textCol("event_type", "meta.code.class"), EpnTapStage.textCol("event_status", "meta.code.status"), EpnTapStage.textCol("event_cite", "meta.code.status")});
        ((MinMaxCol)colMap.get((Object)"azimuth_")).couldBeLongitude_ = true;
        colMap.get((Object)"epoch").checker_ = EpnTapStage.jdChecker();
        colMap.get((Object)"geometry_type").checker_ = EpnTapStage.hashlistOptionsChecker(true, FixedCode.E_PNGT, new String[]{"direct", "specular", "bidirectional", "directional-conical", "conical-directional", "biconical", "directional-hemispherical", "conical-hemispherical", "hemispherical-directional", "hemispherical-conical", "bihemispherical", "directional", "conical", "hemispherical", "other geometry", "unknown"});
        colMap.get((Object)"species_inchikey").checker_ = EpnTapStage.inchikeyListChecker();
        colMap.get((Object)"particle_spectral_type").checker_ = EpnTapStage.optionsChecker(true, FixedCode.E_PPST, new String[]{"energy", "mass", "mass/charge"});
        return colMap.values().toArray(new EpnCol[0]);
    }

    static String toMinUcd(String ucd) {
        return ucd == null ? null : ucd + ";stat.min";
    }

    static String toMaxUcd(String ucd) {
        return ucd == null ? null : ucd + ";stat.max";
    }

    private static SingleCol textCol(String name, String ucd) {
        return new SingleCol(name, Type.TEXT, null, ucd);
    }

    private static String2 minMaxStats(String base) {
        return new String2(EpnTapStage.toMinUcd(base), EpnTapStage.toMaxUcd(base));
    }

    private static ContentChecker notNullChecker() {
        return (stdCol, runner) -> {
            String cname = stdCol.name_;
            String tname = runner.tname_;
            String adql = new StringBuffer().append("SELECT ").append("TOP 1 ").append(cname).append(" FROM ").append(tname).append(" WHERE ").append(cname).append(" IS NULL").toString();
            TableData tdata = runner.runQuery(adql);
            if (tdata != null && tdata.getRowCount() > 0) {
                String msg = new StringBuffer().append("NULL values in ").append(tname).append(" non-nullable column ").append(cname).toString();
                runner.reporter_.report(FixedCode.E_PNUL, msg);
            }
        };
    }

    private static ContentChecker optionsChecker(boolean isNullable, ReportCode failCode, String[] opts) {
        return (stdCol, runner) -> {
            TableData tdata;
            String cname = stdCol.name_;
            String tname = runner.tname_;
            StringBuffer abuf = new StringBuffer().append("SELECT TOP 1 ").append(cname).append(" FROM ").append(tname).append(" WHERE ").append(cname).append(" NOT IN (").append(Arrays.stream(opts).map(s -> "'" + s + "'").collect(Collectors.joining(", "))).append(")");
            if (!isNullable) {
                abuf.append(" OR ").append(cname).append(" IS NULL");
            }
            if ((tdata = runner.runQuery(abuf.toString())) != null && tdata.getRowCount() > 0) {
                Object badValue = tdata.getCell(0, 0);
                StringBuffer mbuf = new StringBuffer();
                if (!isNullable && badValue == null) {
                    mbuf.append("NULL value in ").append(tname).append(" non-nullable");
                } else {
                    mbuf.append("Illegal value \"").append(badValue).append("\" in ").append(tname);
                }
                String msg = mbuf.append(" column ").append(cname).append("; legal values are ").append(Arrays.toString(opts)).toString();
                runner.reporter_.report(failCode, mbuf.toString());
            }
        };
    }

    private static ContentChecker hashlistOptionsChecker(boolean isNullable, ReportCode failCode, String[] opts) {
        return (stdCol, runner) -> {
            String cname = stdCol.name_;
            String tname = runner.tname_;
            String adql = new StringBuffer().append("SELECT DISTINCT TOP 30 ").append(cname).append(" FROM ").append(tname).toString();
            TableData tdata = runner.runQuery(adql);
            LinkedHashSet<String> gotSet = new LinkedHashSet<String>();
            if (tdata != null && tdata.getRowCount() > 0) {
                for (Object val : tdata.getColumn(0)) {
                    if (val == null || "".equals(val)) {
                        gotSet.add(null);
                        continue;
                    }
                    if (!(val instanceof String)) continue;
                    String sval = (String)val;
                    gotSet.addAll(Arrays.asList(sval.split("#", -1)));
                }
            }
            boolean hasNull = gotSet.remove("") | gotSet.remove(null);
            gotSet.removeAll(Arrays.asList(opts));
            if (hasNull && !isNullable) {
                String msg = new StringBuffer().append("NULL values in ").append(tname).append(" non-nullable column ").append(cname).toString();
                runner.reporter_.report(FixedCode.E_PNUL, msg);
            }
            if (gotSet.size() > 0) {
                String msg = new StringBuffer().append("Illegal items in ").append(tname).append(" hashlist column ").append(cname).append(" ").append(gotSet).append("; legal values are ").append(Arrays.toString(opts)).toString();
                runner.reporter_.report(failCode, msg);
            }
        };
    }

    private static ContentChecker rangeChecker(boolean isNullable, ReportCode failCode, String loLimit, String hiLimit) {
        return (stdCol, runner) -> {
            TableData tdata;
            String cname = stdCol.name_;
            String tname = runner.tname_;
            StringBuffer abuf = new StringBuffer().append("SELECT TOP 1 ").append(cname).append(" FROM ").append(tname).append(" WHERE ").append("(NOT ").append(cname).append(" BETWEEN ").append(loLimit).append(" AND ").append(hiLimit).append(")");
            if (!isNullable) {
                abuf.append(" OR (").append(cname).append(" IS NULL)");
            }
            if ((tdata = runner.runQuery(abuf.toString())) != null && tdata.getRowCount() > 0) {
                Object badValue = tdata.getCell(0, 0);
                StringBuffer mbuf = new StringBuffer();
                if (!isNullable && badValue == null) {
                    mbuf.append("NULL value for non-nullable ");
                } else {
                    mbuf.append("Value ").append(badValue).append(" out of range ").append(loLimit).append("...").append(hiLimit).append(" in ");
                }
                mbuf.append(tname).append(" column ").append(cname);
                runner.reporter_.report(failCode, mbuf.toString());
            }
        };
    }

    private static ContentChecker vocabChecker(boolean isNullable, VocabChecker vChecker, ReportCode errorCode, ReportCode flagCode) {
        return (stdCol, runner) -> {
            String cname = stdCol.name_;
            String tname = runner.tname_;
            String adql = new StringBuffer().append("SELECT DISTINCT TOP 10 ").append(cname).append(" FROM ").append(tname).append(" WHERE ").append(cname).append(isNullable ? " IS NOT NULL AND " : " IS NULL OR ").append(cname).append(" NOT IN (").append(vChecker.getFixedTerms().stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "))).append(")").toString();
            TableData tdata = runner.runQuery(adql);
            if (tdata != null && tdata.getRowCount() > 0) {
                String msg;
                Object[] values = tdata.getColumn(0);
                boolean hasNull = false;
                TreeSet<String> prelims = new TreeSet<String>();
                TreeSet<String> deprecs = new TreeSet<String>();
                TreeSet<String> unknowns = new TreeSet<String>();
                URL vocabUrl = vChecker.getVocabularyUrl();
                Map<String, VocabTerm> termMap = vChecker.getRetrievedTerms();
                for (Object value : values) {
                    VocabTerm term = termMap.get(value);
                    if (value == null) {
                        hasNull = true;
                        continue;
                    }
                    if (term == null) {
                        unknowns.add(value.toString());
                        continue;
                    }
                    if (term.isPreliminary()) {
                        prelims.add(value.toString());
                        continue;
                    }
                    if (!term.isDeprecated()) continue;
                    deprecs.add(value.toString());
                }
                if (!isNullable && hasNull) {
                    msg = new StringBuffer().append("NULL values in ").append(tname).append(" non-nullable column ").append(cname).toString();
                    runner.reporter_.report(errorCode, msg);
                }
                if (unknowns.size() > 0) {
                    msg = new StringBuffer().append("Unknown values ").append(unknowns).append(" in ").append(tname).append(" column ").append(cname).append(" not in vocabulary ").append(vocabUrl).append("; options are ").append(termMap.keySet()).toString();
                    runner.reporter_.report(errorCode, msg);
                }
                if (deprecs.size() > 0) {
                    msg = new StringBuffer().append("Terms ").append(deprecs).append(" in ").append(tname).append(" column ").append(cname).append(" are deprecated in vocabulary ").append(vocabUrl).toString();
                    runner.reporter_.report(flagCode, msg);
                } else if (prelims.size() > 0) {
                    msg = new StringBuffer().append("Terms ").append(prelims).append(" in ").append(tname).append(" column ").append(cname).append(" are flagged preliminary in vocabulary ").append(vocabUrl).toString();
                    runner.reporter_.report(flagCode, msg);
                }
            }
        };
    }

    private static ContentChecker timestampChecker(boolean isNullable) {
        return (stdCol, runner) -> {
            TableData tdata;
            String cname = stdCol.name_;
            String tname = runner.tname_;
            StringBuffer abuf = new StringBuffer().append("SELECT DISTINCT TOP 10 ").append(cname).append(" FROM ").append(tname);
            if (isNullable) {
                abuf.append(" WHERE ").append(cname).append(" IS NOT NULL");
            }
            if ((tdata = runner.runQuery(abuf.toString())) != null && tdata.getRowCount() > 0) {
                Object[] values;
                for (Object val : values = tdata.getColumn(0)) {
                    if (val == null || "".equals(val)) {
                        if (isNullable) continue;
                        String msg = new StringBuffer().append("NULL values in ").append(tname).append(" non-nullable column ").append(cname).toString();
                        runner.reporter_.report(FixedCode.E_PNUL, msg);
                        continue;
                    }
                    String sval = (String)val;
                    if (DALI_TIMESTAMP_REGEX.matcher(sval).matches()) continue;
                    String msg = new StringBuffer().append("Timestamp value \"").append(sval).append("\" in ").append(tname).append(" column ").append(cname).append(" does not match ").append(" does not match ").append("YYYY-MM-DD['T'hh:mm:ss[.SSS]['Z']]").toString();
                    runner.reporter_.report(FixedCode.E_PN86, msg);
                    return;
                }
            }
        };
    }

    private static ContentChecker ucdChecker() {
        return (stdCol, runner) -> {
            String cname = stdCol.name_;
            String tname = runner.tname_;
            String adql = new StringBuffer().append("SELECT DISTINCT TOP 30 ").append(cname).append(" FROM ").append(tname).append(" WHERE ").append(cname).append(" IS NOT NULL").toString();
            TableData tdata = runner.runQuery(adql);
            if (tdata != null && tdata.getRowCount() > 0) {
                Object[] values;
                for (Object val : values = tdata.getColumn(0)) {
                    String sval = val instanceof String ? (String)val : null;
                    String badUcd = null;
                    UcdStatus badStatus = null;
                    if (sval != null && sval.trim().length() > 0) {
                        String[] items;
                        for (String item : items = sval.split("#", -1)) {
                            UcdStatus ustat = UcdStatus.getStatus((String)item);
                            if (ustat == null || ustat.getCode() == UcdStatus.Code.OK) continue;
                            badUcd = item;
                            badStatus = ustat;
                        }
                    }
                    if (badUcd == null) continue;
                    UcdStatus.Code ucode = badStatus.getCode();
                    String msg = new StringBuffer().append("Bad UCD \"").append(badUcd).append("\" in ").append(tname).append(" column ").append(cname).append(" (").append(ucode).append(": ").append(badStatus.getMessage()).append(")").toString();
                    FixedCode rcode = ucode.isError() ? FixedCode.E_PNMT : FixedCode.W_PNMT;
                    runner.reporter_.report(rcode, msg);
                }
            }
        };
    }

    private static ContentChecker inchikeyListChecker() {
        return (stdCol, runner) -> {
            String cname = stdCol.name_;
            String tname = runner.tname_;
            StringBuffer abuf = new StringBuffer().append("SELECT DISTINCT TOP 30 ").append(cname).append(" FROM ").append(tname).append(" WHERE ").append(cname).append(" IS NOT NULL");
            TableData tdata = runner.runQuery(abuf.toString());
            if (tdata != null && tdata.getRowCount() > 0) {
                Object[] values;
                for (Object val : values = tdata.getColumn(0)) {
                    String sval = val instanceof String ? (String)val : null;
                    String badInchi = null;
                    String errmsg = null;
                    if (sval != null && sval.trim().length() > 0) {
                        String[] items;
                        for (String item : items = sval.split("#", -1)) {
                            String err = EpnTapStage.inchikeyError(item);
                            if (err == null) continue;
                            badInchi = item;
                            errmsg = err;
                        }
                    }
                    if (badInchi == null) continue;
                    String msg = new StringBuffer().append("Bad InchiKey syntax (").append(errmsg).append(") in ").append(tname).append(" column ").append(cname).append(": \"").append(badInchi).append('\"').toString();
                    runner.reporter_.report(FixedCode.E_PNIK, msg);
                }
            }
        };
    }

    private static String inchikeyError(String txt) {
        int inchikeyLeng = 27;
        if (txt.length() != 27) {
            return "not 27 chars";
        }
        if (!txt.matches("^[-A-Z]*$")) {
            return "chars not matching [-A-Z]";
        }
        return null;
    }

    private static ContentChecker serviceTitleChecker() {
        return (stdCol, runner) -> {
            String cname = stdCol.name_;
            String tname = runner.tname_;
            if (tname.toLowerCase().endsWith(".epn_core")) {
                String schema = tname.substring(0, tname.length() - 1 - EPNCORE_TNAME.length());
                String adql = new StringBuffer().append("SELECT TOP 1 ").append(cname).append(" FROM ").append(tname).append(" WHERE ").append(cname).append(" != '").append(schema).append("'").append(" OR ").append(cname).append(" IS NULL").toString();
                TableData tdata = runner.runQuery(adql);
                if (tdata != null && tdata.getRowCount() > 0) {
                    Object badval = tdata.getCell(0, 0);
                    String badTxt = badval == null ? "NULL" : "\"" + badval + "\"";
                    String msg = new StringBuffer().append("Column ").append(cname).append(" in ").append(tname).append(" is not consistently equal to \"").append(schema).append("\" (e.g. ").append(badTxt).append(")").toString();
                    runner.reporter_.report(FixedCode.E_PNST, msg);
                }
            }
        };
    }

    private static ContentChecker sregionChecker() {
        return (stdCol, runner) -> {
            String cname = stdCol.name_;
            String tname = runner.tname_;
            String adql = new StringBuffer().append("SELECT TOP 1 ").append(cname).append(" FROM ").append(tname).append(" WHERE ").append(cname).append(" IS NOT NULL").toString();
            TableData tdata = runner.runQuery(adql);
            if (tdata != null && tdata.getRowCount() > 0) {
                List<String> arrayXtypes;
                ColumnInfo info = tdata.getTable().getColumnInfo(0);
                Class clazz = info.getContentClass();
                String xtype = info.getXtype();
                String reqXtype = "adql:REGION";
                if (String.class.equals((Object)clazz)) {
                    if (!reqXtype.equals(xtype)) {
                        String msg = new StringBuffer().append("Table ").append(tname).append(" column ").append(cname).append(" has wrong xtype for string datatype: ").append(xtype).append(" != ").append(reqXtype).toString();
                        runner.reporter_.report(FixedCode.E_SRXT, msg);
                    }
                } else if ((float[].class.equals((Object)clazz) || double[].class.equals((Object)clazz)) && !(arrayXtypes = Arrays.asList("point", "circle", "polygon")).contains(xtype)) {
                    String msg = new StringBuffer().append("Table ").append(tname).append(" column ").append(cname).append(" has wrong datatype \"").append(xtype).append("\"; should be one of ").append(arrayXtypes).toString();
                    runner.reporter_.report(FixedCode.E_SRXT, msg);
                }
            }
        };
    }

    private static ContentChecker jdChecker() {
        return (stdCol, runner) -> {
            Object badValue;
            String cname = stdCol.name_;
            String tname = runner.tname_;
            String adql = new StringBuffer().append("SELECT TOP 1 ").append(cname).append(" FROM ").append(tname).append(" WHERE NOT ").append(cname).append(" BETWEEN ").append(2086000).append(" AND ").append(2817000).toString();
            TableData tdata = runner.runQuery(adql);
            if (tdata != null && tdata.getRowCount() > 0 && (badValue = tdata.getCell(0, 0)) != null) {
                double dval;
                StringBuffer mbuf = new StringBuffer().append("Value ").append(badValue).append(" in JD ").append(tname).append(" column ").append(cname).append(" is in distant past/future");
                double d = dval = badValue instanceof Number ? ((Number)badValue).doubleValue() : Double.NaN;
                if (!Double.isInfinite(dval) && !Double.isNaN(dval)) {
                    mbuf.append(" (").append(Times.mjdToIso(Times.jdToMjd(dval))).append(")");
                }
                mbuf.append("; are you sure it's in Julian Days?").toString();
                runner.reporter_.report(FixedCode.W_PNJD, mbuf.toString());
            }
        };
    }

    public static void main(String[] args) {
        System.out.println("# name type unit ucd");
        UnaryOperator fmter = s -> s == null || s.length() == 0 ? "''" : s;
        for (SingleCol col : EpnTapStage.toSingleCols(EpnTapStage.getAllColumns())) {
            System.out.println(col.name_ + " " + col.type_.toString() + " " + (String)fmter.apply(col.unit_) + " " + (String)fmter.apply(col.ucd_));
        }
    }

    private static class MinMaxCol
    extends EpnCol {
        final String2 names_;
        final String2 ucds_;
        boolean couldBeLongitude_;

        MinMaxCol(String baseName, Type type, String unit, String2 ucds) {
            super(baseName, type, unit);
            this.names_ = new String2(baseName + "min", baseName + "max");
            this.ucds_ = ucds == null ? new String2(null, null) : ucds;
        }

        SingleCol minCol() {
            SingleCol minCol = new SingleCol(this.names_.min_, this.type_, this.unit_, this.ucds_.min_);
            minCol.checker_ = this.checker_;
            return minCol;
        }

        SingleCol maxCol() {
            SingleCol maxCol = new SingleCol(this.names_.max_, this.type_, this.unit_, this.ucds_.max_);
            maxCol.checker_ = this.checker_;
            return maxCol;
        }
    }

    static class SingleCol
    extends EpnCol {
        final String name_;
        final String ucd_;

        SingleCol(String name, Type type, String unit, String ucd) {
            super(name, type, unit);
            this.name_ = name;
            this.ucd_ = ucd;
        }
    }

    static abstract class EpnCol {
        final String id_;
        final Type type_;
        final String unit_;
        ContentChecker checker_;

        EpnCol(String id, Type type, String unit) {
            this.id_ = id;
            this.type_ = type;
            this.unit_ = unit;
        }
    }

    private static class String2 {
        final String min_;
        final String max_;

        String2(String min, String max) {
            this.min_ = min;
            this.max_ = max;
        }
    }

    @FunctionalInterface
    private static interface ContentChecker {
        public void checkContent(SingleCol var1, EpncoreRunner var2);
    }

    static enum FrameType {
        CELESTIAL(new String[]{"pos.eq.ra", "pos.eq.dec", "pos.distance"}, new String[]{"deg", "deg", "AU"}, new boolean[]{true, true, false}),
        BODY(new String[][]{{"pos.bodyrc.lon"}, {"pos.bodyrc.lat"}, {"pos.bodyrc.alt"}}, new String[]{"deg", "deg", "km"}, new boolean[]{true, true, false}),
        CARTESIAN(new String[]{"pos.cartesian.x", "pos.cartesian.y", "pos.cartesian.z"}, new String[]{"km", "km", "km"}, new boolean[]{false, false, false}),
        SPHERICAL(new String[]{"pos.spherical.r", "pos.spherical.colat", "pos.spherical.azi"}, new String[]{"m", "deg", "deg"}, new boolean[]{false, true, true}),
        CYLINDRICAL(new String[]{"pos.cylindrical.r", "pos.cylindrical.azi", "pos.cylindrical.z"}, new String[]{"km", "deg", "km"}, new boolean[]{false, true, false});

        final String[][] ucds_;
        final String[] units_;
        final boolean[] isAngular_;
        static final Map<String, FrameType> NAME_MAP;

        private FrameType(String[][] ucds, String[] units, boolean[] isAngular) {
            this.ucds_ = ucds;
            this.units_ = units;
            this.isAngular_ = isAngular;
        }

        private FrameType(String[] ucds, String[] units, boolean[] isAngular) {
            this(new String[][]{{ucds[0]}, {ucds[1]}, {ucds[2]}}, units, isAngular);
        }

        String resolUcd(int idim0) {
            return this.isAngular_[idim0] ? "pos.angResolution" : "pos.resolution";
        }

        static {
            NAME_MAP = Arrays.stream(FrameType.values()).collect(Collectors.toMap(f -> f.toString().toLowerCase(), f -> f));
        }
    }

    private static enum Type {
        INTEGER{

            @Override
            void checkInfo(Reporter reporter, TableMeta tmeta, ValueInfo info) {
                Class clazz = info.getContentClass();
                if (!(clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Integer.class) || clazz.equals(Long.class))) {
                    Type.reportTypeMismatch(reporter, tmeta, info, ObsLocStage.votype(info) + " not integer");
                }
            }
        }
        ,
        DOUBLE{

            @Override
            void checkInfo(Reporter reporter, TableMeta tmeta, ValueInfo info) {
                Class clazz = info.getContentClass();
                if (!clazz.equals(Double.class) && !clazz.equals(Float.class)) {
                    Type.reportTypeMismatch(reporter, tmeta, info, ObsLocStage.votype(info) + " not floating point");
                }
            }
        }
        ,
        TEXT{

            @Override
            void checkInfo(Reporter reporter, TableMeta tmeta, ValueInfo info) {
                if (!String.class.equals((Object)info.getContentClass())) {
                    Type.reportTypeMismatch(reporter, tmeta, info, ObsLocStage.votype(info) + " not Text");
                }
            }
        }
        ,
        TEXT_MOC{

            @Override
            void checkInfo(Reporter reporter, TableMeta tmeta, ValueInfo info) {
                if (!String.class.equals((Object)info.getContentClass())) {
                    Type.reportTypeMismatch(reporter, tmeta, info, ObsLocStage.votype(info) + " not Text");
                } else {
                    Type.checkXtype(reporter, tmeta, info, "moc");
                }
            }
        }
        ,
        TIMESTAMP{

            @Override
            void checkInfo(Reporter reporter, TableMeta tmeta, ValueInfo info) {
                if (!String.class.equals((Object)info.getContentClass())) {
                    Type.reportTypeMismatch(reporter, tmeta, info, ObsLocStage.votype(info) + " not String - not Timestamp?");
                } else {
                    Type.checkXtype(reporter, tmeta, info, "timestamp");
                }
            }
        };


        abstract void checkInfo(Reporter var1, TableMeta var2, ValueInfo var3);

        private static void reportTypeMismatch(Reporter reporter, TableMeta tmeta, ValueInfo info, String txt) {
            String msg = new StringBuffer().append("Data type mismatch for ").append(tmeta.getName()).append(" column ").append(info.getName()).append(": ").append(txt).toString();
            reporter.report(FixedCode.E_PNDE, msg);
        }

        private static void checkXtype(Reporter reporter, TableMeta tmeta, ValueInfo info, String reqValue) {
            String xtype = info.getXtype();
            if (!reqValue.equals(xtype)) {
                String msg = new StringBuffer().append("Wrong xtype for ").append(tmeta.getName()).append(" column ").append(info.getName()).append(": ").append(xtype).append(" != \"").append(reqValue).append("\"").toString();
                reporter.report(FixedCode.E_PNXT, msg);
            }
        }
    }

    private static class EpncoreRunner
    implements Runnable {
        private final Reporter reporter_;
        private final TapService tapService_;
        private final TableMeta epnMeta_;
        private final TapRunner tapRunner_;
        private final String tname_;
        private final Map<String, ColumnMeta> gotCols_;

        EpncoreRunner(Reporter reporter, TapService tapService, TableMeta epnMeta, TapRunner tapRunner) {
            this.reporter_ = reporter;
            this.tapService_ = tapService;
            this.epnMeta_ = epnMeta;
            this.tapRunner_ = tapRunner;
            this.tname_ = epnMeta.getName();
            this.gotCols_ = ObsTapStage.toMap(epnMeta.getColumns());
        }

        @Override
        public void run() {
            ColumnInfo[] cinfos;
            SingleCol[] reqCols;
            ArrayList<Object> presentCols = new ArrayList<Object>();
            ArrayList<ColumnMeta> customCols = new ArrayList<ColumnMeta>(this.gotCols_.values());
            int nreq = 0;
            for (SingleCol reqCol : reqCols = EpnTapStage.toSingleCols(EpnTapStage.createMandatoryColumns())) {
                String cname = reqCol.name_;
                ColumnMeta gotCol = this.gotCols_.get(cname);
                if (gotCol != null) {
                    ++nreq;
                    presentCols.add(reqCol);
                    customCols.remove(gotCol);
                    this.checkMetadata(gotCol, reqCol);
                    continue;
                }
                String msg = new StringBuffer().append("Missing epn_core required column ").append(cname).append(" from table ").append(this.tname_).toString();
                this.reporter_.report(FixedCode.E_PN0C, msg);
            }
            LinkedHashMap<String, SingleCol> optMap = new LinkedHashMap<String, SingleCol>();
            for (SingleCol col : EpnTapStage.toSingleCols(EpnTapStage.getNonMandatoryColumns())) {
                optMap.put(col.name_, col);
            }
            int nopt = 0;
            for (ColumnMeta gotCol : this.epnMeta_.getColumns()) {
                String cname = gotCol.getName();
                ColumnInfo[] stdCol = (ColumnInfo[])optMap.get(cname.toLowerCase());
                if (stdCol == null) continue;
                ++nopt;
                presentCols.add(stdCol);
                customCols.remove(gotCol);
                this.checkMetadata(gotCol, (SingleCol)stdCol);
            }
            HashMap<String, SingleCol> stdColMap = new HashMap<String, SingleCol>();
            stdColMap.putAll(optMap);
            for (SingleCol reqCol : reqCols) {
                stdColMap.put(reqCol.name_, reqCol);
            }
            String adql1 = "SELECT TOP 1 * FROM " + this.tname_;
            TapQuery tq1 = new TapQuery(this.tapService_, adql1, null);
            StarTable table1 = this.tapRunner_.getResultTable(this.reporter_, tq1);
            for (ColumnInfo cinfo : cinfos = table1 == null ? new ColumnInfo[]{} : Tables.getColumnInfos((StarTable)table1)) {
                String cname = cinfo.getName();
                SingleCol singleCol = (SingleCol)stdColMap.get(cname.toLowerCase());
                if (singleCol == null) continue;
                singleCol.type_.checkInfo(this.reporter_, this.epnMeta_, (ValueInfo)cinfo);
            }
            int nCustom = customCols.size();
            if (nCustom > 0) {
                String msg = new StringBuffer().append(nCustom).append(nCustom == 1 ? " non-standard column in table " : " non-standard columns in table ").append(this.tname_).append(" ").append(customCols).toString();
                this.reporter_.report(FixedCode.I_PNNS, msg);
            }
            ArrayList<MinMaxCol> mmCols = new ArrayList<MinMaxCol>();
            for (EpnCol epnCol : EpnTapStage.getAllColumns()) {
                if (!(epnCol instanceof MinMaxCol)) continue;
                mmCols.add((MinMaxCol)epnCol);
            }
            for (MinMaxCol mmCol : mmCols) {
                TableData tdata;
                boolean hasMax;
                String minName = mmCol.names_.min_;
                String string = mmCol.names_.max_;
                boolean hasMin = this.gotCols_.get(minName) != null;
                boolean bl = hasMax = this.gotCols_.get(string) != null;
                if (hasMin != hasMax) {
                    String msg = new StringBuffer().append("Table ").append(this.tname_).append(" has one but not both of ").append(minName).append(", ").append(string).toString();
                    this.reporter_.report(FixedCode.E_PNMX, msg);
                    continue;
                }
                if (!hasMin || !hasMax) continue;
                StringBuffer abuf = new StringBuffer().append("SELECT TOP 1 ").append(this.gotCols_.containsKey("granule_uid") ? "granule_uid, " : "-1 AS dummy_uid, ").append(minName).append(", ").append(string).append(" FROM ").append(this.tname_).append(" WHERE (").append(minName).append(" IS NULL AND ").append(string).append(" IS NOT NULL) OR (").append(minName).append(" IS NOT NULL AND ").append(string).append(" IS NULL)");
                if (!mmCol.couldBeLongitude_) {
                    abuf.append(" OR (").append(minName).append(" > ").append(string).append(")");
                }
                if ((tdata = this.runQuery(abuf.toString())) == null || tdata.getRowCount() <= 0) continue;
                String msg = new StringBuffer().append("Min/Max constraints violated for ").append(this.tname_).append(" columns (").append(minName).append(", ").append(string).append("): (").append(tdata.getCell(0, 1)).append(", ").append(tdata.getCell(0, 2)).append(") at granule_id ").append(tdata.getCell(0, 0)).toString();
                this.reporter_.report(FixedCode.E_PNMM, msg);
            }
            String ftypeAdql = new StringBuffer().append("SELECT DISTINCT TOP 2 spatial_frame_type FROM ").append(this.tname_).append(" WHERE spatial_frame_type IS NOT NULL").toString();
            TableData ftypeData = this.runQuery(ftypeAdql);
            if (ftypeData != null && ftypeData.getRowCount() == 1) {
                FrameType frameType;
                Object ftypeName = ftypeData.getCell(0, 0);
                FrameType frameType2 = frameType = ftypeName instanceof String ? FrameType.NAME_MAP.get(((String)ftypeName).toLowerCase()) : null;
                if (frameType != null) {
                    String msg = "Checking coordinate metadata for spatial_frame_type=" + frameType.toString().toLowerCase();
                    this.reporter_.report(FixedCode.I_PNSP, msg);
                    this.checkSpatialMeta(frameType);
                }
            }
            for (SingleCol singleCol : presentCols) {
                ContentChecker checker = singleCol.checker_;
                if (checker == null) continue;
                checker.checkContent(singleCol, this);
            }
            int nother = this.gotCols_.size() - nreq - nopt;
            String string = new StringBuffer().append(this.tname_).append(" has ").append(nreq).append("/").append(reqCols.length).append(" EPN-TAP required, ").append(nopt).append(" EPN-TAP standard, and ").append(nother).append(" custom columns").toString();
            this.reporter_.report(FixedCode.S_PNCS, string);
        }

        private TableData runQuery(CharSequence adql) {
            TapQuery tq = new TapQuery(this.tapService_, adql.toString(), null);
            StarTable table = this.tapRunner_.getResultTable(this.reporter_, tq);
            return TableData.createTableData(this.reporter_, table);
        }

        private void checkMetadata(ColumnMeta gotCol, SingleCol stdCol) {
            String cname = gotCol.getName();
            if (stdCol.ucd_ != null) {
                this.compareItem(cname, "UCD", FixedCode.E_CUCD, stdCol.ucd_, gotCol.getUcd());
            }
            if (stdCol.unit_ != null) {
                this.compareItem(cname, "Unit", FixedCode.E_CUNI, stdCol.unit_, gotCol.getUnit());
            }
        }

        private void compareItem(String colName, String itemName, ReportCode code, String stdValue, String gotValue) {
            String vStd;
            if (stdValue == null) {
                return;
            }
            if (stdValue.length() == 0 && (gotValue == null || gotValue.trim().length() == 0)) {
                return;
            }
            String vGot = gotValue == null || gotValue.trim().length() == 0 ? "null" : gotValue;
            String string = vStd = stdValue == null ? "null" : stdValue;
            if (!vGot.equals(vStd)) {
                String msg = new StringBuffer().append("Wrong ").append(itemName).append(" for ").append(this.tname_).append(" column ").append(colName).append(": \"").append(gotValue).append("\" != \"").append(stdValue).append("\"").toString();
                this.reporter_.report(code, msg);
            }
        }

        private void checkSpatialMeta(FrameType ftype) {
            Pattern ciRegex = Pattern.compile("c([123])(_resol_)?(min|max)");
            for (ColumnMeta cmeta : this.epnMeta_.getColumns()) {
                String[] stdUcds;
                String[] stringArray;
                String cname = cmeta.getName();
                String gotUcd = cmeta.getUcd();
                String gotUnit = cmeta.getUnit();
                Matcher matcher = ciRegex.matcher(cname.toLowerCase());
                if (!matcher.matches()) continue;
                int idim0 = Integer.parseInt(matcher.group(1)) - 1;
                boolean isResol = "_resol_".equalsIgnoreCase(matcher.group(2));
                boolean isMax = "max".equalsIgnoreCase(matcher.group(3));
                String stdUnit = ftype.units_[idim0];
                if (isResol) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = ftype.resolUcd(idim0);
                } else {
                    stringArray = stdUcds = ftype.ucds_[idim0];
                }
                if (stdUnit != null && !stdUnit.equals(gotUnit)) {
                    String msg = new StringBuffer().append("Coordinate unit mismatch: ").append(cname).append(" in table ").append(this.tname_).append(gotUnit == null ? " has no unit" : " has unit \"" + gotUnit + "\"").append("; for spatial_frame_type \"").append(ftype.toString().toLowerCase()).append("\" recommended unit is \"").append(stdUnit).append("\"").toString();
                    this.reporter_.report(FixedCode.W_SPUN, msg);
                }
                if (stdUcds == null) continue;
                List mmStdUcds = Arrays.stream(stdUcds).map(u -> isMax ? EpnTapStage.toMaxUcd(u) : EpnTapStage.toMinUcd(u)).map(String::toLowerCase).collect(Collectors.toList());
                if (gotUcd != null && mmStdUcds.contains(gotUcd.toLowerCase())) continue;
                StringBuffer mbuf = new StringBuffer().append("Coordinate UCD mismatch: ").append(cname).append(" in table ").append(this.tname_).append(gotUcd == null ? " has no UCD" : " has UCD \"" + gotUcd + "\"").append("; for spatial_frame_type \"").append(ftype.toString().toLowerCase()).append("\" recommended UCD");
                if (mmStdUcds.size() == 1) {
                    mbuf.append(" is \"").append((String)mmStdUcds.get(0)).append("\"");
                } else {
                    mbuf.append(" are \"").append(mmStdUcds);
                }
                this.reporter_.report(FixedCode.W_SPUC, mbuf.toString());
            }
        }
    }
}

