/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class IvoaSchemaResolver
implements LSResourceResolver {
    private final boolean nsUrlDflt_;
    private final Map<String, URL> schemaMap_;
    private final Set<String> resolvedNamespaces_;
    private final Set<String> unresolvedNamespaces_;
    public static final String VODATASERVICE_URI = "http://www.ivoa.net/xml/VODataService/v1.1";
    public static final String CAPABILITIES_URI = "http://www.ivoa.net/xml/VOSICapabilities/v1.0";
    public static final String AVAILABILITY_URI = "http://www.ivoa.net/xml/VOSIAvailability/v1.0";
    public static final String UWS_URI = "http://www.ivoa.net/xml/UWS/v1.0";
    public static final Map<String, URL> IVOA_SCHEMA_MAP = Collections.unmodifiableMap(IvoaSchemaResolver.createIvoaSchemaMap());
    public static final Map<String, URL> W3C_SCHEMA_MAP = Collections.unmodifiableMap(IvoaSchemaResolver.createW3cSchemaMap());
    private static final String SCHEMA_TYPE = "http://www.w3.org/2001/XMLSchema";
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.taplint");

    public IvoaSchemaResolver(Map<String, URL> schemaMap, boolean nsUrlDflt) {
        this.nsUrlDflt_ = nsUrlDflt;
        if (schemaMap == null) {
            schemaMap = new HashMap<String, URL>();
            schemaMap.putAll(W3C_SCHEMA_MAP);
            schemaMap.putAll(IVOA_SCHEMA_MAP);
        }
        this.schemaMap_ = schemaMap;
        this.resolvedNamespaces_ = new LinkedHashSet<String>();
        this.unresolvedNamespaces_ = new LinkedHashSet<String>();
    }

    public IvoaSchemaResolver(boolean nsUrlDflt) {
        this(null, nsUrlDflt);
    }

    public Map<String, URL> getSchemaMap() {
        return this.schemaMap_;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (SCHEMA_TYPE.equals(type) && namespaceURI != null) {
            URL location = this.schemaMap_.get(namespaceURI);
            if (location != null) {
                this.resolvedNamespaces_.add(namespaceURI);
                return new UrlInput(location);
            }
            if (systemId == null && this.nsUrlDflt_) {
                URL nsloc;
                try {
                    nsloc = new URI(namespaceURI).toURL();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    nsloc = null;
                    logger_.info("Namespace URI \"" + namespaceURI + "\" not a URL, can't use for systemId");
                }
                if (nsloc != null) {
                    this.resolvedNamespaces_.add(namespaceURI);
                    return new UrlInput(nsloc);
                }
            }
            this.unresolvedNamespaces_.add(namespaceURI);
            return null;
        }
        return null;
    }

    public Set<String> getResolvedNamespaces() {
        return this.resolvedNamespaces_;
    }

    public Set<String> getUnresolvedNamespaces() {
        return this.unresolvedNamespaces_;
    }

    private static URL getResource(String name) {
        return IvoaSchemaResolver.class.getResource(name);
    }

    private static Map<String, URL> createIvoaSchemaMap() {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put(VODATASERVICE_URI, IvoaSchemaResolver.getResource("VODataService-v1.2.xsd"));
        map.put(CAPABILITIES_URI, IvoaSchemaResolver.getResource("VOSICapabilities-v1.0.xsd"));
        map.put(AVAILABILITY_URI, IvoaSchemaResolver.getResource("VOSIAvailability-v1.0.xsd"));
        map.put(UWS_URI, IvoaSchemaResolver.getResource("UWS-v1.1.xsd"));
        map.put("http://www.ivoa.net/xml/VOSITables/v1.0", IvoaSchemaResolver.getResource("VOSITables-v1.1.xsd"));
        map.put("http://www.ivoa.net/xml/VOResource/v1.0", IvoaSchemaResolver.getResource("VOResource-v1.1.xsd"));
        map.put("http://www.ivoa.net/xml/TAPRegExt/v1.0", IvoaSchemaResolver.getResource("TAPRegExt-v1.0-Erratum1.xsd"));
        map.put("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", IvoaSchemaResolver.getResource("stc-v1.30.xsd"));
        map.put("http://www.ivoa.net/xml/VODataService/v1.0", IvoaSchemaResolver.getResource("VODataService-v1.0.xsd"));
        return map;
    }

    private static Map<String, URL> createW3cSchemaMap() {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("http://www.w3.org/1999/xlink", IvoaSchemaResolver.getResource("xlink.xsd"));
        map.put(SCHEMA_TYPE, IvoaSchemaResolver.getResource("XMLSchema.xsd"));
        map.put("http://www.w3.org/XML/1998/namespace", IvoaSchemaResolver.getResource("xmlnamespace.xsd"));
        return map;
    }

    private static class UrlInput
    implements LSInput {
        private final URL url_;

        public UrlInput(URL url) {
            this.url_ = url;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setStringData(String stringData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSystemId() {
            return this.url_.toString();
        }

        @Override
        public void setSystemId(String systemId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public void setPublicId(String publicId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            throw new UnsupportedOperationException();
        }
    }
}

