/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import uk.ac.starlink.auth.AuthManager;
import uk.ac.starlink.auth.Redirector;
import uk.ac.starlink.auth.UrlConnector;
import uk.ac.starlink.ttools.taplint.ContentTypeOptions;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.XsdValidation;
import uk.ac.starlink.util.ByteList;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.util.ContentType;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.UwsJob;
import uk.ac.starlink.vo.UwsJobInfo;
import uk.ac.starlink.vo.UwsStage;

public class JobStage
implements Stage {
    private final MetadataHolder metaHolder_;
    private final long pollMillis_;
    private static final ContentTypeOptions CTYPE_PLAIN = new ContentTypeOptions(new ContentType[]{new ContentType("text", "plain")});
    private static final ContentTypeOptions CTYPE_XML = new ContentTypeOptions(new ContentType[]{new ContentType("text", "xml"), new ContentType("application", "xml")});

    public JobStage(MetadataHolder metaHolder, long pollMillis) {
        this.metaHolder_ = metaHolder;
        this.pollMillis_ = pollMillis;
    }

    @Override
    public String getDescription() {
        return "Test asynchronous UWS/TAP behaviour";
    }

    @Override
    public void run(Reporter reporter, TapService tapService) {
        SchemaMeta[] smetas = this.metaHolder_.getTableMetadata();
        TableMeta tmeta = this.getFirstTable(this.metaHolder_.getTableMetadata());
        if (tmeta == null) {
            reporter.report(FixedCode.F_NOTM, "No table metadata available (earlier stages failed/skipped?  - will not attempt UWS tests");
            return;
        }
        new UwsRunner(reporter, tapService, tmeta, this.pollMillis_).run();
    }

    private TableMeta getFirstTable(SchemaMeta[] smetas) {
        if (smetas != null) {
            SchemaMeta[] schemaMetaArray = smetas;
            int n = schemaMetaArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = 0;
                SchemaMeta smeta = schemaMetaArray[i];
                TableMeta[] tableMetaArray = smeta.getTables();
                int n3 = tableMetaArray.length;
                if (n2 >= n3) continue;
                TableMeta tmeta = tableMetaArray[n2];
                return tmeta;
            }
        }
        return null;
    }

    private static enum UwsVersion {
        V10("V1.0", false, "[T ]", false),
        V11("V1.1", true, "T", true);

        final String name_;
        final boolean quoteIsIso8601_;
        final boolean requireZ_;
        final Pattern iso8601Regex_;

        private UwsVersion(String name, boolean quoteIsIso8601, String dateSep, boolean requireZ) {
            this.name_ = name;
            this.quoteIsIso8601_ = quoteIsIso8601;
            this.requireZ_ = requireZ;
            this.iso8601Regex_ = Pattern.compile("([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])" + dateSep + "(([01][0-9]|2[0-3])(:[0-5][0-9](:[0-5][0-9]([.][0-9]*)?)?)?)?" + (requireZ ? "Z" : "Z?"));
        }

        public String toString() {
            return this.name_;
        }
    }

    private static class UwsRunner
    implements Runnable {
        private final Reporter reporter_;
        private final TapService tapService_;
        private final TableMeta tmeta_;
        private final long poll_;
        private final String shortAdql_;
        private final String runId1_;
        private final String runId2_;

        UwsRunner(Reporter reporter, TapService tapService, TableMeta tmeta, long poll) {
            this.reporter_ = reporter;
            this.tapService_ = tapService;
            this.tmeta_ = tmeta;
            this.poll_ = poll;
            this.shortAdql_ = "SELECT TOP 100 * FROM " + tmeta.getName();
            this.runId1_ = "TAPLINT-001";
            this.runId2_ = "TAPLINT-002";
        }

        @Override
        public void run() {
            this.checkCreateAbortDelete(this.shortAdql_);
            this.checkCreateDelete(this.shortAdql_);
            this.checkCreateRun(this.shortAdql_);
        }

        private void checkCreateAbortDelete(String adql) {
            UwsJob job = this.createJob(adql);
            if (job == null) {
                return;
            }
            URL jobUrl = job.getJobUrl();
            this.checkPhase(job, "PENDING");
            if (!this.tapService_.getTapVersion().is11()) {
                this.checkParameter(job, "REQUEST", "doQuery", true);
            }
            this.checkParameter(job, "RUNID", this.runId1_, false);
            if (this.postParameter(job, "runId", this.runId2_)) {
                this.checkParameter(job, "RUNID", this.runId2_, false);
            }
            if (this.postPhase(job, "ABORT")) {
                this.checkPhase(job, "ABORTED");
            }
            if (this.postKeyValue(job, "", "ACTION", "DELETE")) {
                this.checkDeleted(job);
            }
        }

        private void checkCreateDelete(String adql) {
            int response;
            URLConnection conn;
            UwsJob job = this.createJob(adql);
            if (job == null) {
                return;
            }
            URL jobUrl = job.getJobUrl();
            this.checkPhase(job, "PENDING");
            UrlConnector delConnector = hconn -> {
                hconn.setRequestMethod("DELETE");
                hconn.setInstanceFollowRedirects(false);
                hconn.connect();
            };
            try {
                conn = AuthManager.getInstance().connect(jobUrl, delConnector, Redirector.NO_REDIRECT);
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_HTDE, "Failed to perform HTTP DELETE to " + jobUrl, e);
                return;
            }
            if (!(conn instanceof HttpURLConnection)) {
                this.reporter_.report(FixedCode.E_NOHT, "Job url " + jobUrl + " not HTTP?");
                return;
            }
            HttpURLConnection hconn2 = (HttpURLConnection)conn;
            try {
                response = hconn2.getResponseCode();
                hconn2.getInputStream().close();
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_HTDE, "Failed to perform HTTP DELETE to " + jobUrl, e);
                return;
            }
            if (response != 303) {
                this.reporter_.report(FixedCode.E_DECO, "HTTP DELETE response was " + response + " not 303");
            }
            this.checkDeleted(job);
        }

        private void checkCreateRun(String adql) {
            UwsJob job = this.createJob(adql);
            if (job == null) {
                return;
            }
            URL jobUrl = job.getJobUrl();
            this.checkEndpoints(job);
            this.checkPhase(job, "PENDING");
            this.validateJobDocument(job);
            if (!this.postPhase(job, "RUN")) {
                return;
            }
            String phase = null;
            try {
                boolean knownPhase = false;
                while (!knownPhase) {
                    UwsJobInfo info = job.readInfo();
                    phase = info.getPhase();
                    knownPhase = !"UNKNOWN".equals(phase);
                    if (knownPhase) continue;
                    this.waitUnknown(jobUrl);
                }
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_RDPH, "Can't read phase for job " + jobUrl, e);
                return;
            }
            assert (!"UNKNOWN".equals(phase));
            if (!Arrays.asList("QUEUED", "EXECUTING", "SUSPENDED", "ERROR", "COMPLETED").contains(phase)) {
                String msg = "Incorrect phase " + phase + " for started job " + jobUrl;
                this.reporter_.report(FixedCode.E_BAPH, msg);
            }
            if (UwsStage.FINISHED == UwsStage.forPhase((String)phase)) {
                this.reporter_.report(FixedCode.I_JOFI, "Job completed immediately - can't test phase progression");
            } else {
                this.waitForFinish(job);
            }
            this.validateJobDocument(job);
            this.delete(job);
        }

        private void checkPhase(UwsJob job, String mustPhase) {
            String msg;
            String phase;
            URL phaseUrl = this.resourceUrl(job, "/phase");
            String resourcePhase = this.readTextContent(phaseUrl, true);
            UwsJobInfo jobInfo = this.readJobInfo(job);
            String infoPhase = jobInfo == null ? null : jobInfo.getPhase();
            String string = phase = resourcePhase != null ? resourcePhase : infoPhase;
            if (phase != null && !mustPhase.equals(phase)) {
                msg = "Phase " + phase + " != " + mustPhase;
                this.reporter_.report(FixedCode.E_PHUR, msg);
            }
            if (infoPhase != null && resourcePhase != null && !infoPhase.equals(resourcePhase)) {
                msg = "Phase mismatch between job info " + "and /phase URL " + '(' + infoPhase + " != " + resourcePhase + ')';
                this.reporter_.report(FixedCode.E_JDPH, msg);
            }
        }

        private void checkParameter(UwsJob job, String name, String mustValue, boolean mandatory) {
            String actualValue;
            UwsJobInfo jobInfo = this.readJobInfo(job);
            if (jobInfo == null) {
                return;
            }
            UwsJobInfo.Parameter param = this.getParamMap(jobInfo).get(name.toUpperCase());
            String string = actualValue = param == null ? null : param.getValue();
            if (mustValue == null) {
                if (actualValue != null) {
                    String msg = "Parameter " + name + " has value " + actualValue + " not blank in job document";
                    this.reporter_.report(FixedCode.E_PANZ, msg);
                }
            } else if ((actualValue != null || mandatory) && !mustValue.equals(actualValue)) {
                String msg = "Parameter " + name + " has value " + actualValue + " not " + mustValue + " in job document";
                this.reporter_.report(FixedCode.E_PAMM, msg);
            }
        }

        private void checkEndpoints(UwsJob job) {
            UwsJobInfo jobInfo;
            URL jobUrl = job.getJobUrl();
            this.readContent(jobUrl, CTYPE_XML, true);
            try {
                jobInfo = job.readInfo();
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_JDIO, "Error reading job document " + jobUrl, e);
                return;
            }
            if (jobInfo == null) {
                this.reporter_.report(FixedCode.E_JDNO, "No job document found " + jobUrl);
                return;
            }
            UwsVersion version = this.getVersion(jobInfo);
            if (!jobUrl.toString().endsWith("/" + jobInfo.getJobId())) {
                String msg = "Job ID mismatch; " + jobInfo.getJobId() + " is not final path element of " + jobUrl;
                this.reporter_.report(FixedCode.E_JDID, msg);
            }
            URL quoteUrl = this.resourceUrl(job, "/quote");
            String quote = this.readTextContent(quoteUrl, true);
            if (version.quoteIsIso8601_) {
                this.checkDateTime(quoteUrl, quote, version);
            }
            URL durationUrl = this.resourceUrl(job, "/executionduration");
            String duration = this.readTextContent(durationUrl, true);
            this.checkInt(durationUrl, duration);
            if (!this.equals(duration, jobInfo.getExecutionDuration())) {
                String msg = "Execution duration mismatch between job info " + "and /executionduration URL " + '(' + jobInfo.getExecutionDuration() + " != " + duration + ')';
                this.reporter_.report(FixedCode.E_JDED, msg);
            }
            URL destructUrl = this.resourceUrl(job, "/destruction");
            String destruct = this.readTextContent(destructUrl, true);
            this.checkDateTime(destructUrl, destruct, version);
            if (!this.equals(destruct, jobInfo.getDestruction())) {
                String msg = "Destruction time mismatch between job info " + "and /destruction URL " + '(' + jobInfo.getDestruction() + " != " + destruct + ')';
                this.reporter_.report(FixedCode.E_JDDE, msg);
            }
        }

        private void checkDeleted(UwsJob job) {
            URLConnection conn;
            URL jobUrl = job.getJobUrl();
            try {
                conn = AuthManager.getInstance().connect(jobUrl);
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_DEOP, "Can't open connection to " + jobUrl, e);
                return;
            }
            if (conn instanceof HttpURLConnection) {
                int code;
                try {
                    code = ((HttpURLConnection)conn).getResponseCode();
                }
                catch (IOException e) {
                    this.reporter_.report(FixedCode.E_DEHT, "Bad HTTP connection to " + jobUrl, e);
                    return;
                }
                if (code != 404) {
                    String msg = "Deleted job " + "gives HTTP response " + code + " not 404" + " for " + jobUrl;
                    this.reporter_.report(FixedCode.E_DENO, msg);
                }
            } else {
                this.reporter_.report(FixedCode.E_NOHT, "Job " + jobUrl + " not HTTP?");
            }
        }

        private URL resourceUrl(UwsJob job, String subResource) {
            String urlStr = job.getJobUrl() + subResource;
            try {
                return URLUtils.newURL((String)urlStr);
            }
            catch (MalformedURLException e) {
                this.reporter_.report(FixedCode.F_MURL, "Bad URL " + urlStr + "??", e);
                return null;
            }
        }

        private boolean postParameter(UwsJob job, String name, String value) {
            return this.postKeyValue(job, "/parameters", name, value);
        }

        private boolean postPhase(UwsJob job, String phase) {
            return this.postKeyValue(job, "/phase", "PHASE", phase);
        }

        private boolean postKeyValue(UwsJob job, String subResource, String key, String value) {
            String msg;
            String responseMsg;
            int code;
            URL url;
            try {
                url = URLUtils.newURL((String)(job.getJobUrl() + subResource));
            }
            catch (MalformedURLException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(e));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(key, value);
            try {
                HttpURLConnection conn = UwsJob.postUnipartForm((URL)url, (ContentCoding)ContentCoding.NONE, map);
                code = conn.getResponseCode();
                responseMsg = conn.getResponseMessage();
            }
            catch (IOException e) {
                String msg2 = "Failed to POST parameter " + key + "=" + value + " to " + url;
                this.reporter_.report(FixedCode.E_POER, msg2, e);
                return false;
            }
            if (code >= 400) {
                msg = "Error response " + code + " " + responseMsg + " for POST " + key + "=" + value + " to " + url;
                this.reporter_.report(FixedCode.E_PORE, msg);
                return false;
            }
            msg = "POSTed " + key + "=" + value + " to " + url + " (" + code + ")";
            this.reporter_.report(FixedCode.I_POPA, msg);
            return true;
        }

        private void delete(UwsJob job) {
            try {
                job.postDelete();
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_DENO, "Failed to delete job " + job.getJobUrl(), e);
                return;
            }
            this.checkDeleted(job);
        }

        private void waitForFinish(UwsJob job) {
            URL jobUrl = job.getJobUrl();
            UwsJobInfo info = job.getLastInfo();
            while (UwsStage.forPhase((String)info.getPhase()) != UwsStage.FINISHED) {
                String phase = info.getPhase();
                UwsStage stage = UwsStage.forPhase((String)phase);
                switch (stage) {
                    case UNSTARTED: {
                        this.reporter_.report(FixedCode.E_RUPH, "Incorrect phase " + phase + " for started job " + jobUrl);
                        return;
                    }
                    case ILLEGAL: {
                        this.reporter_.report(FixedCode.E_ILPH, "Bad phase " + phase + " for job " + jobUrl);
                        return;
                    }
                    case UNKNOWN: {
                        this.waitUnknown(jobUrl);
                        break;
                    }
                    case RUNNING: {
                        this.waitPoll();
                        break;
                    }
                    case FINISHED: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                try {
                    info = job.readInfo();
                }
                catch (IOException e) {
                    this.reporter_.report(FixedCode.E_RDPH, "Can't read phase for job " + jobUrl);
                    return;
                }
            }
        }

        private void waitUnknown(URL jobUrl) {
            this.reporter_.report(FixedCode.W_UNPH, "Phase UNKNOWN reported for job " + jobUrl + "; wait and poll");
            this.waitPoll();
        }

        private void waitPoll() {
            try {
                Thread.sleep(this.poll_);
            }
            catch (InterruptedException e) {
                this.reporter_.report(FixedCode.F_INTR, "Interrupted??");
            }
        }

        private Map<String, UwsJobInfo.Parameter> getParamMap(UwsJobInfo jobInfo) {
            LinkedHashMap<String, UwsJobInfo.Parameter> paramMap = new LinkedHashMap<String, UwsJobInfo.Parameter>();
            if (jobInfo != null && jobInfo.getParameters() != null) {
                UwsJobInfo.Parameter[] params = jobInfo.getParameters();
                for (int ip = 0; ip < params.length; ++ip) {
                    UwsJobInfo.Parameter param = params[ip];
                    String name = param.getId();
                    if (name == null || name.length() == 0) {
                        this.reporter_.report(FixedCode.E_PANO, "Parameter with no name");
                        continue;
                    }
                    String upName = param.getId().toUpperCase();
                    if (paramMap.containsKey(upName)) {
                        String msg = "Duplicate parameter " + upName + " in job parameters list";
                        this.reporter_.report(FixedCode.E_PADU, msg);
                        continue;
                    }
                    paramMap.put(upName, param);
                }
            }
            return paramMap;
        }

        private UwsJobInfo readJobInfo(UwsJob job) {
            try {
                return job.readInfo();
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_JBIO, "Error reading job info", e);
                return null;
            }
        }

        private UwsJob createJob(String adql) {
            UwsJob job;
            LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
            paramMap.put("RUNID", this.runId1_);
            TapQuery tq = new TapQuery(this.tapService_, adql, paramMap);
            try {
                job = UwsJob.createJob((String)this.tapService_.getAsyncEndpoint().toString(), (Map)tq.getStringParams(), (Map)tq.getStreamParams());
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_QFAA, "Failed to submit TAP query " + this.shortAdql_, e);
                return null;
            }
            this.reporter_.report(FixedCode.I_CJOB, "Created new job " + job.getJobUrl());
            return job;
        }

        private void validateJobDocument(UwsJob job) {
            URL url = job.getJobUrl();
            if (url != null) {
                boolean includeSummary = false;
                XsdValidation.validateDoc(this.reporter_, url, "job", "http://www.ivoa.net/xml/UWS/v1.0", includeSummary);
            }
        }

        private boolean equals(String s1, String s2) {
            return s1 == null || s1.trim().length() == 0 ? s2 == null || s2.trim().length() == 0 : s1.equals(s2);
        }

        private void checkInt(URL url, String txt) {
            try {
                Long.parseLong(txt);
            }
            catch (NumberFormatException e) {
                String msg = "Not integer content " + '\"' + txt + '\"' + " from " + url;
                this.reporter_.report(FixedCode.E_IFMT, msg);
            }
        }

        private void checkDateTime(URL url, String txt, UwsVersion version) {
            if (txt != null && txt.length() > 0 && !version.iso8601Regex_.matcher(txt).matches()) {
                StringBuffer sbuf = new StringBuffer().append("Not recommended UWS ").append((Object)version).append(" ISO-8601 form").append(" or empty string");
                if (version.requireZ_ && !txt.endsWith("Z")) {
                    sbuf.append(" (missing trailing Z)");
                }
                sbuf.append(" \"").append(txt).append('\"').append(" from ").append(url);
                this.reporter_.report(FixedCode.W_TFMT, sbuf.toString());
            }
        }

        private String readTextContent(URL url, boolean mustExist) {
            String txt;
            byte[] buf = this.readContent(url, CTYPE_PLAIN, mustExist);
            if (buf == null) {
                return null;
            }
            try {
                txt = new String(buf, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.reporter_.report(FixedCode.F_UTF8, "Unknown encoding UTF-8??", e);
                return null;
            }
            return UwsJob.TRIM_TEXT ? txt.trim() : txt;
        }

        private UwsVersion getVersion(UwsJobInfo jobInfo) {
            UwsVersion vers;
            String version = jobInfo.getUwsVersion();
            if (version == null) {
                this.reporter_.report(FixedCode.I_VUWS, "UWS job document implicitly V1.0");
                return UwsVersion.V10;
            }
            if ("1.0".equals(version)) {
                this.reporter_.report(FixedCode.I_VUWS, "UWS job document explicitly V1.0");
                return UwsVersion.V10;
            }
            if ("1.1".equals(version)) {
                this.reporter_.report(FixedCode.I_VUWS, "UWS job document explicitly V1.1");
                return UwsVersion.V11;
            }
            this.reporter_.report(FixedCode.W_VUWS, "Unknown UWS version \"" + version + "\"");
            try {
                vers = Double.parseDouble(version) >= 1.1 ? UwsVersion.V11 : UwsVersion.V10;
            }
            catch (NumberFormatException e) {
                vers = UwsVersion.V10;
            }
            this.reporter_.report(FixedCode.I_VUWS, "Treat UWS version as " + (Object)((Object)vers));
            return vers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readContent(URL url, ContentTypeOptions reqType, boolean mustExist) {
            byte[] buf;
            String responseMsg;
            int responseCode;
            HttpURLConnection hconn;
            if (url == null) {
                return null;
            }
            try {
                URLConnection conn = AuthManager.getInstance().connect(url);
                if (!(conn instanceof HttpURLConnection)) {
                    this.reporter_.report(FixedCode.W_HURL, "Redirect to non-HTTP URL? " + conn.getURL());
                    return null;
                }
                hconn = (HttpURLConnection)conn;
                hconn.connect();
                responseCode = hconn.getResponseCode();
                responseMsg = hconn.getResponseMessage();
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.E_EURL, "Error contacting URL " + url);
                return null;
            }
            if (responseCode != 200) {
                if (mustExist) {
                    String msg = "Non-OK response " + responseCode + " " + responseMsg + " from " + url;
                    this.reporter_.report(FixedCode.E_NFND, msg);
                }
                return null;
            }
            BufferedInputStream in = null;
            try {
                int b;
                in = new BufferedInputStream(hconn.getInputStream());
                ByteList blist = new ByteList();
                while ((b = ((InputStream)in).read()) >= 0) {
                    blist.add((byte)b);
                }
                buf = blist.toByteArray();
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.W_RDIO, "Error reading resource " + url);
                buf = null;
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (reqType != null) {
                reqType.checkType(this.reporter_, hconn.getContentType(), url);
            }
            return buf;
        }
    }
}

