/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import uk.ac.starlink.ttools.taplint.JsonWriter;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.util.CountMap;

public class JsonOutputReporter
implements OutputReporter {
    private final PrintStream out_;
    private final Collection<ReportType> typeList_;
    private final int maxRepeat_;
    private final boolean debug_;
    private final int maxChar_;
    private final JsonWriter jsoner_;
    private final CountMap<SecCode> codeMap_;
    private final CountMap<ReportType> rtypeMap_;
    private int isect_;
    private int irep_;
    private String scode_;

    public JsonOutputReporter(PrintStream out, ReportType[] types, int maxRepeat, boolean debug, int maxChar) {
        this.out_ = out;
        this.typeList_ = new HashSet<ReportType>(Arrays.asList(types));
        this.maxRepeat_ = maxRepeat;
        this.debug_ = debug;
        this.maxChar_ = maxChar;
        this.codeMap_ = new CountMap();
        this.rtypeMap_ = new CountMap();
        this.jsoner_ = new JsonWriter(2, true);
    }

    @Override
    public void start(String[] announcements) {
        StringBuffer sbuf = new StringBuffer("{");
        sbuf.append(this.jsoner_.jsonPair("announce", Arrays.asList(announcements), 1, false)).append(",").append(this.jsoner_.getIndent(1)).append("\"sections\": [");
        this.out_.print(sbuf.toString());
    }

    @Override
    public void end() {
        this.out_.print(this.jsoner_.getIndent(1) + "],");
        TreeMap<String, Integer> tmap = new TreeMap<String, Integer>();
        boolean i = false;
        for (ReportType rtype : this.typeList_) {
            tmap.put(rtype.toString(), this.rtypeMap_.getCount((Object)rtype));
        }
        this.out_.print(this.jsoner_.jsonPair("totals", tmap, 1, false));
        this.out_.println("\n}");
    }

    @Override
    public void startSection(String scode, String message) {
        this.scode_ = scode;
        this.irep_ = 0;
        StringBuffer sbuf = new StringBuffer();
        if (this.isect_++ > 0) {
            sbuf.append(",");
        }
        sbuf.append(this.jsoner_.getIndent(2)).append("{").append(this.jsoner_.jsonPair("code", scode, 3, false)).append(",").append(this.jsoner_.jsonPair("title", message, 3, false)).append(",").append(this.jsoner_.getIndent(3)).append("\"reports\": [");
        this.out_.print(sbuf.toString());
    }

    @Override
    public void endSection() {
        this.scode_ = null;
        this.out_.print(this.jsoner_.getIndent(3) + "]");
        this.out_.print(this.jsoner_.getIndent(2) + "}");
    }

    @Override
    public String getSectionCode() {
        return this.scode_;
    }

    @Override
    public void report(ReportCode code, String message) {
        this.report(code, message, null);
    }

    @Override
    public void report(ReportCode code, String message, Throwable err) {
        ReportType rtype = code.getType();
        if (!this.typeList_.contains((Object)rtype)) {
            return;
        }
        this.rtypeMap_.addItem((Object)rtype);
        String key = rtype.getChar() + "-" + this.scode_ + "-" + code.getLabel();
        int count = this.codeMap_.addItem((Object)new SecCode(this.scode_, code));
        if (count <= this.maxRepeat_) {
            LinkedHashMap<String, Object> rmap = new LinkedHashMap<String, Object>();
            rmap.put("level", rtype.toString());
            rmap.put("code", code.getLabel());
            rmap.put("text", message);
            rmap.put("iseq", count);
            if (err != null) {
                LinkedHashMap<String, String> emap = new LinkedHashMap<String, String>();
                emap.put("class", err.getClass().getName());
                emap.put("errmsg", err.getMessage());
                if (this.debug_) {
                    StringWriter bufWriter = new StringWriter();
                    PrintWriter pWriter = new PrintWriter(bufWriter);
                    err.printStackTrace(pWriter);
                    pWriter.flush();
                    emap.put("stacktrace", bufWriter.getBuffer().toString());
                }
                rmap.put("error", emap);
            }
            StringBuffer sbuf = new StringBuffer();
            if (this.irep_++ > 0) {
                sbuf.append(",");
            }
            this.jsoner_.toJson(sbuf, rmap, 4, false);
            this.out_.print(sbuf.toString());
        }
    }

    @Override
    public void summariseUnreportedMessages(String scode) {
        Iterator it = this.codeMap_.keySet().iterator();
        while (it.hasNext()) {
            SecCode sc = (SecCode)it.next();
            if ((sc.section_ != null || scode != null) && !sc.section_.equals(scode)) continue;
            int count = this.codeMap_.getCount((Object)sc);
            if (count > this.maxRepeat_) {
                ReportCode code = sc.code_;
                ReportType rtype = code.getType();
                LinkedHashMap<String, Object> rmap = new LinkedHashMap<String, Object>();
                rmap.put("level", rtype.toString());
                rmap.put("code", code.getLabel());
                rmap.put("more", count - this.maxRepeat_);
                StringBuffer sbuf = new StringBuffer();
                if (this.irep_++ > 0) {
                    sbuf.append(",");
                }
                this.jsoner_.toJson(sbuf, rmap, 4, false);
                this.out_.print(sbuf.toString());
            }
            it.remove();
        }
    }

    private static class SecCode {
        final String section_;
        final ReportCode code_;
        final String txt_;

        SecCode(String section, ReportCode code) {
            this.section_ = section;
            this.code_ = code;
            this.txt_ = new StringBuffer().append(code.getType().getChar()).append('-').append(section).append('-').append(code.getLabel()).toString();
        }

        public int hashCode() {
            return this.txt_.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof SecCode && ((SecCode)o).txt_.equals(this.txt_);
        }

        public String toString() {
            return this.txt_;
        }
    }
}

