/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.taplint.CapabilityHolder;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.ObsTapStage;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TableData;
import uk.ac.starlink.ttools.taplint.TapRunner;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.Ivoid;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapLanguageFeature;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;

public class ObsLocStage
implements Stage {
    private final TapRunner tapRunner_;
    private final CapabilityHolder capHolder_;
    private final MetadataHolder metaHolder_;
    public static final String OBSPLAN_TNAME = "ivoa.obsplan";
    public static final Ivoid OBSPLAN_UTYPE = new Ivoid("ivo://ivoa.net/std/obsloctap#table-1.0");
    public static final Ivoid ADQLGEO_TYPE = new Ivoid("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo");
    public static final String[] ADQLGEO_FORMS = new String[]{"CIRCLE", "POLYGON", "POINT", "INTERSECTS", "CONTAINS"};
    public static final String[] REGION_XTYPES = new String[]{"point", "circle", "polygon"};

    public ObsLocStage(TapRunner tapRunner, CapabilityHolder capHolder, MetadataHolder metaHolder) {
        this.tapRunner_ = tapRunner;
        this.capHolder_ = capHolder;
        this.metaHolder_ = metaHolder;
    }

    @Override
    public String getDescription() {
        return "Test implementation of ObsLocTAP Data Model";
    }

    @Override
    public void run(Reporter reporter, TapService tapService) {
        TableMeta planMeta = null;
        for (SchemaMeta smeta : this.metaHolder_.getTableMetadata()) {
            for (TableMeta tmeta : smeta.getTables()) {
                if (!OBSPLAN_TNAME.equalsIgnoreCase(tmeta.getName())) continue;
                planMeta = tmeta;
            }
        }
        if (planMeta == null) {
            reporter.report(FixedCode.F_NOTP, "No table with name ivoa.obsplan");
            return;
        }
        TapCapability tcap = this.capHolder_.getCapability();
        if (tcap == null) {
            reporter.report(FixedCode.F_CAP0, "No capabilities for ADQLGEO declaration");
        } else if (tcap != null) {
            Collection adqlgeoFuncs = Arrays.asList(tcap.getLanguages()).stream().filter(l -> "adql".equalsIgnoreCase(l.getName())).map(l -> (TapLanguageFeature[])l.getFeaturesMap().get(ADQLGEO_TYPE)).flatMap(tlfs -> tlfs == null ? Stream.empty() : Arrays.asList(tlfs).stream()).map(feature -> feature.getForm()).map(String::toUpperCase).collect(Collectors.toCollection(LinkedHashSet::new));
            LinkedHashSet<String> missingGeo = new LinkedHashSet<String>(Arrays.asList(ADQLGEO_FORMS));
            missingGeo.removeAll(adqlgeoFuncs);
            int nMissing = missingGeo.size();
            if (missingGeo.size() > 0) {
                String msg = new StringBuffer().append(nMissing == ADQLGEO_FORMS.length ? "No" : "Not all").append(" required ADQL geometry functions declared").append(" (see TAPRegExt).").append(" ObsLocTAP requires ").append(ADQLGEO_TYPE).append(" features ").append(Arrays.toString(ADQLGEO_FORMS)).toString();
                reporter.report(FixedCode.W_PGEO, msg);
            }
        }
        new ObsLocRunner(reporter, tapService, planMeta, this.tapRunner_).run();
    }

    static Map<String, PlanCol> createRequiredColumns() {
        PlanCol[] cols = new PlanCol[]{new PlanCol("t_planning", Type.FLOAT, "d", null, null), new PlanCol("target_name", Type.STRING, null, "Target.name", "meta.id;src"), new PlanCol("obs_id", Type.STRING, null, "DataID.observationID", "meta.id"), new PlanCol("obs_collection", Type.STRING, null, "DataID.collection", "meta.id"), new PlanCol("s_ra", Type.FLOAT, "deg", "Char.SpatialAxis.Coverage.Location.Coord.Position2D.Value2.C1", "pos.eq.ra"), new PlanCol("s_dec", Type.FLOAT, "deg", "Char.SpatialAxis.Coverage.Location.Coord.Position2D.Value2.C2", "pos.eq.dec"), new PlanCol("s_fov", Type.FLOAT, "deg", "Char.SpatialAxis.Coverage.Bounds.Extent.diameter", "phys.angSize;instr.fov"), new PlanCol("s_region", Type.REGION, null, "Char.SpatialAxis.Coverage.Support.Area", "pos.outline;obs.field"), new PlanCol("s_resolution", Type.FLOAT, "arcsec", "Char.SpatialAxis.Resolution.Refval.value", "pos.angResolution"), new PlanCol("t_min", Type.FLOAT, "d", "Char.TimeAxis.Coverage.Bounds.Limits.StartTime", "time.start;obs.exposure"), new PlanCol("t_max", Type.FLOAT, "d", "Char.TimeAxis.Coverage.Bounds.Limits.StopTime", "time.end;obs.exposure"), new PlanCol("t_exptime", Type.FLOAT, "s", "Char.TimeAxis.Coverage.Support.Extent", "time.duration;obs.exposure"), new PlanCol("t_resolution", Type.FLOAT, "s", "Char.TimeAxis.Resolution.Refval.value", "time.resolution"), new PlanCol("em_min", Type.FLOAT, "m", "Char.SpectralAxis.Coverage.Bounds.Limits.LoLimit", "em.wl;stat.min"), new PlanCol("em_max", Type.FLOAT, "m", "Char.SpectralAxis.Coverage.Bounds.Limits.HiLimit", "em.wl;stat.max"), new PlanCol("em_res_power", Type.FLOAT, null, "Char.SpectralAxis.Resolution.ResolPower.refVal", "spect.resolution"), new PlanCol("o_ucd", Type.STRING, null, "Char.ObservableAxis.ucd", "meta.ucd"), new PlanCol("pol_states", Type.STRING, null, "Char.PolarizationAxis.stateList", "meta.code;phys.polarization"), new PlanCol("pol_xel", Type.INTEGER, null, "Char.PolarizationAxis.numBins", "meta.number"), new PlanCol("facility_name", Type.STRING, null, "Provenance.ObsConfig.Facility.name", "meta.id;instr.tel"), new PlanCol("instrument_name", Type.STRING, null, "Provenance.ObsConfig.Instrument.name", "meta.id;instr"), new PlanCol("t_plan_exptime", Type.FLOAT, "s", "Char.TimeAxis.Coverage.Support.Extent", "time.duration;obs.exposure"), new PlanCol("category", Type.STRING, null, null, null), new PlanCol("priority", Type.INTEGER, null, null, null), new PlanCol("execution_status", Type.STRING, null, null, null), new PlanCol("tracking_type", Type.STRING, null, null, null)};
        LinkedHashMap<String, PlanCol> map = new LinkedHashMap<String, PlanCol>();
        for (PlanCol col : cols) {
            map.put(ObsTapStage.nameKey(col.name_), col);
        }
        assert (map.size() == 26);
        ((PlanCol)map.get((Object)"t_planning")).isNullable_ = false;
        ((PlanCol)map.get((Object)"obs_id")).isNullable_ = false;
        ((PlanCol)map.get((Object)"facility_name")).isNullable_ = false;
        ((PlanCol)map.get("category")).setStringOpts(new String[]{"Fixed", "Coordinated", "Window", "Other"});
        ((PlanCol)map.get((Object)"category")).isNullable_ = false;
        ((PlanCol)map.get("priority")).setIntOpts(new int[]{0, 1, 2});
        ((PlanCol)map.get((Object)"priority")).isNullable_ = false;
        ((PlanCol)map.get("execution_status")).setStringOpts(new String[]{"Planned", "Scheduled", "Unscheduled", "Performed", "Aborted"});
        ((PlanCol)map.get((Object)"execution_status")).isNullable_ = false;
        ((PlanCol)map.get("tracking_type")).setStringOpts(new String[]{"Sidereal", "Solar-system-object-tracking", "Fixed-az-el-transit"});
        ((PlanCol)map.get((Object)"tracking_type")).isNullable_ = false;
        return map;
    }

    private static boolean matchesClass(ValueInfo info, Class<?> ... clazzes) {
        return Arrays.asList(clazzes).contains(info.getContentClass());
    }

    public static String votype(ValueInfo info) {
        return info.getContentClass().getSimpleName();
    }

    static class PlanCol {
        final String name_;
        final Type type_;
        final String unit_;
        final String utype_;
        final String ucd_;
        boolean isNullable_;
        String adqlOptList_;

        PlanCol(String name, Type type, String unit, String utype, String ucd) {
            this.name_ = name;
            this.type_ = type;
            this.unit_ = unit;
            this.utype_ = utype;
            this.ucd_ = ucd;
            this.isNullable_ = true;
        }

        void setStringOpts(String[] opts) {
            this.adqlOptList_ = Arrays.asList(opts).stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
        }

        void setIntOpts(int[] opts) {
            this.adqlOptList_ = IntStream.of(opts).mapToObj(Integer::toString).collect(Collectors.joining(", "));
        }
    }

    private static enum Type {
        INTEGER{

            @Override
            void checkInfo(Reporter reporter, ValueInfo info) {
                if (!ObsLocStage.matchesClass(info, new Class[]{Byte.class, Short.class, Integer.class, Long.class})) {
                    Type.reportTypeMismatch(reporter, info, ObsLocStage.votype(info) + " not integer");
                }
            }
        }
        ,
        FLOAT{

            @Override
            void checkInfo(Reporter reporter, ValueInfo info) {
                if (!ObsLocStage.matchesClass(info, new Class[]{Float.class, Double.class, Byte.class, Short.class, Integer.class, Long.class})) {
                    Type.reportTypeMismatch(reporter, info, ObsLocStage.votype(info) + " not numeric");
                }
            }
        }
        ,
        STRING{

            @Override
            void checkInfo(Reporter reporter, ValueInfo info) {
                if (!String.class.equals((Object)info.getContentClass())) {
                    Type.reportTypeMismatch(reporter, info, ObsLocStage.votype(info) + " not string");
                }
            }
        }
        ,
        REGION{

            @Override
            void checkInfo(Reporter reporter, ValueInfo info) {
                if (!ObsLocStage.matchesClass(info, new Class[]{String.class})) {
                    if (ObsLocStage.matchesClass(info, new Class[]{float[].class, double[].class})) {
                        String xtype = info.getXtype();
                        if (xtype == null || xtype.trim().length() == 0) {
                            Type.reportTypeMismatch(reporter, info, "has no DALI region xtype");
                        } else if (!Arrays.asList(REGION_XTYPES).contains(xtype)) {
                            String msg = new StringBuffer().append("Unrecognised region xtype='").append(xtype).append("' on column ").append(info.getName()).append(" (not in ").append(Arrays.toString(REGION_XTYPES)).append(")").toString();
                            reporter.report(FixedCode.W_CRGN, msg);
                        }
                    } else {
                        Type.reportTypeMismatch(reporter, info, "not string or floating point array");
                    }
                }
            }
        };


        abstract void checkInfo(Reporter var1, ValueInfo var2);

        private static void reportTypeMismatch(Reporter reporter, ValueInfo info, String txt) {
            String msg = new StringBuffer().append("Data type mismatch for ").append(ObsLocStage.OBSPLAN_TNAME).append(" column ").append(info.getName()).append(": ").append(txt).toString();
            reporter.report(FixedCode.E_PCMS, msg);
        }
    }

    private static class ObsLocRunner
    implements Runnable {
        private final Reporter reporter_;
        private final TapService tapService_;
        private final TableMeta planMeta_;
        private final TapRunner tapRunner_;
        private final Map<String, ColumnMeta> gotCols_;
        private final Map<String, PlanCol> reqCols_;

        ObsLocRunner(Reporter reporter, TapService tapService, TableMeta planMeta, TapRunner tapRunner) {
            this.reporter_ = reporter;
            this.tapService_ = tapService;
            this.planMeta_ = planMeta;
            this.tapRunner_ = tapRunner;
            this.gotCols_ = ObsTapStage.toMap(planMeta.getColumns());
            this.reqCols_ = ObsLocStage.createRequiredColumns();
        }

        @Override
        public void run() {
            String utype = this.planMeta_.getUtype();
            if (!OBSPLAN_UTYPE.equalsIvoid(new Ivoid(utype))) {
                String msg = new StringBuffer().append("Table ").append(ObsLocStage.OBSPLAN_TNAME).append(" utype (").append(utype == null ? "null" : '\"' + utype + '\"').append(") != \"").append(OBSPLAN_UTYPE).append("\"").toString();
                this.reporter_.report(FixedCode.E_PLUT, msg);
            }
            int nreq = 0;
            for (String reqName : this.reqCols_.keySet()) {
                PlanCol reqCol = this.reqCols_.get(reqName);
                ColumnMeta gotCol = this.gotCols_.get(reqName);
                if (gotCol != null) {
                    this.checkMetadata(gotCol, reqCol);
                    ++nreq;
                    continue;
                }
                String msg = new StringBuffer().append("Required ObsLocTAP column ").append(reqName).append(" is missing").toString();
                this.reporter_.report(FixedCode.E_PCOL, msg);
            }
            String adql1 = "SELECT TOP 1 * FROM ivoa.obsplan";
            TapQuery tq1 = new TapQuery(this.tapService_, adql1, null);
            StarTable table1 = this.tapRunner_.getResultTable(this.reporter_, tq1);
            ColumnInfo[] cinfos = table1 == null ? new ColumnInfo[]{} : Tables.getColumnInfos((StarTable)table1);
            for (ColumnInfo cinfo : cinfos) {
                String cname = ObsTapStage.nameKey(cinfo.getName());
                PlanCol stdCol = this.reqCols_.get(cname);
                if (stdCol == null) continue;
                stdCol.type_.checkInfo(this.reporter_, (ValueInfo)cinfo);
            }
            for (String cname : this.gotCols_.keySet()) {
                PlanCol stdCol = this.reqCols_.get(cname);
                if (stdCol == null) continue;
                this.checkContent(stdCol);
            }
            this.checkObservationTimes();
            int nother = this.gotCols_.size() - nreq;
            String msg = new StringBuffer().append(ObsLocStage.OBSPLAN_TNAME).append(" columns: ").append(nreq).append("/").append(this.reqCols_.size()).append(" required, ").append(nother).append(" custom").toString();
            this.reporter_.report(FixedCode.S_PCLS, msg);
        }

        private void checkMetadata(ColumnMeta gotCol, PlanCol stdCol) {
            String cname = gotCol.getName();
            this.compareItem(cname, "Utype", FixedCode.E_CUTP, stdCol.utype_, gotCol.getUtype(), false);
            this.compareItem(cname, "UCD", FixedCode.E_CUCD, stdCol.ucd_, gotCol.getUcd(), false);
            this.compareItem(cname, "Unit", FixedCode.E_CUNI, stdCol.unit_, gotCol.getUnit(), true);
        }

        private void checkContent(PlanCol stdCol) {
            String adql;
            TapQuery tq;
            StarTable table;
            TableData tdata;
            String optList = stdCol.adqlOptList_;
            boolean isNullable = stdCol.isNullable_;
            String cname = stdCol.name_;
            if (optList != null) {
                int maxWrong = 4;
                StringBuffer abuf = new StringBuffer().append("SELECT ").append("DISTINCT TOP ").append(maxWrong + 1).append(" ").append(cname).append(" FROM ").append(ObsLocStage.OBSPLAN_TNAME).append(" WHERE ").append(cname).append(" NOT IN (").append(optList).append(")");
                if (isNullable) {
                    abuf.append(" AND ").append(cname).append(" IS NOT NULL");
                } else {
                    abuf.append(" OR ").append(cname).append(" IS NULL");
                }
                String adql2 = abuf.toString();
                TapQuery tq2 = new TapQuery(this.tapService_, adql2, null);
                StarTable table2 = this.tapRunner_.getResultTable(this.reporter_, tq2);
                TableData tdata2 = TableData.createTableData(this.reporter_, table2);
                if (tdata2 == null) {
                    return;
                }
                long nwrong = tdata2.getRowCount();
                if (nwrong > 0L) {
                    String msg = new StringBuffer().append("Illegal ").append(nwrong == 1L ? "value" : "values").append(" in column ").append(cname).append(": ").append(Arrays.asList(tdata2.getColumn(0)).stream().map(String::valueOf).collect(Collectors.joining(", "))).append(nwrong > (long)maxWrong ? ", ..." : "").toString();
                    this.reporter_.report(FixedCode.E_PVAL, msg);
                }
            } else if (!isNullable && (tdata = TableData.createTableData(this.reporter_, table = this.tapRunner_.getResultTable(this.reporter_, tq = new TapQuery(this.tapService_, adql = new StringBuffer().append("SELECT ").append("TOP 1 ").append(cname).append(" FROM ").append(ObsLocStage.OBSPLAN_TNAME).append(" WHERE ").append(cname).append(" IS NULL").toString(), null)))) != null && tdata.getRowCount() > 0) {
                String msg = new StringBuffer().append("NULL values in non-nullable column ").append(cname).toString();
                this.reporter_.report(FixedCode.E_LNUL, msg);
            }
        }

        private void checkObservationTimes() {
            String adql = new StringBuffer().append("SELECT ").append("TOP 1 ").append("execution_status, t_min, t_max, t_exptime ").append(" FROM ").append(ObsLocStage.OBSPLAN_TNAME).append(" WHERE (").append("t_min IS NULL OR ").append("t_max IS NULL OR ").append("t_exptime IS NULL").append(") AND ").append("execution_status IN ('Scheduled', 'Performed')").toString();
            TapQuery tq = new TapQuery(this.tapService_, adql, null);
            StarTable table = this.tapRunner_.getResultTable(this.reporter_, tq);
            TableData tdata = TableData.createTableData(this.reporter_, table);
            if (tdata != null && tdata.getRowCount() > 0) {
                String msg = new StringBuffer().append("NULL t_min/t_max/t_exptime values for ").append("execution_status Scheduled/Performed").toString();
                this.reporter_.report(FixedCode.E_LNSP, msg);
            }
        }

        private void compareItem(String colName, String itemName, ReportCode code, String obsValue, String gotValue, boolean isCaseSensitive) {
            String vObs;
            String vGot = gotValue == null || gotValue.trim().length() == 0 ? "null" : gotValue;
            String string = vObs = obsValue == null ? "null" : obsValue;
            if (isCaseSensitive ? !vGot.equals(vObs) : !vGot.equalsIgnoreCase(vObs)) {
                StringBuffer sbuf = new StringBuffer().append("Wrong ").append(itemName).append(" for ").append(ObsLocStage.OBSPLAN_TNAME).append(" column ").append(colName).append(": ").append(gotValue).append(" != ").append(obsValue);
                this.reporter_.report(code, sbuf.toString());
            }
        }
    }
}

