/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.taplint.CompareMetadataStage;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.TableData;
import uk.ac.starlink.ttools.taplint.TableMetadataStage;
import uk.ac.starlink.ttools.taplint.TapRunner;
import uk.ac.starlink.util.ContentCoding;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.ForeignMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapSchemaInterrogator;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.TapVersion;
import uk.ac.starlink.votable.VOStarTable;

public class TapSchemaStage
extends TableMetadataStage {
    private final TapRunner tapRunner_;

    public TapSchemaStage(TapRunner tapRunner) {
        super("TAP_SCHEMA", new String[]{"indexed", "principal", "std"}, false);
        this.tapRunner_ = tapRunner;
    }

    @Override
    public void run(Reporter reporter, TapService tapService) {
        super.run(reporter, tapService);
        this.tapRunner_.reportSummary(reporter);
    }

    @Override
    protected MetadataHolder readTableMetadata(Reporter reporter, TapService tapService) {
        String adql;
        TapQuery tq;
        StarTable table;
        List sList;
        HashMap tMap;
        HashMap fMap;
        HashMap lMap;
        HashMap cMap;
        TapVersion tapVersion = tapService.getTapVersion();
        reporter.report(FixedCode.I_TAPV, "Validating for TAP version " + tapVersion);
        int maxrec = this.getMetaMaxrec(reporter, tapService, this.tapRunner_) + 10;
        LintTapSchemaInterrogator tsi = new LintTapSchemaInterrogator(reporter, tapService, maxrec, this.tapRunner_);
        try {
            tsi.checkColumnTypes();
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_CERR, "Error reading TAP_SCHEMA.columns data", e);
        }
        try {
            cMap = tsi.readMap(TapSchemaInterrogator.COLUMN_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_CLIO, "Error reading TAP_SCHEMA.columns table", e);
            cMap = new HashMap();
        }
        try {
            lMap = tsi.readMap(TapSchemaInterrogator.LINK_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_KCIO, "Error reading TAP_SCHEMA.key_columns table", e);
            lMap = new HashMap();
        }
        try {
            fMap = tsi.readMap(TapSchemaInterrogator.FKEY_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_FKIO, "Error reading TAP_SCHEMA.keys table", e);
            fMap = new HashMap();
        }
        try {
            tMap = tsi.readMap(TapSchemaInterrogator.TABLE_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_TBIO, "Error reading TAP_SCHEMA.tables table", e);
            tMap = new HashMap();
        }
        try {
            sList = tsi.readList(TapSchemaInterrogator.SCHEMA_QUERIER, null);
        }
        catch (IOException e) {
            reporter.report(FixedCode.E_SCIO, "Error reading TAP_SCHEMA.schemas table", e);
            sList = null;
        }
        for (List flist : fMap.values()) {
            for (ForeignMeta fmeta : flist) {
                tsi.populateForeignKey(fmeta, lMap);
            }
        }
        this.checkEmpty(reporter, lMap, FixedCode.W_FLUN, "key_columns");
        for (List tlist : tMap.values()) {
            for (TableMeta tmeta : tlist) {
                tsi.populateTable(tmeta, fMap, cMap);
            }
        }
        this.checkEmpty(reporter, fMap, FixedCode.W_FKUN, "keys");
        this.checkEmpty(reporter, cMap, FixedCode.W_CLUN, "columns");
        if (sList != null) {
            for (SchemaMeta smeta : sList) {
                tsi.populateSchema(smeta, tMap);
            }
            this.checkEmpty(reporter, tMap, FixedCode.W_TBUN, "tables");
        }
        TableMap tmap = new TableMap(sList);
        ColumnChecker colchecker = new ColumnChecker(reporter, this.tapRunner_, tapService, tmap);
        ColType tStr = ColType.STR;
        ColType tInt = ColType.INT;
        ColType tBool = ColType.BOOL;
        colchecker.checkColumns("TAP_SCHEMA.schemas", new ColReq[]{new ColReq("schema_name", tStr, true), new ColReq("utype", tStr, false), new ColReq("description", tStr, false), new ColReq("schema_index", tInt, false, true)});
        colchecker.checkColumns("TAP_SCHEMA.tables", new ColReq[]{new ColReq("schema_name", tStr, true), new ColReq("table_name", tStr, true), new ColReq("table_type", tStr, true), new ColReq("utype", tStr, false), new ColReq("description", tStr, false), new ColReq("table_index", tInt, false, true)});
        colchecker.checkColumns("TAP_SCHEMA.columns", new ColReq[]{new ColReq("table_name", tStr, true), new ColReq("column_name", tStr, true), new ColReq("datatype", tStr, true), new ColReq("arraysize", tStr, false, true), new ColReq("xtype", tStr, false, true), new ColReq("\"size\"", tInt, false), new ColReq("description", tStr, false), new ColReq("utype", tStr, false), new ColReq("unit", tStr, false), new ColReq("ucd", tStr, false), new ColReq("indexed", tBool, true), new ColReq("principal", tBool, true), new ColReq("std", tBool, true), new ColReq("column_index", tInt, false, true)});
        colchecker.checkColumns("TAP_SCHEMA.keys", new ColReq[]{new ColReq("key_id", tStr, true), new ColReq("from_table", tStr, true), new ColReq("target_table", tStr, true), new ColReq("description", tStr, false), new ColReq("utype", tStr, false)});
        colchecker.checkColumns("TAP_SCHEMA.key_columns", new ColReq[]{new ColReq("key_id", tStr, true), new ColReq("from_column", tStr, true), new ColReq("target_column", tStr, true)});
        if (tapVersion.is11()) {
            ForeignKeyChecker fkchecker = new ForeignKeyChecker(reporter, "TAP_SCHEMA.", tmap);
            fkchecker.checkLink("tables", "schema_name", "schemas", "schema_name");
            fkchecker.checkLink("columns", "table_name", "tables", "table_name");
            fkchecker.checkLink("keys", "from_table", "tables", "table_name");
            fkchecker.checkLink("keys", "target_table", "tables", "table_name");
            fkchecker.checkLink("key_columns", "key_id", "keys", "key_id");
        }
        if (tapVersion.is11() && (table = this.tapRunner_.getResultTable(reporter, tq = tsi.createTapQuery(adql = "SELECT table_name, column_name, datatype, arraysize, \"size\" FROM TAP_SCHEMA.columns"))) != null) {
            try {
                RowSequence rseq = table.getRowSequence();
                while (rseq.next()) {
                    Object[] row = rseq.getRow();
                    String tname = (String)row[0];
                    String cname = (String)row[1];
                    String dtype = (String)row[2];
                    String arraysize = (String)row[3];
                    Number size = (Number)row[4];
                    boolean isCharacter = "char".equals(dtype) || "unicodeChar".equals(dtype);
                    this.checkArraysize(reporter, tname, cname, arraysize, size, isCharacter);
                }
            }
            catch (Throwable e) {
                reporter.report(FixedCode.F_DTIO, "Trouble checking size/arraysize", e);
            }
        }
        if (sList == null) {
            return null;
        }
        final SchemaMeta[] smetas = sList.toArray(new SchemaMeta[0]);
        return new MetadataHolder(){

            @Override
            public SchemaMeta[] getTableMetadata() {
                return smetas;
            }

            @Override
            public boolean hasDetail() {
                return true;
            }
        };
    }

    private int getMetaMaxrec(Reporter reporter, TapService tapService, TapRunner tapRunner) {
        String[] tnames = new String[]{"TAP_SCHEMA.schemas", "TAP_SCHEMA.tables", "TAP_SCHEMA.columns", "TAP_SCHEMA.keys", "TAP_SCHEMA.key_columns"};
        int maxrec = 0;
        for (String tname : tnames) {
            int nr = Math.max(maxrec, this.getRowCount(reporter, tapService, tapRunner, tname));
            if (nr < 0) {
                return 0;
            }
            maxrec = Math.max(maxrec, nr);
        }
        return maxrec;
    }

    private int getRowCount(Reporter reporter, TapService tapService, TapRunner tapRunner, String tname) {
        String adql = "SELECT COUNT(*) AS nr FROM " + tname;
        TapQuery tq = new TapQuery(tapService, adql, null);
        StarTable result = tapRunner.getResultTable(reporter, tq);
        if (result != null) {
            try {
                result = Tables.randomTable((StarTable)result);
                if (result.getColumnCount() == 1 && result.getRowCount() == 1L) {
                    Object cell = result.getCell(0L, 0);
                    if (cell instanceof Number) {
                        return ((Number)cell).intValue();
                    }
                    reporter.report(FixedCode.E_NONM, "Non-numeric return cell from " + adql);
                    return -1;
                }
                reporter.report(FixedCode.E_NO11, "Expecting nrow=1, ncol=1, got nrow=" + result.getRowCount() + " ncol=" + result.getColumnCount() + " from " + adql);
                return -1;
            }
            catch (IOException e) {
                reporter.report(FixedCode.E_NRER, "Error counting rows with " + adql, e);
                return -1;
            }
        }
        return -1;
    }

    private void checkEmpty(Reporter reporter, Map<?, ?> map, ReportCode code, String stName) {
        for (Object key : map.keySet()) {
            reporter.report(code, "Unused entry in TAP_SCHEMA." + stName + " table: " + key);
        }
    }

    private void checkArraysize(Reporter reporter, String tname, String cname, String arraysize, Number size, boolean isCharacter) {
        String context = new StringBuffer().append(tname).append(".").append(cname).append(": arraysize=").append(arraysize).append("; size=").append(size).toString();
        if (arraysize == null) {
            if (size != null) {
                reporter.report(FixedCode.E_TSSZ, "Non-null size for null arraysize: " + context);
            }
        } else if ("*".equals(arraysize)) {
            if (size != null) {
                reporter.report(FixedCode.E_TSSZ, "Arraysize/size mismatch: " + context);
            }
        } else if (arraysize.matches("[0-9]+[*]?")) {
            String astxt = arraysize.endsWith("*") ? arraysize.substring(0, arraysize.length() - 1) : arraysize;
            long asize = Long.parseLong(astxt);
            if (size == null || size.longValue() != asize) {
                reporter.report(FixedCode.E_TSSZ, "Size does not match arraysize for vector: " + context);
            } else if ("1".equals(arraysize) && !isCharacter) {
                reporter.report(FixedCode.W_TSZ1, "Questionable use of single-element array: " + context);
            }
        } else if (arraysize.matches("([0-9]+x)+[0-9]*[0-9*]")) {
            if (size != null) {
                reporter.report(FixedCode.E_TSSZ, "Non-null size does not match arraysize: " + context);
            }
        } else {
            reporter.report(FixedCode.E_TSAZ, "Bad arraysize syntax: " + context);
        }
    }

    private static class LintTapSchemaInterrogator
    extends TapSchemaInterrogator {
        private final Reporter reporter_;
        private final TapRunner tapRunner_;
        private static Integer BOOL_TRUE = 1;
        private static Integer BOOL_FALSE = 0;

        public LintTapSchemaInterrogator(Reporter reporter, TapService tapService, int maxrec, TapRunner tapRunner) {
            super(tapService, maxrec, ContentCoding.NONE);
            this.reporter_ = reporter;
            this.tapRunner_ = tapRunner;
        }

        protected StarTable executeQuery(TapQuery tq) throws IOException {
            try {
                return this.tapRunner_.attemptGetResultTable(this.reporter_, tq);
            }
            catch (SAXException e) {
                throw (IOException)new IOException("Result parse error: " + e.getMessage()).initCause(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkColumnTypes() throws IOException {
            String[] colNames = new String[]{"principal", "indexed", "std", "size"};
            String[] colTypes = new String[]{"int", "int", "int", "int"};
            boolean[] colBools = new boolean[]{true, true, true, false};
            String adql = "SELECT principal, indexed, std, \"size\" FROM TAP_SCHEMA.columns";
            StarTable table = this.executeQuery(this.createTapQuery(adql));
            int ncol = Math.min(colNames.length, table.getColumnCount());
            for (int ic = 0; ic < ncol; ++ic) {
                ColumnInfo cinfo = table.getColumnInfo(ic);
                String type = (String)cinfo.getAuxDatumValue(VOStarTable.DATATYPE_INFO, String.class);
                if (colTypes[ic].equals(type)) continue;
                String msg = new StringBuffer().append("Column ").append(colNames[ic]).append(" in ").append("TAP_SCHEMA.columns").append(" has wrong type ").append(type).append(" not ").append(colTypes[ic]).toString();
                this.reporter_.report(FixedCode.E_CINT, msg);
                colBools[ic] = false;
            }
            try (RowSequence rseq = table.getRowSequence();){
                while (rseq.next()) {
                    Object[] row = rseq.getRow();
                    for (int ic = 0; ic < ncol; ++ic) {
                        Object cell;
                        if (!colBools[ic] || BOOL_TRUE.equals(cell = row[ic]) || BOOL_FALSE.equals(cell)) continue;
                        String msg = new StringBuffer().append("Non-boolean value ").append(cell).append(" in TAP_SCHEMA.columns column ").append(colNames[ic]).toString();
                        this.reporter_.report(FixedCode.E_CLOG, msg);
                    }
                }
            }
        }

        public TapQuery createTapQuery(String adql) {
            return super.createTapQuery(adql);
        }
    }

    private static enum ColType {
        STR("VARCHAR", "string"){

            @Override
            boolean isCompatibleTap11(String datatype, String arraysize) {
                return ("char".equals(datatype) || "unicodeChar".equals(datatype)) && arraysize != null && arraysize.matches("[0-9]*[0-9*]");
            }

            @Override
            boolean isCompatibleTap10(String datatype) {
                return CompareMetadataStage.compatibleDataTypes("varchar", datatype);
            }
        }
        ,
        INT("INTEGER", "integer"){

            @Override
            boolean isCompatibleTap11(String datatype, String arraysize) {
                return !(!"unsignedByte".equals(datatype) && !"int".equals(datatype) && !"short".equals(datatype) && !"long".equals(datatype) || arraysize != null && !"1".equals(arraysize));
            }

            @Override
            boolean isCompatibleTap10(String datatype) {
                return CompareMetadataStage.compatibleDataTypes("integer", datatype);
            }
        }
        ,
        BOOL("INTEGER", "integer"){

            @Override
            boolean isCompatibleTap11(String datatype, String arraysize) {
                return INT.isCompatibleTap11(datatype, arraysize);
            }

            @Override
            boolean isCompatibleTap10(String datatype) {
                return INT.isCompatibleTap10(datatype);
            }
        };

        final String name10_;
        final String name11_;

        private ColType(String name10, String name11) {
            this.name10_ = name10;
            this.name11_ = name11;
        }

        abstract boolean isCompatibleTap11(String var1, String var2);

        abstract boolean isCompatibleTap10(String var1);
    }

    private static class ColReq {
        final String name_;
        final ColType type_;
        final boolean notNull_;
        final boolean is11_;

        ColReq(String name, ColType type, boolean notNull) {
            this(name, type, notNull, false);
        }

        ColReq(String name, ColType type, boolean notNull, boolean is11) {
            this.name_ = name;
            this.type_ = type;
            this.notNull_ = notNull;
            this.is11_ = is11;
        }
    }

    private static class TableMap {
        private final Map<String, TableMeta> tmap_ = new HashMap<String, TableMeta>();

        TableMap(List<SchemaMeta> schemaList) {
            if (schemaList != null) {
                for (SchemaMeta smeta : schemaList) {
                    for (TableMeta tmeta : smeta.getTables()) {
                        this.tmap_.put(tmeta.getName().toLowerCase(), tmeta);
                    }
                }
            }
        }

        TableMeta getTable(String name) {
            return this.tmap_.get(name.toLowerCase());
        }
    }

    private static class ForeignKeyChecker {
        private final Reporter reporter_;
        private final String tablePrefix_;
        private final TableMap tmap_;

        ForeignKeyChecker(Reporter reporter, String tablePrefix, TableMap tmap) {
            this.reporter_ = reporter;
            this.tablePrefix_ = tablePrefix;
            this.tmap_ = tmap;
        }

        void checkLink(String table1, String col1, String table2, String col2) {
            String fqTable1 = this.tablePrefix_ + table1;
            String fqTable2 = this.tablePrefix_ + table2;
            TableMeta tmeta = this.tmap_.getTable(fqTable1.toLowerCase());
            if (tmeta != null) {
                for (ForeignMeta fmeta : tmeta.getForeignKeys()) {
                    ForeignMeta.Link[] links;
                    if (!fqTable2.equalsIgnoreCase(fmeta.getTargetTable()) || (links = fmeta.getLinks()).length != 1 || !col1.equalsIgnoreCase(links[0].getFrom()) || !col2.equalsIgnoreCase(links[0].getTarget())) continue;
                    return;
                }
                String msg = new StringBuffer().append("Missing foreign key ").append(fqTable1).append(".").append(col1).append(" -> ").append(fqTable2).append(".").append(col2).toString();
                this.reporter_.report(FixedCode.E_TSLN, msg);
            }
        }
    }

    private static class ColumnChecker {
        private final Reporter reporter_;
        private final TapRunner tapRunner_;
        private final TapService tapService_;
        private final TableMap tmap_;

        ColumnChecker(Reporter reporter, TapRunner tapRunner, TapService tapService, TableMap tmap) {
            this.reporter_ = reporter;
            this.tapRunner_ = tapRunner;
            this.tapService_ = tapService;
            this.tmap_ = tmap;
        }

        void checkColumns(String tableName, ColReq[] colReqs) {
            boolean is11 = this.tapService_.getTapVersion().is11();
            TableMeta tmeta = this.tmap_.getTable(tableName);
            if (tmeta == null) {
                this.reporter_.report(FixedCode.E_TST0, "Missing required table " + tableName);
                return;
            }
            LinkedHashMap<String, ColumnMeta> colMap = new LinkedHashMap<String, ColumnMeta>();
            for (ColumnMeta columnMeta : tmeta.getColumns()) {
                colMap.put(columnMeta.getName().toLowerCase(), columnMeta);
            }
            for (ColReq colReq : colReqs) {
                String adql;
                TapQuery tq;
                StarTable table;
                TableData tdata;
                if (colReq.is11_ && !is11) continue;
                String ctxt = "column " + tmeta.getName() + "." + colReq.name_;
                ColumnMeta cmeta = (ColumnMeta)colMap.remove(colReq.name_.toLowerCase());
                if (cmeta == null) {
                    this.reporter_.report(FixedCode.E_TSC0, "Missing required " + ctxt);
                } else {
                    String msg;
                    if (!cmeta.hasFlag("std")) {
                        this.reporter_.report(FixedCode.E_TSTD, "Not declared STD " + ctxt);
                    }
                    String datatype = cmeta.getDataType();
                    String arraysize = cmeta.getArraysize();
                    ColType reqType = colReq.type_;
                    if (is11) {
                        if (!reqType.isCompatibleTap11(datatype, arraysize)) {
                            msg = new StringBuffer().append("Type mismatch for ").append(ctxt).append(" datatype=").append(datatype).append(" arraysize=").append(arraysize).append(" is not ").append(reqType.name11_).append("-like").append(" (TAP 1.1)").toString();
                            this.reporter_.report(FixedCode.E_TSCT, msg);
                        }
                    } else if (!reqType.isCompatibleTap10(datatype)) {
                        msg = new StringBuffer().append("Possible type mismatch for ").append(ctxt).append(": datatype=").append(datatype).append(" does not look ").append(reqType.name10_).append("-like").append(" (TAP 1.0)").toString();
                        this.reporter_.report(FixedCode.W_TSCT, msg);
                    }
                }
                if (!colReq.notNull_ || (tdata = TableData.createTableData(this.reporter_, table = this.tapRunner_.getResultTable(this.reporter_, tq = new TapQuery(this.tapService_, adql = new StringBuffer().append("SELECT TOP 1 ").append(colReq.name_).append(" FROM ").append(tableName).append(" WHERE ").append(colReq.name_).append(" IS NULL").toString(), null)))) == null || tdata.getRowCount() <= 0) continue;
                this.reporter_.report(FixedCode.E_TSNL, "Null values in non-nullable " + ctxt);
            }
            if (!colMap.isEmpty()) {
                String string = new StringBuffer().append(colMap.size()).append(" non-standard columns in ").append(tableName).append(": ").append(colMap.keySet()).toString();
                this.reporter_.report(FixedCode.I_TSNS, string);
            }
        }
    }
}

