/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.MetadataHolder;
import uk.ac.starlink.ttools.taplint.ReportCode;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.vo.ColumnMeta;
import uk.ac.starlink.vo.SchemaMeta;
import uk.ac.starlink.vo.TableMeta;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.vo.UcdStatus;
import uk.ac.starlink.vo.UnitStatus;

public class UnitUcdStage
implements Stage {
    private final MetadataHolder metaHolder_;
    private static final int MAX_LOCS = 4;
    private static final ItemChecker UNIT_CHECKER = UnitUcdStage.createUnitChecker();
    private static final ItemChecker UCD_CHECKER = UnitUcdStage.createUcdChecker();

    public UnitUcdStage(MetadataHolder metaHolder) {
        this.metaHolder_ = metaHolder;
    }

    @Override
    public String getDescription() {
        return "Check column units and UCDs are legal";
    }

    @Override
    public void run(Reporter reporter, TapService tapService) {
        TableMeta[] tmetas;
        SchemaMeta[] smetas = this.metaHolder_.getTableMetadata();
        ArrayList<TableMeta> tlist = new ArrayList<TableMeta>();
        if (smetas != null) {
            for (SchemaMeta smeta : smetas) {
                for (TableMeta tmeta : smeta.getTables()) {
                    tlist.add(tmeta);
                }
            }
        }
        if ((tmetas = tlist.toArray(new TableMeta[0])).length == 0) {
            reporter.report(FixedCode.F_NOTM, "No table metadata available (earlier stages failed/skipped?) - will not check units/UCDs");
            return;
        }
        String uvmsg = new StringBuffer().append("UCD validation details: ").append(UcdStatus.getParser().getFullVersion().replaceAll("\n", ", ")).toString();
        reporter.report(FixedCode.I_UCDV, uvmsg);
        this.reportBadValues(reporter, tmetas, "UCD", ColumnMeta::getUcd, UCD_CHECKER);
        this.reportBadValues(reporter, tmetas, "unit", ColumnMeta::getUnit, UNIT_CHECKER);
    }

    private void reportBadValues(Reporter reporter, TableMeta[] tmetas, String itemType, Function<ColumnMeta, String> itemFunc, ItemChecker checker) {
        HashSet<String> okSet = new HashSet<String>();
        LinkedHashMap<String, Issue> issueMap = new LinkedHashMap<String, Issue>();
        for (TableMeta tmeta : tmetas) {
            for (ColumnMeta cmeta : tmeta.getColumns()) {
                String item = itemFunc.apply(cmeta);
                if (okSet.contains(item)) continue;
                if (issueMap.containsKey(item)) {
                    ((Issue)issueMap.get((Object)item)).locs_.add(new Location(tmeta, cmeta));
                    continue;
                }
                Message message = checker.check(item);
                if (message == null) {
                    okSet.add(item);
                    continue;
                }
                issueMap.put(item, new Issue(message, tmeta, cmeta));
            }
        }
        for (Map.Entry entry : issueMap.entrySet()) {
            String item = (String)entry.getKey();
            Issue issue = (Issue)entry.getValue();
            Message message = issue.message_;
            List<Location> locs = issue.locs_;
            StringBuffer sbuf = new StringBuffer().append(message.code_.getType() == ReportType.ERROR ? "Bad " : "Questionable ").append(itemType).append(" \"").append(item).append("\"; ").append(message.txt_);
            int nloc = locs.size();
            if (nloc == 1) {
                sbuf.append(" in column ").append(locs.get(0));
            } else {
                sbuf.append(" in ").append(nloc).append(" columns: ").append(locs.stream().limit(4L).map(Location::toString).collect(Collectors.joining(", ")));
                if (nloc > 4) {
                    sbuf.append(", ...");
                }
            }
            reporter.report(message.code_, sbuf.toString());
        }
    }

    private static ItemChecker createUnitChecker() {
        return unit -> {
            UnitStatus status = UnitStatus.getStatus((String)unit);
            if (status != null) {
                String descrip;
                FixedCode rcode;
                UnitStatus.Code ucode = status.getCode();
                if (ucode.isError()) {
                    rcode = FixedCode.W_VUNE;
                    descrip = "Not legal";
                } else if (ucode.isWarning()) {
                    rcode = FixedCode.W_VUNR;
                    descrip = "Questionable";
                } else {
                    rcode = null;
                    descrip = null;
                }
                if (rcode != null) {
                    String txt = new StringBuffer().append(descrip).append(" VOUnits string (").append(ucode).append("): ").append(status.getMessage()).toString();
                    return new Message(rcode, txt);
                }
            }
            return null;
        };
    }

    private static ItemChecker createUcdChecker() {
        return ucd -> {
            UcdStatus status = UcdStatus.getStatus((String)ucd);
            if (status != null) {
                UcdStatus.Code code = status.getCode();
                if (code.isError()) {
                    return new Message(FixedCode.E_UCDX, code + ": " + status.getMessage());
                }
                if (code.isWarning()) {
                    return new Message(FixedCode.W_UCDQ, code + ": " + status.getMessage());
                }
            }
            return null;
        };
    }

    private static class Issue {
        final Message message_;
        final List<Location> locs_;

        Issue(Message message) {
            this.message_ = message;
            this.locs_ = new ArrayList<Location>();
        }

        Issue(Message message, TableMeta tmeta, ColumnMeta cmeta) {
            this(message);
            this.locs_.add(new Location(tmeta, cmeta));
        }
    }

    private static class Location {
        final TableMeta tmeta_;
        final ColumnMeta cmeta_;

        Location(TableMeta tmeta, ColumnMeta cmeta) {
            this.tmeta_ = tmeta;
            this.cmeta_ = cmeta;
        }

        public String toString() {
            return this.tmeta_.getName() + "." + this.cmeta_.getName();
        }
    }

    private static class Message {
        final ReportCode code_;
        final String txt_;

        private Message(ReportCode code, String txt) {
            this.code_ = code;
            this.txt_ = txt;
        }
    }

    @FunctionalInterface
    private static interface ItemChecker {
        public Message check(String var1);
    }
}

