/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.taplint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ArrayColumn;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.taplint.AdhocCode;
import uk.ac.starlink.ttools.taplint.CapabilityHolder;
import uk.ac.starlink.ttools.taplint.FixedCode;
import uk.ac.starlink.ttools.taplint.ReportType;
import uk.ac.starlink.ttools.taplint.Reporter;
import uk.ac.starlink.ttools.taplint.Stage;
import uk.ac.starlink.ttools.taplint.TapRunner;
import uk.ac.starlink.vo.TapCapability;
import uk.ac.starlink.vo.TapQuery;
import uk.ac.starlink.vo.TapService;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOStarTable;
import uk.ac.starlink.votable.VOTableBuilder;
import uk.ac.starlink.votable.VOTableVersion;
import uk.ac.starlink.votable.VOTableWriter;

public class UploadStage
implements Stage {
    private final TapRunner tapRunner_;
    private final CapabilityHolder capHolder_;
    private static final Pattern DALI_ISO_REGEX = Pattern.compile("[0-9]{4}-[01][0-9]-[0-3][0-9](T[0-2][0-9]:[0-5][0-9]:[0-6][0-9](\\.[0-9]+)?)?");

    public UploadStage(TapRunner tapRunner, CapabilityHolder capHolder) {
        this.tapRunner_ = tapRunner;
        this.capHolder_ = capHolder;
    }

    @Override
    public String getDescription() {
        return "Make queries with table uploads";
    }

    @Override
    public void run(Reporter reporter, TapService tapService) {
        TapCapability tcap = this.capHolder_.getCapability();
        if (tcap != null && (tcap.getUploadMethods() == null || tcap.getUploadMethods().length == 0)) {
            reporter.report(FixedCode.F_NOUP, "Table capabilities lists no upload methods - will not attempt upload tests");
            return;
        }
        new UploadRunner(reporter, tapService, tcap, this.tapRunner_).run();
    }

    private static String normaliseXtype(String xtype) {
        if (xtype == null) {
            return null;
        }
        if ("adql:TIMESTAMP".equals(xtype)) {
            return "timestamp";
        }
        return xtype;
    }

    private static String renderCell(Object cell) {
        if (Tables.isBlank((Object)cell)) {
            return "";
        }
        if (cell.getClass().isArray()) {
            StringBuilder sbuf = new StringBuilder();
            for (int i = 0; i < Array.getLength(cell); ++i) {
                sbuf.append(i == 0 ? (char)'[' : ',').append(Array.get(cell, i));
            }
            sbuf.append(']');
            return sbuf.toString();
        }
        return cell.toString();
    }

    private static final StarTable createUploadTable(int nrow) {
        int arraySize = 4;
        short[] shortData = new short[nrow];
        int[] intData = new int[nrow];
        long[] longData = new long[nrow];
        float[] floatData = new float[nrow];
        double[] doubleData = new double[nrow];
        char[] charData = new char[nrow];
        String[] stringData = new String[nrow];
        String[] timeData = new String[nrow];
        for (int ir = 0; ir < nrow; ++ir) {
            shortData[ir] = (short)ir;
            intData[ir] = ir;
            longData[ir] = ir;
            floatData[ir] = 1.125f * (float)ir;
            doubleData[ir] = 1.125 * (double)ir;
            charData[ir] = (char)(65 + ir);
            stringData[ir] = Integer.toString(ir);
            timeData[ir] = Times.mjdToIso(51544.0 + 1.01 * (double)ir);
        }
        ColumnStarTable ctable = ColumnStarTable.makeTableWithRows((long)nrow);
        ctable.addColumn(UploadStage.makeColumn("d_short", shortData, null));
        ctable.addColumn(UploadStage.makeColumn("d_int", intData, null));
        ctable.addColumn(UploadStage.makeColumn("d_long", longData, null));
        ctable.addColumn(UploadStage.makeColumn("d_float", floatData, null));
        ctable.addColumn(UploadStage.makeColumn("d_double", doubleData, null));
        ctable.addColumn(UploadStage.makeColumn("d_char", charData, null));
        ctable.addColumn(UploadStage.makeColumn("d_string", stringData, null));
        ctable.addColumn(UploadStage.makeColumn("d_time", timeData, "timestamp"));
        int irBlank = nrow - 1;
        for (int ic = 0; ic < ctable.getColumnCount(); ++ic) {
            ColumnData dcol = ctable.getColumnData(ic);
            if (!dcol.getColumnInfo().isNullable()) continue;
            ((ArrayColumn)dcol).storeValue((long)irBlank, null);
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            VOTableWriter vow = new VOTableWriter(DataFormat.BINARY, true, VOTableVersion.V12);
            vow.writeStarTable((StarTable)ctable, (OutputStream)bout);
            bout.close();
            byte[] bbuf = bout.toByteArray();
            StarTableFactory stfact = new StarTableFactory();
            stfact.setStoragePolicy(StoragePolicy.PREFER_MEMORY);
            return stfact.makeStarTable((InputStream)new ByteArrayInputStream(bbuf), (TableBuilder)new VOTableBuilder(true));
        }
        catch (IOException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unexpected error re-reading VOTable"))).initCause(e));
        }
    }

    private static ColumnData makeColumn(String name, Object data, String xtype) {
        boolean nullable;
        Class clazz;
        ArrayColumn col = ArrayColumn.makeColumn((String)name, (Object)data);
        ColumnInfo cinfo = col.getColumnInfo();
        if (xtype != null) {
            cinfo.setXtype(xtype);
        }
        if ((clazz = cinfo.getContentClass()) == String.class) {
            nullable = false;
            String[] sdata = (String[])data;
            int size = sdata[0].length();
            for (int i = 0; i < sdata.length; ++i) {
                if (sdata[i].length() == size) continue;
                size = -1;
            }
            if (size >= 0) {
                cinfo.setElementSize(size);
            }
        } else if (clazz.isArray()) {
            nullable = false;
            int size = Array.getLength(Array.get(data, 0));
            for (int i = 0; i < Array.getLength(data); ++i) {
                Object item = Array.get(data, i);
                if (Array.getLength(Array.get(data, i)) == size) continue;
                size = -1;
            }
            cinfo.setShape(new int[]{size});
        } else {
            nullable = clazz != Character.class;
        }
        cinfo.setNullable(nullable);
        return col;
    }

    private static class UploadRunner
    implements Runnable {
        private final Reporter reporter_;
        private final TapService tapService_;
        private final TapCapability tcap_;
        private final TapRunner tRunner_;

        UploadRunner(Reporter reporter, TapService tapService, TapCapability tcap, TapRunner tapRunner) {
            this.reporter_ = reporter;
            this.tapService_ = tapService;
            this.tcap_ = tcap;
            this.tRunner_ = tapRunner;
        }

        @Override
        public void run() {
            VOTableWriter[] vowriters = new VOTableWriter[]{new VOTableWriter(DataFormat.TABLEDATA, true, VOTableVersion.V12), new VOTableWriter(DataFormat.BINARY, true, VOTableVersion.V12)};
            StarTable upTable = UploadStage.createUploadTable(23);
            for (int i = 0; i < vowriters.length; ++i) {
                this.runUploadQuery(upTable, vowriters[i]);
            }
        }

        private void runUploadQuery(StarTable upTable, VOTableWriter vowriter) {
            TapQuery tq;
            String upName = "t1";
            String adql = "SELECT * FROM TAP_UPLOAD." + upName;
            LinkedHashMap<String, StarTable> upMap = new LinkedHashMap<String, StarTable>();
            upMap.put(upName, upTable);
            try {
                tq = new TapQuery(this.tapService_, adql, null, upMap, -1L, vowriter);
            }
            catch (IOException e) {
                String msg = new StringBuffer().append("Upload failed").append(" using VOTable serializer ").append(vowriter).toString();
                this.reporter_.report(FixedCode.E_UPER, msg, e);
                return;
            }
            StarTable resultTable = this.tRunner_.getResultTable(this.reporter_, tq);
            if (resultTable == null) {
                return;
            }
            try {
                upTable = Tables.randomTable((StarTable)upTable);
                resultTable = Tables.randomTable((StarTable)resultTable);
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.F_TRND, "Unexpected error randomising tables", e);
            }
            this.compareTables(upTable, resultTable);
        }

        private void compareTables(StarTable t1, StarTable t2) {
            int ncol;
            boolean ok = true;
            long nrow = t1.getRowCount();
            if (nrow != t2.getRowCount()) {
                ok = false;
                String msg = "Upload result row count wrong, " + t2.getRowCount() + " != " + t1.getRowCount();
                this.reporter_.report(FixedCode.E_TMNR, msg);
            }
            if ((ncol = t1.getColumnCount()) != t2.getColumnCount()) {
                ok = false;
                String msg = "Upload result column count wrong, " + t2.getColumnCount() + " != " + t1.getColumnCount();
                this.reporter_.report(FixedCode.E_TMNC, msg);
            } else {
                for (int ic = 0; ic < ncol; ++ic) {
                    String name2;
                    ColumnInfo c1 = t1.getColumnInfo(ic);
                    ColumnInfo c2 = t2.getColumnInfo(ic);
                    String name1 = c1.getName();
                    if (!name1.equalsIgnoreCase(name2 = c2.getName())) {
                        String msg = new StringBuffer().append("Upload result column name mismatch ").append(name2).append(" != ").append(name1).toString();
                        this.reporter_.report(FixedCode.E_TMCN, msg);
                    }
                    this.compareStringAuxMetadata(c1, c2, VOStarTable.DATATYPE_INFO);
                    String xtype1 = UploadStage.normaliseXtype(c1.getXtype());
                    String xtype2 = UploadStage.normaliseXtype(c2.getXtype());
                    if ((xtype1 != null || xtype2 == null) && (xtype1 == null || xtype1.equals(xtype2))) continue;
                    String msg = new StringBuffer().append("Upload result column xtype mismatch ").append(c1.getXtype()).append(" != ").append(c2.getXtype()).toString();
                    this.reporter_.report(FixedCode.E_TMCX, msg);
                }
            }
            if (!ok) {
                return;
            }
            try {
                int ir = 0;
                while ((long)ir < nrow) {
                    for (int ic = 0; ic < ncol; ++ic) {
                        boolean reportMismatch;
                        String msg;
                        Object o1 = t1.getCell((long)ir, ic);
                        Object o2 = t2.getCell((long)ir, ic);
                        String s1 = UploadStage.renderCell(o1);
                        String s2 = UploadStage.renderCell(o2);
                        boolean isTimeCol = "timestamp".equals(t2.getColumnInfo(ic).getXtype());
                        if (isTimeCol && s1.length() > 0 && s2.length() > 0) {
                            if (!DALI_ISO_REGEX.matcher(s2).matches()) {
                                msg = new StringBuffer().append("Incorrect time syntax: \"").append(s2).append("\" does not match ").append("yyyy-MM-dd['T'HH:mm:ss[.SSS]]").toString();
                                this.reporter_.report(FixedCode.W_TSDL, msg);
                                reportMismatch = false;
                            } else {
                                double d2;
                                double d1 = Times.isoToMjd(s1);
                                reportMismatch = d1 != (d2 = Times.isoToMjd(s2));
                            }
                        } else {
                            boolean bl = reportMismatch = !s1.equals(s2);
                        }
                        if (!reportMismatch) continue;
                        msg = "Upload result value mismatch" + " for column " + t1.getColumnInfo(ic) + " in row " + ir + ": " + s2 + " != " + s1;
                        this.reporter_.report(FixedCode.E_TMCD, msg);
                    }
                    ++ir;
                }
            }
            catch (IOException e) {
                this.reporter_.report(FixedCode.F_DTIO, "Unexpected IO error reading table", e);
            }
        }

        private void compareStringAuxMetadata(ColumnInfo c1, ColumnInfo c2, ValueInfo metaInfo) {
            String s2;
            DescribedValue dv1 = c1.getAuxDatum(metaInfo);
            DescribedValue dv2 = c2.getAuxDatum(metaInfo);
            String s1 = dv1 == null ? null : (String)dv1.getValue();
            String string = s2 = dv2 == null ? null : (String)dv2.getValue();
            if (s1 == null && s2 != null || s1 != null && !s1.equals(s2)) {
                String msg = "Upload result column " + metaInfo.getName() + " mismatch (" + s1 + " != " + s2 + ")" + " for column " + c1.getName();
                AdhocCode code = new AdhocCode(ReportType.WARNING, "TM" + metaInfo.getName().substring(0, 2).toUpperCase());
                this.reporter_.report(code, msg);
            }
        }
    }
}

