/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.task.InputTableParameter;

public class Calc
implements Task {
    private final StringParameter exprParam_ = new StringParameter("expression");
    private final InputTableParameter tableParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public Calc() {
        this.exprParam_.setPosition(1);
        this.exprParam_.setUsage("<expr>");
        this.exprParam_.setPrompt("Expression to evaluate");
        this.exprParam_.setDescription(new String[]{"<p>An expression to evaluate.", "The functions in <ref id='staticMethods'/> can be used.", "</p>"});
        this.tableParam_ = new InputTableParameter("table");
        this.tableParam_.setNullPermitted(true);
        this.tableParam_.setUsage("<table>");
        this.tableParam_.setPrompt("Table providing context for expression");
        this.tableParam_.setDescription(new String[]{"<p>A table which provides the context within which", "<code>" + this.exprParam_.getName() + "</code> is evaluated.", "This parameter is optional, and will usually not be required;", "its only purpose is to allow use of constant expressions", "(table parameters) associated with the table.", "These can be referenced using identifiers of the form", "<code>param$*</code>,", "<code>ucd$*</code> or", "<code>utype$*</code> -", "see <ref id='jel-paramref'/> for more detail.", "</p>"});
    }

    public String getPurpose() {
        return "Evaluates expressions";
    }

    public Parameter<?>[] getParameters() {
        return new Parameter[]{this.exprParam_, this.tableParam_};
    }

    public Executable createExecutable(Environment env) throws TaskException {
        CompiledExpression compEx;
        String tname = this.tableParam_.stringValue(env);
        StarTable table = tname == null || tname.trim().length() == 0 ? null : this.tableParam_.tableValue(env);
        final JELRowReader rdr = JELUtils.createDatalessRowReader(table);
        Library lib = JELUtils.getLibrary(rdr);
        String expr = this.exprParam_.stringValue(env);
        final PrintStream out = env.getOutputStream();
        try {
            compEx = Evaluator.compile(expr, lib);
        }
        catch (CompilationException e) {
            throw new TaskException("Bad expression \"" + expr + "\": " + e.getMessage(), (Throwable)e);
        }
        return new Executable(){

            public void execute() throws TaskException {
                out.println("   " + this.format(this.evaluate()));
            }

            private Object evaluate() throws TaskException {
                try {
                    return rdr.evaluate(compEx);
                }
                catch (NullPointerException e) {
                    return null;
                }
                catch (Throwable e) {
                    String msg = e.getMessage();
                    msg = msg == null ? "Execution error: " + e.toString() : "Execution error: " + msg;
                    throw new TaskException(msg, e);
                }
            }

            private String format(Object obj) {
                if (obj == null) {
                    return "null";
                }
                if (obj instanceof boolean[]) {
                    return Arrays.toString((boolean[])obj);
                }
                if (obj instanceof char[]) {
                    return Arrays.toString((char[])obj);
                }
                if (obj instanceof byte[]) {
                    return Arrays.toString((byte[])obj);
                }
                if (obj instanceof short[]) {
                    return Arrays.toString((short[])obj);
                }
                if (obj instanceof int[]) {
                    return Arrays.toString((int[])obj);
                }
                if (obj instanceof long[]) {
                    return Arrays.toString((long[])obj);
                }
                if (obj instanceof float[]) {
                    return Arrays.toString((float[])obj);
                }
                if (obj instanceof double[]) {
                    return Arrays.toString((double[])obj);
                }
                if (obj instanceof Object[]) {
                    return Arrays.toString((Object[])obj);
                }
                return obj.toString();
            }
        };
    }
}

