/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.OutputModeParameter;
import uk.ac.starlink.ttools.task.OutputTableParameter;
import uk.ac.starlink.util.LoadException;

public class ChoiceMode
implements ProcessingMode {
    private final OutputModeParameter modeParam_ = new OutputModeParameter("omode");
    private final Parameter<?>[] params_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public ChoiceMode() {
        ArrayList<OutputModeParameter> paramList = new ArrayList<OutputModeParameter>();
        paramList.add(this.modeParam_);
        paramList.addAll(Arrays.asList(ChoiceMode.getDefaultAssociatedParameters(this.modeParam_)));
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    @Override
    public Parameter<?>[] getAssociatedParameters() {
        return this.params_;
    }

    public OutputModeParameter getOutputModeParameter() {
        return this.modeParam_;
    }

    @Override
    public String getDescription() {
        return new StringBuffer().append("Provides a choice of output mode options via the\n").append(this.modeParam_.getName()).append("parameter.").toString();
    }

    @Override
    public TableConsumer createConsumer(Environment env) throws TaskException {
        return this.modeParam_.consumerValue(env);
    }

    private static Parameter<?>[] getDefaultAssociatedParameters(OutputModeParameter modeParam) {
        ProcessingMode mode;
        String modeName = modeParam.getStringDefault();
        try {
            mode = (ProcessingMode)Stilts.getModeFactory().createObject(modeName);
        }
        catch (LoadException e) {
            logger_.warning("Can't load default output mode?? " + (Object)((Object)e));
            return new Parameter[0];
        }
        Parameter<?>[] modeParams = mode.getAssociatedParameters();
        if (modeParams.length != 2 || !(modeParams[0] instanceof OutputTableParameter) || !(modeParams[1] instanceof OutputFormatParameter)) {
            logger_.warning("Output mode parameters out of sync?");
            return new Parameter[0];
        }
        OutputTableParameter outParam = new OutputTableParameter(modeParams[0].getName());
        OutputFormatParameter fmtParam = new OutputFormatParameter(modeParams[1].getName());
        Parameter[] resultParams = new Parameter[]{outParam, fmtParam};
        for (int i = 0; i < resultParams.length; ++i) {
            resultParams[i].setDescription(new String[]{resultParams[i].getDescription(), "<p>This parameter must only be given if", "<code>" + modeParam.getName() + "</code>", "has its default value of \"<code>" + modeName + "</code>\".", "</p>"});
        }
        return resultParams;
    }
}

