/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.task.CombinerParameter;
import uk.ac.starlink.ttools.task.StringMultiParameter;

public class CombinedColumn {
    private final String expr_;
    private final Combiner combiner_;
    private final String name_;

    public CombinedColumn(String expr, Combiner combiner, String name) {
        this.expr_ = expr;
        this.combiner_ = combiner;
        this.name_ = name;
    }

    public String getExpression() {
        return this.expr_;
    }

    public Combiner getCombiner() {
        return this.combiner_;
    }

    public String getName() {
        return this.name_;
    }

    public static CombinedColumn parseSpecification(Environment env, String txt, Parameter<?> txtParam, CombinerParameter combinerParam) throws ParameterValueException {
        Combiner combiner;
        String[] fields = txt.split(";", 3);
        int nf = fields.length;
        assert (nf > 0 && nf <= 3);
        String expr = fields[0];
        if (nf > 1 && fields[1].trim().length() > 0) {
            try {
                combiner = combinerParam.stringToObject(env, fields[1]);
            }
            catch (TaskException e) {
                throw new ParameterValueException(txtParam, "No such combination method \"" + fields[1] + "\"", (Throwable)e);
            }
        } else {
            combiner = null;
        }
        String name = nf > 2 && fields[2].trim().length() > 0 ? fields[2] : null;
        return new CombinedColumn(expr, combiner, name);
    }

    public static StringMultiParameter createCombinedColumnsParameter(String name, CombinerParameter dfltCombinerParam) {
        StringMultiParameter param = new StringMultiParameter(name, ' ');
        param.setPrompt("Aggregate column definitions");
        param.setUsage("<expr>[;<combiner>[;<name>]] ...");
        param.setDescription(new String[]{"<p>Defines the quantities to be calculated.", "The value is a space-separated list of items,", "one for each aggregated column in the output table.", "</p>", "<p>Each item is composed of one, two or three tokens,", "separated by semicolon (\"<code>;</code>\") characters:", "<ul>", "<li><code>&lt;expr&gt;</code>: <em>(required)</em>", "    column name or expression using the", "    <ref id='jel'>expression language</ref>", "    for the quantity to be aggregated.", "    </li>", "<li><code>&lt;combiner&gt;</code>: <em>(optional)</em>", "    combination method, using the same options as for the", "    <code>" + dfltCombinerParam.getName() + "</code> parameter.", "    If omitted, the value specified for that parameter", "    will be used.", "    </li>", "<li><code>&lt;name&gt;</code>: <em>(optional)</em>", "    name of output column; if omitted,", "    the <code>&lt;expr&gt;</code> value", "    (perhaps somewhat sanitised)", "    will be used.", "    </li>", "</ul>", "It is often sufficient just to supply a space-separated list", "of input table column names for this parameter,", "but the additional syntax may be required for instance if", "it's required to calculate both a sum and mean", "of the same input column.", "</p>"});
        param.setNullPermitted(true);
        return param;
    }
}

