/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StringContent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.Credibility;
import uk.ac.starlink.ttools.task.CredibleString;
import uk.ac.starlink.ttools.task.LineEnder;
import uk.ac.starlink.ttools.task.LineInvoker;
import uk.ac.starlink.ttools.task.MapEnvironment;
import uk.ac.starlink.ttools.task.Setting;
import uk.ac.starlink.ttools.task.SettingGroup;
import uk.ac.starlink.ttools.task.StiltsCommand;

public class CommandFormatter {
    private final int continueIndent_;
    private final int levelIndent_;
    private final int cwidth_;
    private final CredibleString invocation_;
    private final LineEnder lineEnder_;
    private final boolean includeDflts_;
    private final Color syntaxColor_;
    private final boolean addSuggestions_;
    private boolean forceError_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public CommandFormatter(CredibleString invocation, boolean includeDflts, LineEnder lineEnder, int levelIndent, int cwidth, boolean addSuggestions) {
        this.invocation_ = invocation;
        this.includeDflts_ = includeDflts;
        this.lineEnder_ = lineEnder;
        this.levelIndent_ = levelIndent;
        this.cwidth_ = cwidth;
        this.continueIndent_ = 1;
        this.syntaxColor_ = new Color(0xA0A0FF);
        this.addSuggestions_ = addSuggestions;
    }

    public CredibleString getInvocation() {
        return this.invocation_;
    }

    public void setForceError(boolean forceError) {
        this.forceError_ = forceError;
    }

    public Executable createExecutable(StiltsCommand command) throws TaskException {
        MapEnvironment env = new MapEnvironment(){
            final Map<String, Object> map = this.getMap();

            @Override
            public MapEnvironment setValue(String paramName, Object value) {
                if (this.map.containsKey(paramName)) {
                    throw new IllegalStateException("Duplicate parameter: " + paramName);
                }
                return super.setValue(paramName, value);
            }
        };
        try {
            this.populateEnvironment(command, env);
        }
        catch (RuntimeException e) {
            throw new TaskException(e.getMessage(), (Throwable)e);
        }
        Task task = command.getTask();
        Executable exec = task.createExecutable((Environment)env);
        String[] unused = this.stripExpectedUnused(task, env.getUnused());
        if (unused.length > 0) {
            throw new TaskException(LineInvoker.getUnusedWarning(unused));
        }
        return exec;
    }

    public StyledDocument createShellDocument(StiltsCommand command) {
        StyleContext context = StyleContext.getDefaultStyleContext();
        AttributeSet plain = context.getEmptySet();
        AttributeSet faint = context.addAttribute(plain, StyleConstants.Foreground, Color.LIGHT_GRAY);
        AttributeSet syntax = this.syntaxColor_ == null ? plain : context.addAttribute(plain, StyleConstants.Foreground, this.syntaxColor_);
        AttributeSet warning1 = context.addAttribute(plain, StyleConstants.Foreground, Color.BLUE);
        AttributeSet warning2 = context.addAttribute(plain, StyleConstants.Foreground, Color.RED);
        AttributeSet suggestion = context.addAttribute(plain, StyleConstants.Foreground, new Color(0xA0A000));
        DefaultStyledDocument doc = new DefaultStyledDocument();
        AttributeSet invokeStyle = CommandFormatter.getStyle(this.invocation_.getCredibility(), plain, warning1, warning2);
        String invokeTxt = this.invocation_.getValue();
        CommandFormatter.addText(doc, invokeTxt + " ", invokeStyle);
        if (invokeTxt.length() > 16) {
            CommandFormatter.addText(doc, this.getPrefix(0), faint);
        }
        CommandFormatter.addText(doc, command.getTaskName() + " ", plain);
        for (SettingGroup g : this.getGroups(command)) {
            List<Setting> settings = this.getSettings(g);
            if (settings.size() <= 0) continue;
            String prefix = this.getPrefix(g.getLevel());
            int icr = prefix.lastIndexOf("\n");
            boolean hasNewline = icr >= 0;
            int npre = prefix.length() - icr - 1;
            int npost = hasNewline ? icr : 0;
            String prefixCont = hasNewline ? prefix + CommandFormatter.spaces(this.continueIndent_) : prefix;
            int npreCont = hasNewline ? npre + this.continueIndent_ : npre;
            CommandFormatter.addText(doc, prefix, faint);
            int nc = npre;
            for (Setting s : settings) {
                boolean isDflt = s.isDefaultValue();
                AttributeSet keyStyle = isDflt ? faint : plain;
                AttributeSet equStyle = isDflt ? faint : syntax;
                AttributeSet valStyle = CommandFormatter.getStyle(s.getCredibility(), keyStyle, warning1, warning2);
                String key = s.getKey();
                String val = Setting.shellQuote(s.getStringValue());
                int wleng = key.length() + 1 + val.length() + 1;
                if (nc + wleng + npre > this.cwidth_ && nc > npre) {
                    CommandFormatter.addText(doc, prefixCont, faint);
                    nc = npreCont;
                }
                CommandFormatter.addText(doc, key, keyStyle);
                CommandFormatter.addText(doc, "=", equStyle);
                CommandFormatter.addText(doc, val, valStyle);
                CommandFormatter.addText(doc, " ", plain);
                nc += wleng;
            }
        }
        if (this.addSuggestions_ && command.getTask() instanceof ConsumerTask) {
            ProcessingMode mode;
            CommandFormatter.addText(doc, this.getPrefix(1), faint);
            if (this.includeDflts_ && (mode = ((ConsumerTask)command.getTask()).getOutputMode()) instanceof ChoiceMode) {
                String omodeName = ((ChoiceMode)mode).getOutputModeParameter().getName();
                CommandFormatter.addText(doc, omodeName + "=out", faint);
                CommandFormatter.addText(doc, " ", plain);
            }
            CommandFormatter.addText(doc, "out=result.fits", suggestion);
        }
        return doc;
    }

    private List<Setting> getSettings(SettingGroup group) {
        ArrayList<Setting> list = new ArrayList<Setting>();
        for (Setting s : group.getSettings()) {
            if (!this.includeDflts_ && s.isDefaultValue()) continue;
            list.add(s);
        }
        return list;
    }

    protected String[] stripExpectedUnused(Task task, String[] words) {
        return words;
    }

    private List<SettingGroup> getGroups(StiltsCommand command) {
        ArrayList<SettingGroup> list = new ArrayList<SettingGroup>(Arrays.asList(command.getGroups()));
        if (this.forceError_) {
            list.add(new SettingGroup(0, new Setting[]{new Setting("force_error", "true", null)}));
        }
        return list;
    }

    public void populateEnvironment(StiltsCommand command, MapEnvironment env) {
        for (SettingGroup g : this.getGroups(command)) {
            for (Setting s : this.getSettings(g)) {
                String key = s.getKey();
                Object objVal = s.getObjectValue();
                env.setValue(key, objVal == null ? s.getStringValue() : objVal);
            }
        }
    }

    private void envSettings(MapEnvironment env, Collection<Setting> settings) {
        for (Setting s : settings) {
            if (s == null || s.isDefaultValue()) continue;
            String key = s.getKey();
            Object objVal = s.getObjectValue();
            env.setValue(key, objVal == null ? s.getStringValue() : objVal);
        }
    }

    private static void addText(Document doc, String text, AttributeSet attSet) {
        block2: {
            try {
                doc.insertString(doc.getLength(), text, attSet);
            }
            catch (BadLocationException e) {
                logger_.log(Level.SEVERE, "Can't insert string?", e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private static AttributeSet getStyle(Credibility cred, AttributeSet yesStyle, AttributeSet maybeStyle, AttributeSet noStyle) {
        switch (cred) {
            case YES: {
                return yesStyle;
            }
            case MAYBE: {
                return maybeStyle;
            }
            case NO: {
                return noStyle;
            }
        }
        assert (false);
        return yesStyle;
    }

    private String getPrefix(int level) {
        if (this.lineEnder_.includesNewline()) {
            return new StringBuffer().append(this.lineEnder_.getEndOfLine()).append(CommandFormatter.spaces(level * this.levelIndent_)).toString();
        }
        return "";
    }

    public static StyledDocument createBasicDocument(String txt) {
        StringContent content;
        block2: {
            content = new StringContent();
            try {
                content.insertString(0, txt);
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        StyleContext context = StyleContext.getDefaultStyleContext();
        return new DefaultStyledDocument((AbstractDocument.Content)content, context);
    }

    private static String spaces(int n) {
        StringBuffer sbuf = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            sbuf.append(' ');
        }
        return sbuf.toString();
    }
}

