/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.BufferedInputStream;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.taplint.DatalinkValidator;
import uk.ac.starlink.ttools.taplint.OutputReporter;
import uk.ac.starlink.ttools.task.OutputReporterParameter;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.vo.DatalinkVersion;
import uk.ac.starlink.vo.UserAgentUtil;

public class DatalinkLint
implements Task {
    private final Parameter<String> locParam_;
    private final ChoiceParameter<DatalinkVersion> versionParam_;
    private final OutputReporterParameter reporterParam_;
    private final Parameter<?>[] params_;

    public DatalinkLint() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.locParam_ = new StringParameter("votable");
        this.locParam_.setPosition(1);
        this.locParam_.setPrompt("Location of DataLink VOTable");
        this.locParam_.setUsage("<filename>|<URL>|-");
        this.locParam_.setDescription(new String[]{"<p>Location of the DataLink VOTable document to check.", "This may be a URL, or a filename, or the special value", "\"<code>-</code>\" to indicate standard input.", "</p>"});
        paramList.add(this.locParam_);
        this.versionParam_ = new ChoiceParameter<DatalinkVersion>("version", DatalinkVersion.values()){

            public String stringifyOption(DatalinkVersion version) {
                return version.getNumber();
            }
        };
        this.versionParam_.setNullPermitted(true);
        this.versionParam_.setPrompt("DataLink standard version");
        this.versionParam_.setDescription(new String[]{"<p>Selects the version of the DataLink standard which the", "input document is supposed to conform to.", "If left blank, the default, then the version will be determined", "from the document itself if possible, otherwise a default", "value for the application will be used.", "</p>", "<p>Options are currently:", "<ul>", Arrays.stream(DatalinkVersion.values()).map(v -> new StringBuffer().append("<li><code>").append(v.getNumber()).append("</code>: ").append(v.getFullName()).append("</li>\n").toString()).collect(Collectors.joining()), "</ul>", "</p>", "<p>If a non-null version is specified and it conflicts with", "declarations in the document itself, this conflict will be", "reported as an error.", "</p>"});
        paramList.add(this.versionParam_);
        this.reporterParam_ = new OutputReporterParameter("format");
        paramList.add((Object)this.reporterParam_);
        paramList.addAll(Arrays.asList(this.reporterParam_.getReporterParameters()));
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    public String getPurpose() {
        return "Validates DataLink documents";
    }

    public Parameter<?>[] getParameters() {
        return this.params_;
    }

    public Executable createExecutable(Environment env) throws TaskException {
        Runnable runner;
        String loc = this.locParam_.stringValue(env);
        final OutputReporter reporter = (OutputReporter)this.reporterParam_.objectValue(env);
        DatalinkVersion version = (DatalinkVersion)this.versionParam_.objectValue(env);
        final DatalinkValidator validator = new DatalinkValidator(reporter, version);
        if ("-".equals(loc)) {
            runner = new Runnable(){

                @Override
                public void run() {
                    BufferedInputStream in = new BufferedInputStream(System.in);
                    validator.validateDatalink(in);
                }
            };
        } else {
            final URL url = DatalinkLint.toUrl(loc);
            if (url == null) {
                throw new ParameterValueException(this.locParam_, "No such file or URL: " + loc);
            }
            String proto = url.getProtocol();
            final boolean isDatalinkService = proto.equalsIgnoreCase("http") || proto.equalsIgnoreCase("https");
            boolean mustSucceed = true;
            runner = new Runnable(){

                @Override
                public void run() {
                    validator.validateDatalink(url, isDatalinkService, true);
                }
            };
        }
        final String[] announcements = this.getAnnouncements();
        return new Executable(){

            public void execute() {
                reporter.start(announcements);
                String uaToken = UserAgentUtil.COMMENT_TEST;
                UserAgentUtil.pushUserAgentToken((String)uaToken);
                try {
                    runner.run();
                }
                finally {
                    UserAgentUtil.popUserAgentToken((String)uaToken);
                }
                reporter.summariseUnreportedMessages(null);
                reporter.end();
            }
        };
    }

    private String[] getAnnouncements() {
        return new String[]{new StringBuffer().append("This is the STILTS DataLink validator, ").append(Stilts.getVersion()).append("/").append(Stilts.getStarjavaRevision()).toString()};
    }

    private static URL toUrl(String loc) {
        try {
            return URLUtils.newURL((String)loc);
        }
        catch (MalformedURLException malformedURLException) {
            File f = new File(loc);
            if (f.exists()) {
                return URLUtils.makeFileURL((File)f);
            }
            return null;
        }
    }
}

