/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.TablesInput;

public class FixedTablesInput
implements TablesInput {
    private final InputTableParameter[] inTableParams_;
    private final FilterParameter[] inFilterParams_;
    private final Parameter<?>[] params_;

    public FixedTablesInput(int nIn, boolean useInFilters) {
        int i1;
        int i;
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.inTableParams_ = new InputTableParameter[nIn];
        for (i = 0; i < nIn; ++i) {
            InputTableParameter inParam;
            i1 = i + 1;
            String ord = FixedTablesInput.getOrdinal(i1);
            this.inTableParams_[i] = inParam = new InputTableParameter("in" + i1);
            inParam.setPosition(i1);
            inParam.setUsage("<table" + i1 + ">");
            inParam.setPrompt("Location of " + ord + " input table");
            inParam.setTableDescription("the " + ord + " input table");
            paramList.add((Object)inParam);
            paramList.add(inParam.getFormatParameter());
        }
        this.inFilterParams_ = new FilterParameter[nIn];
        if (useInFilters) {
            for (i = 0; i < nIn; ++i) {
                i1 = i + 1;
                FilterParameter fp = new FilterParameter("icmd" + i1);
                String ord = FixedTablesInput.getOrdinal(i1);
                fp.setTableDescription("the " + ord + " input table", this.inTableParams_[i], Boolean.TRUE);
                this.inFilterParams_[i] = fp;
                paramList.add(fp);
            }
        }
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    @Override
    public Parameter<?>[] getParameters() {
        return this.params_;
    }

    @Override
    public InputTableSpec[] getInputSpecs(Environment env) throws TaskException {
        int nIn = this.inTableParams_.length;
        InputTableSpec[] specs = new InputTableSpec[nIn];
        for (int i = 0; i < nIn; ++i) {
            InputTableParameter tableParam = this.inTableParams_[i];
            FilterParameter filterParam = this.inFilterParams_[i];
            specs[i] = InputTableSpec.createSpec(tableParam.stringValue(env), filterParam == null ? null : filterParam.stepsValue(env), tableParam.tableValue(env));
        }
        return specs;
    }

    public InputTableParameter getInputTableParameter(int i) {
        return this.inTableParams_[i];
    }

    @Override
    public FilterParameter getFilterParameter(int i) {
        return this.inFilterParams_[i];
    }

    private static String getOrdinal(int i) {
        switch (i) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
            case 4: {
                return "fourth";
            }
            case 5: {
                return "fifth";
            }
        }
        return "next";
    }
}

