/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.JELTable;
import uk.ac.starlink.ttools.mode.CubeMode;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.layer.BinMapper;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.CombinedColumn;
import uk.ac.starlink.ttools.task.CombinerParameter;
import uk.ac.starlink.ttools.task.RowRunnerParameter;
import uk.ac.starlink.ttools.task.SingleMapperTask;
import uk.ac.starlink.ttools.task.SingleTableMapping;
import uk.ac.starlink.ttools.task.StringMultiParameter;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.ttools.task.WordsParameter;

public class GridDensityMap
extends SingleMapperTask {
    private final WordsParameter<String> coordsParam_;
    private final WordsParameter<double[]> boundsParam_;
    private final WordsParameter<Boolean> logsParam_;
    private final WordsParameter<Double> binsizeParam_;
    private final WordsParameter<Integer> nbinParam_;
    private final StringMultiParameter quantsParam_;
    private final CombinerParameter combinerParam_;
    private final BooleanParameter sparseParam_;
    private final RowRunnerParameter runnerParam_;

    public GridDensityMap() {
        super("Calculates N-dimensional density maps", new ChoiceMode(), true, true);
        String quantsName = "cols";
        this.coordsParam_ = WordsParameter.createStringWordsParameter("coords");
        this.coordsParam_.setWordUsage("<expr>");
        this.coordsParam_.setPrompt("Coordinate for each dimension");
        this.coordsParam_.setDescription(new String[]{"<p>Defines the dimensions of the grid over which", "accumulation will take place.", "The form of this value is a space-separated list of words", "each giving a column name or", "<ref id='jel'>algebraic expression</ref>", "defining one of the dimensions of the output grid.", "For a 1-dimensional histogram, only one value is required.", "</p>"});
        String requireDimCount = String.join((CharSequence)"\n", "<p>If supplied, this parameter must have the same number of words", "as the <code>" + this.coordsParam_.getName() + "</code> parameter.", "</p>", "");
        this.logsParam_ = WordsParameter.createBooleanWordsParameter("logs");
        this.logsParam_.setWordUsage("true|false");
        this.logsParam_.setPrompt("Log flag for each dimension");
        this.logsParam_.setNullPermitted(true);
        this.logsParam_.setDescription(new String[]{"<p>Determines whether each coordinate axis is linear or", "logarithmic.", "By default the grid axes are linear, but if this parameter", "is supplied with one or more true values,", "the bins on the corresponding axes are assigned logarithmically", "instead.", "</p>", requireDimCount});
        this.boundsParam_ = CubeMode.createBoundsParameter("bounds");
        this.boundsParam_.setNullPermitted(true);
        this.boundsParam_.setStringDefault(null);
        this.boundsParam_.setWordUsage("[<lo>]:[<hi>]");
        this.boundsParam_.setPrompt("Data bounds for each dimension");
        this.boundsParam_.setDescription(new String[]{"<p>Gives the bounds for each dimension of the cube in data", "coordinates.  The form of the value is a space-separated list", "of words, each giving an optional lower bound, then a colon,", "then an optional upper bound, for instance", "\"1:100 0:20\" to represent a range for two-dimensional output", "between 1 and 100 of the first coordinate (table column)", "and between 0 and 20 for the second.", "Either or both numbers may be omitted to indicate that the", "bounds should be determined automatically by assessing the", "range of the data in the table.", "A null value for the parameter indicates that all bounds should", "be determined automatically for all the dimensions.", "</p>", "<p>If any of the bounds need to be determined automatically", "in this way, two passes through the data will be required,", "the first to determine bounds and the second", "to calculate the map.", "</p>", requireDimCount});
        String binsizeName = "binsizes";
        String nbinName = "nbins";
        this.binsizeParam_ = WordsParameter.createDoubleWordsParameter(binsizeName);
        this.binsizeParam_.setWordUsage("<size>");
        this.binsizeParam_.setNullPermitted(true);
        this.binsizeParam_.setPrompt("Extent of bins in each dimension");
        this.binsizeParam_.setDescription(new String[]{"<p>Gives the extent of of the data bins in each", "dimension in data coordinates.", "The form of the value is a space-separated list of values,", "giving a list of extents for the first, second, ... dimension.", "Either this parameter or the <code>" + nbinName + "</code>", "parameter must be supplied.", "</p>", requireDimCount});
        this.nbinParam_ = WordsParameter.createIntegerWordsParameter(nbinName);
        this.nbinParam_.setWordUsage("<num>");
        this.nbinParam_.setNullPermitted(true);
        this.nbinParam_.setPrompt("Number of bins in each dimension");
        this.nbinParam_.setDescription(new String[]{"<p>Gives the approximate number of bins in each dimension.", "The form of the value is a space-separated list of integers,", "giving the number of bins for the output histogram in the", "first, second, ... dimension.", "An attempt is made to use round numbers for bin sizes", "so the bin counts may not be exactly as specified.", "Either this parameter or the <code>" + binsizeName + "</code>", "parameter must be supplied.", "</p>", requireDimCount});
        this.combinerParam_ = new CombinerParameter("combine");
        this.combinerParam_.setDescription(new String[]{"<p>Defines the default way that values contributing", "to the same density map bin", "are combined together to produce the value assigned to that bin.", "Possible values are:", this.combinerParam_.getOptionsDescription(), "</p>", "<p>Note this value may be overridden on a per-column basis", "by the <code>cols</code> parameter.", "</p>"});
        this.combinerParam_.setDefaultOption(Combiner.MEAN);
        this.sparseParam_ = new BooleanParameter("sparse");
        this.sparseParam_.setPrompt("Omit rows for empty cells?");
        this.sparseParam_.setDescription(new String[]{"<p>Determines whether a row is written for every cell in the", "defined grid, or only for those cells in which data appears", "in the input.", "The result will usually be more compact if this is set false,", "but if you want to compare results from different runs", "it may be convenient to set it true.", "</p>"});
        this.sparseParam_.setBooleanDefault(true);
        this.quantsParam_ = CombinedColumn.createCombinedColumnsParameter("cols", this.combinerParam_);
        String quantsDflt = "1;count;COUNT";
        this.quantsParam_.setStringDefault(quantsDflt);
        this.quantsParam_.setDescription(this.quantsParam_.getDescription() + String.join((CharSequence)"\n", "<p>The default value is \"<code>" + quantsDflt + "</code>\"", "which simply provides an unweighted histogram,", "i.e. a count of the rows in each bin", "(aggregation of the value \"<code>1</code>\" using the", "combination method \"<code>count</code>\",", "yielding an output column named \"<code>COUNT</code>\").", "</p>", ""));
        this.runnerParam_ = RowRunnerParameter.createScanRunnerParameter("runner");
        this.getParameterList().addAll(Arrays.asList(new Parameter[]{this.coordsParam_, this.logsParam_, this.boundsParam_, this.binsizeParam_, this.nbinParam_, this.quantsParam_, this.combinerParam_, this.sparseParam_, this.runnerParam_}));
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        int[] nbins;
        double[] binsizes;
        String[] coordExprs = this.coordsParam_.wordsValue(env);
        int ndim = coordExprs.length;
        this.boundsParam_.setRequiredWordCount(ndim);
        this.logsParam_.setRequiredWordCount(ndim);
        this.binsizeParam_.setRequiredWordCount(ndim);
        this.nbinParam_.setRequiredWordCount(ndim);
        Boolean[] logFlags = this.logsParam_.wordsValue(env);
        Scale[] scales = new Scale[ndim];
        for (int idim = 0; idim < ndim; ++idim) {
            boolean isLog = logFlags != null && Boolean.TRUE.equals(logFlags[idim]);
            scales[idim] = isLog ? Scale.LOG : Scale.LINEAR;
        }
        double[][] boundsWords = this.boundsParam_.wordsValue(env);
        double[] loBounds = new double[ndim];
        double[] hiBounds = new double[ndim];
        if (boundsWords != null) {
            for (int i = 0; i < ndim; ++i) {
                double[] bounds = boundsWords[i];
                loBounds[i] = bounds[0];
                hiBounds[i] = bounds[1];
            }
        } else {
            Arrays.fill(loBounds, Double.NaN);
            Arrays.fill(hiBounds, Double.NaN);
        }
        Double[] binsizeWords = this.binsizeParam_.wordsValue(env);
        if (binsizeWords != null) {
            binsizes = new double[ndim];
            for (int i = 0; i < ndim; ++i) {
                binsizes[i] = binsizeWords[i];
                if (binsizes[i] > 0.0) continue;
                throw new ParameterValueException(this.binsizeParam_, "Non-positive value");
            }
            nbins = null;
        } else {
            this.nbinParam_.setNullPermitted(false);
            Integer[] nbinWords = this.nbinParam_.wordsValue(env);
            nbins = new int[ndim];
            for (int i = 0; i < ndim; ++i) {
                nbins[i] = nbinWords[i];
                if (nbins[i] > 0) continue;
                throw new ParameterValueException(this.nbinParam_, "Non-positive value");
            }
            binsizes = null;
        }
        String[] quants = this.quantsParam_.stringsValue(env);
        Combiner dfltCombiner = (Combiner)this.combinerParam_.objectValue(env);
        ArrayList<CombinedColumn> qcList = new ArrayList<CombinedColumn>();
        for (String quantity : quants) {
            CombinedColumn parsedCol = CombinedColumn.parseSpecification(env, quantity, this.quantsParam_, this.combinerParam_);
            String expr = parsedCol.getExpression();
            Combiner qCombiner = parsedCol.getCombiner();
            Combiner combiner = qCombiner == null ? dfltCombiner : qCombiner;
            String qName = parsedCol.getName();
            String label = qName == null ? expr.replaceAll("\\s+", "").replaceAll("[^0-9A-Za-z]+", "_") : qName;
            qcList.add(new CombinedColumn(expr, combiner, label));
        }
        RowRunner runner = (RowRunner)this.runnerParam_.objectValue(env);
        boolean isSparse = this.sparseParam_.booleanValue(env);
        final GridMapMapping mapping = new GridMapMapping(coordExprs, scales, loBounds, hiBounds, nbins, binsizes, qcList.toArray(new CombinedColumn[0]), isSparse, runner);
        final TableProducer inProd = this.createInputProducer(env);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException, TaskException {
                return mapping.map(inProd.getTable());
            }
        };
    }

    private static class BinsCollector
    extends RowCollector<List<Map<BinKey, Combiner.Container>>> {
        private final BinMapper[] binMappers_;
        private final Combiner[] qCombiners_;
        private final DoublePredicate[] coordTests_;
        private final int ndim_;
        private final int nq_;

        BinsCollector(BinMapper[] binMappers, Scale[] scales, Combiner[] qCombiners, double[] loBounds, double[] hiBounds) {
            this.binMappers_ = binMappers;
            this.qCombiners_ = qCombiners;
            this.ndim_ = binMappers.length;
            this.nq_ = qCombiners.length;
            this.coordTests_ = new DoublePredicate[this.ndim_];
            for (int idim = 0; idim < this.ndim_; ++idim) {
                double[] hiBin;
                BinMapper mapper = binMappers[idim];
                Scale scale = scales[idim];
                double blo = loBounds[idim];
                double bhi = hiBounds[idim];
                double dlo = Double.isNaN(blo) ? Double.NaN : BinsCollector.getPointBinLimits(mapper, blo)[0];
                double dhi = Double.isNaN(bhi) ? Double.NaN : (bhi == (hiBin = BinsCollector.getPointBinLimits(mapper, bhi))[0] ? hiBin[0] : hiBin[1]);
                this.coordTests_[idim] = BinsCollector.createCoordTest(dlo, dhi, scale);
            }
        }

        public List<Map<BinKey, Combiner.Container>> createAccumulator() {
            ArrayList<Map<BinKey, Combiner.Container>> qMaps = new ArrayList<Map<BinKey, Combiner.Container>>(this.nq_);
            for (int iq = 0; iq < this.nq_; ++iq) {
                qMaps.add(new HashMap());
            }
            return qMaps;
        }

        public List<Map<BinKey, Combiner.Container>> combine(List<Map<BinKey, Combiner.Container>> qMaps1, List<Map<BinKey, Combiner.Container>> qMaps2) {
            ArrayList<Map<BinKey, Combiner.Container>> result = new ArrayList<Map<BinKey, Combiner.Container>>(this.nq_);
            for (int iq = 0; iq < this.nq_; ++iq) {
                boolean big1 = qMaps1.get(iq).size() >= qMaps2.get(iq).size();
                Map<BinKey, Combiner.Container> mapA = (big1 ? qMaps1 : qMaps2).get(iq);
                Map<BinKey, Combiner.Container> mapB = (big1 ? qMaps2 : qMaps1).get(iq);
                for (Map.Entry<BinKey, Combiner.Container> entryB : mapB.entrySet()) {
                    BinKey key = entryB.getKey();
                    Combiner.Container valB = entryB.getValue();
                    Combiner.Container valA = mapA.get(key);
                    if (valA == null) {
                        mapA.put(key, valB);
                        continue;
                    }
                    valA.add(valB);
                }
                result.add(mapA);
            }
            return result;
        }

        public void accumulateRows(RowSplittable rseq, List<Map<BinKey, Combiner.Container>> qMaps) throws IOException {
            while (rseq.next()) {
                BinKey binKey = this.getBinKey((RowSequence)rseq);
                if (binKey == null) continue;
                for (int iq = 0; iq < this.nq_; ++iq) {
                    double dq;
                    Object qObj = rseq.getCell(this.ndim_ + iq);
                    if (!(qObj instanceof Number) || Double.isNaN(dq = ((Number)qObj).doubleValue())) continue;
                    Combiner combiner = this.qCombiners_[iq];
                    qMaps.get(iq).computeIfAbsent(binKey, k -> combiner.createContainer()).submit(dq);
                }
            }
        }

        private BinKey getBinKey(RowSequence rseq) throws IOException {
            int[] ibins = new int[this.ndim_];
            for (int idim = 0; idim < this.ndim_; ++idim) {
                int ix;
                double dc;
                Object cObj = rseq.getCell(idim);
                if (cObj instanceof Number) {
                    dc = ((Number)cObj).doubleValue();
                    if (!this.coordTests_[idim].test(dc)) {
                        return null;
                    }
                } else {
                    return null;
                }
                ibins[idim] = ix = this.binMappers_[idim].getBinIndex(dc);
            }
            return new BinKey(ibins);
        }

        private static double[] getPointBinLimits(BinMapper mapper, double dval) {
            return Double.isNaN(dval) ? null : mapper.getBinLimits(mapper.getBinIndex(dval));
        }

        private static DoublePredicate createCoordTest(double loBound, double hiBound, Scale scale) {
            boolean hasHi;
            boolean hasLo = !Double.isNaN(loBound);
            boolean bl = hasHi = !Double.isNaN(hiBound);
            if (hasLo && hasHi) {
                return d -> d >= loBound && d < hiBound;
            }
            if (hasLo) {
                return d -> d >= loBound;
            }
            if (hasHi) {
                return scale.isPositiveDefinite() ? d -> d < hiBound && d > 0.0 : d -> d < hiBound;
            }
            return scale.isPositiveDefinite() ? d -> d > 0.0 : d -> !Double.isNaN(d);
        }
    }

    private static class RangeCollector
    extends RowCollector<Range[]> {
        final int ndim_;

        RangeCollector(int ndim) {
            this.ndim_ = ndim;
        }

        public Range[] createAccumulator() {
            Range[] ranges = new Range[this.ndim_];
            for (int i = 0; i < this.ndim_; ++i) {
                ranges[i] = new Range();
            }
            return ranges;
        }

        public Range[] combine(Range[] ranges0, Range[] ranges1) {
            for (int i = 0; i < this.ndim_; ++i) {
                ranges0[i].extend(ranges1[i]);
            }
            return ranges1;
        }

        public void accumulateRows(RowSplittable rseq, Range[] ranges) throws IOException {
            while (rseq.next()) {
                for (int i = 0; i < this.ndim_; ++i) {
                    Object obj = rseq.getCell(i);
                    if (!(obj instanceof Number)) continue;
                    ranges[i].submit(((Number)obj).doubleValue());
                }
            }
        }
    }

    private static class GridTable
    extends ColumnStarTable {
        private final BinMapper[] binMappers_;
        private final Scale[] scales_;
        private final CombinedColumn[] qcols_;
        private final ColumnInfo[] cqInfos_;
        private final List<Map<BinKey, Combiner.Container>> qMaps_;
        private final RowControl rowControl_;

        GridTable(BinMapper[] binMappers, Scale[] scales, CombinedColumn[] qcols, ColumnInfo[] cqInfos, List<Map<BinKey, Combiner.Container>> qMaps, RowControl rowControl) {
            this.binMappers_ = binMappers;
            this.scales_ = scales;
            this.qcols_ = qcols;
            this.cqInfos_ = cqInfos;
            this.qMaps_ = qMaps;
            this.rowControl_ = rowControl;
        }

        public long getRowCount() {
            return this.rowControl_.getRowCount();
        }

        void addCoordColumn(final int icoord, final double frac, String nameSuffix, String descripSuffix, String secondaryUcd) {
            String ucd;
            ColumnInfo info = new ColumnInfo((ValueInfo)this.cqInfos_[icoord]);
            info.setContentClass(Double.class);
            if (nameSuffix != null) {
                info.setName(info.getName() + nameSuffix);
            }
            if (descripSuffix != null) {
                String descrip = info.getDescription();
                if (descrip == null || descrip.trim().length() == 0) {
                    descrip = "Coordinate";
                }
                info.setDescription(descrip + descripSuffix);
            }
            if (secondaryUcd != null && (ucd = info.getUCD()) != null) {
                info.setUCD(ucd + ";" + secondaryUcd);
            }
            final BinMapper binMapper = this.binMappers_[icoord];
            this.addColumn(new ColumnData(info){

                public Double readValue(long lrow) {
                    int ibin = ((GridTable)this).rowControl_.getBinKey((long)lrow).ibins_[icoord];
                    double[] limits = binMapper.getBinLimits(ibin);
                    double dval = PlotUtil.scaleValue(limits[0], limits[1], frac, scales_[icoord]);
                    return dval;
                }
            });
        }

        void addQuantityColumn(int iq) {
            DoubleFunction<Number> dataFunc;
            int ndim = this.binMappers_.length;
            CombinedColumn qcol = this.qcols_[iq];
            ValueInfo cInfo = qcol.getCombiner().createCombinedInfo((ValueInfo)this.cqInfos_[ndim + iq], null);
            DefaultValueInfo dInfo = new DefaultValueInfo(cInfo);
            dInfo.setName(qcol.getName());
            Class dataClazz = dInfo.getContentClass();
            if (Integer.class.equals((Object)dataClazz)) {
                dataFunc = d -> (int)d;
            } else if (Short.class.equals((Object)dataClazz)) {
                dataFunc = d -> (short)d;
            } else if (Long.class.equals((Object)dataClazz)) {
                dataFunc = d -> (long)d;
            } else {
                assert (Double.class.equals((Object)dataClazz));
                dataFunc = d -> d;
            }
            final Map<BinKey, Combiner.Container> qMap = this.qMaps_.get(iq);
            this.addColumn(new ColumnData((ValueInfo)dInfo){

                public Object readValue(long lrow) {
                    BinKey binKey = rowControl_.getBinKey(lrow);
                    Combiner.Container container = (Combiner.Container)qMap.get(binKey);
                    if (container == null) {
                        return null;
                    }
                    double dval = container.getCombinedValue();
                    return Double.isNaN(dval) ? null : dataFunc.apply(dval);
                }
            });
        }
    }

    private static interface RowControl {
        public long getRowCount();

        public BinKey getBinKey(long var1);
    }

    private static class BinKey {
        final int[] ibins_;

        BinKey(int[] ibins) {
            this.ibins_ = ibins;
        }

        public int hashCode() {
            return Arrays.hashCode(this.ibins_);
        }

        public boolean equals(Object other) {
            return other instanceof BinKey && Arrays.equals(this.ibins_, ((BinKey)other).ibins_);
        }
    }

    private static class GridMapMapping
    implements SingleTableMapping {
        final String[] coordExprs_;
        final Scale[] scales_;
        final double[] loBounds_;
        final double[] hiBounds_;
        final int[] nbins_;
        final double[] binSizes_;
        final CombinedColumn[] qcols_;
        final boolean isSparse_;
        final RowRunner rowRunner_;
        final int ndim_;
        final int nq_;

        GridMapMapping(String[] coordExprs, Scale[] scales, double[] loBounds, double[] hiBounds, int[] nbins, double[] binSizes, CombinedColumn[] qcols, boolean isSparse, RowRunner rowRunner) {
            this.coordExprs_ = coordExprs;
            this.scales_ = scales;
            this.loBounds_ = loBounds;
            this.hiBounds_ = hiBounds;
            this.nbins_ = nbins;
            this.binSizes_ = binSizes;
            this.qcols_ = qcols;
            this.isSparse_ = isSparse;
            this.rowRunner_ = rowRunner;
            this.ndim_ = coordExprs.length;
            this.nq_ = qcols.length;
        }

        @Override
        public StarTable map(StarTable inTable) throws IOException, TaskException {
            int idim;
            StarTable cqTable;
            String[] qExprs = new String[this.nq_];
            Combiner[] qCombiners = new Combiner[this.nq_];
            for (int iq = 0; iq < this.nq_; ++iq) {
                CombinedColumn qcol = this.qcols_[iq];
                qExprs[iq] = qcol.getExpression();
                qCombiners[iq] = qcol.getCombiner();
            }
            String[] exprs = new String[this.ndim_ + this.nq_];
            System.arraycopy(this.coordExprs_, 0, exprs, 0, this.ndim_);
            System.arraycopy(qExprs, 0, exprs, this.ndim_, this.nq_);
            try {
                cqTable = JELTable.createJELTable(inTable, exprs);
            }
            catch (CompilationException e) {
                throw new TaskException("Bad expression: " + e.getMessage(), (Throwable)e);
            }
            for (int ic = 0; ic < this.ndim_ + this.nq_; ++ic) {
                ColumnInfo info = cqTable.getColumnInfo(ic);
                if (Number.class.isAssignableFrom(info.getContentClass())) continue;
                String msg = (ic < this.ndim_ ? "Coordinate " : "Quantity ") + info.getName() + " is not numeric";
                throw new TaskException(msg);
            }
            BinMapper[] binMappers = this.createBinMappers(cqTable);
            List qMaps = (List)this.rowRunner_.collect((RowCollector)new BinsCollector(binMappers, this.scales_, qCombiners, this.loBounds_, this.hiBounds_), cqTable);
            RowControl rowControl = this.createRowControl(binMappers, qMaps);
            GridTable outTable = new GridTable(binMappers, this.scales_, this.qcols_, Tables.getColumnInfos((StarTable)cqTable), qMaps, rowControl);
            for (idim = 0; idim < this.ndim_; ++idim) {
                outTable.addCoordColumn(idim, 0.5, null, ", central position", null);
            }
            for (int iq = 0; iq < this.nq_; ++iq) {
                outTable.addQuantityColumn(iq);
            }
            for (idim = 0; idim < this.ndim_; ++idim) {
                outTable.addCoordColumn(idim, 0.0, "_lo", ", lower bound", "stat.min");
                outTable.addCoordColumn(idim, 1.0, "_hi", ", upper bound", "stat.max");
            }
            return outTable;
        }

        private BinMapper[] createBinMappers(StarTable cqTable) throws IOException {
            BinMapper[] mappers = new BinMapper[this.ndim_];
            if (this.binSizes_ != null) {
                for (int idim = 0; idim < this.ndim_; ++idim) {
                    Scale scale = this.scales_[idim];
                    double binPoint = this.getExampleCoordinate(cqTable, idim);
                    double binSize = this.binSizes_[idim];
                    double binPhase = this.getBinPhase(binSize, idim);
                    mappers[idim] = new BinMapper(scale, binSize, binPhase, binPoint);
                }
                return mappers;
            }
            Range[] ranges = this.hasAllBounds() ? null : (Range[])this.rowRunner_.collect((RowCollector)new RangeCollector(this.ndim_), cqTable);
            for (int idim = 0; idim < this.ndim_; ++idim) {
                Scale scale = this.scales_[idim];
                boolean posdef = scale.isPositiveDefinite();
                double lo = Double.isNaN(this.loBounds_[idim]) ? ranges[idim].getFiniteBounds(posdef)[0] : this.loBounds_[idim];
                double hi = Double.isNaN(this.hiBounds_[idim]) ? ranges[idim].getFiniteBounds(posdef)[1] : this.hiBounds_[idim];
                double binSize = BinSizer.createCountBinSizer(this.nbins_[idim]).getScaleWidth(scale, lo, hi, true);
                double binPhase = this.getBinPhase(binSize, idim);
                mappers[idim] = new BinMapper(scale, binSize, binPhase, lo);
            }
            return mappers;
        }

        private double getExampleCoordinate(StarTable cqTable, int idim) throws IOException {
            if (!Double.isNaN(this.loBounds_[idim])) {
                return this.loBounds_[idim];
            }
            if (!Double.isNaN(this.hiBounds_[idim])) {
                return this.hiBounds_[idim];
            }
            try (RowSequence rseq = cqTable.getRowSequence();){
                while (rseq.next()) {
                    Double dval;
                    Object obj = rseq.getCell(idim);
                    if (!(obj instanceof Number) || Double.isNaN(dval = Double.valueOf(((Number)obj).doubleValue())) || this.scales_[idim].isPositiveDefinite() && !(dval > 0.0)) continue;
                    double d = dval;
                    return d;
                }
            }
            throw new IOException("No data for dimension " + idim);
        }

        private double getBinPhase(double binSize, int idim) {
            double dpoint;
            if (!Double.isNaN(this.loBounds_[idim])) {
                dpoint = this.loBounds_[idim];
            } else if (!Double.isNaN(this.hiBounds_[idim])) {
                dpoint = this.hiBounds_[idim];
            } else {
                return 0.0;
            }
            Scale scale = this.scales_[idim];
            double phase = scale.dataToScale(dpoint) % binSize / scale.dataToScale(binSize);
            if (phase < 0.0) {
                phase += 1.0;
            }
            assert (phase >= 0.0 && phase <= 1.0);
            return phase;
        }

        private boolean hasAllBounds() {
            for (int idim = 0; idim < this.ndim_; ++idim) {
                if (!Double.isNaN(this.loBounds_[idim]) && !Double.isNaN(this.hiBounds_[idim])) continue;
                return false;
            }
            return true;
        }

        private RowControl createRowControl(BinMapper[] binMappers, List<Map<BinKey, Combiner.Container>> qMaps) {
            if (this.isSparse_) {
                final BinKey[] keys = this.getAllKeys(qMaps).toArray(new BinKey[0]);
                Arrays.sort(keys, new Comparator<BinKey>(){

                    @Override
                    public int compare(BinKey k1, BinKey k2) {
                        int[] ibins1 = k1.ibins_;
                        int[] ibins2 = k2.ibins_;
                        for (int idim = 0; idim < ndim_; ++idim) {
                            int ibin1 = ibins1[idim];
                            int ibin2 = ibins2[idim];
                            if (ibin1 < ibin2) {
                                return -1;
                            }
                            if (ibin1 > ibin2) {
                                return 1;
                            }
                            assert (ibin1 == ibin2);
                        }
                        return 0;
                    }
                });
                return new RowControl(){

                    @Override
                    public long getRowCount() {
                        return keys.length;
                    }

                    @Override
                    public BinKey getBinKey(long lrow) {
                        return keys[(int)lrow];
                    }
                };
            }
            final int[] loIbins = new int[this.ndim_];
            final int[] hiIbins = new int[this.ndim_];
            if (!this.hasAllBounds()) {
                Arrays.fill(loIbins, Integer.MAX_VALUE);
                Arrays.fill(hiIbins, Integer.MIN_VALUE);
                for (BinKey key : this.getAllKeys(qMaps)) {
                    for (int idim = 0; idim < this.ndim_; ++idim) {
                        int ibin = key.ibins_[idim];
                        loIbins[idim] = Math.min(loIbins[idim], ibin);
                        hiIbins[idim] = Math.max(hiIbins[idim], ibin);
                    }
                }
            }
            for (int idim = 0; idim < this.ndim_; ++idim) {
                BinMapper binMapper = binMappers[idim];
                double loBound = this.loBounds_[idim];
                double hiBound = this.hiBounds_[idim];
                if (!Double.isNaN(loBound)) {
                    loIbins[idim] = binMapper.getBinIndex(loBound);
                }
                if (Double.isNaN(hiBound)) continue;
                hiIbins[idim] = binMapper.getBinIndex(hiBound);
            }
            long nr = 1L;
            final int[] nbins = new int[this.ndim_];
            for (int idim = 0; idim < this.ndim_; ++idim) {
                nbins[idim] = hiIbins[idim] - loIbins[idim] + 1;
                nr *= (long)nbins[idim];
            }
            final long nrow = nr;
            return new RowControl(){

                @Override
                public long getRowCount() {
                    return nrow;
                }

                @Override
                public BinKey getBinKey(long lrow) {
                    int[] ibins = new int[ndim_];
                    long lr = lrow;
                    for (int idim = ndim_ - 1; idim >= 0; --idim) {
                        int nb = nbins[idim];
                        int ib = (int)(lr % (long)nb);
                        if (ib < 0) {
                            ib += nb;
                        }
                        assert (ib >= 0 && ib < nb);
                        ibins[idim] = ib + loIbins[idim];
                        assert (ibins[idim] >= loIbins[idim] && ibins[idim] <= hiIbins[idim]);
                        lr /= (long)nb;
                    }
                    return new BinKey(ibins);
                }
            };
        }

        private Set<BinKey> getAllKeys(List<Map<BinKey, Combiner.Container>> qMaps) {
            if (qMaps.size() == 1) {
                return Collections.unmodifiableSet(qMaps.get(0).keySet());
            }
            HashSet<BinKey> keySet = new HashSet<BinKey>();
            for (Map<BinKey, Combiner.Container> qMap : qMaps) {
                keySet.addAll(qMap.keySet());
            }
            return keySet;
        }
    }
}

