/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.task.TableConsumerParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;
import uk.ac.starlink.ttools.task.TableProducer;

public class MapEnvironment
implements TableEnvironment {
    private final Map<String, Object> paramMap_;
    private final Map<String, StarTable> outputTables_ = new LinkedHashMap<String, StarTable>();
    private final ByteArrayOutputStream out_ = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err_ = new ByteArrayOutputStream();
    private final PrintStream pout_ = new PrintStream(this.out_);
    private final PrintStream perr_ = new PrintStream(this.err_);
    private final Set<String> usedNames_ = new HashSet<String>();
    private Class<?> resourceBase_ = MapEnvironment.class;
    private StarTableFactory tfact_;
    private StarTableOutput tout_;
    private boolean strictVot_;
    private boolean debug_;

    public MapEnvironment() {
        this(new LinkedHashMap<String, Object>());
    }

    public MapEnvironment(Map<String, Object> map) {
        this.paramMap_ = map;
    }

    public MapEnvironment(MapEnvironment env) {
        this(new LinkedHashMap<String, Object>(env.paramMap_));
        this.resourceBase_ = env.resourceBase_;
        this.debug_ = env.debug_;
        this.strictVot_ = env.strictVot_;
    }

    public PrintStream getOutputStream() {
        return this.pout_;
    }

    public PrintStream getErrorStream() {
        return this.perr_;
    }

    public void clearValue(Parameter<?> param) {
        throw new UnsupportedOperationException();
    }

    public String[] getNames() {
        return this.paramMap_.keySet().toArray(new String[0]);
    }

    public Map<String, Object> getMap() {
        return this.paramMap_;
    }

    public String getOutputText() {
        this.pout_.flush();
        return new String(this.out_.toByteArray());
    }

    public String[] getOutputLines() {
        String text = this.getOutputText();
        return text.length() == 0 ? new String[]{} : text.split("\\n");
    }

    public String getErrorText() {
        this.perr_.flush();
        return new String(this.err_.toByteArray());
    }

    public String[] getErrorLines() {
        String text = this.getErrorText();
        return text.length() == 0 ? new String[]{} : text.split("\\n");
    }

    public MapEnvironment setValue(String paramName, Object value) {
        this.paramMap_.put(paramName, value);
        return this;
    }

    public MapEnvironment setResourceBase(Class<?> clazz) {
        this.resourceBase_ = clazz;
        return this;
    }

    public StarTable getOutputTable(String paramName) {
        return this.outputTables_.get(paramName);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void acquireValue(Parameter<?> param) throws TaskException {
        void var4_9;
        final String pname = param.getName();
        Class pclazz = param.getValueClass();
        if (!this.paramMap_.containsKey(pname)) {
            if (param instanceof TableConsumerParameter) {
                TableConsumer tableConsumer = new TableConsumer(){

                    @Override
                    public void consume(StarTable table) {
                        MapEnvironment.this.outputTables_.put(pname, table);
                    }
                };
            } else {
                String string = param.getStringDefault();
            }
        } else {
            Object mapVal = this.paramMap_.get(pname);
            if (pclazz.equals(TableProducer[].class) && mapVal instanceof StarTable[]) {
                StarTable[] tables = (StarTable[])mapVal;
                int nTable = tables.length;
                TableProducer[] tablePs = new TableProducer[nTable];
                for (int i = 0; i < nTable; ++i) {
                    final StarTable table = tables[i];
                    final String name = "table_" + (i + 1);
                    tablePs[i] = new TableProducer(){

                        @Override
                        public StarTable getTable() {
                            return table;
                        }

                        public String toString() {
                            return name;
                        }
                    };
                }
                TableProducer[] tableProducerArray = tablePs;
            } else if (pclazz.equals(StarTable.class) && mapVal instanceof String && ((String)mapVal).indexOf(47) < 0) {
                URL url;
                String sval = (String)mapVal;
                String frag = "";
                int ihash = sval.indexOf(35);
                if (ihash > 0) {
                    frag = sval.substring(ihash);
                    sval = sval.substring(0, ihash);
                }
                Object object = (url = this.resourceBase_.getResource(sval)) == null ? mapVal : url.toString() + frag;
            } else {
                Object object = mapVal;
            }
        }
        this.usedNames_.add(pname);
        if (var4_9 == null) {
            if (!param.isNullPermitted()) throw new ParameterValueException(param, "No value supplied for non-nullable parameter");
            param.setValueFromString((Environment)this, null);
            return;
        } else if (pclazz.isAssignableFrom(var4_9.getClass())) {
            this.setParamValueFromObject(param, var4_9);
            return;
        } else if (var4_9 instanceof String) {
            param.setValueFromString((Environment)this, (String)var4_9);
            return;
        } else if (pclazz.getComponentType() != null && pclazz.getComponentType().isInstance(var4_9)) {
            Object array = Array.newInstance(pclazz.getComponentType(), 1);
            Array.set(array, 0, var4_9);
            this.setParamValueFromObject(param, array);
            return;
        } else {
            if (!(param instanceof TableConsumerParameter) || !(var4_9 instanceof TableConsumer)) throw new ParameterValueException(param, "Unexpected type " + var4_9.getClass() + " (expecting String or " + pclazz.getName() + ")");
            ((TableConsumerParameter)param).setValueFromConsumer(this, (TableConsumer)var4_9);
        }
    }

    @Override
    public synchronized StarTableFactory getTableFactory() {
        if (this.tfact_ == null) {
            this.tfact_ = new StarTableFactory();
            Stilts.addStandardSchemes(this.tfact_);
        }
        return this.tfact_;
    }

    @Override
    public synchronized StarTableOutput getTableOutput() {
        if (this.tout_ == null) {
            this.tout_ = new StarTableOutput();
        }
        return this.tout_;
    }

    @Override
    public JDBCAuthenticator getJdbcAuthenticator() {
        return null;
    }

    @Override
    public boolean isDebug() {
        return this.debug_;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug_ = debug;
    }

    @Override
    public boolean isStrictVotable() {
        return this.strictVot_;
    }

    @Override
    public void setStrictVotable(boolean strict) {
        this.strictVot_ = strict;
    }

    public String[] getUnused() {
        ArrayList<String> pnames = new ArrayList<String>(this.paramMap_.keySet());
        pnames.removeAll(this.usedNames_);
        return pnames.toArray(new String[0]);
    }

    private <X> void setParamValueFromObject(Parameter<X> param, Object obj) throws TaskException {
        param.setValueFromObject((Environment)this, param.getValueClass().cast(obj));
    }
}

