/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import uk.ac.starlink.parquet.ParquetDump;
import uk.ac.starlink.parquet.ParquetStarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.MultiChoiceParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.DocUtils;

public class ParquetTool
implements Task {
    private final Parameter<String> locParam_;
    private final MultiChoiceParameter<MetaItem> itemsParam_;
    private final Parameter<?>[] params_;
    private static final String DFLT_TOKEN = "default";
    private static final int MAXCHAR = 75;

    public ParquetTool() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        this.locParam_ = new StringParameter("in");
        this.locParam_.setPosition(1);
        this.locParam_.setPrompt("Location of parquet file");
        this.locParam_.setUsage("<filename>");
        this.locParam_.setDescription(new String[]{"<p>Name of the parquet file to examine.", "</p>"});
        paramList.add(this.locParam_);
        this.itemsParam_ = new MultiChoiceParameter("items", MetaItem.class, ',', (Object[])MetaItem.DFLT_ITEMS, DFLT_TOKEN);
        this.itemsParam_.setStringDefault(DFLT_TOKEN);
        this.itemsParam_.setNullPermitted(true);
        this.itemsParam_.setPrompt("Metadata items to display");
        ArrayList<MetaItem> itemList = new ArrayList<MetaItem>(Arrays.asList(MetaItem.DFLT_ITEMS));
        for (MetaItem extraItem : MetaItem.EXTRA_ITEMS) {
            this.itemsParam_.addOption((Object)extraItem);
            itemList.add(extraItem);
        }
        this.itemsParam_.setDescription(new String[]{"<p>Selects which items of metadata about the parquet file", "to display.  The value is a comma-separated list,", "containing zero or more of the following:", DocUtils.describedList(itemList.toArray(new MetaItem[0]), m -> m.name_, m -> m.description_, false), "If the value is the special token", "\"<code>default</code>\"", "then all the items above", "except for", Arrays.stream(MetaItem.EXTRA_ITEMS).map(m -> "\"<code>" + m + "</code>\"").collect(Collectors.joining(", ")), "will be output.", "If the value is blank then none of these will be output.", "Either way, informational reports will still be written", "as requested.", "</p>", "<p>The text is written to standard output.", "If there are multiple items to display, they are indented", "and presented under headings.", "In the case that there is only one however, it is output", "without adornment.", "</p>"});
        paramList.add(this.itemsParam_);
        this.params_ = paramList.toArray(new Parameter[0]);
    }

    public String getPurpose() {
        return "Presents information about a parquet file";
    }

    public Parameter<?>[] getParameters() {
        return this.params_;
    }

    public Executable createExecutable(Environment env) throws TaskException {
        String loc = this.locParam_.stringValue(env);
        boolean tryUrl = false;
        PrintStream out = env.getOutputStream();
        MetaItem[] items = (MetaItem[])this.itemsParam_.objectValue(env);
        return () -> {
            ParquetStarTable starTable = ParquetDump.readParquetTable((String)loc);
            ParquetDump dump = new ParquetDump(starTable);
            if (items != null && items.length != 0) {
                if (items.length == 1) {
                    String txt = items[0].action_.apply(dump);
                    if (txt != null && txt.trim().length() > 0) {
                        out.println(txt);
                    }
                } else {
                    for (MetaItem item : items) {
                        String txt = item.action_.apply(dump);
                        if (txt == null) {
                            txt = "";
                        }
                        out.println(this.formatLines(item.heading_, txt));
                    }
                }
            }
        };
    }

    private String formatLines(String heading, String lines) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(heading).append(":\n");
        if (lines != null) {
            for (String line : lines.split("[\n\r]+")) {
                sbuf.append("   ").append(line).append('\n');
            }
        }
        return sbuf.toString();
    }

    public static class MetaItem {
        final String name_;
        final String heading_;
        final String description_;
        final Function<ParquetDump, String> action_;
        public static final MetaItem SCHEMA = new MetaItem("schema", "Parquet Schema", "displays the parquet schema", ParquetDump::formatSchema);
        public static final MetaItem KV_COMPACT = new MetaItem("keyvalue", "Key-Value Metadata, compact format", "displays the parquet per-table key-value metadata pairs in a compact format; long or multi-line values are summarised", d -> d.formatKeyValuesCompact(75));
        public static final MetaItem KV_FULL = new MetaItem("keyvaluefull", "Key-Value Metadata, full content", "displays the full content of parquet per-table key-value metadata pairs", ParquetDump::formatKeyValuesFull);
        public static final MetaItem BLOCKS = new MetaItem("blocks", "Data Blocks", "displays information about the parquet data blocks", ParquetDump::formatBlocks);
        public static final MetaItem CHUNKS = new MetaItem("chunks", "Column Chunks", "displays information about the column chunks in the parquet file", ParquetDump::formatColumnChunks);
        public static final MetaItem VOTABLE = new MetaItem("votable", "VOParquet VOTable", "displays the VOTable document providing additional metadata according to the VOParquet convention", dump -> dump.getTable().getVOTableMetadataText());
        public static final MetaItem[] DFLT_ITEMS = new MetaItem[]{SCHEMA, KV_COMPACT, BLOCKS, CHUNKS, VOTABLE};
        public static final MetaItem[] EXTRA_ITEMS = new MetaItem[]{KV_FULL};

        MetaItem(String name, String heading, String description, Function<ParquetDump, String> action) {
            this.name_ = name;
            this.heading_ = heading;
            this.description_ = description;
            this.action_ = action;
        }

        public String toString() {
            return this.name_;
        }
    }
}

