/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.logging.Logger;
import java.util.regex.Pattern;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.StringParameter;

public class SkyCoordParameter
extends StringParameter {
    private static final Pattern RA_REGEX = Pattern.compile("RA_?J?(2000)?", 2);
    private static final Pattern DEC_REGEX = Pattern.compile("DEC?L?_?J?(2000)?", 2);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");

    public SkyCoordParameter(String name, String coordName, String coordSys, String tableDescrip) {
        super(name);
        this.setUsage("<expr>");
        String prompt = coordName + " expression in degrees";
        if (coordSys != null) {
            prompt = prompt + " (" + coordSys + ")";
        }
        this.setPrompt(prompt);
        this.setNullPermitted(true);
        String inSys = coordSys == null ? "" : " in the " + coordSys + " coordinate system";
        this.setDescription(new String[]{"<p>" + coordName + " in degrees" + inSys, "for the position of each row of " + tableDescrip + ".", "This may simply be a column name, or it may be an", "algebraic expression calculated from columns as explained", "in <ref id='jel'/>.", "If left blank, an attempt is made to guess from UCDs,", "column names and unit annotations what expression to use.", "</p>"});
    }

    public static StringParameter createRaParameter(String paramName, String coordSys, String tableDescrip) {
        return new SkyCoordParameter(paramName, "Right ascension", coordSys, tableDescrip);
    }

    public static StringParameter createDecParameter(String paramName, String coordSys, String tableDescrip) {
        return new SkyCoordParameter(paramName, "Declination", coordSys, tableDescrip);
    }

    public static String guessRaDegreesExpression(StarTable inTable) {
        return SkyCoordParameter.guessDegreesExpression(inTable, "ra", RA_REGEX);
    }

    public static String guessDecDegreesExpression(StarTable inTable) {
        return SkyCoordParameter.guessDegreesExpression(inTable, "dec", DEC_REGEX);
    }

    private static String guessDegreesExpression(StarTable inTable, String ucdAtom, Pattern nameRegex) {
        double factor;
        String atom = ucdAtom.toLowerCase();
        String ucd1Part = "pos_eq_" + atom;
        String ucd1Full = ucd1Part + "_main";
        String ucd1pPart = "pos.eq." + atom;
        String ucd1pFull = ucd1pPart + ";meta.main";
        int bestIndex = -1;
        int score = 0;
        int ncol = inTable.getColumnCount();
        for (int i = 0; i < ncol; ++i) {
            ColumnInfo info = inTable.getColumnInfo(i);
            if (!Number.class.isAssignableFrom(info.getContentClass())) continue;
            String ucd = info.getUCD();
            String name = info.getName();
            if (ucd != null && ucd.length() > 0) {
                ucd = ucd.trim().toLowerCase();
                if (score < 20 && (ucd.equals(ucd1Full) || ucd.equals(ucd1pFull))) {
                    bestIndex = i;
                    score = 20;
                }
                if (score < 10 && (ucd.equals(ucd1Part) || ucd.equals(ucd1pPart))) {
                    bestIndex = i;
                    score = 10;
                }
            }
            if (name == null || name.length() <= 0 || score >= 5 || !nameRegex.matcher(name.trim()).matches()) continue;
            bestIndex = i;
            score = 5;
        }
        if (bestIndex < 0) {
            assert (score == 0);
            return null;
        }
        ColumnInfo info = inTable.getColumnInfo(bestIndex);
        logger_.info("Identified column " + info + " as " + ucdAtom.toUpperCase());
        String units = info.getUnitString();
        if (units == null || units.trim().length() == 0) {
            logger_.info("No units listed for column " + info.getName() + " - assuming degrees");
            factor = 1.0;
        } else if (units.toLowerCase().startsWith("deg")) {
            factor = 1.0;
        } else if (units.toLowerCase().startsWith("rad")) {
            factor = 57.29577951308232;
        } else {
            logger_.info("Units for column " + info.getName() + " listed as " + units + " - assuming degrees");
            factor = 1.0;
        }
        String expr = "$" + (bestIndex + 1);
        if (factor != 1.0) {
            expr = factor + "*" + expr;
        }
        logger_.config(ucdAtom.toUpperCase() + ": " + expr);
        return expr;
    }
}

