/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Library;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.HealpixTableInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.cone.HealpixTiling;
import uk.ac.starlink.ttools.cone.SkyTiling;
import uk.ac.starlink.ttools.cone.TilingParameter;
import uk.ac.starlink.ttools.jel.DummyJELRowReader;
import uk.ac.starlink.ttools.jel.JELQuantity;
import uk.ac.starlink.ttools.jel.JELRowReader;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.SequentialJELRowReader;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.BinListCollector;
import uk.ac.starlink.ttools.plot2.layer.BinResultColumnData;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.SolidAngleUnit;
import uk.ac.starlink.ttools.plot2.layer.Unit;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.CombinedColumn;
import uk.ac.starlink.ttools.task.CombinerParameter;
import uk.ac.starlink.ttools.task.RowRunnerParameter;
import uk.ac.starlink.ttools.task.SingleMapperTask;
import uk.ac.starlink.ttools.task.SingleTableMapping;
import uk.ac.starlink.ttools.task.StringMultiParameter;
import uk.ac.starlink.ttools.task.TableProducer;

public class SkyDensityMap
extends SingleMapperTask {
    private final StringParameter lonParam_;
    private final StringParameter latParam_;
    private final TilingParameter tilingParam_;
    private final BooleanParameter countParam_;
    private final StringMultiParameter quantParam_;
    private final CombinerParameter combinerParam_;
    private final ChoiceParameter<SolidAngleUnit> unitParam_;
    private final BooleanParameter completeParam_;
    private final RowRunnerParameter runnerParam_;

    public SkyDensityMap() {
        super("Calculates sky density maps", new ChoiceMode(), true, true);
        String quantName = "cols";
        this.lonParam_ = new StringParameter("lon");
        this.lonParam_.setUsage("<expr/deg>");
        this.lonParam_.setPrompt("Longitude coordinate in input table");
        this.lonParam_.setDescription(new String[]{"<p>Longitude in degrees for the position of each row", "in the input table.", "This may simply be a column name, or it may be", "an algebraic expression as explained in <ref id='jel'/>.", "The sky system used here will determine the", "grid on which the output map is built.", "</p>"});
        this.latParam_ = new StringParameter("lat");
        this.latParam_.setUsage("<expr/deg>");
        this.latParam_.setPrompt("Latitude coordinate in input table");
        this.latParam_.setDescription(new String[]{"<p>Latitude in degrees for the position of each row", "in the input table.", "This may simply be a column name, or it may be", "an algebraic expression as explained in <ref id='jel'/>.", "The sky system used here will determine the", "grid on which the output map is built.", "</p>"});
        this.tilingParam_ = new TilingParameter("tiling");
        this.tilingParam_.setHealpixNestDefault(5);
        this.countParam_ = new BooleanParameter("count");
        this.countParam_.setPrompt("Include count column?");
        this.countParam_.setDescription(new String[]{"<p>Controls whether a COUNT column is added to the output table", "along with any other columns that may have been requested.", "If included, this reports the number of rows from the input table", "that fell within the corresponding bin.", "</p>"});
        this.countParam_.setBooleanDefault(true);
        this.combinerParam_ = new CombinerParameter("combine");
        Object[] units = SolidAngleUnit.getKnownUnits();
        this.unitParam_ = new ChoiceParameter("perunit", units);
        this.combinerParam_.setDescription(new String[]{"<p>Defines the default way that values contributing", "to the same density map bin", "are combined together to produce the value assigned to that bin.", "Possible values are:", this.combinerParam_.getOptionsDescription(), "</p>", "<p>For density-like values", "(<code>" + Combiner.DENSITY + "</code>,", "<code>" + Combiner.WEIGHTED_DENSITY + "</code>)", "the scaling is additionally influenced by the", "<code>" + this.unitParam_.getName() + "</code> parameter.", "</p>", "<p>Note this value may be overridden on a per-column basis", "by the <code>cols</code> parameter.", "</p>"});
        this.combinerParam_.setDefaultOption(Combiner.MEAN);
        this.unitParam_.setPrompt("Solid angle unit for densities");
        StringBuffer ubuf = new StringBuffer();
        for (Object unit : units) {
            ubuf.append("<li>").append("<code>").append(((Unit)unit).getLabel()).append("</code>: ").append(((Unit)unit).getTextName()).append("</li>\n");
        }
        this.unitParam_.setDescription(new String[]{"<p>Defines the unit of sky area used for scaling density-like", "combinations", "(e.g. <code>" + this.combinerParam_.getName() + "</code>=<code>" + Combiner.DENSITY + "</code> or", "<code>" + Combiner.WEIGHTED_DENSITY + "</code>).", "If the combination mode is calculating values per unit area", "this configures the area scale in question.", "For non-density-like combination modes", "(e.g. <code>" + this.combinerParam_.getName() + "</code>=<code>" + Combiner.SUM + "</code> or ", "<code>" + Combiner.MEAN + "</code>)", "it has no effect.", "</p>", "<p>Possible values are:", "<ul>", ubuf.toString(), "</ul>", "</p>"});
        this.unitParam_.setDefaultOption((Object)SolidAngleUnit.DEGREE2);
        this.completeParam_ = new BooleanParameter("complete");
        this.completeParam_.setPrompt("Write row for every pixel?");
        this.completeParam_.setDescription(new String[]{"<p>Determines whether the output table contains a row", "for every pixel in the tiling, or only the rows for", "pixels in which some of the input data fell.", "</p>", "<p>The value of this parameter may affect performance as well", "as output.  If you know that most pixels on the sky will", "be covered, it's probably a good idea to set this true,", "and if you know that only a small patch of sky will be", "covered, it's better to set it false.", "</p>"});
        this.completeParam_.setBooleanDefault(false);
        this.quantParam_ = CombinedColumn.createCombinedColumnsParameter("cols", this.combinerParam_);
        this.runnerParam_ = RowRunnerParameter.createScanRunnerParameter("runner");
        this.getParameterList().addAll(Arrays.asList(new Parameter[]{this.lonParam_, this.latParam_, this.tilingParam_, this.countParam_, this.quantParam_, this.combinerParam_, this.unitParam_, this.completeParam_, this.runnerParam_}));
    }

    @Override
    public TableProducer createProducer(Environment env) throws TaskException {
        int countIndex;
        String lonString = this.lonParam_.stringValue(env);
        String latString = this.latParam_.stringValue(env);
        SkyTiling tiling = (SkyTiling)this.tilingParam_.objectValue(env);
        String[] quants = this.quantParam_.stringsValue(env);
        Combiner dfltCombiner = (Combiner)this.combinerParam_.objectValue(env);
        SolidAngleUnit unit = (SolidAngleUnit)this.unitParam_.objectValue(env);
        boolean complete = this.completeParam_.booleanValue(env);
        ArrayList<AggregateQuantity> aqList = new ArrayList<AggregateQuantity>();
        boolean hasCount = this.countParam_.booleanValue(env);
        RowRunner runner = (RowRunner)this.runnerParam_.objectValue(env);
        if (hasCount) {
            countIndex = aqList.size();
            aqList.add(new AggregateQuantity(Combiner.COUNT, "1"){

                @Override
                public ValueInfo adjustInfo(ValueInfo combInfo) {
                    DefaultValueInfo info = new DefaultValueInfo(combInfo);
                    info.setName("count");
                    info.setDescription("number of input table rows in bin");
                    info.setUnitString(null);
                    return info;
                }
            });
        } else {
            countIndex = -1;
        }
        for (String quantity : quants) {
            CombinedColumn parsedCol = CombinedColumn.parseSpecification(env, quantity, this.quantParam_, this.combinerParam_);
            String expr = parsedCol.getExpression();
            Combiner qCombiner = parsedCol.getCombiner();
            Combiner combiner = qCombiner == null ? dfltCombiner : qCombiner;
            String qName = parsedCol.getName();
            final String label = qName == null ? expr.replaceAll("\\s+", "").replaceAll("[^0-9A-Za-z]+", "_") : qName;
            aqList.add(new AggregateQuantity(combiner, expr){

                @Override
                public ValueInfo adjustInfo(ValueInfo combInfo) {
                    DefaultValueInfo info = new DefaultValueInfo(combInfo);
                    info.setName(label);
                    return info;
                }
            });
        }
        AggregateQuantity[] aqs = aqList.toArray(new AggregateQuantity[0]);
        if (aqs.length == 0) {
            String msg = "No aggregate quantities to calculate; use parameters " + this.quantParam_.getName().toUpperCase() + " or " + this.countParam_.getName().toUpperCase();
            throw new TaskException(msg);
        }
        final SkyMapMapping mapping = new SkyMapMapping(lonString, latString, tiling, complete, aqs, unit, countIndex, runner);
        if (tiling instanceof HealpixTiling) {
            HealpixTiling hpx = (HealpixTiling)tiling;
            HealpixTableInfo.HpxCoordSys csys = null;
            HealpixTableInfo hpxInfo = new HealpixTableInfo(hpx.getHealpixK(), hpx.isNest(), hpx.getIndexInfo().getName(), csys);
            DescribedValue[] params = hpxInfo.toParams();
        } else {
            DescribedValue[] params = new DescribedValue[]{};
        }
        final TableProducer inProd = this.createInputProducer(env);
        return new TableProducer(){

            @Override
            public StarTable getTable() throws IOException, TaskException {
                return mapping.map(inProd.getTable());
            }
        };
    }

    private static double doEvaluateDouble(JELRowReader jelReader, CompiledExpression compEx) throws IOException {
        try {
            return jelReader.evaluateDouble(compEx);
        }
        catch (Throwable e) {
            throw new IOException("Evaluation error", e);
        }
    }

    private static ColumnData createIndexColumn(SkyTiling tiling) {
        DefaultValueInfo info = new DefaultValueInfo(tiling.getIndexInfo());
        if (tiling.getPixelCount() <= Integer.MAX_VALUE) {
            info.setContentClass(Integer.class);
            return new ColumnData((ValueInfo)info){

                public Object readValue(long irow) {
                    return (int)irow;
                }
            };
        }
        info.setContentClass(Long.class);
        return new ColumnData((ValueInfo)info){

            public Object readValue(long irow) {
                return irow;
            }
        };
    }

    private static class UnsparseTable
    extends WrapperStarTable {
        private final StarTable base_;
        private final long minIrow_;
        private final long maxIrow_;
        private final int[] testIcols_;

        UnsparseTable(StarTable base, long minIrow, long maxIrow, int[] testIcols) {
            super(base);
            this.base_ = base;
            this.minIrow_ = minIrow;
            this.maxIrow_ = maxIrow;
            this.testIcols_ = testIcols;
        }

        public RowSequence getRowSequence() throws IOException {
            return new RowSequence(){
                long irow;
                {
                    this.irow = minIrow_ - 1L;
                }

                public boolean next() throws IOException {
                    while (!this.hasData(++this.irow)) {
                        if (this.irow <= maxIrow_) continue;
                        return false;
                    }
                    return true;
                }

                public Object getCell(int icol) throws IOException {
                    this.checkStarted();
                    return base_.getCell(this.irow, icol);
                }

                public Object[] getRow() throws IOException {
                    this.checkStarted();
                    return base_.getRow(this.irow);
                }

                public void close() {
                }

                private void checkStarted() {
                    if (this.irow < minIrow_) {
                        throw new IllegalStateException("next not called");
                    }
                }
            };
        }

        public RowSplittable getRowSplittable() throws IOException {
            return Tables.getDefaultRowSplittable((StarTable)this);
        }

        private boolean hasData(long irow) throws IOException {
            for (int ic : this.testIcols_) {
                if (Tables.isBlank((Object)this.base_.getCell(irow, ic))) continue;
                return true;
            }
            return false;
        }

        public boolean isRandom() {
            return false;
        }

        public long getRowCount() {
            return -1L;
        }

        public RowAccess getRowAccess() throws IOException {
            throw new UnsupportedOperationException("not random");
        }

        public Object getCell(long irow, int icell) {
            throw new UnsupportedOperationException();
        }

        public Object[] getRow(long irow) {
            throw new UnsupportedOperationException();
        }
    }

    private static class BinDataCollector
    extends RowCollector<BinData> {
        final StarTable table_;
        final SkyTiling tiling_;
        final AggregateQuantity[] aqs_;
        final Function<Library, CompiledExpression> lonCompiler_;
        final Function<Library, CompiledExpression> latCompiler_;
        final List<Function<Library, CompiledExpression>> quantCompilers_;
        final int nq_;
        final long npix_;

        BinDataCollector(StarTable table, SkyTiling tiling, AggregateQuantity[] aqs, Function<Library, CompiledExpression> lonCompiler, Function<Library, CompiledExpression> latCompiler, List<Function<Library, CompiledExpression>> qComps) {
            this.table_ = table;
            this.tiling_ = tiling;
            this.aqs_ = aqs;
            this.lonCompiler_ = lonCompiler;
            this.latCompiler_ = latCompiler;
            this.quantCompilers_ = qComps;
            this.nq_ = this.aqs_.length;
            this.npix_ = this.tiling_.getPixelCount();
        }

        public BinData createAccumulator() {
            BinList[] binLists = Arrays.stream(this.aqs_).map(aq -> BinListCollector.createDefaultBinList(aq.combiner_, this.npix_)).collect(Collectors.toList()).toArray(new BinList[this.nq_]);
            return new BinData(binLists, this.npix_);
        }

        public BinData combine(BinData binData1, BinData binData2) {
            BinList[] bls1 = binData1.binLists_;
            BinList[] bls2 = binData2.binLists_;
            for (int iq = 0; iq < this.nq_; ++iq) {
                bls1[iq] = BinListCollector.mergeBinLists(bls1[iq], bls2[iq]);
            }
            binData1.minIndex_ = Math.min(binData1.minIndex_, binData2.minIndex_);
            binData1.maxIndex_ = Math.max(binData1.maxIndex_, binData2.maxIndex_);
            return binData1;
        }

        public void accumulateRows(RowSplittable rseq, BinData binData) throws IOException {
            SequentialJELRowReader jelRdr = new SequentialJELRowReader(this.table_, rseq);
            Library lib = JELUtils.getLibrary(jelRdr);
            CompiledExpression lonExpr = this.lonCompiler_.apply(lib);
            CompiledExpression latExpr = this.latCompiler_.apply(lib);
            int nq = this.aqs_.length;
            CompiledExpression[] quantExprs = new CompiledExpression[nq];
            for (int iq = 0; iq < nq; ++iq) {
                quantExprs[iq] = this.quantCompilers_.get(iq).apply(lib);
            }
            long minIndex = binData.minIndex_;
            long maxIndex = binData.maxIndex_;
            BinList[] binLists = binData.binLists_;
            while (rseq.next()) {
                double lon = SkyDensityMap.doEvaluateDouble(jelRdr, lonExpr);
                double lat = SkyDensityMap.doEvaluateDouble(jelRdr, latExpr);
                if (Double.isNaN(lon) || Double.isNaN(lat)) continue;
                long index = this.tiling_.getPositionTile(lon, lat);
                minIndex = Math.min(minIndex, index);
                maxIndex = Math.max(maxIndex, index);
                for (int iq = 0; iq < nq; ++iq) {
                    double datum = SkyDensityMap.doEvaluateDouble(jelRdr, quantExprs[iq]);
                    if (Double.isNaN(datum)) continue;
                    binLists[iq].submitToBin(index, datum);
                }
            }
            binData.minIndex_ = minIndex;
            binData.maxIndex_ = maxIndex;
        }
    }

    private static class BinData {
        BinList[] binLists_;
        long minIndex_;
        long maxIndex_;

        BinData(BinList[] binLists, long npix) {
            this.binLists_ = binLists;
            this.minIndex_ = npix;
            this.maxIndex_ = -1L;
        }
    }

    private static abstract class AggregateQuantity {
        final Combiner combiner_;
        final String expr_;

        AggregateQuantity(Combiner combiner, String expr) {
            this.combiner_ = combiner;
            this.expr_ = expr;
        }

        abstract ValueInfo adjustInfo(ValueInfo var1);
    }

    private static class SkyMapMapping
    implements SingleTableMapping {
        private final String lonStr_;
        private final String latStr_;
        private final SkyTiling tiling_;
        private final boolean complete_;
        private final AggregateQuantity[] aqs_;
        private final SolidAngleUnit unit_;
        private final int countIndex_;
        private final RowRunner runner_;

        SkyMapMapping(String lonStr, String latStr, SkyTiling tiling, boolean complete, AggregateQuantity[] aqs, SolidAngleUnit unit, int countIndex, RowRunner runner) {
            this.lonStr_ = lonStr;
            this.latStr_ = latStr;
            this.tiling_ = tiling;
            this.complete_ = complete;
            this.aqs_ = aqs;
            this.unit_ = unit;
            this.countIndex_ = countIndex;
            this.runner_ = runner;
        }

        @Override
        public StarTable map(StarTable inTable) throws IOException, TaskException {
            Object outTable;
            Function<Library, CompiledExpression> latCompiler;
            Function<Library, CompiledExpression> lonCompiler;
            try {
                lonCompiler = JELUtils.compiler(inTable, this.lonStr_, Double.TYPE);
                latCompiler = JELUtils.compiler(inTable, this.latStr_, Double.TYPE);
            }
            catch (CompilationException e) {
                throw new TaskException("Bad lon/lat value: " + e.getMessage(), (Throwable)e);
            }
            ArrayList<Function<Library, CompiledExpression>> qCompilers = new ArrayList<Function<Library, CompiledExpression>>();
            ArrayList<ValueInfo> qInfos = new ArrayList<ValueInfo>();
            DummyJELRowReader dummyRdr = new DummyJELRowReader(inTable);
            Library lib = JELUtils.getLibrary(dummyRdr);
            for (AggregateQuantity aq : this.aqs_) {
                JELQuantity jq;
                String qexpr = aq.expr_;
                try {
                    qCompilers.add(JELUtils.compiler(inTable, qexpr, Double.TYPE));
                    jq = JELUtils.compileQuantity(lib, dummyRdr, qexpr, Double.TYPE);
                }
                catch (CompilationException e) {
                    throw new TaskException("Bad quantity value " + qexpr + ": " + e.getMessage(), (Throwable)e);
                }
                ValueInfo qInfo = aq.adjustInfo(aq.combiner_.createCombinedInfo(jq.getValueInfo(), this.unit_));
                qInfos.add(qInfo);
            }
            BinDataCollector collector = new BinDataCollector(inTable, this.tiling_, this.aqs_, lonCompiler, latCompiler, qCompilers);
            BinData binData = (BinData)this.runner_.collect((RowCollector)collector, inTable);
            long npix = this.tiling_.getPixelCount();
            ColumnStarTable binsTable = ColumnStarTable.makeTableWithRows((long)npix);
            binsTable.addColumn(SkyDensityMap.createIndexColumn(this.tiling_));
            long minIndex = npix;
            long maxIndex = 0L;
            for (int iq = 0; iq < this.aqs_.length; ++iq) {
                AggregateQuantity aq = this.aqs_[iq];
                double binExtent = Math.PI * 4 / (double)npix * 32400.0 / (Math.PI * Math.PI) / this.unit_.getExtentInSquareDegrees();
                double binFactor = aq.combiner_.getType().getBinFactor(binExtent);
                BinResultColumnData<?> qData = BinResultColumnData.createInstance((ValueInfo)qInfos.get(iq), binData.binLists_[iq].getResult(), binFactor);
                binsTable.addColumn(qData);
            }
            if (this.complete_) {
                outTable = binsTable;
            } else {
                int[] testIcols;
                int icolOffset = 1;
                if (this.countIndex_ >= 0) {
                    testIcols = new int[]{icolOffset + this.countIndex_};
                } else {
                    int ncol = binsTable.getColumnCount();
                    testIcols = new int[ncol - icolOffset];
                    for (int i = 0; i < testIcols.length; ++i) {
                        testIcols[i] = icolOffset + i;
                    }
                }
                outTable = new UnsparseTable((StarTable)binsTable, binData.minIndex_, binData.maxIndex_, testIcols);
            }
            if (this.tiling_ instanceof HealpixTiling) {
                HealpixTiling hpxTiling = (HealpixTiling)this.tiling_;
                HealpixTableInfo hpxInfo = new HealpixTableInfo(hpxTiling.getHealpixK(), hpxTiling.isNest(), hpxTiling.getIndexInfo().getName(), (HealpixTableInfo.HpxCoordSys)null);
                outTable.getParameters().addAll(Arrays.asList(hpxInfo.toParams()));
            }
            return outTable;
        }
    }
}

